(function($) {
    "use strict";
    $('.input100').each(function() {
        $(this).on('blur', function() {
            if ($(this).val().trim() != "") {
                $(this).addClass('has-val');
            } else {
                $(this).removeClass('has-val');
            }
        })
    })
    var name = $('.validate-input input[name="name"]');
     var auth_key = $('.validate-input input[name="auth_key"]');
     var store_url = $('.validate-input input[name="store_url"]');
    var email = $('.validate-input input[name="email"]');
    var message = $('.validate-input textarea[name="message"]');
    $('.validate-form').on('submit', function() {
        var check = true;
        if ($(name).val().trim() == '') {
            showValidate(name);
            check = false;
        }
        
         if ($(auth_key).val().trim() == '') {
            showValidate(auth_key);
            check = false;
        }
         
         if ($(store_url).val().trim() == '') {
            showValidate(store_url);
            check = false;
        }
        
        if ($(email).val().trim().match(/^([a-zA-Z0-9_\-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([a-zA-Z0-9\-]+\.)+))([a-zA-Z]{1,5}|[0-9]{1,3})(\]?)$/) == null) {
            showValidate(email);
            check = false;
        }
        if ($(message).val().trim() == '') {
            showValidate(message);
            check = false;
        }
        return check;
    });
    $('.validate-form .input100').each(function() {
        $(this).focus(function() {
            hideValidate(this);
        });
    });

    function showValidate(input) {
        var thisAlert = $(input).parent();
        $(thisAlert).addClass('alert-validate');
    }

    function hideValidate(input) {
        var thisAlert = $(input).parent();
        $(thisAlert).removeClass('alert-validate');
    }
})(jQuery);