<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Middleware\CorsMiddleware;
use Sheets;
use Illuminate\Support\Facades\Storage;
use Carbon\Carbon;

 use Google_Client;
use Google_Service_Sheets;
use Illuminate\Support\Facades\File;
use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;

class GoogleSheetController extends Controller
{

    ################# Customer Details API #############################
    
    /**
     * Retrieve customer details based on phone number.
     *
     * @OA\Get(
     *     path="/Laravel_GoogleSheet/customer_detail",
     *     tags={"Customer Details API"},
     *     @OA\Parameter(
     *         name="Phone",
     *         in="query",
     *         required=true,
     *         description="Phone number of the user",
     *         @OA\Schema(
     *             type="string"
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Success",
     *         @OA\JsonContent(
     *             @OA\Property(property="meta", type="object",
     *                 @OA\Property(property="code", type="number", example=200),
     *                 @OA\Property(property="status", type="string", example="success"),
     *                 @OA\Property(property="message", type="string", example="User fetched successfully!"),
     *             ),
     *             @OA\Property(property="data", type="object",
     *                 @OA\Property(property="user", type="object",
     *                     @OA\Property(property="Phone", type="string", example="9425109334"),
     *                 ),
     *             ),
     *         )
     *     ),
     *     @OA\Response(
     *         response=401,
     *         description="Invalid token",
     *         @OA\JsonContent(
     *             @OA\Property(property="meta", type="object",
     *                 @OA\Property(property="code", type="number", example=422),
     *                 @OA\Property(property="status", type="string", example="error"),
     *                 @OA\Property(property="message", type="string", example="Unauthenticated."),
     *             ),
     *             @OA\Property(property="data", type="object", example={}),
     *         )
     *     ),
     *     security={
     *         {"token": {}}
     *     }
     * )
     */
    public function index(Request $request)
    {
        
        
        $sheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')->sheet('Customers Details')->get();
        
        $header = $sheet->pull(0);
        $values = Sheets::collection($header,$sheet);
        $values->toArray();
        $arry_values = json_decode(json_encode($values),true);
        $Monile = $request->query('Phone');
       
        // echo "<pre>";
        // print_r($arry_values);
        // die();
        $searchingData = [];
        if(count($arry_values) >0 && !empty($Monile)){
            foreach($arry_values as $arry_values_data){
                $check_Mobile = $arry_values_data['Contact No'];
                $check_Mobiles[] = $arry_values_data['Contact No'];
                if($check_Mobile == $Monile){
                    
                    if($arry_values_data['Is Delete Customer'] === 'TRUE'){
                        // $check_Mobile = $arry_values_data['Primary Contact No.'];
                         return response()->json([
                            'status' => $arry_values_data['Is Delete Customer'],
                            'msg'=>'Your Account Deleted',
                        ],200);
                    }
                    $searchingData[] = $arry_values_data;
                }
            }
        }
        
        if(count($searchingData) >0){
            return response()->json([
                    'status' => true,
                    'userData'=>$searchingData[0],
                    'meassage' => 'Customers Data Fetch SuccessFully !'
                ],200);
        }else{
            return response()->json([
                    'status'=>false,
                    'userData' => 'Your mobile number not register our database',
                    'meassage' => 'Customers Data Not Found !'
                ],200);
        }
        
        
        
        
        

        // $sheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')->sheet('customer_details')->get();
        
        // $header = $sheet->pull(0);
        // $values = Sheets::collection($header,$sheet);
        // $values->toArray();
        // $arry_values = json_decode(json_encode($values),true);
        // $Monile = $request->query('Phone');
        
        // $searchingData = [];
        // if(count($arry_values) >0 && !empty($Monile)){
        //     foreach($arry_values as $arry_values_data){
        //         $check_Mobile = $arry_values_data['Primary Contact No.'];
        //         $check_Mobiles[] = $arry_values_data['Primary Contact No.'];
        //         if($check_Mobile == $Monile){
                    
        //             if($arry_values_data['Is Delete Customer'] === 'TRUE'){
        //                 // $check_Mobile = $arry_values_data['Primary Contact No.'];
        //                  return response()->json([
        //                     'status' => $arry_values_data['Is Delete Customer'],
        //                     'msg'=>'Your Account Deleted',
        //                 ],200);
        //             }
        //             $searchingData[] = $arry_values_data;
        //         }
        //     }
        // }
        
        // if(count($searchingData) >0){
        //     return response()->json([
        //             'status' => true,
        //             'userData'=>$searchingData
        //         ],200);
        // }else{
        //     return response()->json([
        //             'status'=>false,
        //             'userData' => 'User Data Not Found'
        //         ],200);
        // }
            
    }
    
    ################# Customer Details API END #############################
    
        
    
  ################# Customer Fields Add API Start #############################
         
        /**
    * @OA\Post(
    * path="/Laravel_GoogleSheet/Customer_Extra_fields",
    * tags={"Customer Fields Add"}  ,
    * summary="Customer Fields",
    * description="Customer Fields Add here",
    *     @OA\RequestBody(
    *         @OA\JsonContent(),
    *         @OA\MediaType(
    *            mediaType="multipart/form-data",
    *            @OA\Schema(
    *               type="object",
    *               required={"emergency_name","emergency_no","customer_contact_no"},
    *               @OA\Property(property="emergency_name", type="text",example="Amit"),
    *               @OA\Property(property="emergency_no", type="number",example="9509069357"),
    *               @OA\Property(property="customer_contact_no", type="number",example="9425111133"),
    *            ),
    *        ),
    *    ),
    *      @OA\Response(
    *          response=201,
    *          description="Register Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=200,
    *          description="Register Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=422,
    *          description="Unprocessable Entity",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(response=400, description="Bad request"),
    *      @OA\Response(response=404, description="Resource Not Found"),
    * )
    */
    
    
         ################# Complaint API End #############################
     
    public function customer_extra_fields(Request $req){
        // Check if 'complaints' key exists in the request data
        
        $sheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')->sheet('Customers Details')->get();

        $header = $sheet->pull(0);
        $values = Sheets::collection($header,$sheet);
        $values->toArray();
        $req_category_data = json_decode(json_encode($values),true);
        // $RequestType = $request->query('Request_Type');
        
        
        
          $requestData = $req->all();

        // Find the row where contact_no matches
        $contactNo = $requestData['customer_contact_no'];
        $spreadsheetId = '1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM';
        $sheetName = 'Customers Details';
    
        // Fetch existing data from the sheet
        $spreadsheetData = Sheets::spreadsheet($spreadsheetId)
            ->sheet($sheetName)
            ->all();
    
        $rowIndex = null;
        foreach ($spreadsheetData as $index => $row) {
            if (isset($row[1]) && $row[2] == $contactNo) { // Assuming contact_no is in the second column (index 1)
                $rowIndex = $index + 1; // Adding 1 because row index starts from 1 in Google Sheets API
                break;
            }
        }
        

        if ($rowIndex !== null) {
            // Prepare the updated data
            $formattedData = [
                $requestData['emergency_name'] ?? '', 
                $requestData['emergency_no'] ?? ''
            ];
    
            // Define the range for the specific row to update
            $updateRange = "$sheetName!J$rowIndex:K$rowIndex"; // Adjust the range according to your columns
    
            // Update the row in the sheet
            Sheets::spreadsheet($spreadsheetId)
                ->sheet($sheetName)
                ->range($updateRange)
                ->update([$formattedData]);
                
                
                
                // email code 
                
                
                
                
    
            return response()->json(['status'=>true,'message' => 'Emergency Data Uploaded successfully.']);
        } else {
            return response()->json(['message' => 'Contact number not found.'], 404);
        }
    
    }
    
    ################# Customer Fields Add API END #############################
    
    
    
    
      ################# Update Firebase Key Add API Start #############################

    
    
    
    
    
    
            /**
    * @OA\Post(
    * path="/Laravel_GoogleSheet/UpdateFiraBaseKey",
    * tags={"Update Firebase Key API"}  ,
    * summary="Update Firebase Key Add",
    * description="Update Firebase Key Add here",
    *     @OA\RequestBody(
    *         @OA\JsonContent(),
    *         @OA\MediaType(
    *            mediaType="multipart/form-data",
    *            @OA\Schema(
    *               type="object",
    *               required={"key","customer_contact_no"},
    *               @OA\Property(property="key", type="text",example=""),
    *               @OA\Property(property="customer_contact_no", type="number",example="9179096304"),
    *            ),
    *        ),
    *    ),
    *      @OA\Response(
    *          response=201,
    *          description="Register Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=200,
    *          description="Register Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=422,
    *          description="Unprocessable Entity",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(response=400, description="Bad request"),
    *      @OA\Response(response=404, description="Resource Not Found"),
    * )
    */
     
    public function update_firabase_key(Request $req){
        // Check if 'complaints' key exists in the request data
        
        $sheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')->sheet('Customers Details')->get();
// return $req->all();
        $header = $sheet->pull(0);
        $values = Sheets::collection($header,$sheet);
        $values->toArray();
        $req_category_data = json_decode(json_encode($values),true);
        $requestData = $req->all();
// return $requestData;
        // Find the row where contact_no matches
        $contactNo = $requestData['customer_contact_no'];
        $spreadsheetId = '1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM';
        $sheetName = 'Customers Details';
    
        // Fetch existing data from the sheet
        $spreadsheetData = Sheets::spreadsheet($spreadsheetId)
            ->sheet($sheetName)
            ->all();
    
        $rowIndex = null;
        foreach ($spreadsheetData as $index => $row) {
            if (isset($row[2]) && $row[2] == $contactNo) { // Assuming contact_no is in the second column (index 1)
                $rowIndex = $index + 1; // Adding 1 because row index starts from 1 in Google Sheets API
                break;
            }
        }
    
        if ($rowIndex !== null) {
            // Prepare the updated data
            $formattedData = [
                $requestData['key'] ?? '', 
            ];
    
            // Define the range for the specific row to update
            $updateRange = "$sheetName!A$rowIndex"; // Adjust the range according to your columns
    
            // Update the row in the sheet
            Sheets::spreadsheet($spreadsheetId)
                ->sheet($sheetName)
                ->range($updateRange)
                ->update([$formattedData]);
    
            return response()->json(['status'=>true,'message' => 'Key updated successfully.']);
        } else {
            return response()->json(['message' => 'Something went Wrong'], 404);
        }
    
    }
    
    ################# Update Firebase Key Add API END #############################
    
    
    
    
    
    
    ################# property Details API #############################
    
    /**
     * Retrieve customer details based on phone number.
     *
     * @OA\Get(
     *     path="/Laravel_GoogleSheet/PropertyDetails",
     *     tags={"Property Details API"},
     *     @OA\Parameter(
     *         name="Phone",
     *         in="query",
     *         required=true,
     *         description="Phone number of the user",
     *         @OA\Schema(
     *             type="string"
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Success",
     *         @OA\JsonContent(
     *             @OA\Property(property="meta", type="object",
     *                 @OA\Property(property="code", type="number", example=200),
     *                 @OA\Property(property="status", type="string", example="success"),
     *                 @OA\Property(property="message", type="string", example="User fetched successfully!"),
     *             ),
     *             @OA\Property(property="data", type="object",
     *                 @OA\Property(property="user", type="object",
     *                     @OA\Property(property="Phone", type="string", example="9425109334"),
     *                 ),
     *             ),
     *         )
     *     ),
     *     @OA\Response(
     *         response=401,
     *         description="Invalid token",
     *         @OA\JsonContent(
     *             @OA\Property(property="meta", type="object",
     *                 @OA\Property(property="code", type="number", example=422),
     *                 @OA\Property(property="status", type="string", example="error"),
     *                 @OA\Property(property="message", type="string", example="Unauthenticated."),
     *             ),
     *             @OA\Property(property="data", type="object", example={}),
     *         )
     *     ),
     *     security={
     *         {"token": {}}
     *     }
     * )
     */
    public function property_details(Request $request)
    {

        $sheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')->sheet('Property details')->get();

        $header = $sheet->pull(0);

        $values = Sheets::collection($header,$sheet);

        $arry_values = json_decode(json_encode($values),true);
        $Monile = $request->query('Phone');
        $searchingData = [];
        if(count($arry_values) >0 && !empty($Monile)){
            foreach($arry_values as $arry_values_data){
                $check_Mobile = $arry_values_data['Customer Id'];
                $check_Mobiles[] = $arry_values_data['Customer Id'];
                if($check_Mobile == $Monile){
                    
                    // if($arry_values_data['Is Delete Customer'] === 'TRUE'){
                    //     // $check_Mobile = $arry_values_data['Primary Contact No.'];
                    //      return response()->json([
                    //         'status' => $arry_values_data['Is Delete Customer'],
                    //         'msg'=>'Your Account Deleted',
                    //     ],200);
                    // }
                    $searchingData[] = $arry_values_data;
                }
            }
        }
        
        if(count($searchingData) >0){
            return response()->json([
                    'status' => true,
                    'userData'=>$searchingData,
                    "message" => "User Data get SuccessFully !"
                ],200);
        }else{
            return response()->json([
                    'status'=>false,
                    'userData' => [],
                    "message" => "User Data Not Found!"
                ],200);
        }
            
    }
    
    ################# property Details API END #############################
    
    ################# All Category API START #############################
    
    /**
     * Retrieve customer details based on phone number.
     *
     * @OA\Get(
     *     path="/Laravel_GoogleSheet/All_Category",
     *     tags={"All Category API"},
     *     @OA\Response(
     *         response=200,
     *         description="Success",
     *         @OA\JsonContent(
     *             @OA\Property(property="meta", type="object",
     *                 @OA\Property(property="code", type="number", example=200),
     *                 @OA\Property(property="status", type="string", example="success"),
     *                 @OA\Property(property="message", type="string", example="User fetched successfully!"),
     *             ),
     *             @OA\Property(property="data", type="object",
     *                 @OA\Property(property="user", type="object",
     *                     @OA\Property(property="Request Type", type="string", example=""),
     *                 ),
     *             ),
     *         )
     *     ),
     *     @OA\Response(
     *         response=401,
     *         description="Invalid token",
     *         @OA\JsonContent(
     *             @OA\Property(property="meta", type="object",
     *                 @OA\Property(property="code", type="number", example=422),
     *                 @OA\Property(property="status", type="string", example="error"),
     *                 @OA\Property(property="message", type="string", example="Unauthenticated."),
     *             ),
     *             @OA\Property(property="data", type="object", example={}),
     *         )
     *     ),
     *     security={
     *         {"token": {}}
     *     }
     * )
     */
    public function all_category(Request $request)
    {

        $sheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')->sheet('All Categories')->get();

        
        $header = $sheet->pull(0);
        $values = Sheets::collection($header,$sheet);
        $values->toArray();
        $req_category_data = json_decode(json_encode($values),true);
        // $RequestType = $request->query('Request_Type');

        $searchingData = [];
        if(count($req_category_data) >0 ){
            foreach($req_category_data as $req_category_datas){
                // $check_Type = $req_category_datas['Type'];
                // if($check_Type == $RequestType){
                    $searchingData[] = $req_category_datas;
                // }
            }
        }
        //                         echo "<pre>";
        //         print_r($searchingData);
        // die();
        if(count($searchingData) >0){
            return response()->json([
                    'status' => true,
                    'requestData'=>$searchingData
                ],200);
        }else{
            return response()->json([
                    'status'=>false,
                    'requestData' => 'Request Data Not Found'
                ],200);
        }
            
    }
    
    ################# All Category API END #############################

     
     ################# Complaint API Start #############################
         
    /**
    * @OA\Post(
    * path="/Laravel_GoogleSheet/ServiceRequest_store",
    * tags={"Service Request Add"}  ,
    * summary="Service Request",
    * description="Service Request Register here",
    *     @OA\RequestBody(
    *         @OA\JsonContent(),
    *         @OA\MediaType(
    *            mediaType="multipart/form-data",
    *            @OA\Schema(
    *               type="object",
    *               required={"name","contact_no","project_id","projectname","Request_Type","Request_About","Request_Category","image","Narration"},
    *               @OA\Property(property="name", type="text",example="Amit"),
    *               @OA\Property(property="contact_no", type="text",example="9509069357"),
    *               @OA\Property(property="project_id", type="text",example="3555"),
    *               @OA\Property(property="projectname", type="text",example="Hyde Park"),
    *               @OA\Property(property="Request_Type", type="text",example="Internal"),
    *               @OA\Property(property="Request_About", type="text",example="Living Room"),
    *               @OA\Property(property="Request_Category", type="text",example="Electrical"),
    *               @OA\Property(property="image", type="file"),
    *               @OA\Property(property="Narration", type="text",example="Light Problem"),
    *            ),
    *        ),
    *    ),
    *      @OA\Response(
    *          response=201,
    *          description="Register Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=200,
    *          description="Register Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=422,
    *          description="Unprocessable Entity",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(response=400, description="Bad request"),
    *      @OA\Response(response=404, description="Resource Not Found"),
    * )
    */
    
         ################# Complaint API End #############################
     
    public function Complaint(Request $req){
        // Check if 'complaints' key exists in the request data

        $requestData = $req->all();
            
                
        if ($req->file('image')->isValid()) {
            // Get the original file name
            $originalName = $req->file('image')->getClientOriginalName();
            $imageWithTime = time().'_'.$originalName;
            
            // Move the uploaded file to the public path
            $path = $req->file('image')->move(public_path('ComplaintImages'), $imageWithTime);
    
            // Generate the URL for the stored image
            $url = asset('ComplaintImages/' . $imageWithTime);
    
       }else{
             // Handle invalid file
            return response()->json(['message' => 'Invalid file'], 400);   
       }
    
        $ComplaintImage =  url('/public/ComplaintImages/'.$imageWithTime);

        // Convert the time zone to Kolkata
        $timestamp = Carbon::now('UTC');
        // Convert the time zone to Kolkata
        $timestamp->setTimezone('Asia/Kolkata');
        
        $Service_Request_Id = rand(0000,9999);
        // Format the complaint data
        $timestamp = $timestamp->format('Y/m/d H:i:s');
        $formattedData[] = [
            'Timestamp' => $timestamp,
            'Service Request Id' => $Service_Request_Id,
            'Customer Id' => $Customer_Id ?? '',
            'Name' => $requestData['name'] ?? '',
            'Unit No.' => $requestData['Unit_No'] ?? '',
            'Contact No.' => $requestData['contact_no'] ?? '',
            'Project Id' => $requestData['project_id'] ?? '',
            'Project Name' => $requestData['projectname'] ?? '',
            'Request Type' => $requestData['Request_Type'] ?? '',
            'Request About' => $requestData['Request_About'] ?? '',
            'Request Category' => $requestData['Request_Category'] ?? '',
            // 'Apartment No.' => $requestData['apartment_no'] ?? '',
            'Narration' => $requestData['Narration'] ?? '',
            'Image' => $ComplaintImage ?? '',
            'Status' =>  'Pending',
            'Comments From Admin' =>  '',
        ];
            
        // Append the formatted data to the spreadsheet
        $complaintSheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')
                               ->sheet('Service Request')
                               ->append($formattedData);
                               
        // email code
        
        $name = $requestData['name'] ?? 'N/A';
        $contact = $requestData['contact_no'] ?? 'N/A';
        $department = $requestData['Request_About'] ?? 'N/A';
        $narration = $requestData['Narration'] ?? 'N/A';
        $image = $ComplaintImage ?? '';
        $timestampFormatted = Carbon::now('Asia/Kolkata')->format('d M Y, h:i A');
        
        $htmlContent = '
        <html>
        <head>
          <style>
            body { font-family: Arial, sans-serif; background-color: #f6f6f6; padding: 20px; }
            .container { background: #fff; border-radius: 8px; padding: 20px; max-width: 600px; margin: auto; box-shadow: 0 2px 8px rgba(0,0,0,0.1); }
            .header { background-color: #004aad; color: white; padding: 10px 20px; border-radius: 8px 8px 0 0; }
            .section { padding: 10px 0; }
            .label { font-weight: bold; color: #333; }
            .footer { margin-top: 20px; font-size: 12px; color: #777; text-align: center; }
            img { max-width: 100%; height: auto; margin-top: 10px; }
          </style>
        </head>
        <body>
          <div class="container">
            <div class="header"><h2>New Complaint Submitted</h2></div>
            <div class="section"><p><span class="label">Date:</span> '.$timestampFormatted.'</p></div>
            <div class="section"><p><span class="label">Name:</span> '.$name.'</p></div>
            <div class="section"><p><span class="label">Contact No.:</span> '.$contact.'</p></div>
            <div class="section"><p><span class="label">Department:</span> '.$department.'</p></div>
            <div class="section"><p><span class="label">Narration:</span><br>'.$narration.'</p></div>
            <div class="section"><p><span class="label">Image:</span><br><img src="'.$image.'" alt="Complaint Image"/></p></div>
            <div class="footer">  A new service request has been logged and requires your attention. Please review and take the necessary action at the earliest.</div>
          </div>
        </body>
        </html>
        ';
        
        $postData = [
            "sender" => [
                "name" => "Neoteric",
                "email" => "system2@neotericgrp.in"
            ],
            "to" => [
                [ "email" => "kuldeepk@neotericgrp.in", "name" => "Kuldeep" ],
                [ "email" => "cre@neotericgrp.in", "name" => "CRE" ],
                [ "email" => "salescoordinator1@neotericgrp.in", "name" => "Sales Coordinator" ],
                [ "email" => "Sakshikaushal@neotericgrp.in", "name" => "Sakshi Kaushal" ],
            ],
            "subject" => "New Complaint from $name",
            "htmlContent" => $htmlContent
        ];
        
        $curl = curl_init();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.brevo.com/v3/smtp/email',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($postData),
            CURLOPT_HTTPHEADER => array(
                'accept: application/json',
                'api-key: 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',
                'content-type: application/json'
            ),
        ));
        
        $response = curl_exec($curl);
        curl_close($curl);
        
        $resArray = json_decode($response, true);


        if($complaintSheet == true) {
            return response()->json([
                'status' => true,
                'msg' => 'We will Solve Your Request in 24 Hour.'
            ], 200);
        }
    
        // If no complaints data or if appending fails
        return response()->json([
            'status' => false,
            'msg' => 'Failed to submit Request. Please check your data and try again.'
        ], 400);
    }
    
    ################# Complaint API END #############################
    
    
    
    ################# Complaint LIST API Start #############################
        /**
     * Retrieve customer details based on phone number.
     *
     * @OA\Get(
     *     path="/Laravel_GoogleSheet/Service_Request_List",
     *     tags={"Service Request List API"},
     *     @OA\Parameter(
     *         name="Phone",
     *         in="query",
     *         required=true,
     *         description="Phone number of the user",
     *         @OA\Schema(
     *             type="string"
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Success",
     *         @OA\JsonContent(
     *             @OA\Property(property="meta", type="object",
     *                 @OA\Property(property="code", type="number", example=200),
     *                 @OA\Property(property="status", type="string", example="success"),
     *                 @OA\Property(property="message", type="string", example="User fetched successfully!"),
     *             ),
     *             @OA\Property(property="data", type="object",
     *                 @OA\Property(property="user", type="object",
     *                     @OA\Property(property="Phone", type="string", example="9425109334"),
     *                 ),
     *             ),
     *         )
     *     ),
     *     @OA\Response(
     *         response=401,
     *         description="Invalid token",
     *         @OA\JsonContent(
     *             @OA\Property(property="meta", type="object",
     *                 @OA\Property(property="code", type="number", example=422),
     *                 @OA\Property(property="status", type="string", example="error"),
     *                 @OA\Property(property="message", type="string", example="Unauthenticated."),
     *             ),
     *             @OA\Property(property="data", type="object", example={}),
     *         )
     *     ),
     *     security={
     *         {"token": {}}
     *     }
     * )
     */
    public function service_request_list(Request $req){
         $sheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')->sheet('Service Request')->get();
        
        $header = $sheet->pull(0);
        $values = Sheets::collection($header,$sheet);
        $values->toArray();
        $arry_values = json_decode(json_encode($values),true);
        $Monile = $req->get('Phone');

        $searchingData = [];
        if(count($arry_values) >0 && !empty($Monile)){
            foreach($arry_values as $arry_values_data){
                $check_Mobile = $arry_values_data['Contact No.'];
                if($check_Mobile == $Monile){
                    $date = $arry_values_data['Timestamp'];
                    $formated_date = Carbon::createFromFormat('Y/m/d H:i:s', $date);
                    
                    // Convert the date to the desired format
                    $formattedDate = $formated_date->format('j F Y h:i:s A');
                    // echo "<pre>";
                    // print_r($formattedDate);
                    $arry_values_data['Timestamp'] = $formattedDate;
                    $searchingData[] = $arry_values_data;
                }
            }
        }
                
        $rev_serchData = array_reverse($searchingData);


        if(count($searchingData) >0){
            return response()->json([
                    'status' => true,
                    'ComplaintData'=>$rev_serchData,
                    'message' => "Your Complained Data Get SuccessFully ~!"
                ],200);
        }else{
            return response()->json([
                    'status'=>false,
                    'ComplaintData' => 'Your Complained Data Not Found !'
                ],404);
        }
    }
    
     ################# Complaint LIST API END #############################
    
    
    
     ################# Project LIST API Start #############################
     /**
     * @OA\Get(
     *     path="/Laravel_GoogleSheet/projects_list",
     *      tags={"Projects List API"},
     *     summary="Get a list of Projects",
     *     @OA\Response(response="200", description="Success"),
     *     security={{"bearerAuth":{}}}
     * )
     */
    public function projects_list(){
        $sheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')->sheet('Projects')->get();
        
        $header = $sheet->pull(0);
        $values = Sheets::collection($header,$sheet);
        $values->toArray();
        
        $arry_values = json_decode(json_encode($values),true);
        
        // echo "<pre>";
        // print_r($arry_values);
        // die();
        $projectData=[];
         foreach($arry_values as $arry_values_data){
            $projectData[] = $arry_values_data;

            // $projectData[]['Image'] = $arry_values_data['Image'];
        }
        
        if(count($arry_values) >0){
            return response()->json([
                    'status' => true,
                    'ProjectsData'=>$projectData,
                    'message' => 'Project Data Fetch SuccessFully !'
                ],200);
        }else{
            return response()->json([
                    'status'=>false,
                    'ProjectsData' => [],
                    'message' => 'Project Data Fetch SuccessFully !'
                ],404);
        }
    }
     ################# Project LIST API END #############################
    
    
     ################# Work Category LIST API Start #############################
     /**
     * @OA\Get(
     *     path="/Laravel_GoogleSheet/workcategory_list",
     *      tags={"Complaint Type API"},
     *     summary="Get a list of Work Categories",
     *     @OA\Response(response="200", description="Success"),
     *     security={{"bearerAuth":{}}}
     * )
     */
    public function workcategory_list(){
        $sheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')->sheet('WorkCategory')->get();
        
        $header = $sheet->pull(0);
        $values = Sheets::collection($header,$sheet);
        $values->toArray();
        
        $arry_values = json_decode(json_encode($values),true);
        $Complaint_Types=[];
         foreach($arry_values as $arry_values_data){
            $Complaint_Types[] = $arry_values_data;
        }
        // echo "<pre>";
        // print_r($Propert_Type);
        // die();
        if(count($arry_values) >0){
            return response()->json([
                    'status' => true,
                    'WorkCategory'=>$Complaint_Types,
                    'message' => 'Category Data Fetch SuccessFully !'
                ],200);
        }else{
            return response()->json([
                    'status'=>false,
                    'WorkCategory' => [],
                    'message' => 'Category Data Not Found !'
                ],404);
        }
    }
    
    ################# Work Category LIST API END #############################
     
   
   ################# Owner Property Rent API START #############################
   
   /**
    * @OA\Post(
    * path="/Laravel_GoogleSheet/property_rent_store",
    * tags={"Owner Property Rent"},
    * summary="Owner Property Rent  Form",
    * description="Owner Rent here",
    *     @OA\RequestBody(
    *         @OA\JsonContent(),
    *         @OA\MediaType(
    *            mediaType="multipart/form-data",
    *            @OA\Schema(
    *               type="object",
    *               required={"project_id","owner_name","owner_contact","property_name","apartment_type","furnished", "air_conditioner", "kitchen","bed","wardrobe","ro","parking","tenant_type","tenant_service","tenant_tenure","expected_rent","last_rent","maintenance_included_in_rent","security_deposit_amount","bank","account_no","ifse","beneficiary_name",},
    *               @OA\Property(property="project_id", type="text",example="3555"),
    *               @OA\Property(property="owner_name", type="text",example="Rahul"),
    *               @OA\Property(property="owner_contact", type="text",example="9509069357"),
    *               @OA\Property(property="property_name", type="text",example="Nature Park"),
    *               @OA\Property(property="apartment_type", type="text",example="3 BHK"),
    *               @OA\Property(property="furnished", type="text",example="Yes"),
    *               @OA\Property(property="air_conditioner", type="text",example="Yes"),
    *               @OA\Property(property="kitchen", type="text",example="Yes"),
    *               @OA\Property(property="bed", type="text",example="Yes"),
    *               @OA\Property(property="wardrobe", type="text",example="Yes"),
    *               @OA\Property(property="ro", type="text",example="Yes"),
    *               @OA\Property(property="parking", type="text",example="Yes"),
    *               @OA\Property(property="tenant_type", type="text",example="Student"),
    *               @OA\Property(property="tenant_service", type="text",example="Private"),
    *               @OA\Property(property="tenant_tenure", type="text",example="12 Months"),
    *               @OA\Property(property="expected_rent", type="text",example="15000"),
    *               @OA\Property(property="last_rent", type="text",example="12000"),
    *               @OA\Property(property="maintenance_included_in_rent", type="text",example="20000"),
    *               @OA\Property(property="security_deposit_amount", type="text",example="1000"),
    *               @OA\Property(property="bank", type="text",example="SBI"),
    *               @OA\Property(property="account_no", type="text",example="FSFEG45789"),
    *               @OA\Property(property="ifse", type="text",example="73583"),
    *               @OA\Property(property="beneficiary_name", type="text",example="Lokesh"),
    *            ),
    *        ),
    *    ),
    *      @OA\Response(
    *          response=201,
    *          description="Register Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=200,
    *          description="Register Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=422,
    *          description="Unprocessable Entity",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(response=400, description="Bad request"),
    *      @OA\Response(response=404, description="Resource Not Found"),
    * )
    */
    public function property_rent_store(Request $req){
        
        // Get the data from the request
        
        $property_rentData = $req->all();
        $RequestId = rand(00000,999999);
        
        // Convert the time zone to Kolkata
        $timestamp = Carbon::now('UTC');
        // Convert the time zone to Kolkata
        $timestamp->setTimezone('Asia/Kolkata');
        $timestamp = $timestamp->format('Y/m/d H:i:s');
        
        $formattedData[] = [
            'Timestamp' => $timestamp,
            'Request Id' => $RequestId ?? '',
            'Customer Id' => $CustomerId ?? '',
            'Unit No.' => $property_rentData['Unit_No'] ?? '',
            'Project Id' => $property_rentData['project_id'] ?? '',
            'Flat/Property Owner Name'=> $property_rentData['owner_name'] ?? '',
            'Flat/Property Owner Contact No.' => $property_rentData['owner_contact'] ?? '',
            'Property Name' => $property_rentData['property_name'] ?? '',
            'Apartment Type' => $property_rentData['apartment_type'] ?? '',
            'Furnished' => $property_rentData['furnished'] ?? '',
            'Air Conditioner' => $property_rentData['air_conditioner'] ?? '',
            'Kitchen' => $property_rentData['kitchen'] ?? '',
            'Bed' => $property_rentData['bed'] ?? '',
            'Wardrobe' => $property_rentData['wardrobe'] ?? '',
            'RO' => $property_rentData['ro'] ?? '',
            'Parking' => $property_rentData['parking'] ?? '',
            'Tenant Type' => $property_rentData['tenant_type'] ?? '',
            'Tenant Service' => $property_rentData['tenant_service'] ?? '',
            'Tenant Tenure' => $property_rentData['tenant_tenure'] ?? '',
            'Expected Rent' => $property_rentData['expected_rent'] ?? '', 
            'Last Rent' => $property_rentData['last_rent'] ?? '', 
            'Maintenance Included in Rent' => $property_rentData['maintenance_included_in_rent'] ?? '', 
            'Security Deposit Amount' => $property_rentData['security_deposit_amount'] ?? '', 
            'Bank' => $property_rentData['bank'] ?? '', 
            'Account No.' => $property_rentData['account_no'] ?? '', 
            'IFSC' => $property_rentData['ifse'] ?? '', 
            'Beneficiary Name' => $property_rentData['beneficiary_name'] ?? '', 


            // 'Email ID' => $property_rentData['email'] ?? '', // Assuming 'email' is the key in the request for email
            // 'Project' => $property_rentData['project'] ?? '',
            // 'Unit/Property No.' => $property_rentData['unit_property_no'] ?? '',
            // 'Type of Apartment' => $property_rentData['apartment_type'] ?? '',
            // 'Size of Apartment/Property' => $property_rentData['apartment_size'] ?? '',
            // 'Furnished Description' => $property_rentData['furnished_description'] ?? '',
            // 'Property/Furnishing Description' => $property_rentData['property_description'] ?? '', 
            'Status' => $property_rentData['status'] ?? 'Pending', 
        ];
          // }

        // Append the formatted data to the spreadsheet
        $complaintSheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')
                           ->sheet('Owner Rent Request')
                           ->append($formattedData);
                           
        //   email code
                        
     // Setup email content
        $emailHTML = "
        <html>
            <head></head>
            <body>
                <p>Hello,</p>
                <p>A new property rent request has been submitted.</p>
                <p><strong>Request ID:</strong> {$RequestId}</p>
                <p><strong>Owner:</strong> {$property_rentData['owner_name']}<br>
                   <strong>Contact:</strong> {$property_rentData['owner_contact']}</p>
                <p>Please check the Google Sheet for full details.</p>
            </body>
        </html>";

        // Send email via Brevo API
        $emailPayload = json_encode([
            "sender" => [
                "name" => "Neoteric",
                "email" => "system2@neotericgrp.in"
            ],
            "to" => [
                [
                    "email" => "pc1@neotericgrp.in",
                    "name" => "pc1"
                ]
            ],
            "subject" => "New Property Rent Request",
            "htmlContent" => $emailHTML
        ]);

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://api.brevo.com/v3/smtp/email',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $emailPayload,
            CURLOPT_HTTPHEADER => [
                'accept: application/json',
                'api-key: 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',
                'content-type: application/json'
            ]
        ]);
        $response = curl_exec($curl);
        curl_close($curl);
        $resArray = json_decode($response, true);
        

        if($complaintSheet == true) {
            return response()->json([
                'status' => true,
                'msg' => 'Your Property Owner form for Rent SuccessFully Submit !'
            ], 200);
        }
   
        // If no complaints data or if appending fails
        return response()->json([
            'status' => false,
            'msg' => 'Failed to submit Form. Please check your data and try again.'
        ], 400);
        
        

   }
    ################# Owner Property Rent  API END #############################
    
    
          #################Owner Property Rent LIST API Start #############################
        /**
     * Retrieve customer details based on phone number.
     *
     * @OA\Get(
     *     path="/Laravel_GoogleSheet/Property_Rent_List",
     *     tags={"Owner Property Rent List API"},
     *     @OA\Parameter(
     *         name="Phone",
     *         in="query",
     *         required=true,
     *         description="Phone number of the user",
     *         @OA\Schema(
     *             type="string"
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Success",
     *         @OA\JsonContent(
     *             @OA\Property(property="meta", type="object",
     *                 @OA\Property(property="code", type="number", example=200),
     *                 @OA\Property(property="status", type="string", example="success"),
     *                 @OA\Property(property="message", type="string", example="User fetched successfully!"),
     *             ),
     *             @OA\Property(property="data", type="object",
     *                 @OA\Property(property="user", type="object",
     *                     @OA\Property(property="Phone", type="string", example="9425109334"),
     *                 ),
     *             ),
     *         )
     *     ),
     *     @OA\Response(
     *         response=401,
     *         description="Invalid token",
     *         @OA\JsonContent(
     *             @OA\Property(property="meta", type="object",
     *                 @OA\Property(property="code", type="number", example=422),
     *                 @OA\Property(property="status", type="string", example="error"),
     *                 @OA\Property(property="message", type="string", example="Unauthenticated."),
     *             ),
     *             @OA\Property(property="data", type="object", example={}),
     *         )
     *     ),
     *     security={
     *         {"token": {}}
     *     }
     * )
     */
    public function property_rent_list(Request $req){
         $sheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')->sheet('Owner Rent Request')->get();
        
        $header = $sheet->pull(0);

        $values = Sheets::collection($header,$sheet);
        $values->toArray();
        $arry_values = json_decode(json_encode($values),true);
        
        // echo "<pre>";
        // print_r($arry_values);
        // die();
        $Monile = $req->get('Phone');
        $searchingData = [];
        if(count($arry_values) >0 && !empty($Monile)){
            foreach($arry_values as $arry_values_data){
                $check_Mobile = $arry_values_data['Flat/Property Owner Contact No.'];
                if($check_Mobile == $Monile){
                    $date = $arry_values_data['Timestamp'];
                    $formated_date = Carbon::createFromFormat('Y/m/d H:i:s', $date);
                    
                    // Convert the date to the desired format
                    $formattedDate = $formated_date->format('j F Y h:i:s A');
                    // echo "<pre>";
                    // print_r($formattedDate);
                    $arry_values_data['Timestamp'] = $formattedDate;
                    $searchingData[] = $arry_values_data;
                }
            }
        }


    // return $searchingData;
        if(count($searchingData) >0){
            return response()->json([
                    'status' => true,
                    'ComplaintData'=>$searchingData,
                    'message' => 'Property Data Fetch SuccessFully !'
                ],200);
        }else{
            return response()->json([
                    'status'=>false,
                    'ComplaintData' => [],
                    'message' => 'Property Data Not Found !'
                ],200);
        }
    }
    ################# Owner Property Rent LIST API END #############################
      
      
      

   
   
    ################# Tanent Rent LIST API START #############################
   
      /**
        * @OA\Post(
        * path="/Laravel_GoogleSheet/tenant_rent_store",
        * tags={"Tenant Property Rent"},
        * summary="Tenant Register Form",
        * description="Owner Register here",
        *     @OA\RequestBody(
        *         @OA\JsonContent(),
        *         @OA\MediaType(
        *            mediaType="multipart/form-data",
        *            @OA\Schema(
        *               type="object",
        *               required={"name","contact_no", "email", "project","property_type","occupation","budget","rent_period","description_needs"},
        *               @OA\Property(property="name", type="text",example="Rahul"),
        *               @OA\Property(property="contact_no", type="text",example="9509069357"),
        *               @OA\Property(property="project", type="text",example="Hyde Park"),
        *               @OA\Property(property="email", type="text",example="rk@gmail.com"),
        *               @OA\Property(property="property_type", type="text",example="2 BHK"),
        *               @OA\Property(property="occupation", type="text",example="Doctor"),
        *               @OA\Property(property="budget", type="text",example="12000"),
        *               @OA\Property(property="rent_period", type="text",example="30 Days"),
        *               @OA\Property(property="description_needs", type="text",example="Good Frunishing")
        *            ),
        *        ),
        *    ),
        *      @OA\Response(
        *          response=201,
        *          description="Register Successfully",
        *          @OA\JsonContent()
        *       ),
        *      @OA\Response(
        *          response=200,
        *          description="Register Successfully",
        *          @OA\JsonContent()
        *       ),
        *      @OA\Response(
        *          response=422,
        *          description="Unprocessable Entity",
        *          @OA\JsonContent()
        *       ),
        *      @OA\Response(response=400, description="Bad request"),
        *      @OA\Response(response=404, description="Resource Not Found"),
        * )
        */
    // public function tenant_rent_store(Request $req){
    //     // Get the data from the request
    //     $tanent_rentData = $req->all();
    //     //     echo "<pre>"; 
    //     // print_r($requestData);
    //     // die();
    //     // Check if 'tanent_rent' key exists in the request data
    //     // if(isset($requestData['tanent_rent']) && is_array($requestData['tanent_rent'])) {
    //         // Get tanent_rent data from the request
    //         // $tanent_rent = $requestData['tanent_rent'];
    
    //         // Initialize an array to hold the formatted data
    //         // $formattedData = [];
    
    //         // Iterate over each complaint
    //         // foreach($tanent_rent as $tanent_rentData) {
    //             // Format the complaint data
    //             // Convert the time zone to Kolkata
    //             $timestamp = Carbon::now('UTC');
    //             // Convert the time zone to Kolkata
    //             $timestamp->setTimezone('Asia/Kolkata');
    //             $timestamp = $timestamp->format('Y/m/d H:i:s');
    //             $formattedData[] = [
    //                 'Timestamp' => $timestamp,
    //                 'Name' => $tanent_rentData['name'] ?? '',
    //                 'Contact no.' => $tanent_rentData['contact_no'] ?? '',
    //                 'Project' => $tanent_rentData['project'] ?? '',
    //                 'Email' => $tanent_rentData['email'] ?? '', // Assuming 'email' is the key in the request for email
    //                 'Property Type' => $tanent_rentData['property_type'] ?? '',
    //                 'Occupation' => $tanent_rentData['occupation'] ?? '',
    //                 'Budget' => $tanent_rentData['budget'] ?? '',
    //                 'Time period for Rent' => $tanent_rentData['rent_period'] ?? '',
    //                 'Description & Needs' => $tanent_rentData['description_needs'] ?? '',
    //                 'Status' => $tanent_rentData['status'] ?? 'Pending', // Assuming 'status' is set to 'Pending' by default
    //             ];
    //         // }
    
    //         // Append the formatted data to the spreadsheet
    //         $complaintSheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')
    //                               ->sheet('TenantRent')
    //                               ->append($formattedData);
    
    //         if($complaintSheet == true) {
    //             return response()->json([
    //                 'status' => true,
    //                 'msg' => 'Your Rent Form Successfully Submitted!'
    //             ], 200);
    //         }
    //     // }
    
    //     // If no complaints data or if appending fails
    //     return response()->json([
    //         'status' => false,
    //         'msg' => 'Failed to submit Form. Please check your data and try again.'
    //     ], 400);
    // }
    ################# Tanent Rent LIST API END #############################
    
    
    
    ################# Contact Us API Start #############################
    /**
    * @OA\Post(
    * path="/Laravel_GoogleSheet/ContactUs",
    * tags={"Contact Us"}  ,
    * summary="Add Contact",
    * description="Contact Add here",
    *     @OA\RequestBody(
    *         @OA\JsonContent(),
    *         @OA\MediaType(
    *            mediaType="multipart/form-data",
    *            @OA\Schema(
    *               type="object",
    *               required={"name","contact_no", "email"},
    *               @OA\Property(property="name", type="text",example="Surya"),
    *               @OA\Property(property="contact_no", type="text",example="9785642368"),
    *               @OA\Property(property="email", type="text",example="lk@gmail.com"),
    *               @OA\Property(property="description", type="text",example="description here"),

    *            ),
    *        ),
    *    ),
    *      @OA\Response(
    *          response=201,
    *          description="Contact Add Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=200,
    *          description="Contact Add Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=422,
    *          description="Unprocessable Entity",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(response=400, description="Bad request"),
    *      @OA\Response(response=404, description="Resource Not Found"),
    * )
    */
    
public function contact(Request $request){
    $Contact_Data = $request->all();

    if(isset($Contact_Data) && is_array($Contact_Data)) {
        $timestamp = Carbon::now('UTC')->setTimezone('Asia/Kolkata')->format('Y/m/d H:i:s');
        $ContactData[] = [
            'TimeStamp'   => $timestamp,
            'Name'        => $Contact_Data['name'],
            'Contact No'  => $Contact_Data['contact_no'],
            'Email'       => $Contact_Data['email'],
            'Description' => $Contact_Data['description'],
        ];

        // Append data to Google Sheet
        $complaintSheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')
                                ->sheet('Contact Us')
                                ->append($ContactData);

        // Prepare HTML content
        $htmlContent = '
        <html>
            <head></head>
            <body>
                 <p><strong>New contact request received — please review the details below.</strong></p>
        <p><strong>Name:</strong> '.$Contact_Data['name'].'</p>
        <p><strong>Contact No:</strong> '.$Contact_Data['contact_no'].'</p>
        <p><strong>Email:</strong> '.$Contact_Data['email'].'</p>
        <p><strong>Description:</strong> '.$Contact_Data['description'].'</p>
        <hr>
        <p style="color:#0055A4; font-style: italic;">
            This message was generated via your application Contact Us form.
        </p>
            </body>
        </html>';

        // Send Email
        $postData = [
            "sender" => [
                "name" => "Neoteric",
                "email" => "system2@neotericgrp.in"
            ],
            "to" => [
                [
                    "email" => "Sakshikaushal@neotericgrp.in",
                    "name" => "Sakshi Kaushal"
                ],
                [
                    "email" => "cre@neotericgrp.in",
                    "name" => "CRE"
                ],
                [
                    "email" => "salescoordinator1@neotericgrp.in",
                    "name" => "Sales Coordinator"
                ]
              
            ],
            "subject" => "New Contact Request from: ".$Contact_Data['name'],
            "htmlContent" => $htmlContent
        ];

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://api.brevo.com/v3/smtp/email',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($postData),
            CURLOPT_HTTPHEADER => [
                'accept: application/json',
                'api-key: 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',
                'content-type: application/json',
                'chatgptapi: shpua_2e644524e9c3275d64fb9db70677e3dd'
            ],
        ]);

        $response = curl_exec($curl);
        curl_close($curl);
            // echo $response;                    
                                
            $resArray = json_decode($response, true);
        
    
            if($complaintSheet == true) {
                return response()->json([
                    'status' => true,
                    'msg' => 'Your Contact Add  Successfully!'
                ], 200);
            }

    
        // If no complaints data or if appending fails
        return response()->json([
            'status' => false,
            'msg' => 'Failed to submit Form. Please check your data and try again.'
        ], 400);
        
        
    }
        
    }
   
   ################# Contact Us API END #############################
   
   
    ################# Slider LIST API Start #############################
     /**
     * @OA\Get(
     *     path="/Laravel_GoogleSheet/Slider_images",
     *      tags={"Slider Images API"},
     *     summary="Get a list of Slider Images",
     *     @OA\Response(response="200", description="Success"),
     *     security={{"bearerAuth":{}}}
     * )
     */
   public function slider_images(Request $request){
        $sheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')->sheet('Slider Images')->get();
        
        $header = $sheet->pull(0);
        $values = Sheets::collection($header,$sheet);
        $values->toArray();
        
        $arry_values = json_decode(json_encode($values),true);
        // echo "<pre>";
        // print_r($arry_values);
        // die();
        $check_Mobile=[];
             foreach($arry_values as $arry_values_data){
                $check_Mobile[]['Image'] = $arry_values_data['Image'];
              
        
            }
            
            
        if(count($arry_values) >0){
            return response()->json([
                    'status' => true,
                    'WorkCategory'=>$check_Mobile
                ],200);
        }else{
            return response()->json([
                    'status'=>false,
                    'WorkCategory' => 'User Data Not Found'
                ],404);
        }
       
       
   }
   
      ################# Slider LIST API END  #############################
   
   
   
      ################# Repaire Property Request API START #############################
   
   /**
    * @OA\Post(
    * path="/Laravel_GoogleSheet/Repair_Request",
    * tags={"Repaire Property Request "},
    * summary="Repaire Property Request  Form",
    * description="Repaire Property Request here",
    *     @OA\RequestBody(
    *         @OA\JsonContent(),
    *         @OA\MediaType(
    *            mediaType="multipart/form-data",
    *            @OA\Schema(
    *               type="object",
    *               required={"owner_name","owner_contact", "email", "project","unit_property_no","apartment_type","apartment_size","repair_details"},
    *               @OA\Property(property="owner_name", type="text",example="Rahul"),
    *               @OA\Property(property="owner_contact", type="text",example="9509069357"),
    *               @OA\Property(property="email", type="text",example="rk@gmail.com"),
    *               @OA\Property(property="project", type="text",example="Hyde Park"),
    *               @OA\Property(property="unit_property_no", type="text",example="102"),
    *               @OA\Property(property="apartment_type", type="text",example="2 BHK"),
    *               @OA\Property(property="apartment_size", type="text",example="50 sqr"),
    *               @OA\Property(property="repair_details", type="text",example="Repair My Property"),
    *
    *            ),
    *        ),
    *    ),
    *      @OA\Response(
    *          response=201,
    *          description="Register Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=200,
    *          description="Register Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=422,
    *          description="Unprocessable Entity",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(response=400, description="Bad request"),
    *      @OA\Response(response=404, description="Resource Not Found"),
    * )
    */
    public function repair_request(Request $req){
        
        // Get the data from the request

        $property_rentData = $req->all();

                $timestamp = Carbon::now('UTC');
                // Convert the time zone to Kolkata
                $timestamp->setTimezone('Asia/Kolkata');
                $timestamp = $timestamp->format('Y/m/d H:i:s');
                $formattedData[] = [
                    'Timestamp' => $timestamp,
                    'Flat/Property Owner Name'=> $property_rentData['owner_name'] ?? '',
                    'Flat/Property Owner Contact No.' => $property_rentData['owner_contact'] ?? '',
                    'Email ID' => $property_rentData['email'] ?? '', // Assuming 'email' is the key in the request for email
                    'Project' => $property_rentData['project'] ?? '',
                    'Unit/Property No.' => $property_rentData['unit_property_no'] ?? '',
                    'Type of Apartment' => $property_rentData['apartment_type'] ?? '',
                    'Size of Apartment/Property' => $property_rentData['apartment_size'] ?? '',
                    'Repair Details' => $property_rentData['repair_details'] ?? '',
                    'Status' => $property_rentData['status'] ?? 'Pending', 
                ];
            // }
    
            // Append the formatted data to the spreadsheet
            $complaintSheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')
                                   ->sheet('Repair Request')
                                   ->append($formattedData);
                                   
                                   
                                //   email code 
    
            if($complaintSheet == true) {
                return response()->json([
                    'status' => true,
                    'msg' => 'Your Repaire Property Request SuccessFully Submit !'
                ], 200);
            }
   
        // If no complaints data or if appending fails
        return response()->json([
            'status' => false,
            'msg' => 'Failed to submit Form. Please check your data and try again.'
        ], 400);

   }
    ################# Repaire Property Request API END #############################
    
    
    
     ################# Property Type LIST API Start #############################
     /**
     * @OA\Get(
     *     path="/Laravel_GoogleSheet/Property_Type",
     *     tags={"Property Type List API"},
     *     summary="Get a list of Property Type",
     *     @OA\Response(response="200", description="Success"),
     *     security={{"bearerAuth":{}}}
     * )
     */
   public function property_type(Request $request){
        $sheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')->sheet('Propert Type')->get();
        
        $header = $sheet->pull(0);
        $values = Sheets::collection($header,$sheet);
        $values->toArray();
        
        $arry_values = json_decode(json_encode($values),true);
        $Propert_Type=[];
         foreach($arry_values as $arry_values_data){
            $Propert_Type[]['Name'] = $arry_values_data['Name'];
        }
            
        if(count($arry_values) >0){
            return response()->json([
                    'status' => true,
                    'PropertyType'=>$Propert_Type
                ],200);
        }else{
            return response()->json([
                    'status'=>false,
                    'PropertyType' => 'Property Type Data Not Found'
                ],404);
        }
       
       
   }
   
      ################# Property Type LIST API END  #############################
      
      
      
            ################# Referral Property Request API START #############################
   
   /**
    * @OA\Post(
    * path="/Laravel_GoogleSheet/Property_referral",
    * tags={"Property Referral API "},
    * summary="Property Referral Form",
    * description="Repaire Property Request here",
    *     @OA\RequestBody(
    *         @OA\JsonContent(),
    *         @OA\MediaType(
    *            mediaType="multipart/form-data",
    *            @OA\Schema(
    *               type="object",
    *               required={"user_name","user_contact","user_apartment_no","referral_name","referral_contact_no", "property_description"},
    *               @OA\Property(property="user_name", type="text",example="Arjun"),
    *               @OA\Property(property="user_contact", type="number",example="9874456254"),
    *               @OA\Property(property="user_apartment_no", type="text",example="115"),
    *               @OA\Property(property="referral_name", type="text",example="Yuvraj"),
    *               @OA\Property(property="referral_contact_no", type="number",example="9787421452"),
    *               @OA\Property(property="referral_email", type="text",example="ak@gmail.com"),
    *               @OA\Property(property="property_description", type="text",example="2 BHK"),
    *
    *            ),
    *        ),
    *    ),
    *      @OA\Response(
    *          response=201,
    *          description="Register Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=200,
    *          description="Register Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=422,
    *          description="Unprocessable Entity",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(response=400, description="Bad request"),
    *      @OA\Response(response=404, description="Resource Not Found"),
    * )
    */
public function property_referral(Request $req){
    $property_referralData = $req->all();
    $timestamp = Carbon::now('UTC')->setTimezone('Asia/Kolkata')->format('Y/m/d H:i:s');

    $formattedData[] = [
        'Timestamp' => $timestamp,
        'User Name' => $property_referralData['user_name'] ?? '',
        'User Contact No.' => $property_referralData['user_contact'] ?? '',
        'User Apartment No.' => $property_referralData['user_apartment_no'] ?? '',
        'Referral Name' => $property_referralData['referral_name'] ?? '',
        'Referral Email Id' => $property_referralData['referral_email'] ?? '',
        'Referral Contact No.' => $property_referralData['referral_contact_no'] ?? '',
        'Property Description' => $property_referralData['property_description'] ?? '',
        'Status' => $property_referralData['status'] ?? 'Pending',
    ];

    $complaintSheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')
                            ->sheet('Property Referral Details')
                            ->append($formattedData);

    // Prepare HTML content for the email
    $htmlContent = '
    <html>
        <head></head>
        <body>
            <p><strong>You have received a new property referral submission.</strong></p>
            <p><strong>Timestamp:</strong> ' . $timestamp . '</p>
            <p><strong>User Name:</strong> ' . ($property_referralData['user_name'] ?? '') . '</p>
            <p><strong>User Contact No.:</strong> ' . ($property_referralData['user_contact'] ?? '') . '</p>
            <p><strong>User Apartment No.:</strong> ' . ($property_referralData['user_apartment_no'] ?? '') . '</p>
            <p><strong>Referral Name:</strong> ' . ($property_referralData['referral_name'] ?? '') . '</p>
            <p><strong>Referral Email Id:</strong> ' . ($property_referralData['referral_email'] ?? '') . '</p>
            <p><strong>Referral Contact No.:</strong> ' . ($property_referralData['referral_contact_no'] ?? '') . '</p>
            <p><strong>Property Description:</strong> ' . ($property_referralData['property_description'] ?? '') . '</p>
            <p><strong>Status:</strong> ' . ($property_referralData['status'] ?? 'Pending') . '</p>
            <hr>
            <p style="color:#0055A4; font-style: italic;">
                This message was generated via your application\'s Property Referral Form.
            </p>
        </body>
    </html>';

    // Send email using Brevo API
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://api.brevo.com/v3/smtp/email',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => json_encode([
            "sender" => [
                "name" => "Neoteric",
                "email" => "system2@neotericgrp.in"
            ],
            "to" => [
                [
                    "email" => "Sakshikaushal@neotericgrp.in",
                    "name" => "Sakshi kaushal"
                ],
                [
                    "email" => "cre@neotericgrp.in",
                    "name" => "CRE"
                ],
                [
                    "email" => "salescoordinator1@neotericgrp.in",
                    "name" => "sales coordinator"
                ]
             
            ],
            "subject" => "New Property Referral Submission",
            "htmlContent" => $htmlContent
        ]),
        CURLOPT_HTTPHEADER => array(
            'accept: application/json',
            'api-key: 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',
            'content-type: application/json'
        ),
    ));

    $response = curl_exec($curl);
    curl_close($curl);
    $resArray = json_decode($response, true);

    if ($complaintSheet == true) {
        return response()->json([
            'status' => true,
            'msg' => 'Your Property Referral Form SuccessFully Submit !'
        ], 200);
    }

    return response()->json([
        'status' => false,
        'msg' => 'Failed to submit Form. Please check your data and try again.'
    ], 400);
}

      
    ################# Referral Property Request API END #############################
      
      
      
    ################# Booking API START #############################
   
   /**
    * @OA\Post(
    * path="/Laravel_GoogleSheet/Booking",
    * tags={"Booking API "},
    * summary="Booking Form",
    * description="Booking here",
    *     @OA\RequestBody(
    *         @OA\JsonContent(),
    *         @OA\MediaType(
    *            mediaType="multipart/form-data",
    *            @OA\Schema(
    *               type="object",
    *               required={"property_booking_name","name","club_services","contact_no","person_adult","person_Child","date","booking_time" },
    *               @OA\Property(property="property_booking_name", type="text",example="Resort"),
    *               @OA\Property(property="name", type="text",example="Rohan"),
    *               @OA\Property(property="contact_no", type="number",example="9787421452"),
    *               @OA\Property(property="club_services", type="text",example=""),
    *               @OA\Property(property="person_adult", type="number",example="4"),
    *               @OA\Property(property="person_Child", type="number",example="2"),
    *               @OA\Property(property="date", type="text",example="11/05/2024"),
    *               @OA\Property(property="booking_time", type="text",example=""),
    *
    *            ),
    *        ),
    *    ),
    *      @OA\Response(
    *          response=201,
    *          description="Register Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=200,
    *          description="Register Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=422,
    *          description="Unprocessable Entity",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(response=400, description="Bad request"),
    *      @OA\Response(response=404, description="Resource Not Found"),
    * )
    */
        public function booking(Request $req){

            
            $bookingData = $req->all();
            $timestamp = Carbon::now('UTC');
            // Convert the time zone to Kolkata
            $timestamp->setTimezone('Asia/Kolkata');
            $timestamp = $timestamp->format('Y/m/d H:i:s');
            $rand_book_num = rand(1111,9999);
            
            // $Club_Services = $req->get('club_services');
            // $array = json_decode($Club_Services, true);
            
            
            // $Club_Services = ["SwimmingPool","Gymnasium","Sport Services"];
            //   $ClubServices = implode(",", $Club_Services);
            // print_r($array);
            // die();
            
            // $ClubServices = implode(",",$array);
            // return $ClubServices;
            $BookkingData[] = [
                'Timestamp' => $timestamp,
                "Booking Number" => $rand_book_num,
                'Unit No.'=> $bookingData['Unit_No'] ?? '',
                'Prooperty Booking Name'=> $bookingData['property_booking_name'] ?? '',
                'Name' => $bookingData['name'] ?? '',
                'Contact No.' => $bookingData['contact_no'] ?? '', // Assuming 'email' is the key in the request for email
                // 'Club Services' => $ClubServices ?? '', // Assuming 'email' is the key in the request for email
                'Club Services' => "SwimmingPool,Gymnasium,Sport Services", // Assuming 'email' is the key in the request for email
                'Person Adult' => $bookingData['person_adult'] ?? '',
                'Person Child' => $bookingData['person_Child'] ?? '',
                // 'Room Type' => $bookingData['room_type'] ?? '',
                'Date' => $bookingData['date'] ?? '',
                'Booking Time' => $bookingData['booking_time'] ?? '',
                'Status' => $bookingData['status'] ?? 'Pending',
            ];
        
            // Append the formatted data to the spreadsheet
            $bookingSheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')
                                   ->sheet('Booking')
                                   ->append($BookkingData);
              
              
                             
            // email code    
            
            
            $curl = curl_init();
            
            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://api.brevo.com/v3/smtp/email',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                
                CURLOPT_POSTFIELDS => json_encode([
                "sender" => [
                    "name" => "Neoteric",
                    "email" => "system2@neotericgrp.in"
                ],
                "to" => [
                            [
                                "email" => "Sakshikaushal@neotericgrp.in",
                                "name" => "Sakshi kaushal"
                            ],
                            [
                                "email" => "cre@neotericgrp.in",
                                "name" => "CRE"
                            ],
                            [
                                "email" => "salescoordinator1@neotericgrp.in",
                                "name" => "sales coordinator"
                            ],
                            [
                                "email" => "infoclub@neotericgrp.in",
                                "name" => "Info club"
                            ]
                ],
                "subject" => "New Club Booking Request - " . $rand_book_num,
                "htmlContent" => "<html><head></head><body><p>Hello Neoteric Team,</p><p>We are pleased to confirm your new booking request. </p></body></html>"
            ]),
                CURLOPT_HTTPHEADER => array(
                    'accept: application/json',
                    'api-key: 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',
                    'content-type: application/json',
                    'chatgptapi: shpua_2e644524e9c3275d64fb9db70677e3dd'
                ),
            ));
            
            $response = curl_exec($curl);
            curl_close($curl);


            
            // curl_close($curl);
            // echo $response;                    
                                
            $resArray = json_decode($response, true);                       
        
            if($bookingSheet == true) {
                return response()->json([
                    'status' => true,
                    'msg' => 'Your Booking SuccessFully Submit !',
                ], 200);
            }
       
    //   email code
            // If no complaints data or if appending fails
            return response()->json([
                'status' => false,
                'msg' => 'Failed to submit Form. Please check your data and try again.'
            ], 400);
          }
          
        ################# Booking API END #############################
        
        
        ################# Send Mail API Start #############################
        
        public function sendmail(Requesrt $req){
            
            
            $msg = "First line of text\nSecond line of text";

            // use wordwrap() if lines are longer than 70 characters
            $msg = wordwrap($msg,70);
            
            // send email
            mail("lokesh3112002@gmail.com","My subject",$msg);
            
            return response()->json([
                    "status"=>true,
                    "msg"=> "Your Mail send successfully"
                ]);
            
            
        }
     ################# Send Mail API END #############################
        
        
    ################# Booking LIST API Start #############################
        /**
     * Retrieve customer details based on phone number.
     *
     * @OA\Get(
     *     path="/Laravel_GoogleSheet/Booking_history",
     *     tags={"Booking List API"},
     *     @OA\Parameter(
     *         name="Phone",
     *         in="query",
     *         required=true,
     *         description="Phone number of the user",
     *         @OA\Schema(
     *             type="string"
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Success",
     *         @OA\JsonContent(
     *             @OA\Property(property="meta", type="object",
     *                 @OA\Property(property="code", type="number", example=200),
     *                 @OA\Property(property="status", type="string", example="success"),
     *                 @OA\Property(property="message", type="string", example="User fetched successfully!"),
     *             ),
     *             @OA\Property(property="data", type="object",
     *                 @OA\Property(property="user", type="object",
     *                     @OA\Property(property="Phone", type="string", example="9425109334"),
     *                 ),
     *             ),
     *         )
     *     ),
     *     @OA\Response(
     *         response=401,
     *         description="Invalid token",
     *         @OA\JsonContent(
     *             @OA\Property(property="meta", type="object",
     *                 @OA\Property(property="code", type="number", example=422),
     *                 @OA\Property(property="status", type="string", example="error"),
     *                 @OA\Property(property="message", type="string", example="Unauthenticated."),
     *             ),
     *             @OA\Property(property="data", type="object", example={}),
     *         )
     *     ),
     *     security={
     *         {"token": {}}
     *     }
     * )
     */
    public function bookinglist(Request $req){
         $sheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')->sheet('Booking')->get();
        
        $header = $sheet->pull(0);

        $values = Sheets::collection($header,$sheet);
        $values->toArray();
        $arry_values = json_decode(json_encode($values),true);
        $Monile = $req->get('Phone');
        $searchingData = [];
        if(count($arry_values) >0 && !empty($Monile)){
            foreach($arry_values as $arry_values_data){
                $check_Mobile = $arry_values_data['Contact No.'];
                if($check_Mobile == $Monile){
                    $date = $arry_values_data['Timestamp'];
                    $formated_date = Carbon::createFromFormat('Y/m/d H:i:s', $date);
                    
                    // Convert the date to the desired format
                    $formattedDate = $formated_date->format('j F Y h:i:s A');
                    // echo "<pre>";
                    // print_r($formattedDate);
                    $arry_values_data['Timestamp'] = $formattedDate;
                    $searchingData[] = $arry_values_data;
                }
            }
        }
        $rev_serchData = array_reverse($searchingData);
    //reverse($searchingData);
    // return $searchingData;
        if(count($rev_serchData) >0){
            return response()->json([
                    'status' => true,
                    'ComplaintData'=>$rev_serchData,
                    "message" => "Your Booking Data Fetched SuccessFully !"
                ],200);
        }else{
            // $searchingData[] = 'User Data Not Found';
            return response()->json([
                    'status'=>false,
                    'ComplaintData' => [],
                    "message" => "Your Booking Data Not Found !"
                ],200);
        }
    }
    ################# Booking LIST API END #############################
    
    
    
    ################# Sendotp API Start #############################
    /**
    * @OA\Post(
    * path="/Laravel_GoogleSheet/Sendotp",
    * tags={"Send Otp"}  ,
    * summary="Otp Send Api",
    * description="Contact Number For Otp",
    *     @OA\RequestBody(
    *         @OA\JsonContent(),
    *         @OA\MediaType(
    *            mediaType="multipart/form-data",
    *            @OA\Schema(
    *               type="object",
    *               required={"contact_no"},
    *               @OA\Property(property="contact_no", type="number",example="9179096304"),

    *            ),
    *        ),
    *    ),
    *      @OA\Response(
    *          response=201,
    *          description="Register Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=200,
    *          description="Register Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=422,
    *          description="Unprocessable Entity",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(response=400, description="Bad request"),
    *      @OA\Response(response=404, description="Resource Not Found"),
    * )
    */

    
    public function sendotp(Request $req){
        
        $contact_num = $req->get('contact_no');
        //     return response()->json([
        //             'status' => true,
        //             'otp'=>111111,
        //             "msg"=>'OTP SMS sent successfully.'
        //         ],200);
                
        if( $contact_num == 8828164859){
            $otp_num = 111111;
            
             return response()->json([
                    'status' => true,
                    'otp'=>$otp_num,
                    "msg"=>'OTP SMS sent successfully.'
                ],200);
        }
        // else{
        // }
            $otp_num = rand(000000,999999);

        
        // $curl = curl_init();

        // curl_setopt_array($curl, array(
        //   CURLOPT_URL => 'https://www.fast2sms.com/dev/bulkV2',
        //   CURLOPT_RETURNTRANSFER => true,
        //   CURLOPT_ENCODING => '',
        //   CURLOPT_MAXREDIRS => 10,
        //   CURLOPT_TIMEOUT => 0,
        //   CURLOPT_FOLLOWLOCATION => true,
        //   CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        //   CURLOPT_CUSTOMREQUEST => 'POST',
        //   CURLOPT_POSTFIELDS => 'variables_values='.$otp_num.'&route=otp&numbers='.$contact_num,
        //   CURLOPT_HTTPHEADER => array(
        //     'authorization: 3ZYw8GdblErAgFhcVJeSq2Hts6TfLDjOxyiIBnaC7RvMuoXm1QFV24Urx0HNhSaLj7E3gCezqy6bG1uv',
        //     'Content-Type: application/x-www-form-urlencoded',
        //     'Cookie: MLftzK0F0WvpzzRuZnm7FCHV2voRgDDzdjuQuKkP=eyJpdiI6IlwvRmd4T0VPWkFPWFJMNm56QXdUOXJRPT0iLCJ2YWx1ZSI6IlpcL3dyOXdJRDB6VW9LbVI3RzBleWhqVTNvWkN4RkxZSzhtV2RFTCthSlhOd3MyUVwvUFVLTHRqNWdqZFcyREJWSWVUTk53a2NRRVNKR1ZkRHZUdjZKSldwVERUSzFaQWpqMFFDejdScW9hNU5yTDdwV0dldWlKOUk0RXI3TXBNUXZMZjYrMElqQjZvZGdjMVFINUNpMU9cL3ExcWRyeEtZR0RKMlJmY1BcL1dmSGNuTHB5XC9Yb20xNktQd2t4M253bEowUTRLVWxoa1AyYlN6NFJHdUladE5tR0hFbDFwQXJPUlFKK2srSE1Cc0lzUT0iLCJtYWMiOiI3ZjBlOWM4ODE4YzkxMDI4NzdmNjA0YTIzOGNlNmVjMzRiZmNmNjdkNjg3YjUzOWJlMDJkMWNmOTQ3Yjg4YTU0In0%3D; XSRF-TOKEN=eyJpdiI6InFPcWp1TFA4dDJKRUxieDE5elhkSWc9PSIsInZhbHVlIjoiVFptWkRPWDFWZXpJcEtQd01BU05maXFISXhPUkNyMVpycTVzVm12SElRVEdyZFRTc3RFVkZHM3cxdHp2U2FZQlwvR2JhSTh6Q2IzWllVd1JybXhmUWF3PT0iLCJtYWMiOiI0OWYxZTZkOGNmZjY3YWZiMjg4NGM5YWEyNmI4ZWFkMjVjOTZhYTg5YTU3YmU0N2FkY2RiZTg0N2ExNzI1NDEwIn0%3D; laravel_session=eyJpdiI6Ik55Tk45b0Y2U1U2XC9PNlIrbFBwTzd3PT0iLCJ2YWx1ZSI6ImxtVDlDWlwvOTZXMjZWajZ2d2NPRUtaXC9zQ3NoMGdZRWN4K2I2ZlBUMjE1ZXlkR0FTNVJYelBQS0UwZXdKN0Zqb05DUncxRXB2VitJQkJURGJOY0VpeUE9PSIsIm1hYyI6IjhiNTA0MjBkNWMzNjMwMGI0NzQ2NWI0NGNlYTViNWI0NTkxNzQyNTU3ZmJjNGM0MjUzOGZhNmE1YmY3MWNjNmIifQ%3D%3D'
        //   ),
        // ));
        
        // $response = curl_exec($curl);
        
        // curl_close($curl);
        
        
        
        
        
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://www.fast2sms.com/dev/bulkV2',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => 'sender_id=NEOTER&message=183651&variables_values='.$otp_num.'&route=dlt&numbers='.$contact_num,
          CURLOPT_HTTPHEADER => array(
            'authorization: 3ZYw8GdblErAgFhcVJeSq2Hts6TfLDjOxyiIBnaC7RvMuoXm1QFV24Urx0HNhSaLj7E3gCezqy6bG1uv',
            'Content-Type: application/x-www-form-urlencoded',
            'Cookie: JwHvhRsdttkhD8dXCsfbEJszrhE8Pk8jD3Bs9G2i=eyJpdiI6IlV5TXBJQ29USDIyS2F6ZVwvZ1NaR3JRPT0iLCJ2YWx1ZSI6IjRRcFpzUVNpZGxmMHhERzdkbmRJOGxYK0l5Q2dcL0RcLzBrOGpybEpcL2hnTktMVThpeCtSNnJlRDRmTnBaelVoZUl4UDZzc0lxcmlwaW56dzRNTTVSM0RiblVMdmQ1Q1dwZ0I1YTZjMkRCTGcwTFl6ZkR4K0Vnc1p5N3pjNmNyQ0hJa3p0dHlJaDFYdXJMS1BTaTFzaWxXRTExMzBHRzBoUDA3WmY4RkVRa1FcL0VWNU4remtMdG1qbG1nMmNIY3lRM0hnOUNSTkFzUVErdG5VY2kyT3pVWXc5Rmg4clRVbGdCTWVOTVFFM0J5ckV3PSIsIm1hYyI6IjU2NGYzNGI3NDU1Njg1YWFmZWQ5NDczYTQwNzNlYmIyNjFlZjNjZjkxMDdlYWQ0ODVlMjQ4MjRiOWFiMjVmYzcifQ%3D%3D; XSRF-TOKEN=eyJpdiI6ImM1TjJnb1kxcEh1aEIrcTMrbTBSUXc9PSIsInZhbHVlIjoiSkpMaG9PaWRkZHE1cGJrU3h4ems4YmRrSFJFTWFLOUpleSsxOFdPcmRoMGk2R2tBSEZcL1ZIZkZcL0VQc2RpR1N4NFozZmRrRUxmbjlyNEdxQTFzTDdmUT09IiwibWFjIjoiOTBkZWY1YjYxZTcwNmE0ZWM2M2U2OTViNWM5YTQ4MzczYjAwYTE3NTIxZDE0YTU1MTgzOTZiZmI3ZWUzODg3ZiJ9; laravel_session=eyJpdiI6IllXV1lQejZzazBOS09nYjVZd1dGZVE9PSIsInZhbHVlIjoiRm5ORlZ3ZWlnKzhcL1JHQkh4NGxyaVI4ME9NMDJsQkhvYUJpVSswS1lvMER6MHBod3VsNXZOTDRJQkdabEV5SEd4TDdpK2toK2tvZmIyQkJISlFhRk5RPT0iLCJtYWMiOiJmYTE4MTJkYzczOTVhNDhlNTQ4YjQ3MjZlYzBhYjk2OGFhM2NhZTgyNzFlNGY4MmNhM2I1YzZmMzY2NDFhYWZiIn0%3D'
          ),
        ));
        
        $response = curl_exec($curl);
        
        curl_close($curl);
        // echo $response;
        
        
        
        
        
        
        // echo $response;
        $resArray = json_decode($response, true);
        //  return response()->json([
        //             'status' => true,
        //             'otp'=>$otp_num,
        //             "msg"=>'OTP SMS sent successfully.',
        //             "data" => $resArray
        //         ],200);
        if($resArray['return'] == true){
            return response()->json([
                    'status' => true,
                    'otp'=>$otp_num,
                    "msg"=>'OTP SMS sent successfully.',
                    'res'=>$resArray
                ],200);
        }else{
            return response()->json([
                    'status'=>false,
                    'otp'=>'',
                    "msg"=>'Failed OTP SMS.'
                ],200);
        }
        
    }
    
     ################# Send Otp API End #############################
    
    
    
     ################# Account Delete API Start #############################
         
    /**
    * @OA\Post(
    * path="/Laravel_GoogleSheet/AccountDelete",
    * tags={"Account Delete Api"}  ,
    * summary="Account Delete",
    * description="Contact Number For Account Delete",
    *     @OA\RequestBody(
    *         @OA\JsonContent(),
    *         @OA\MediaType(
    *            mediaType="multipart/form-data",
    *            @OA\Schema(
    *               type="object",
    *               required={"contact_no"},
    *               @OA\Property(property="contact_no", type="number",example="9509069357"),

    *            ),
    *        ),
    *    ),
    *      @OA\Response(
    *          response=201,
    *          description="Register Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=200,
    *          description="Register Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=422,
    *          description="Unprocessable Entity",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(response=400, description="Bad request"),
    *      @OA\Response(response=404, description="Resource Not Found"),
    * )
    */
    

    public function AccountDelete(Request $req){

        $CustomerDetails_Sheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')->sheet('customer_details')->get();

        $header = $CustomerDetails_Sheet->pull(0);
        $values = Sheets::collection($header,$CustomerDetails_Sheet);
        $values->toArray();
        $arry_values = json_decode(json_encode($values),true);
        $contact_no = $req->get('contact_no');

        $searchingData = [];
        $arr_check_Mobile =[];
        if(count($arry_values) >0 && !empty($contact_no)){
            foreach($arry_values as $index => $arry_values_data){
                $check_Mobile = $arry_values_data['Primary Contact No.'];
                $arr_check_Mobile[] = $arry_values_data['Primary Contact No.'];

                if($check_Mobile == $contact_no){
                    
                    // Prepare the range to update (Column J is the 10th column)
                    $range = 'customer_details!J' . ($index + 1); // Adjust index + 2 for correct row number
    
                    // Prepare the value range body with the new value for "Is Delete Customer"
                    $body = new \Google_Service_Sheets_ValueRange([
                        'values' => [['TRUE']]
                    ]);
    
                    // Update the specific cell in Column J
                    $params = [
                        'valueInputOption' => 'RAW'
                    ];
                    $sheetsService = Sheets::getService();
                    $sheetsService->spreadsheets_values->update('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM', $range, $body, $params);
             
                }
            }
        }
        
        if(in_array($contact_no,$arr_check_Mobile)){
            return response()->json([
                'status' => true,
                "msg"=>'Account Delete successfully.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                "msg"=>'Failed Account or No User Found For deletion.'
            ],200);
        }



        
    }
    ################# Account Delete API End #############################
    
    
    
    
    
      ################# Feedback API Start #############################
         
    /**
    * @OA\Post(
    * path="/Laravel_GoogleSheet/Feedback",
    * tags={"Feedback Add"}  ,
    * summary="Feedback",
    * description="Feedback Add here",
    *     @OA\RequestBody(
    *         @OA\JsonContent(),
    *         @OA\MediaType(
    *            mediaType="multipart/form-data",
    *            @OA\Schema(
    *               type="object",
    *               required={"name","contact_no","department","narration"},
    *               @OA\Property(property="name", type="text",example="Amit"),
    *               @OA\Property(property="contact_no", type="text",example="9509069357"),
    *               @OA\Property(property="department", type="text",example="Security"),
    *               @OA\Property(property="narration", type="text",example="Your Security is to good"),
    *            ),
    *        ),
    *    ),
    *      @OA\Response(
    *          response=201,
    *          description="Register Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=200,
    *          description="Register Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=422,
    *          description="Unprocessable Entity",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(response=400, description="Bad request"),
    *      @OA\Response(response=404, description="Resource Not Found"),
    * )
    */
    
         ################# Feedback API End #############################
     
    public function feedback(Request $req){

        $requestData = $req->all();
        // Convert the time zone to Kolkata
        $timestamp = Carbon::now('UTC');
        // Convert the time zone to Kolkata
        $timestamp->setTimezone('Asia/Kolkata');
        
        // echo "<pre>";
        // print_r($requestData);
        // die();
        
        $Service_Request_Id = rand(0000,9999);
        // Format the Feedback data
        $timestamp = $timestamp->format('Y/m/d H:i:s');
        $formattedData[] = [
            'Date of Event' => $timestamp,
            'Name' => $requestData['name'] ?? '',
            'Contact No.' => $requestData['contact_no'] ?? '',
            'Department' => $requestData['department'] ?? '',
            'Narration' => $requestData['narration'] ?? '',
        ];
            
        // Append the formatted data to the spreadsheet
        $FeedbackSheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')
                               ->sheet('Feedback')
                               ->append($formattedData);
        //   email code 
                            
        $emailHTML = "
        <html>
            <head></head>
            <body>
                <p>Hello,</p>
                <p>You have received a new feedback submission.</p>
                <p><strong>Feedback ID:</strong> {$Service_Request_Id}</p>
                <p><strong>Name:</strong> {$requestData['name']}<br>
                   <strong>Contact No:</strong> {$requestData['contact_no']}<br>
                   <strong>Department:</strong> {$requestData['department']}<br>
                   <strong>Narration:</strong> {$requestData['narration']}</p>
                <p>Submitted on: {$timestamp}</p>
            </body>
        </html>";

        // Send email using Brevo API
        $emailPayload = json_encode([
            "sender" => [
                "name" => "Neoteric",
                "email" => "system2@neotericgrp.in"
            ],
            "to" => [
                [ "email" => "Sakshikaushal@neotericgrp.in", "name" => "Sakshi Kaushal" ],
                [ "email" => "cre@neotericgrp.in", "name" => "CRE" ],
                [ "email" => "salescoordinator1@neotericgrp.in", "name" => "Sales Coordinator" ]
            ],
            "subject" => "New Feedback Received",
            "htmlContent" => $emailHTML
        ]);

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://api.brevo.com/v3/smtp/email',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $emailPayload,
            CURLOPT_HTTPHEADER => [
                'accept: application/json',
                'api-key: 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',
                'content-type: application/json'
            ]
        ]);
        $response = curl_exec($curl);
        curl_close($curl);
        $resArray = json_decode($response, true);
 
        if($FeedbackSheet == true) {
            return response()->json([
                'status' => true,
                'msg' => 'Feedback Add Successfully',
                "res"=>$resArray
            ], 200);
        }
    
        // If no Feedback data or if appending fails
        return response()->json([
            'status' => false,
            'msg' => 'Failed to submit Feedback. Please check your data and try again.'
        ], 400);
    }
    
    ################# Feedback API END #############################
    
    

    
    
    
    
        ################# Paymenty Plan LIST API Start #############################
        /**
     * Retrieve customer details based on phone number.
     * 
     * @OA\Get(
     *     path="/Laravel_GoogleSheet/Payment_List",
     *     tags={"Paymenty Plan LIST API"},
     *     @OA\Parameter(
     *         name="customer_id",
     *         in="query",
     *         required=true,
 *             example ="9179096304",
     *         description="Customer Id number of the user",
     *         @OA\Schema(
     *             type="string"
     *         )
     *     ),
     *     @OA\Parameter(
     *         name="property_id",
     *         in="query",
     *         required=true,
 *             example ="3555",
     *         description="Property Id number of the user",
     *         @OA\Schema(
     *             type="string"
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Success",
     *         @OA\JsonContent(
     *             @OA\Property(property="meta", type="object",
     *                  @OA\Property(property="code", type="number", example=200),
     *                 @OA\Property(property="status", type="string", example="success"),
     *                 @OA\Property(property="message", type="string", example="User fetched successfully!"),
     *             ),
     *             @OA\Property(property="data", type="object",
     *                 @OA\Property(property="user", type="object",
     *                       @OA\Property(property="customer_id", type="date",example="9826905515"),
 *                           @OA\Property(property="property_id", type="string",example="4223"),
     *                 ),
     *             ),
     *         )
     *     ),
     *     @OA\Response(
     *         response=401,
     *         description="Invalid token",
     *         @OA\JsonContent(
     *             @OA\Property(property="meta", type="object",
     *                 @OA\Property(property="code", type="number", example=422),
     *                 @OA\Property(property="status", type="string", example="error"),
     *                 @OA\Property(property="message", type="string", example="Unauthenticated."),
     *             ),
     *             @OA\Property(property="data", type="object", example={}),
     *         )
     *     ),
     *     security={
     *         {"token": {}}
     *     }
     * )
     */
    public function payment_list(Request $req){
         $sheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')->sheet('Payment Plans')->get();
        
        $header = $sheet->pull(0);
        $values = Sheets::collection($header,$sheet);
        $values->toArray();
        $arry_values = json_decode(json_encode($values),true);
        $customer_id = $req->get('customer_id');
        $property_id = $req->get('property_id');
        
        //       echo "<pre>";
        // print_r($customer_id);
        // die();
        $total_amount = 0;
        $pending_amount = 0;
        $searchingData = [];
        if(count($arry_values) >0 && !empty($property_id)){
            foreach($arry_values as $arry_values_data){
                $CustomerId = $arry_values_data['Customer Id'];
                $PropertyId = $arry_values_data['Property Id'];
                if($CustomerId == $customer_id && $property_id == $PropertyId){
                    // $date = $arry_values_data['Timestamp'];
                    if($arry_values_data['Payment Satus'] == 'Panding'){
                        $pending_amount += $arry_values_data['Payment(INR)'];
                    }
                    $total_amount += $arry_values_data['Payment(INR)'];
                    $searchingData[] = $arry_values_data;
                    //              echo "<pre>";
                    // print_r($searchingData);
                    // die();

                }
            }
        }
                
        // $rev_serchData = array_reverse($searchingData);
        //      echo "<pre>";
        // print_r($searchingData);
        // die();

        if(count($searchingData) >0){
            return response()->json([
                    'status' => true,
                    'total_amount' => $total_amount,
                    'pending_amount' => $pending_amount,
                    'PaynentData'=>$searchingData,
                    'message' => "Payment Data Get SuccessFully !"
                ],200);
        }else{
            return response()->json([
                    'status'=>false,
                    'total_amount'=>0,
                    'pending_amount' => 0,
                    'PaynentData' => [],
                    'message' => "Payment Data Not Found !"
                ],404);
        }
    }
    
     ################# Paymenty Plan LIST API END #############################
    
    
    
    
         ################# Profile API Start #############################
         
    /**
    * @OA\Post(
    * path="/Laravel_GoogleSheet/ProfileUpdate",
    * tags={"Profile Update API"}  ,
    * summary="Profile Update",
    * description="Profile Update here",
    *     @OA\RequestBody(
    *         @OA\JsonContent(),
    *         @OA\MediaType(
    *            mediaType="multipart/form-data",
    *            @OA\Schema(
    *               type="object",
    *               required={"customer_id","image"},
    *               @OA\Property(property="customer_id", type="text",example="9509069357"),
    *               @OA\Property(property="image", type="file"),
    *            ),
    *        ),
    *    ),
    *      @OA\Response(
    *          response=201,
    *          description="Update Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=200,
    *          description="Update Successfully",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(
    *          response=422,
    *          description="Unprocessable Entity",
    *          @OA\JsonContent()
    *       ),
    *      @OA\Response(response=400, description="Bad request"),
    *      @OA\Response(response=404, description="Resource Not Found"),
    * )
    */
     
    
    public function profileUpdate(Request $req){
        $requestData = $req->all();

        if ($req->file('image')->isValid()) {
            // Get the original file name
            $originalName = $req->file('image')->getClientOriginalName();
            $imageWithTime = time() . '_' . $originalName;
        
            // Move the uploaded file to the public path
            $path = $req->file('image')->move(public_path('Profile_Update'), $imageWithTime);
        
            // Generate the URL for the stored image
            $url = asset('Profile_Update/' . $imageWithTime);
        } else {
            // Handle invalid file
            return response()->json(['message' => 'Invalid file'], 400);
        }

        $ProfileImage = url('/public/Profile_Update/' . $imageWithTime);

        $sheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')->sheet('Profile Images')->get();

        $header = $sheet->pull(0);

        $values = Sheets::collection($header,$sheet);
        $values->toArray();
        $arry_values = json_decode(json_encode($values),true);

        $Monile = $requestData['customer_id'];
        $searchingData = [];

        if (count($values) > 0 && !empty($Monile)) {
            // echo 33;
            foreach ($values as $index => $value) {
                if ($value['Custmer ID'] == $Monile) {
                    $img_baseName = basename($value['Image']);
                    if (File::exists(public_path('Profile_Update/'.$img_baseName))) {
                        unlink(public_path('Profile_Update/'.$img_baseName));
                    } 
                    $rowIndex = $index + 1; // Adding 2 to account for the header row and 1-based index
                 
                    $updateRange = "B$rowIndex"; // Assuming 'Image' column is B
                    $formattedData = [
                        [$ProfileImage],
                    ];
        
                    Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')
                        ->sheet('Profile Images')
                        ->range($updateRange)
                        ->update($formattedData);
        
                    return response()->json([
                        'status' => true,
                        'msg' => 'Profile Updated Successfully!'
                    ], 200);
                }
            }
        }

        // return response()->json([
        //     'status' => false,
        //     'msg' => 'Customer ID not found'
        // ], 404);

        
        // echo "<pre>";
        // print_r($updateProfile);
        // die();
        

        // Convert the time zone to Kolkata
        $timestamp = Carbon::now('UTC');
        // Convert the time zone to Kolkata
        $timestamp->setTimezone('Asia/Kolkata');
        
        $Service_Request_Id = rand(0000,9999);
        // Format the complaint data
        $timestamp = $timestamp->format('Y/m/d H:i:s');
        $formattedData[] = [
            'Custmer ID' => $requestData['customer_id'] ?? '',
            'Image' => $ProfileImage ?? '',
        ];
            
        // Append the formatted data to the spreadsheet
        $ProfileSheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')
                               ->sheet('Profile Images')
                               ->append($formattedData);

        if($ProfileSheet == true) {
            return response()->json([
                'status' => true,
                'msg' => 'Profile Update SuccessFully !'
            ], 200);
        }
    
        // If no complaints data or if appending fails
        return response()->json([
            'status' => false,
            'msg' => 'Profile Not Updated 1'
        ], 200);
    }
     ################# Profile API Start #############################
     
      ################# Get Profile Image API #############################
    
    /**
     * Retrieve customer details based on phone number.
     *
     * @OA\Get(
     *     path="/Laravel_GoogleSheet/GetProfileImage",
     *     tags={"Get Profile Image API"},
     *     @OA\Parameter(
     *         name="Phone",
     *         in="query",
     *         required=true,
     *         description="Phone number of the user",
     *         @OA\Schema(
     *             type="string"
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Success",
     *         @OA\JsonContent(
     *             @OA\Property(property="meta", type="object",
     *                 @OA\Property(property="code", type="number", example=200),
     *                 @OA\Property(property="status", type="string", example="success"),
     *                 @OA\Property(property="message", type="string", example="User fetched successfully!"),
     *             ),
     *             @OA\Property(property="data", type="object",
     *                 @OA\Property(property="user", type="object",
     *                     @OA\Property(property="Phone", type="string", example="9425109334"),
     *                 ),
     *             ),
     *         )
     *     ),
     *     @OA\Response(
     *         response=401,
     *         description="Invalid token",
     *         @OA\JsonContent(
     *             @OA\Property(property="meta", type="object",
     *                 @OA\Property(property="code", type="number", example=422),
     *                 @OA\Property(property="status", type="string", example="error"),
     *                 @OA\Property(property="message", type="string", example="Unauthenticated."),
     *             ),
     *             @OA\Property(property="data", type="object", example={}),
     *         )
     *     ),
     *     security={
     *         {"token": {}}
     *     }
     * )
     */
    public function getProfileImage(Request $request)
    {
        $sheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')->sheet('Profile Images')->get();

        $header = $sheet->pull(0);

        $values = Sheets::collection($header,$sheet);
        $values->toArray();
        $arry_values = json_decode(json_encode($values),true);
        $Monile = $request->query('Phone');
        $searchingData = [];
        if(count($arry_values) >0 && !empty($Monile)){
            foreach($arry_values as $arry_values_data){
                $check_Mobile = $arry_values_data['Custmer ID'];
                $check_Mobiles[] = $arry_values_data['Custmer ID'];
                if($check_Mobile == $Monile){
                    
                    // if($arry_values_data['Is Delete Customer'] === 'TRUE'){
                    //     // $check_Mobile = $arry_values_data['Primary Contact No.'];
                    //      return response()->json([
                    //         'status' => $arry_values_data['Is Delete Customer'],
                    //         'msg'=>'Your Account Deleted',
                    //     ],200);
                    // }
                    $searchingData[] = $arry_values_data;
                }
            }
        }
        
        if(count($searchingData) >0){
            return response()->json([
                    'status' => true,
                    'profileData'=>$searchingData,
                    "message" => "Profile Image get SuccessFully !"
                ],200);
        }else{
            return response()->json([
                    'status'=>false,
                    'profileData' => [],
                    "message" => "Profile Image Not Found!"
                ],200);
        }
            
    }
    
    #################  Get Profile Image API END #############################

    public function sendPushNotifications()
    {
        $PaymentDetails_Sheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')->sheet('Payment Plans')->get();

        $header = $PaymentDetails_Sheet->pull(0);
        $values = Sheets::collection($header,$PaymentDetails_Sheet);
        $values->toArray();
        $arry_values = json_decode(json_encode($values),true);
        
        // Convert the time zone to Kolkata
        $timestamp = Carbon::now('UTC');
        // Convert the time zone to Kolkata
        $timestamp->setTimezone('Asia/Kolkata');
        
        $Service_Request_Id = rand(0000,9999);
        // Format the complaint data
        $timestamp = $timestamp->format('Y/m/d');
        // Parse the given date
        $carbonDate = Carbon::createFromFormat('Y/m/d', $timestamp);
        $newcarbonDate = Carbon::createFromFormat('Y/m/d', $timestamp);
        
        // Add 2 days to the date
        $carbonDate->addDays(2);
        $newcarbonDate->addDays(1);
        
        // Format the new date as you wish
        $newDate = $carbonDate->format('Y/m/d');
        $anothernewDate = $newcarbonDate->format('Y/m/d');
        
        // echo $anothernewDate;
        // die();
        $ustomerDetails_Sheet = Sheets::spreadsheet('1A0Jhur3vvDlZL_Ia7_RWGg5MsmSkhEIObA_lEBAo4AM')->sheet('Customers Details')->get();
        $headers = $ustomerDetails_Sheet->pull(0);
        $valuess = Sheets::collection($headers,$ustomerDetails_Sheet);
        $valuess->toArray();
        $arry_valuess = json_decode(json_encode($valuess),true);
        
        $allDevice_Data = [];
        foreach($arry_valuess as $customerData){
            $customerPhone = $customerData['Contact No'];
            // $allDevice_Data = [];
            foreach($arry_values as $payDetailsKey =>$payDetails){
                $date = $payDetails['Date'];
                $customerId = $payDetails['Customer Id'];
                $paymentRecieve = $payDetails['Payment Recieve'];
        // echo "<pre>";
        // print_r($paymentRecieve);
        // die();
                if($newDate == $date && $paymentRecieve == 'No'){
                  
                    if($customerPhone == $customerId){
                        $device_Key = $customerData['Key'];
                        $allDevice_Data['twoDayKey'][] = $device_Key;
                        $allDevice_Data['twoDayKey'][] = '2 Days';
                    }
                    
            
            
                    // $customerId = $payDetails['Customer Id'];
                    // $deviceKeysData[] = $this->callCustomerDetails($customerId,'2 Days');
                }else if($anothernewDate == $date && $paymentRecieve == 'No'){
                    $customerId = $payDetails['Customer Id'];
                     
                    if($customerPhone == $customerId){
                        $device_Key = $customerData['Key'];
                        $allDevice_Data['oneDayKey'][] = $device_Key;
                        $allDevice_Data['oneDayKey'][] = '1 Day';
                        //  echo $customerPhone;
                    // echo '<pre>';
                    // print_r($allDevice_Data);
                    // die();
                    }
                    // $deviceKeysData[] = $this->callCustomerDetails($customerId,'1 Daya');
                }else if($timestamp == $date && $paymentRecieve == 'No'){
                    $customerId = $payDetails['Customer Id'];
                    if($customerPhone == $customerId){
                        $device_Key = $customerData['Key'];
                        $allDevice_Data['toDayKey'][] = $device_Key;
                        $allDevice_Data['toDayKey'][] = 'Today';
                    }
                    // $deviceKeysData[] = $this->callCustomerDetails($customerId,'Today');
                }
                    //   $desiredArray = array(
                    //         "device_Key" => array(
                    //             $allDevice_Data["device_Key"][$payDetailsKey],
                    //             $allDevice_Data["remainingDays"][$payDetailsKey]
                    //         ),
                    //         "remainingDays" => array(
                    //             $allDevice_Data["device_Key"][$payDetailsKey],
                    //             $allDevice_Data["remainingDays"][$payDetailsKey]
                    //         )
                    //     );
            }
        }
        
        // Create a new array to swap the necessary elements
        // $transformedData = [
        //     'device_Key' => [],
        //     'remainingDays' => []
        // ];
        
        // foreach ($allDevice_Data['device_Key'] as $key => $deviceKey) {
        //     $remainingDay = $allDevice_Data['remainingDays'][$key];
        
        //     // Append to the transformed array
        //     $transformedData['device_Key'][] = $deviceKey;
        //     $transformedData['remainingDays'][] = $remainingDay;
        // }
        
        // // Dynamic swap logic
        // foreach ($transformedData['device_Key'] as $index => $value) {
        //     if ($index % 2 != 0) {
        //         $temp = $transformedData['device_Key'][$index];
        //         $transformedData['device_Key'][$index] = $transformedData['remainingDays'][$index];
        //         $transformedData['remainingDays'][$index] = $temp;
        //     }
        // }

        // echo "<pre>";
        // print_r($allDevice_Data);
        // die();
        // $desiredArray = array(
        //     "device_Key" => array(
        //         $allDevice_Data["device_Key"][0],
        //         $allDevice_Data["remainingDays"][0]
        //     ),
        //     "remainingDays" => array(
        //         $allDevice_Data["device_Key"][1],
        //         $allDevice_Data["remainingDays"][1]
        //     )
        // );
         
        
        $SERVER_API_KEY = 'AAAAK8-0bg0:APA91bE6ymtOxVryw3DDTcC8yDmnmXw-0UfrHWawWj2vt5L-jbYfJjxUQ9ySi9eXLneChWWnOZSMO5g2JQu0cn6Wa3gR1IVuI5-D9yd4vrKyEWj35h2BU3w0yIDz6gIJ6EXDilhqXbwc';
        
        foreach($allDevice_Data as $allDevice_DataKey =>  $deviceKeysDataVal){
            //      echo "<pre>";
            // print_r($deviceKeysDataVal);
            // die();
            $firebaseToken = array();
            // $firebaseToken = ['et24F2H6TTCk-ug2SMb8L2:APA91bFm19CuBbRXs3Qo7VHoWGhGugB4mHcAbj6mJq9zsET8bu_6Kx5N9BHHRKO1I0Wti1ie5GyAsCoMzG1nDNc71sSX3fUOkjEk9AGO3ZU4xKVS8zLzP8DFFQ81DMVLf8AfKLmzrIvn','fpJ6GThVS3WVA03-8jrF-b:APA91bGvJSzotu9HaTDaCaG34pBicpN8ERLTRL6_UqaQdJwiAk5HQP4vsLIxBM_cpEVBbWhYgAMrwlfBGJPlpj7pmwOmeBOazKeX24s2HZdg5BKp-R9-QKmFBGE5DXoWB5kaWreAqNWg'];
            $firebaseToken[] = trim($deviceKeysDataVal[0]);
            $data = [
                "registration_ids" => $firebaseToken,
                "notification" => [
                    "title" => 'Payment Due Reminder',
                    "body" => 'Your Next Payment Due in '.$deviceKeysDataVal[1],
                    "content_available" => true,
                    "priority" => "high",
                ]
            ];
            $dataString = json_encode($data);
    
            $headers = [
                'Authorization: key=' . $SERVER_API_KEY,
                'Content-Type: application/json',
            ];
    
            $ch = curl_init();
    
            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
    
            $response[] = curl_exec($ch);
             curl_close($ch);
        }
        echo "<pre>";
        // print_r($deviceKeysDataVal[0]);
        echo "<br>";
        print_r($response);
        die();  
        
        
        
        
        
        die();

        $data=[];
        $data['message']= "This is Testing Message";

        // $data['booking_id']=188168302093;
        
        $tokens = [];
        $tokens[] = 'fYgTIadcRYKteW2xpssn2I:APA91bH7ayFbQtwxBSFLPmIfFSS8pPYIoqay16so2Qw9wpjz_dTU-EPekXen7O9pE31aQwBXymX6MhtKFWxZyy91j3qbwhzS767lfeeh4TQvlisJ7AHC2KWHWbZhBEt87YAGOoVBcWsg';
        $response = $this->sendFirebasePush($tokens,$data);

    }
    // public function sendFirebasePush($tokens, $data)
    // {
    
     
    //     $serverKey = 'AAAAK8-0bg0:APA91bE6ymtOxVryw3DDTcC8yDmnmXw-0UfrHWawWj2vt5L-jbYfJjxUQ9ySi9eXLneChWWnOZSMO5g2JQu0cn6Wa3gR1IVuI5-D9yd4vrKyEWj35h2BU3w0yIDz6gIJ6EXDilhqXbwc';
        
    //     // prep the bundle
    //     // $msg = array
    //     // (
    //     //     'message'   => $data['message'],
    //     //     'booking_id' => $data['booking_id'],
    //     // );

    //     $notifyData = [
    //          "body" => $data['message'],
    //          "title"=> "Neotreic App"
    //     ];

    //     $registrationIds = $tokens;
        
    //     if(count($tokens) > 1){
    //         echo "<pre>";
    //         print_r(1111);
    //         die();
            
    //         $fields = array
    //         (
    //             'registration_ids' => $registrationIds, //  for  multiple users
    //             'notification'  => $notifyData,
    //             'data'=> $msg,
    //             'priority'=> 'high'
    //         );
    //     }
    //     else{
           
    //         $fields = array
    //         (
    //             'to' => $registrationIds[0], //  for  only one users
    //             'notification'  => $notifyData,
    //             // 'data'=> $msg,
    //             'priority'=> 'high'
    //         );
    //     }
    //         //  echo "<pre>";
    //         // print_r($fields);
    //         // die();
    //     $headers[] = 'Content-Type: application/json';
    //     $headers[] = 'Authorization: key='. $serverKey;

    //     $ch = curl_init();
    //     curl_setopt( $ch,CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send' );
    //     curl_setopt( $ch,CURLOPT_POST, true );
    //     curl_setopt( $ch,CURLOPT_HTTPHEADER, $headers );
    //     curl_setopt( $ch,CURLOPT_RETURNTRANSFER, true );
    //     // curl_setopt( $ch,CURLOPT_SSL_VERIFYPEER, false );
    //     curl_setopt( $ch,CURLOPT_POSTFIELDS, json_encode( $fields ) );
    //     $result = curl_exec($ch );
    //     if ($result === FALSE) 
    //     {
    //         echo 22222222;
    //         die('FCM Send Error: ' . curl_error($ch));
    //     }
    //     curl_close( $ch );
    //       echo "<pre>";
    //         print_r($result);
    //         die();
    //     return $result;
    // }
    
    //     public function sendPushNotification() {
    //         // 7723023881
    //     // Set POST variables
    //     $data = [
    //         "notification" => [
    //             "title" => 'Neoteric App',
    //             "body" => 'navneet',
    //             "content_available" => true,
    //             "priority" => "high",
    //         ]
    //     ];
    //     $registration_ids[] = 'et24F2H6TTCk-ug2SMb8L2:APA91bFm19CuBbRXs3Qo7VHoWGhGugB4mHcAbj6mJq9zsET8bu_6Kx5N9BHHRKO1I0Wti1ie5GyAsCoMzG1nDNc71sSX3fUOkjEk9AGO3ZU4xKVS8zLzP8DFFQ81DMVLf8AfKLmzrIvn';
    //     $url = 'https://fcm.googleapis.com/fcm/send';
    //     $fields = array('registration_ids' => $registration_ids, 'data' => $data);
    //     $api_key = 'AAAAK8-0bg0:APA91bE6ymtOxVryw3DDTcC8yDmnmXw-0UfrHWawWj2vt5L-jbYfJjxUQ9ySi9eXLneChWWnOZSMO5g2JQu0cn6Wa3gR1IVuI5-D9yd4vrKyEWj35h2BU3w0yIDz6gIJ6EXDilhqXbwc';
    //     $headers = array('Authorization: key=' . $api_key, 'Content-Type: application/json');
        
    //     // echo "<pre>";
    //     // print_r($fields);
    //     // die();
    //     // Open connection
    //     $ch = curl_init();

    //     // Set the url, number of POST vars, POST data
    //     curl_setopt($ch, CURLOPT_URL, $url);
    //     curl_setopt($ch, CURLOPT_POST, true);
    //     curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    //     curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    //     // Disabling SSL Certificate support temporary
    //     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    //     curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    //     // Execute post
    //     $result = curl_exec($ch);
    //     if ($result === FALSE) {
    //         die('Curl failed: ' . curl_error($ch));
    //     }
    //     // Close connection
    //     curl_close($ch);
    //     echo "<pre>";
    //     print_r($result);
    //     die();
    //     $result_data = json_decode($result);
    //     $result_arr = array();
    //     $result_arr['success'] = $result_data->success;
    //     $result_arr['failure'] = $result_data->failure;
    //     return $result_arr;
    // }
}
