<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Detail;
use App\Mail\ExpiryReminderMail;
use Illuminate\Support\Facades\Mail;
use Carbon\Carbon;

class SendExpiryReminderEmails extends Command
{
    protected $signature = 'email:send-expiry-reminders';
    protected $description = 'Send emails for items expiring in 30, 15, 7, 1 days, and today';

    public function handle()
    {
        // Define the days before expiry to check
        $daysBefore = [30, 15, 7, 1, 0]; // 0 means the expiry date is today

        foreach ($daysBefore as $days) {
            // Calculate the target expiry date for the current day interval
            $targetDate = Carbon::today()->addDays($days);

            // Query details expiring on the target date
            $details = Detail::whereDate('dateofexpiry', $targetDate)->get();

            foreach ($details as $detail) {
                // Send an email for each detail item expiring
                Mail::to($detail->email)->send(new ExpiryReminderMail($detail, $days));

                $this->info("Sent expiry reminder for {$detail->name} expiring in {$days} days.");
            }
        }

        return 0;
    }
}
