<?php 
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Detail;

class DetailController extends Controller
{
    public function store(Request $request)
    {
        // Validate the incoming request data
        $validated = $request->validate([
            'type' => 'required|string|max:255',
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'dateofexpiry' => 'required|date',
        ]);

        // Insert the validated data into the database
        Detail::create([
            'type' => $validated['type'],
            'name' => $validated['name'],
            'email' => $validated['email'],
            'dateofexpiry' => $validated['dateofexpiry'],   
        ]);

        // Return a response
        return back()->with('success', 'Details submitted successfully!');
    }
}
