<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ExpiryReminderMail extends Mailable
{
    use Queueable, SerializesModels;

    public $detail;
    public $daysLeft;

    /**
     * Create a new message instance.
     */
    public function __construct($detail, $daysLeft)
    {
        $this->detail = $detail;
        $this->daysLeft = $daysLeft;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->subject('Reminder: Your item is expiring soon')
                    ->view('emails.expiry_reminder');
    }
}
