<!doctype html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">

    <title>Account Deletion Policy - BrandPeak</title>
  </head>
  <body>
    <nav class="navbar navbar-dark bg-dark justify-content-between text-light">
        <div class="container" style="justify-content: center;">
            <h1 class="navbar-brand" style="font-size:30px;">Account Deletion Policy</h1>
        </div>
    </nav>
    <div class="container">
            <h2 class="mt-5 mb-3"><strong>1. Introduction:</strong></h2>
            <span>This policy outlines the procedure and guidelines for users who wish to delete their accounts on the BrandPeak available on the Play Store. The deletion process is designed to ensure the protection of user data and privacy.</span>

            <h2 class="mt-5 mb-3"><strong>2. User Account Deletion Process:</strong></h2>
            <span>Users can initiate the account deletion process through the following steps:
                <ul>
                    <li>open DRAWER</li>
                    <li>select "MY PROFILE"</li>
                    <li>select "ACCOUNT DETAILS"</li>
                    <li>Locate and choose the "DELETE ACCOUNT" option.</li>
                </ul>
            </span>
        
            <h2 class="mt-5 mb-3"><strong>3. Information Collected:</strong></h2>
            <span>The following information is collected during the user registration process and stored in our database:
                <ul>
                    <li>Name</li>
                    <li>Mobile Number</li>
                    <li>Email</li>
                </ul>
            </span>
        
            <h2 class="mt-5 mb-3"><strong>4. Data Deletion Confirmation:</strong></h2>
            <span>Before an account is permanently deleted, users will be prompted to confirm their decision. This confirmation may be in the form of a pop-up notification.</span>
        
            <h2 class="mt-5 mb-3"><strong>5. Timeframe for Deletion:</strong></h2>
            <span>Once a user confirms the account deletion, the process will be initiated immediately. The account and associated data will be scheduled for permanent deleted.</span>
        
            <h2 class="mt-5 mb-3"><strong>6. Backup and Data Security:</strong></h2>
            <span>We ensure that user data is securely stored and protected. Regular backups are performed to prevent data loss. However, once the account deletion process is complete, the user data will be permanently removed from our servers.</span>
        
            <h2 class="mt-5 mb-3"><strong>7. Exceptions:</strong></h2>
            <span>Certain data may be retained even after account deletion for legal or compliance reasons. This may include order history, transaction history, billing information, or data required for tax purposes. Such data will be securely stored and used only as required by law.</span>
        
            <h2 class="mt-5 mb-3"><strong>8. Contact Information:</strong></h2>
            <span>For any questions or concerns regarding the account deletion process, users can contact our customer support at hello@brandpeak.app.</span>
        
            <h2 class="mt-5 mb-3"><strong>9. Changes to the Policy:</strong></h2>
            <span>This policy may be updated from time to time. Users will be notified of any significant changes, and the updated policy will be made available on our website.</span>
        
            <h2 class="mt-5 mb-3"><strong>10. Compliance with Applicable Laws:</strong></h2>
            <span>Our account deletion process complies with relevant data protection laws, including but not limited to the General Data Protection Regulation (GDPR) and other applicable privacy regulations.</span>

            <div class="mb-5"></div>
    </div>

    <!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.14.3/dist/umd/popper.min.js" integrity="sha384-ZMP7rVo3mIykV+2+9J3UJ46jBk0WLaUAdn689aCwoqbBJiSnjAK/l8WvCWPIPm49" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/js/bootstrap.min.js" integrity="sha384-ChfqqxuZUCnJSK3+MXmPNIyE6ZbWh2IMqE241rYiqJxyMiZ6OW/JmZQ5stwEULTy" crossorigin="anonymous"></script>
  </body>
</html>