

<?php $__env->startSection('extra_css'); ?>
<style type="text/css">

</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="card card-primary">
        <div class="card-header">
        <h3 class="card-title">Notification</h3>
        </div>

        <div class="card-body">
        <?php if(count($errors) > 0): ?>
            <div class="alert alert-danger">
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
            </div>
        <?php endif; ?>

        <?php if(session()->has('message')): ?>
            <div class="alert alert-success">
                <?php echo e(session()->get('message')); ?>

            </div>
        <?php endif; ?>

        <?php echo Form::open(['url' => 'admin/notification','method'=>'post','files'=>true]); ?>

        <?php echo Form::hidden('user_id',Auth::user()->id); ?>

        <div class="row">
            <div class="col-12">
                <div class="form-group row">
                    <?php echo Form::label('title','Title', ['class' => 'col-sm-3 col-form-label']); ?>

                    <div class="col-sm-4">
                        <?php echo Form::text('title', null,['class' => 'form-control','required']); ?>

                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="form-group row">
                    <?php echo Form::label('message','Message', ['class' => 'col-sm-3 col-form-label']); ?>

                    <div class="col-sm-4">
                        <?php echo Form::textarea('message', null,['class' => 'form-control','rows' => 3,'required']); ?>

                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="form-group row">
                    <?php echo Form::label('image','Select Image', ['class' => 'col-sm-3 col-form-label']); ?>

                    <div class="col-sm-4">
                        <input class="form-control" type="file" id="image" name="image" required>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-3"></div>
                    <div class="col-sm-9 mb-3" id="preview"><img type="image" class="shadow bg-white rounded" src="<?php echo e(asset('assets/images/no-image.png')); ?>" alt="Image" style="width: auto;height: 120px"/></div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="form-group row">
                    <?php echo Form::label('type','Type', ['class' => 'col-sm-3 col-form-label']); ?>

                    <div class="col-sm-4">
                        <select id="type" name="type" class="form-control" required>
                            <option value="">Select Type</option>
                            <option value="category">Category</option>
                            <option value="festival">Festival</option>
                            <option value="custom">Custom</option>
                            <option value="externalLink">External Link</option>
                            <option value="subscriptionPlan">Subscription Plan</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="form-group" id="otherText">
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12 m-3 text-center">
            <?php if(Auth::user()->user_type == "Demo"): ?>
            <button type="button" class="btn btn-success ToastrButton">Send</button>
            <?php else: ?>
            <?php echo Form::submit('Send', ['class' => 'btn btn-success']); ?>

            <?php endif; ?>
            </div>
        </div>
        <?php echo Form::close(); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
<script type="text/javascript">
    $(document).ready(function() {
        $('#type').select2();
        
        $("#type").change(function() {
            $('#otherText').empty();
            if($(this).find("option:selected").text() == "Category")
            {
                $('#otherText').append('<div class="row"><div class="col-sm-3"><label class="col-form-label">Select Category</label></div><div class="col-sm-4"><select id="category_id" name="category_id" class="form-control" required><option value="">Select Category</option><?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><option value="<?php echo e($c->id); ?>"><?php echo e($c->name); ?></option><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></select></div></div>');
            }
            if($(this).find("option:selected").text() == "Festival")
            {
                $('#otherText').append('<div class="row"><div class="col-sm-3"><label class="col-form-label">Select Festival</label></div><div class="col-sm-4"><select id="festival_id" name="festival_id" class="form-control" required><option value="">Select Festival</option><?php $__currentLoopData = $festival; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><option value="<?php echo e($f->id); ?>"><?php echo e($f->title); ?></option><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></select></div></div>');
            }
            if($(this).find("option:selected").text() == "Custom")
            {
                $('#otherText').append('<div class="row"><div class="col-sm-3"><label class="col-form-label">Select Custom Category</label></div><div class="col-sm-4"><select id="custom_category_id" name="custom_category_id" class="form-control" required><option value="">Select Custom Category</option><?php $__currentLoopData = $custom; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><option value="<?php echo e($c->id); ?>"><?php echo e($c->name); ?></option><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></select></div></div>');
            }
            if($(this).find("option:selected").text() == "External Link")
            {
                $('#otherText').append('<div class="row"><div class="col-sm-3"><label class="col-form-label">External Link (Optional)</label></div><div class="col-sm-4"><input type="text" id="external_link" class="form-control" name="external_link" placeholder="http://www.google.com"></div></div>');
            }
            if($(this).find("option:selected").text() == "Subscription Plan")
            {
                $('#otherText').append('<div class="row"><div class="col-sm-3"><label class="col-form-label">Subscription Plan</label></div><div class="col-sm-4"><select id="plan_id" name="subscription_id" class="form-control" required><option value="">Select Subscription Plan</option><?php $__currentLoopData = $plan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><option value="<?php echo e($p->id); ?>"><?php echo e($p->plan_name); ?></option><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></select></div></div>');
            }
            $('#category_id').select2();
            $('#festival_id').select2();
            $('#custom_category_id').select2();
            $('#plan_id').select2();
        });
    });

    function imagePreview(fileInput) 
    { 
        if (fileInput.files && fileInput.files[0]) 
        {
            var fileReader = new FileReader();
            fileReader.onload = function (event) 
            {
                $('#preview').html('<img src="'+event.target.result+'" class="shadow bg-white rounded" width="auto" alt="Select Image" height="120px"/>');
            };
            fileReader.readAsDataURL(fileInput.files[0]);
        }
    }

    $("#image").change(function () {
        imagePreview(this);
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lytexacn/public_html/postermaking/resources/views/backend/notification.blade.php ENDPATH**/ ?>