<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Carbon\Carbon;
use App\Models\VerifyUser;

class CleanUpExpiredOtps extends Command
{
    protected $signature = 'delete:expired-verify-users';

    protected $description = 'Delete expired VerifyUser records';

    public function handle()
    {
        VerifyUser::where('expires_at', '<', now())->delete();
        $this->info('Expired VerifyUser records deleted successfully.');
    }
}
