<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\Settings;
use App\Models\ApiService;
use App\Models\Plan;
use App\Models\Email_config;
use App\Models\Category;
use App\Models\VerifyUser;
use App\User;
use App\Rules\MatchOldPassword;
use Hash;
use Carbon\Carbon;
use Spatie\Activitylog\Models\Activity;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\File;
use App\Models\Wallet;
use App\Models\WalletTransaction;
class AdminController extends Controller
{
    public function index(){
        $data = User::select(\DB::raw("COUNT(*) as count"), \DB::raw("DAYNAME(created_at) as day_name"), \DB::raw("DAY(created_at) as day"))
        ->where('created_at', '>', Carbon::today()->subDay(6))
        ->groupBy('day_name','day')
        ->orderBy('day')
        ->get();
     $array[] = ['Name', 'Number'];
     foreach($data as $key => $value)
     {
       $array[++$key] = [$value->day_name, $value->count];
     }

    //  return $data;
     return view('backend.index')->with('users', json_encode($array));
    }
    
    
    public function getLastSevenDaysUsers()
    {
        // Fetch last 7 days users with their signup date
        $lastSevenDaysUsers = VerifyUser::select('id', 'email', 'created_at')
                                        ->whereDate('created_at', '>=', now()->subDays(6))
                                        ->get();
    
        return response()->json($lastSevenDaysUsers);
    }


    public function profile(){
        $profile=Auth()->user();
        // return $profile;
        return view('backend.users.profile')->with('profile',$profile);
    }

    // public function profileUpdate(Request $request,$id){
    //     // return $request->all();
    //     $user=User::findOrFail($id);
    //     $data=$request->all();



    //     $UserimageName = time().'.'.$request->photo->extension();
    //     if ($UserimageName !='' && !empty($UserimageName)) {
    //         $directory = public_path('user/');

    //         if (!is_dir($directory)) {
    //             // Directory does not exist, create it
    //             mkdir($directory, 0755, true); // 0755 is the default permission, true enables recursive creation
    //             $request->photo->move($directory,$UserimageName);
    //             // echo "Directory created successfully!";
    //         } else {

    //             $fileData = $request->photo->move($directory,$UserimageName);


    //         }
    //     }
    //     $data['photo']=$UserimageName;


    //     // echo "<pre>";
    //     // print_r($data);
    //     // die();
    //     $status=$user->fill($data)->save();
    //     if($status){
    //         request()->session()->flash('success','Successfully updated your profile');
    //     }
    //     else{
    //         request()->session()->flash('error','Please try again!');
    //     }
    //     return redirect()->back();
    // }

    // public function settings(){
    //     $data=Settings::first();
    //     return view('backend.setting')->with('data',$data);
    // }
    public function userlist(){
        
        $userslist = VerifyUser::all();
        // echo '<pre>';
        // print_r($userslist);
        // die();

        return view('backend/websiteuser/index',compact('userslist'));
      
    }
    public function profileUpdate(Request $request, $id){
    // return $request->all();
    $user = User::findOrFail($id);
    $data = $request->all();

    if ($request->hasFile('photo')) {
        $UserimageName = time().'.'.$request->photo->extension();
        $directory = public_path('user/');

        if (!is_dir($directory)) {
            mkdir($directory, 0755, true); // Create the directory if it doesn't exist
        }

        // Move the uploaded file to the directory
        $request->photo->move($directory, $UserimageName);

        // Update the photo field in the database
        $data['photo'] = $UserimageName;
    }

    // Update other fields
    $status = $user->fill($data)->save();

    if($status){
        request()->session()->flash('success','Successfully updated your profile');
    } else {
        request()->session()->flash('error','Please try again!');
    }

    return redirect()->back();
}

    

    public function addBalance(Request $request)
    {
    
    //  echo "<pre>";
    //  print_r($request->all());
    //  die();
    // Validate the form data
    $request->validate([
        // 'user_id' => 'required|exists:users,id',
        'balance' => 'required|numeric',
        // Add validation rules for additional fields if needed
    ]);



    // Find or create a wallet record for the specified user
    $wallet = Wallet::updateOrCreate(
        ['verify_user_id' => $request->input('user_id')],
        ['balance' => DB::raw('balance + ' . $request->input('balance'))]
    );

     WalletTransaction::create([
            'wallet_id' => $wallet->id,
            'type' => 'credit by admin', // Assuming it's a credit operation
            'amount' => $request->input('balance'),
        ]);
 

    return redirect()->back()->with('success', 'Balance added successfully.');
}




    // Controller method for handling debit balance
    public function debitBalance(Request $request)
    {
    
    
    //      echo "<pre>";
    //  print_r($request->all());
    //  die();
    // Validate the form data
    $request->validate([
        // 'user_id' => 'required|exists:users,id',
        'balance' => 'required|numeric',
        // Add validation rules for additional fields if needed
    ]);

        // Find or create a wallet record for the specified user
        $wallet = Wallet::updateOrCreate(
            ['verify_user_id' => $request->input('user_id')],
            ['balance' => DB::raw('balance - ' . $request->input('balance'))]
        );
   WalletTransaction::create([
            'wallet_id' => $wallet->id,
            'type' => 'debit by admin',
            'amount' => $request->input('balance'),
        ]);
      

        return redirect()->back()->with('success', 'Debit Balance successful.');
  
}




    
    public function emailsetting(){

        $data=Email_config::first();
        return view('backend.email_setting')->with('data',$data);
    }
    
    
    
    
     public function emailupdate(Request $request){
         
        $this->validate($request,[
            'email_desc'=>'required',
          
        ]);
        $data=$request->all();
        
         $settings = Email_config::firstOrFail();
        if($request->get('type') != ''){
            $settings=Email_config::where('type',$request->get('type'))->get();
            foreach ($settings as $item) {
                // print_r($item['email_desc']);
                    // $newSetting = new Email_config();
                    $newSetting=Email_config::find($item['id']);
                    
                    $status=$newSetting->fill($data)->save();
                }
    
            if($status){
                request()->session()->flash('success','Email Setting successfully updated');
            }
            else{
                request()->session()->flash('error','Please try again');
            }
            return redirect()->back();
        }else{
             request()->session()->flash('error','Please Select Mail Type');
              return redirect()->back();

        }
        
        
    }
    
    
    public function getmailtype(Request $req){
        
        $data=Email_config::where('type',$req->get("mailtype"))->get();
        
        // $setarray = json_decode(json_encode($data),true);

        return json_encode(['status'=>true,'mailData'=>$data]);
    }
    
    
    
    

    public function settingsUpdate(Request $request){
        return $request->all();
        $this->validate($request,[
            'short_des'=>'required|string',
            'description'=>'required|string',
            // 'photo'=>'required',
            // 'logo'=>'required',
            'address'=>'required|string',
            'email'=>'required|email',
            'phone'=>'required|string',
        ]);
        // $data=$request->all();
         $settings = Settings::firstOrFail();
         $data = $request->all();
        
        if ($request->hasFile('photo')) {
            $file = $request->file('photo');
            $fileName = time() . '_' . $file->getClientOriginalExtension();
            // echo "<pre>";
            // print_r($fileName);
            // die();
            $file->move(public_path('setting'), $fileName);
        
            // Save the complete file path in the 'photo' field of the $data array
            $data['photo'] = $fileName;
        }
                
           // Save the complete file path in the 'photo' field of the $data array
        // $data['photo'] = 'setting/' . $fileName;
        
        // Delete the old photo if it exists
        if ($settings->photo && file_exists(public_path($settings->photo))) {
            unlink(public_path($settings->photo));
        }
        // return $data;
        $settings=Settings::first();
        // return $settings;
        $status=$settings->fill($data)->save();
        if($status){
            request()->session()->flash('success','Setting successfully updated');
        }
        else{
            request()->session()->flash('error','Please try again');
        }
        return redirect()->route('admin');
    }
    
    //     public function Service(Request $request){
            
    //           $plan=Plan::all();
    //          $categoryIds = $plan->pluck('category_id')->toArray();
    //           $data=ApiService::first();
              
    //           $categoryId = $categoryIds;
    //           $categoryName = Category::getCategoryNameById($categoryId);
        
        
      
    //     return view('backend.service-setting')->with(['data' => $data, 'plan' => $plan ,'categoryName' => $categoryName]);

    // }
    
    public function Service(Request $request)
    {
        $plan = Plan::all();
      
        $categoryIds = $plan->pluck('category_id')->toArray();
        $data = ApiService::first();
    
    
        $categoryNames = Category::whereIn('id', $categoryIds)->pluck('title', 'id')->toArray();
    
        return view('backend.service-setting')->with(['data' => $data, 'plan' => $plan, 'categoryNames' => $categoryNames]);
    }
     

    public function serviceUpdate(Request $request){
        $this->validate($request,[
            'provider_name'=>'required',

            'plan_id'=>'required',
            'service_id'=>'required',

        ]);
        $settings=ApiService::first();
        
        
        // echo "<pre>";
        // print_r($settings);
        // die();
        
        $settings->provider_name = $request->get('provider_name');
        $settings->service_id = $request->get('service_key');
        $settings->plan_id = $request->get('plan_id');
        $settings->service_id = $request->get('service_id');
        $settings->save();
        if($settings == true){
            request()->session()->flash('success','Service_setting successfully updated');
        }
        else{
            request()->session()->flash('error','Please try again');
        }
        return redirect()->back();
    }
    
    
    
    // public function store(Request $request){
        
    //     $this->validate($request,[
    //         'provider_name'=>'string|required',
    //         'service_key'=>'integer|required',
    //         'plan_id'=>'string|required',
    //         'service_id'=>'string|required',
    //     ]);
    //     // print_r($request->all());
    //     // die();
    //     $data=$request->all();
    //     // return $data;
    //     $status=ApiService::create($data);
    //     if($status){
    //         request()->session()->flash('success','Plan successfully created');
    //     }
    //     else{
    //         request()->session()->flash('error','Error, Please try again');
    //     }
    //     return redirect()->route('plan.index');
    // }
    
    
    
    
    
    

    public function changePassword(){
        return view('backend.layouts.changePassword');
    }
    public function changPasswordStore(Request $request)
    {
        $request->validate([
            'current_password' => ['required', new MatchOldPassword],
            'new_password' => ['required'],
            'new_confirm_password' => ['same:new_password'],
        ]);

        User::find(auth()->user()->id)->update(['password'=> Hash::make($request->new_password)]);

        return redirect()->route('admin')->with('success','Password successfully changed');
    }

    // Pie chart
    public function userPieChart(Request $request){
        // dd($request->all());
        $data = User::select(\DB::raw("COUNT(*) as count"), \DB::raw("DAYNAME(created_at) as day_name"), \DB::raw("DAY(created_at) as day"))
        ->where('created_at', '>', Carbon::today()->subDay(6))
        ->groupBy('day_name','day')
        ->orderBy('day')
        ->get();
     $array[] = ['Name', 'Number'];
     foreach($data as $key => $value)
     {
       $array[++$key] = [$value->day_name, $value->count];
     }
    //  return $data;
     return view('backend.index')->with('course', json_encode($array));
    }

    // public function activity(){
    //     return Activity::all();
    //     $activity= Activity::all();
    //     return view('backend.layouts.activity')->with('activities',$activity);
    // }

    public function storageLink(){
        // check if the storage folder already linked;
        if(File::exists(public_path('storage'))){
            // removed the existing symbolic link
            File::delete(public_path('storage'));

            //Regenerate the storage link folder
            try{
                Artisan::call('storage:link');
                request()->session()->flash('success', 'Successfully storage linked.');
                return redirect()->back();
            }
            catch(\Exception $exception){
                request()->session()->flash('error', $exception->getMessage());
                return redirect()->back();
            }
        }
        else{
            try{
                Artisan::call('storage:link');
                request()->session()->flash('success', 'Successfully storage linked.');
                return redirect()->back();
            }
            catch(\Exception $exception){
                request()->session()->flash('error', $exception->getMessage());
                return redirect()->back();
            }
        }
    }
    
    
   
}
