<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\blog;

class Blogcontroller extends Controller{
    //
        public function create(){
            
        return view('backend.blog.create');
        
    }
        public function index(Request $request){
            
            $blogs = blog::all();
            // echo "<pre>";
            // print_r($blogs);
            // die();
            
        return view('backend/blog/index')->with('blogs',$blogs);
    }
    
   
    
    public function store(Request $request){
    $this->validate($request, [
        'title' => 'required',
        'description' => 'string|nullable',
        'summernote' => 'required|nullable',
        'photo' => 'required|image', 
        'status' => 'required|in:active,inactive',
    ]);

    $data = new blog();

    $data->title = $request->input('title');
    $data->description = $request->input('description');
    $data->summernote = $request->input('summernote');
    $data->status = $request->input('status');

    if ($request->hasFile('photo')) {
        $file = $request->file('photo');
        $extension = $file->getClientOriginalExtension();
        $filename = time() . '.' . $extension;
        $file->move(public_path('blog'), $filename);
        $data->photo = $filename;
    }

    $status = $data->save();

    if ($status) {
        request()->session()->flash('success', 'Data successfully added');
    } else {
        request()->session()->flash('error', 'Error occurred while adding data');
    }

   return redirect()->route('blog.index');
}
      public function edit($id){
        $blog=blog::findOrFail($id);
        return view('backend.blog.edit')->with('blog',$blog);
    }
    //     public function update(Request $request, $id){
    //     $this->validate($request, [
    //     'title' => 'required',
    //     'description' => 'string|nullable',
    //     'photo' => 'required|image', 
    //     'status' => 'required|in:active,inactive',
    // ]);

    // $data = new blog();

    // $data->title = $request->input('title');
    // $data->description = $request->input('description');
    // $data->status = $request->input('status');

    // if ($request->hasFile('photo')){
    //     $file = $request->file('photo');
    //     $extension = $file->getClientOriginalExtension();
    //     $filename = time() . '.' . $extension;
    //     $file->move(public_path('blog'), $filename);
    //     $data->photo = $filename;
    // }

    // $status = $data->save();

    // if ($status) {
    //     request()->session()->flash('success', 'Data successfully added');
    // } else {
    //     request()->session()->flash('error', 'Error occurred while adding data');
    // }

    // return view('backend.blog.index');
    // }
    
    
    public function update(Request $request, $id)
{
    $this->validate($request, [
        'title' => 'required',
        'description' => 'string|nullable',
        'photo' => 'image|nullable', // Make the photo field nullable as it's not required for updating
        'summernote' => 'required|nullable',
        'status' => 'required|in:active,inactive',
    ]);

    // Find the existing record by its ID
    $data = Blog::findOrFail($id);

    // Update the fields
    $data->title = $request->input('title');
    $data->description = $request->input('description');
    $data->summernote = $request->input('summernote');
    $data->status = $request->input('status');

    // Handle photo upload
    if ($request->hasFile('photo')) {
        $file = $request->file('photo');
        $extension = $file->getClientOriginalExtension();
        $filename = time() . '.' . $extension;
        $file->move(public_path('blog'), $filename);

        // Delete the old photo if it exists
        if ($data->photo && file_exists(public_path('blog/' . $data->photo))) {
            unlink(public_path('blog/' . $data->photo));
        }

        // Save the new photo filename
        $data->photo = $filename;
    }

    $status = $data->save();

    if ($status) {
        request()->session()->flash('success', 'Data successfully updated');
    } else {
        request()->session()->flash('error', 'Error occurred while updating data');
    }

    return redirect()->route('blog.index');
}

    
       public function destroy($id){
        $blog=blog::findOrFail($id);
        $status=$blog->delete();
        if($status){
            request()->session()->flash('success','blog successfully deleted');
        }
        else{
            request()->session()->flash('error','Error occurred while deleting blog');
        }
        return redirect()->back();
    }
    
    
    
//       public function blogDetail($id){
//     //   $blog = Blog::getPostById($id);
//     //   $summernote = $blog->summernote;
//         $blog = Blog::getPostById($id);
//       $summernoteData = $blog->attributes['summernote'];

// echo "<pre>";
// print_r($summernoteData);
// die();
          
//         // $post=Post::getPostBySlug($slug);
//         // $rcnt_post=Post::where('status','active')->orderBy('id','DESC')->limit(3)->get();
//         // // return $post;
//         return view('frontend.pages.blog-detail');
//         // return view('frontend.pages.blog-detail')->with('post',$post)->with('recent_posts',$rcnt_post);
//     }
    
    
    public function blogDetail($id){
        //   $blogs = Blog::all();
           $blogs=blog::findOrFail($id);
        //   $blogs = blog::paginate(10);
// echo "<pre>";
// print_r($blogs);
// die();
 
    //   $summernoteData = [];

    // foreach ($blogs as $blog) {
    //     // $summernoteData = $blog->summernote;
    //     $summernoteData[$blog->id]['id'] = $blog->id;
    // }

    return view('frontend.pages.blog-detail', compact( 'blogs'));
    }

}
