<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category;
use Illuminate\Support\Str;
use Illuminate\Validation\Rules\Exists;
use Illuminate\Support\Facades\Storage;
use App\Models\Product;
use App\Models\Provider;

class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $category=Category::getAllCategory();
        // return $category;
        return view('backend.category.index')->with('categories',$category);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $parent_cats=Category::where('is_parent',1)->orderBy('title','ASC')->get();
        return view('backend.category.create')->with('parent_cats',$parent_cats);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        
        // echo 1111;
        // die();
        
        
//         if ($request->hasFile('photo')) {
//             // Get the file
//             $photo = $request->file('photo');
// echo $photo;
// die();
//             // Generate a unique name for the file
//             $imageName = time() . '.' . $image->extension();

//             // Store the file in the storage directory
//             Storage::putFileAs('uploads', $image, $imageName);

//             // Get the path to the stored file
//             $path = Storage::url('uploads/' . $imageName);

//             return back()
//                 ->with('success', 'Image uploaded successfully.')
//                 ->with('image', $path);
//         } else {
//             // Handle the case where no file is uploaded
//             return back()->withErrors(['message' => 'No image uploaded']);
//         }
        // return $request->all();
        $this->validate($request,[
            'title'=>'string|required',
            'summary'=>'string|nullable',
            // 'photo'=>'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            'status'=>'required|in:active,inactive',
            'is_parent'=>'sometimes|in:1',
            'parent_id'=>'nullable|exists:categories,id',
        ]);
        $data= $request->all();
        $slug=Str::slug($request->title);
        $count=Category::where('slug',$slug)->count();
        if($count>0){
            $slug=$slug.'-'.date('ymdis').'-'.rand(0,999);
        }
        $data['slug']=$slug;
        $data['is_parent']=$request->input('is_parent',0);
        $catimageName = time().'.'.$request->photo->extension();
        if ($catimageName !='' && !empty($catimageName)) {
            $directory = public_path('/category');

            if (!is_dir($directory)) {
                // Directory does not exist, create it
                mkdir($directory, 0755, true); // 0755 is the default permission, true enables recursive creation
                $request->photo->move($directory,$catimageName);
                // echo "Directory created successfully!";
            } else {

                $fileData = $request->photo->move($directory,$catimageName);


            }
        }
        $data['photo']=$catimageName;

        // return $data;   
        $status=Category::create($data);
        if($status){
            request()->session()->flash('success','Category successfully added');
        }
        else{
            request()->session()->flash('error','Error occurred, Please try again!');
        }
        
        return redirect()->route('category.index');


    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $parent_cats=Category::where('is_parent',1)->get();
        $category=Category::findOrFail($id);
        return view('backend.category.edit')->with('category',$category)->with('parent_cats',$parent_cats);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    // public function update(Request $request, $id)
    // {
    //     // return $request->all();
    //     $category=Category::findOrFail($id);
    //     $this->validate($request,[
    //         'title'=>'string|required',
    //         'summary'=>'string|nullable',
    //         // 'photo'=>'string|nullable',
    //         'status'=>'required|in:active,inactive',
    //         'is_parent'=>'sometimes|in:1',
    //         'parent_id'=>'nullable|exists:categories,id',
    //     ]);
    //     $data= $request->all();
        
    //     $data['is_parent']=$request->input('is_parent',0);
    //     // return $data;
    //     $status=$category->fill($data)->save();
    //         if ($request->hasFile('photo')) {
    //     $catimageName = time() . '.' . $request->photo->extension();
    //     $directory = public_path('/category');

    //     if (!is_dir($directory)) {
    //             mkdir($directory, 0755, true); // Recursive directory creation
    //         }


    //     // Delete the old image if it exists
    //     // if (File::exists(public_path('/category/' . $category->photo))) {
    //     //     // File::delete(public_path('/category/' . $category->photo));
    //     // }

    //     // Upload the new image
    //     $request->photo->move($directory, $catimageName);
    //     $data['photo'] = $catimageName;

    //     // Update the category with the new image
    //     $category->update(['photo' => $catimageName]);
    // }
    //     if($status){
    //         request()->session()->flash('success','Category successfully updated');
    //     }
    //     else{
    //         request()->session()->flash('error','Error occurred, Please try again!');
    //     }
    //     return redirect()->route('category.index');
    // }
public function update(Request $request, $id)
{
    // $category = Category::findOrFail($id);

    $this->validate($request, [
        'title' => 'string|required',
        'summary' => 'string|nullable',
        'status' => 'required|in:active,inactive',
        'is_parent' => 'sometimes|in:1',
        'parent_id' => 'nullable|exists:categories,id',
        'photo' => '|nullable|max:2048', // Adjust max file size as needed
    ]);

     $data = Category::findOrFail($id);

    // Update the fields
    $data->title = $request->input('title');
    $data->summary = $request->input('summary');
    $data->is_parent = $request->input('is_parent');
    $data->status = $request->input('status');

    // Handle photo upload
    if ($request->hasFile('photo')) {
        $file = $request->file('photo');
        $extension = $file->getClientOriginalExtension();
        $filename = time() . '.' . $extension;
        $file->move(public_path('category'), $filename);

        // Delete the old photo if it exists
        // if ($data->photo && file_exists(public_path('category/' . $data->photo))) {
        //     unlink(public_path('category/' . $data->photo));
        // }

        // Save the new photo filename
        $data->photo = $filename;
    }

    $status = $data->save();
    if ($status) {
        request()->session()->flash('success', 'Category successfully updated');
    } else {
        request()->session()->flash('error', 'Error occurred, Please try again!');
    }

    return redirect()->route('category.index');
}

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $category=Category::findOrFail($id);
        $child_cat_id=Category::where('parent_id',$id)->pluck('id');
        // return $child_cat_id;
        $status=$category->delete();
        
        if($status){
            if(count($child_cat_id)>0){
                Category::shiftChild($child_cat_id);
            }
            request()->session()->flash('success','Category successfully deleted');
        }
        else{
            request()->session()->flash('error','Error while deleting category');
        }
        return redirect()->route('category.index');
    }

    public function getChildByParent($title,$cat_id,Request $request){
        $category=Category::findOrFail($request->id);
        //   echo "<pre>";
        //  print_r($category);
        // die();
        $child_cat=Category::getChildByParentID($request->id);
        $prod_con = ["title"=>$title,'cat_id'=>$cat_id];
        $Product_data = Product::where($prod_con)->get()->toArray();
        $Product_fields['plan_value'] = explode(",",$Product_data[0]['plan_value']);
        $Product_fields['plan_price'] = explode(",",$Product_data[0]['plan_price']);
        $Product_fields['service_id'] = explode(",",$Product_data[0]['service_id']);
        
// Number of elements in the arrays
$numElements = count($Product_fields['plan_value']);

// Initialize an empty array to store the result
$Product_fieldsArray = array();

// Iterate through the data and construct the desired arrays
for ($i = 0; $i < $numElements; $i++) {
    $Product_fieldsArray[] = array(
        'plan_value' => $Product_fields['plan_value'][$i],
        'plan_price' => $Product_fields['plan_price'][$i],
        'service_id' => $Product_fields['service_id'][$i] // Adjusting the service_id based on the loop index
    );
}

// Print the result array
// print_r($resultArray);
        // echo "<pre>";
        // print_r($resultArray);
        // die();
        
        // return $child_cat;
        if(count($Product_data)<=0){
            return response()->json(['status'=>false,'msg'=>'','data'=>null,'Product_fields'=>$Product_fieldsArray]);
        }
        else{
            return response()->json(['status'=>true,'msg'=>'','data'=>$child_cat,'Product_fieldsArray'=>$Product_fieldsArray]);
        }
    }
    
    
//     public function getserviceprovider($title, $cat_id, Request $request)
// {
//     // Use $cat_id instead of $request->id

//     // Rest of your code...
// }
    
    
//     public function getserviceprivider($title,$cat_id,Request $request){
        
        
//       \Log::info('Category ID: ' . $cat_id);
//         $category = Provider::findOrFail($cat_id);
        
//             //  echo "<pre>";
//             //  print_r($category);
//             // die();
//         $child_cat=Category::getChildByParentID($request->id);
//         $prod_con = ["title"=>$title,'cat_id'=>$cat_id];
//         $Product_data = Product::where($prod_con)->get()->toArray();
//         $Product_fields['plan_value'] = explode(",",$Product_data[0]['plan_value']);
//         $Product_fields['plan_price'] = explode(",",$Product_data[0]['plan_price']);
//         $Product_fields['service_id'] = explode(",",$Product_data[0]['service_id']);
        
// // Number of elements in the arrays
// $numElements = count($Product_fields['plan_value']);

// // Initialize an empty array to store the result
// $Product_fieldsArray = array();

// // Iterate through the data and construct the desired arrays
// for ($i = 0; $i < $numElements; $i++) {
//     $Product_fieldsArray[] = array(
//         'plan_value' => $Product_fields['plan_value'][$i],
//         'plan_price' => $Product_fields['plan_price'][$i],
//         'service_id' => $Product_fields['service_id'][$i] // Adjusting the service_id based on the loop index
//     );
// }

// // Print the result array
// // print_r($resultArray);
//         // echo "<pre>";
//         // print_r($resultArray);
//         // die();
        
//         // return $child_cat;
//         if(count($Product_data)<=0){
//             return response()->json(['status'=>false,'msg'=>'','data'=>null,'Product_fields'=>$Product_fieldsArray]);
//         }
//         else{
//             return response()->json(['status'=>true,'msg'=>'','data'=>$child_cat,'Product_fieldsArray'=>$Product_fieldsArray]);
//         }
//     }
    
//     public function getserviceprivider($title, $cat_id, Request $request)
// {
//     \Log::info('Category ID: ' . $cat_id);
    
//     try {
//         $category = Category::findOrFail($cat_id);
//     } catch (\Exception $exception) {
//         \Log::error('Category not found: ' . $exception->getMessage());
//         return response()->json(['status' => false, 'msg' => 'Category not found', 'data' => null, 'Product_fields' => []]);
//     }

//     $child_cat = Category::getChildByParentID($request->id);
    
//     $prod_con = ["title" => $title, 'cat_id' => $cat_id];
    
//     $Product_data = Product::where($prod_con)->get()->toArray();

//     // Check if $Product_data array is empty or does not have key 0
//     if (empty($Product_data) || !isset($Product_data[0])) {
//         return response()->json(['status' => false, 'msg' => '', 'data' => null, 'Product_fields' => []]);
//     }

//     $Product_fields['plan_value'] = explode(",", $Product_data[0]['plan_value']);
//     $Product_fields['plan_price'] = explode(",", $Product_data[0]['plan_price']);
//     $Product_fields['service_id'] = explode(",", $Product_data[0]['service_id']);

//     // Number of elements in the arrays
//     $numElements = count($Product_fields['plan_value']);

//     // Initialize an empty array to store the result
//     $Product_fieldsArray = [];

//     // Iterate through the data and construct the desired arrays
//     for ($i = 0; $i < $numElements; $i++) {
//         $Product_fieldsArray[] = [
//             'plan_value' => $Product_fields['plan_value'][$i],
//             'plan_price' => $Product_fields['plan_price'][$i],
//             'service_id' => $Product_fields['service_id'][$i], // Adjusting the service_id based on the loop index
//         ];
//     }

//     // Return the response
//     return response()->json(['status' => true, 'msg' => '', 'data' => $child_cat, 'Product_fieldsArray' => $Product_fieldsArray]);
// }

public function getserviceprivider($title, $cat_id,$pro_id, Request $request)
{
    
    // echo $pro_id;
    // die();
    \Log::info('Category ID: ' . $cat_id);

    try {
        $category = Category::findOrFail($cat_id);
    } catch (\Exception $exception) {
        \Log::error('Category not found: ' . $exception->getMessage());
        return response()->json(['status' => false, 'msg' => 'Category not found', 'data' => null, 'Product_fields' => []]);
    }

    $child_cat = Category::getChildByParentID($request->id);

    $prod_con = ["title" => $title, 'cat_id' => $cat_id ,'service_provider'=>$pro_id];

    // Fetch products based on the selected provider (service_provider)
    $provider_id = $request->input('service_provider');
    if ($provider_id) {
        $prod_con['service_provider'] = $provider_id;
    }

    $Product_data = Product::where($prod_con)->get()->toArray();

    // Check if $Product_data is empty or does not have key 0
    if (empty($Product_data) || !array_key_exists(0, $Product_data)) {
        return response()->json(['status' => false, 'msg' => '', 'data' => null, 'Product_fields' => []]);
    }

    $Product_fields['plan_value'] = explode(",", $Product_data[0]['plan_value']);
    $Product_fields['plan_price'] = explode(",", $Product_data[0]['plan_price']);
    $Product_fields['service_id'] = explode(",", $Product_data[0]['service_id']);

    // Number of elements in the arrays
    $numElements = count($Product_fields['plan_value']);

    // Initialize an empty array to store the result
    $Product_fieldsArray = [];

    // Iterate through the data and construct the desired arrays
    for ($i = 0; $i < $numElements; $i++) {
        $Product_fieldsArray[] = [
            'plan_value' => $Product_fields['plan_value'][$i],
            'plan_price' => $Product_fields['plan_price'][$i],
            'service_id' => $Product_fields['service_id'][$i],
        ];
    }

    // Return the response
    return response()->json(['status' => true, 'msg' => '', 'data' => $child_cat, 'Product_fieldsArray' => $Product_fieldsArray]);
}

    
    
    
    
    
}
