<?php

namespace App\Http\Controllers;
use App\Models\Banner;
use App\Models\Product;
use App\Models\Category;
use App\Models\PostTag;
use App\Models\PostCategory;
use App\Models\Post;
use App\Models\Cart;
use App\Models\Brand;
use App\Models\Plan;
use App\Models\Order;
use App\Models\loginModel;
use App\Models\VerifyUser;
use App\Models\Settings;
use App\Models\ProductReview;
use App\User;
use Auth;
use Session;
use Newsletter;
use DB;
use Hash;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Password;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Storage;
use Laravel\Socialite\Facades\Socialite;

use Illuminate\Support\Facades\Cache;


class FrontendController extends Controller
{

   
   
     public function redirectToGoogle(){
        
    
        return Socialite::driver('google')->redirect();
    }

        public function handleGoogleCallback()
    {
        $user = Socialite::driver('google')->user();
    
        // Check if the user already exists based on the email
        $findUser = VerifyUser::where('google_id', $user->id)->first();
    
        if (!$findUser) {
            // If the user doesn't exist, check by email
            $findUser = VerifyUser::where('email', $user->email)->first();
    
            if (!$findUser) {
                // If the user still doesn't exist, create a new one
                $findUser = VerifyUser::create([
                    'name' => $user->name,
                    'email' => $user->email,
                    'google_id' => $user->id,
                ]);
            }
        }
    
        Auth::login($findUser);
    
            //   $emailid = Session::get('email');
                          
            //     $orders = Order::where('email', $emailid)
            //   ->orderBy('id', 'DESC')
            //   ->paginate(10);
        return redirect('/');
                        // return redirect()->route('user/logininfo');
                                //   return view ("frontend/pages/logininformation_page", compact('emailid','orders'));


    }


    // public function index(Request $request)
    // {
    //     $user = Auth::user();
    
    //     // Redirect based on the user's role
    //     $route = $user->role; // Assuming the role corresponds to a route name
    
    //     // Pass user information to the view
    //     return view($route, ['user' => $user]);
    // }
    
    
    public function index(Request $request){
        //   $emailid = Session::get('user');
        return redirect()->route($request->user()->role);
    }
    
    
    public function like($service , $id){
        $element_id = base64_decode((string) $id);
        // echo $element_id;die();
        $Product_data = Product::find($element_id);
        $cat_id = $Product_data->cat_id;
        $service_id = $Product_data->service_id;
          $element_id =  $id;
        $title = $Product_data->title;
        $plan_con = ['category_id'=>$cat_id,'Fields'=>$title];
        // $Plan_data = Plan::where($plan_con)->get();
        
        $plan_value = $Product_data->plan_value;
        $plan_price = $Product_data->plan_price;
        $plan_values = explode(',',$plan_value);
        $plan_prices = explode(',', $plan_price);

        $MinPlan_Vlaue = min($plan_values);
        $MinPrice = min($plan_prices);
    // Assuming both arrays have the same length
    // if (count($plan_values) == count($plan_prices)) {
    //     foreach ($plan_values as $key => $value) {
    //         $current_price = $plan_prices[$key];
    
    //         // Use $value and $current_price as needed
    //         echo "Plan Value: $value, Plan Price: $current_price<br>";
    //     }
    // }

           $review_data = ProductReview::all();
           $setting_data = Settings::all();

        return view('frontend/pages/like',compact('Product_data','review_data','setting_data','service_id','plan_prices','plan_values','title','element_id','MinPlan_Vlaue','MinPrice'));
    }
    public function header($service){
        // $element_id = base64_decode((string) $id);
        $Category_data = Category::where('title',$service)->get();
        $cat_id =$Category_data[0]->id; 
        
        // echo $element_id;die();
        $Product_data = Product::where('cat_id',$cat_id)->get();
        // $cat_id = $Product_data->cat_id;
        // $title = $Product_data->title;
        // $plan_con = ['category_id'=>$cat_id,'Fields'=>$title];
        // echo "<pre>";
        // print_r($Product_data);
        // die();
        return json_encode(['status'=>true,'Product_data'=>$Product_data]);
    }

    public function checkout_selection($plan,$id,Request $req){

        $decode_id = base64_decode((string) $id);
        // $decode_id = $id;
        $plan_val = $req->get('plan_val');
        $price_val = $req->get('price_val');
        
        $service_id = $decode_id;
         $Product_data = Product::find($decode_id);
        // print_r($Product_data) ;
        // die();
         
         $plan_value = $Product_data->plan_value;
         $title = $Product_data->title;
        $plan_price = $Product_data->plan_price;
        $plan_values = explode(',',$plan_value);
        $plan_prices = explode(',', $plan_price);
        
        
        // $Plan_data = Plan::find($decode_id);
        // $category_id = $Plan_data->category_id;
        // $field_id = $Plan_data->Fields;
        // $plan_con = ['category_id'=>$category_id,'Fields'=>$field_id];
        // $all_Plan_data = Plan::where($plan_con)->get(); 
        // echo "<pre>";
        // print_r($title);
        // die();
        return view('frontend/pages/checkout/selection',compact('plan','decode_id','service_id','plan_values','plan_prices','title','price_val','plan_val'));
        // return view('frontend/pages/checkout/selection',compact('all_Plan_data','Plan_data','plan','decode_id','service_id'));
    }
    public function selection_post(Request $request){
        header('Access-Control-Allow-Origin: *');
        header('Access-Control-Allow-Methods: GET, POST');
        header("Access-Control-Allow-Headers: X-Requested-With");
        $req_data = $request->all();

        $nub_of_ser_count = $req_data['package-select'];
        $price = $req_data['price'];
        $plan = $req_data['plan'];
        $next_max_id = (int)$req_data['next_max_id'];
        $user_pk_id = (int)$req_data['pk_id'];
        $username = $req_data['username-input'];
      
        $explode_package = explode(',',$nub_of_ser_count);
        $planVal = $explode_package[0];
        $planprice = $explode_package[1];
        


            if(!empty($user_pk_id) && !empty($next_max_id)){

                $curl = curl_init();
    
                curl_setopt_array($curl, [
                	CURLOPT_URL => "https://rocketapi-for-instagram.p.rapidapi.com/instagram/user/get_media",
                	CURLOPT_RETURNTRANSFER => true,
                	CURLOPT_ENCODING => "",
                	CURLOPT_MAXREDIRS => 10,
                	CURLOPT_TIMEOUT => 30,
                	CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                	CURLOPT_CUSTOMREQUEST => "POST",
                	CURLOPT_POSTFIELDS => json_encode([
                		'id' => $user_pk_id,
                		'count' => 12,
                		'max_id' => $next_max_id
                	]),
                	CURLOPT_HTTPHEADER => [
                		"X-RapidAPI-Host: rocketapi-for-instagram.p.rapidapi.com",
                		"X-RapidAPI-Key: 8c25fcd73emsh340231e3ad84c0bp1e376cjsne0e86ea2e39e",
                		"content-type: application/json"
                	],
                ]);
                
                $response = curl_exec($curl);
                $err = curl_error($curl);
                
                curl_close($curl);
                
                if ($err) {
                	echo "cURL Error #:" . $err;
                } else {
                // 	echo $response;
                	 $array_res = json_decode($response, true);
                	 $terma_data = $array_res['response']['body']['items'];
                	 $body_res = $array_res['response']['body'];
                //  $variable = "some value";
    
                    if (isset($body_res['next_max_id'])) {
                        $next_max_id = $body_res['next_max_id'];
                    } else {
                        $next_max_id = '';
                    }
                // 	 $terma_data = $insts_post_data['items'];
                    $pk_id = $body_res['user']['pk_id'];
                    $user_id = $body_res['user']['pk_id'];
                    $full_name = $body_res['user']['full_name'];
                    $user_name = $body_res['user']['username'];
                    $profile_pic = $body_res['user']['profile_pic_url'];
                    
                    $static_val = true;
                    $user_name_isValid = true;
                }
            }elseif(empty($user_pk_id) && empty($next_max_id)){
         
                $curl = curl_init();
            
                curl_setopt_array($curl, [
                	CURLOPT_URL => "https://instagram230.p.rapidapi.com/user/posts?username=".$username,
                	CURLOPT_RETURNTRANSFER => true,
                	CURLOPT_ENCODING => "",
                	CURLOPT_MAXREDIRS => 10,
                	CURLOPT_TIMEOUT => 30,
                	CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                	CURLOPT_CUSTOMREQUEST => "GET",
                	CURLOPT_HTTPHEADER => [
                		"X-RapidAPI-Host: instagram230.p.rapidapi.com",
                		"X-RapidAPI-Key: 8c25fcd73emsh340231e3ad84c0bp1e376cjsne0e86ea2e39e"
                	],
                ]);
                
                $response = curl_exec($curl);
                $err = curl_error($curl);
                
                curl_close($curl);
                
                if ($err) {
                	echo "cURL Error #:" . $err;
                } else {
                    $insts_post_data = json_decode($response, true);
                    // echo "<pre>";
                    // print_r($insts_post_data);
                    // die();
            
                    if(count($insts_post_data['items']) >0){
                        
                            $terma_data = $insts_post_data['items'];
                            $next_max_id = $insts_post_data['next_max_id'];
                            $pk_id = $insts_post_data['user']['pk_id'];
                            $user_id = $insts_post_data['user']['pk_id'];
                            $full_name = $insts_post_data['user']['full_name'];
                            $user_name = $insts_post_data['user']['username'];
                            $profile_pic = $insts_post_data['user']['profile_pic_url'];
                            $user_name_isValid = true;
                    }else{
                        $terma_data = [];
                        $next_max_id = '';
                        $pk_id = '';
                        $user_id = '';
                        $full_name = '';
                        $user_name = '';
                        $profile_pic = '';
                        
                        $user_name_isValid = false;
                    }
                }
                
                $static_val = false;
            }
            

                        
            $post_link_id=[];
            
          $Pro_user_id = '';
            if(count($terma_data) >0){
                $PicdirectoryPath = public_path('frontend/insta_api_posts/profile_pic');
                
                if(!File::exists($PicdirectoryPath)){
                     File::makeDirectory($PicdirectoryPath, 0755, true);
                     
                     
                     
                    if ( File::isDirectory($PicdirectoryPath)) {    
                        $Pro_files = File::files($PicdirectoryPath);
                         //   print_r($files->getfileName());die();
                         $Pro_file_name = [];
                        foreach ($Pro_files as $Pro_file) {
                            $Pro_file_name[] = $Pro_file->getFilename();
                        }
                        
                        
                        if(in_array($user_id,$Pro_file_name)){
                            // $post_link_data['filePath'] = $file->getPathname();
                            // array_push($post_link_id,$insts_post_datas['code']);
                            $Pro_user_id = $user_id;
                        }else{
                            // $profile_pic = $terma_data[0]['user']['hd_profile_pic_versions'][0]['url'];
                            $pro_filename = $user_id; // You may generate a unique filename as needed
                            $PicdestionPath = public_path('frontend/insta_api_posts/profile_pic');
                            
                            // Download the image and save it to the public directory
                            file_put_contents("{$PicdestionPath}/{$pro_filename}", file_get_contents($profile_pic));
                            $Pro_user_id = $user_id;
                            // array_push($post_link_id,$insts_post_datas['code']);
                        }
                        
                        // $post_link_data['file_path'] = $insts_post_datas['code'];
                        
                    }else {
                        echo "The specified directory does not exist.";
                    }
                }else {
                        
                        //$imgUrl = $insts_post_datas['image_versions2']['candidates']['0']['url'];
                        
                        
                        if ( File::isDirectory($PicdirectoryPath)) {    
                            $Pro_files = File::files($PicdirectoryPath);
                             //   print_r($files->getfileName());die();
                             $Pro_file_name = [];
                            foreach ($Pro_files as $Pro_file) {
                                $Pro_file_name[] = $Pro_file->getFilename();
                            }
                            
                            
                            if(in_array($user_id,$Pro_file_name)){
                                // $post_link_data['filePath'] = $file->getPathname();
                                // array_push($post_link_id,$insts_post_datas['code']);
                                $Pro_user_id = $user_id;
                            }else{
                                // $profile_pic = $terma_data[0]['user']['hd_profile_pic_versions'][0]['url'];
                                $pro_filename = $user_id; // You may generate a unique filename as needed
                                $PicdestionPath = public_path('frontend/insta_api_posts/profile_pic');
                                
                                // Download the image and save it to the public directory
                                file_put_contents("{$PicdestionPath}/{$pro_filename}", file_get_contents($profile_pic));
                                $Pro_user_id = $user_id;
                                
                            }
                            
                        }
                    }
                
                foreach($terma_data as $insts_post_datas){
            
                    $directoryPath = public_path('frontend/insta_api_posts/post_img');
        
                    if (!File::exists($directoryPath)) {
                        // Directory doesn't exist, create it
                        File::makeDirectory($directoryPath, 0755, true);
                      
                         if (File::isDirectory($directoryPath) && File::isDirectory($PicdirectoryPath)) {    
                            $files = File::files($directoryPath);
                            $file_name = [];
                            foreach ($files as $file) {
                                $file_name[] = $file->getFilename();
                            }
                            
                            if(in_array($insts_post_datas['code'],$file_name)){
                                // $post_link_data['filePath'] = $file->getPathname();
                                array_push($post_link_id,$insts_post_datas['code']);
                            }else{
                                $imgUrl = $insts_post_datas['image_versions2']['candidates']['0']['url'];
                                $filename = $insts_post_datas['code']; // You may generate a unique filename as needed
                                $destinationPath = public_path('/frontend/insta_api_posts/post_img');
                                
                                // Download the image and save it to the public directory
                                file_put_contents("{$destinationPath}/{$filename}", file_get_contents($imgUrl));
                                
                                array_push($post_link_id,$insts_post_datas['code']);
                            }
                            
                        }else {
                            echo "The specified directory does not exist.";
                        }
                    } else {
                        
                        //$imgUrl = $insts_post_datas['image_versions2']['candidates']['0']['url'];
                        
                        
                         if (File::isDirectory($directoryPath)) {    
                            $files = File::files($directoryPath);
                             //   print_r($files->getfileName());die();
                             $file_name = [];
                            foreach ($files as $file) {
                                $file_name[] = $file->getFilename();
                            }
                            
                            
                            if(in_array($insts_post_datas['code'],$file_name)){
                                // $post_link_data['filePath'] = $file->getPathname();
                                array_push($post_link_id,$insts_post_datas['code']);
                            }else{
                                $imgUrl = $insts_post_datas['image_versions2']['candidates']['0']['url'];
                                $filename = $insts_post_datas['code']; // You may generate a unique filename as needed
                                $destinationPath = public_path('/frontend/insta_api_posts/post_img');
                                
                                // Download the image and save it to the public directory
                                file_put_contents("{$destinationPath}/{$filename}", file_get_contents($imgUrl));
                                array_push($post_link_id,$insts_post_datas['code']);
                            }
                            
                        }else {
                            echo "The specified directory does not exist.";
                        }
                    }
                }
            }
            
            
            // if(!empty($user_pk_id) && !empty($next_max_id)){
            //      $post_link_id=['Ch4KvmpP7yc','Ch4LAQAPP1M','Ch4Lf6xv5HU','Chc45zZKgpP','CiAGc4dPUad','CiDYxFfPtIj','CiQPU8yPnmy','CiU-et2KCzZ','CiX2nHpqIUp','Ck0sIpWLUT6','CLUXO9egIjC','CSkCMWXpOay'];
            //     $next_max_id = '2908449722172312143_4268234209555';
            //     $user_pk_id = '4268234209';
            //     $pk_id = '4268234209';
            //      $static_val = true;
            //      $user_name_isValid = false;
            // }elseif(empty($user_pk_id) && empty($next_max_id)){
            //     $next_max_id = '2908449722172312143_4268234209';
            //     $post_link_id=['B1fzgztgIkR','B2PTIgyguFX','B5RlRAoAcTA','BcU8jQxhBlW','BcU8MLHBIDx','BhneiUDnjnA','BhnfUNCHunk','Bj6qgC0H1MB','BnwQ3OHnQY2','BrwsnZIgp-G','Cbh4-T0PnIS','CC-kDFYAFpH','CC8T_FBA3E-','CC8TsaOAkKv','CDAl3EMASne','CDAlp_NA1py','CDAlsHigUZR','CDHaSv9gG0A','Ch-K81TqNQo','Ch-Lu5wqpzq'];
            //     $user_pk_id = '4268234209';
            //     $pk_id = '4268234209';
            //     $static_val = false;
            //     $user_name_isValid = true;
                
            // }
            
            // $full_name = 'lokesh';
            // $user_name = 'connect_l.k';
            // $Pro_user_id = '4268234209';
    
            return json_encode(['status'=>true,'post_link_id'=>$post_link_id,'nub_of_ser_count'=>$planVal,'price'=>$planprice,'plan'=>$plan,'full_name'=>$full_name,'user_name'=>$user_name,'Pro_user_id'=>$Pro_user_id,'next_max_id'=>$next_max_id,'pk_id'=>$pk_id,'static_val'=>$static_val,'user_name_isValid'=>$user_name_isValid]);

    }
    public function thankyou(Request $request){
        
        // print_r($plan);
        // die();
        // $service_value = $id;
        // $service_name = $plan;
        $email = session::get('email');
        $name = session::get('name');
        $price = session::get('price');
        
        return view('frontend/pages/thankyou',compact('email','name','price'));
    }
    public function checkout_media($plan,$id,$newid, Request $request){
        $post_data = $request->session()->get('data');

        return view('frontend/pages/checkout/media',compact('post_data'));
    }
    public function checkout_payment(){

        return view('frontend/pages/checkout/payment');
    }

    public function home(){
        $featured=Product::where('status','active')->where('is_featured',1)->orderBy('price','DESC')->limit(2)->get();
        $posts=Post::where('status','active')->orderBy('id','DESC')->limit(3)->get();
        $banners=Banner::where('status','active')->limit(3)->orderBy('id','DESC')->get();
        // return $banner;
        $products=Product::where('status','active')->orderBy('id','DESC')->limit(8)->get();
        $category=Category::where('status','active')->where('is_parent',1)->orderBy('title','ASC')->get();
        // echo "<pre>";
        // print_r($category);
        // die();
        // return $category;

        return view('frontend.index')
                ->with('featured',$featured)
                ->with('posts',$posts)
                ->with('banners',$banners)
                ->with('product_lists',$products)
                ->with('category_lists',$category);
    }   

    public function aboutUs(){
        return view('frontend.pages.about-us');
    }

    public function contact(){
        return view('frontend.pages.contact');
    }

    public function productDetail($slug){
        $product_detail= Product::getProductBySlug($slug);
        // dd($product_detail);
        return view('frontend.pages.product_detail')->with('product_detail',$product_detail);
    }

    public function productGrids(){
        $products=Product::query();
        
        if(!empty($_GET['category'])){
            $slug=explode(',',$_GET['category']);
            // dd($slug);
            $cat_ids=Category::select('id')->whereIn('slug',$slug)->pluck('id')->toArray();
            // dd($cat_ids);
            $products->whereIn('cat_id',$cat_ids);
            // return $products;
        }
        if(!empty($_GET['brand'])){
            $slugs=explode(',',$_GET['brand']);
            $brand_ids=Brand::select('id')->whereIn('slug',$slugs)->pluck('id')->toArray();
            return $brand_ids;
            $products->whereIn('brand_id',$brand_ids);
        }
        if(!empty($_GET['sortBy'])){
            if($_GET['sortBy']=='title'){
                $products=$products->where('status','active')->orderBy('title','ASC');
            }
            if($_GET['sortBy']=='price'){
                $products=$products->orderBy('price','ASC');
            }
        }

        if(!empty($_GET['price'])){
            $price=explode('-',$_GET['price']);
            // return $price;
            // if(isset($price[0]) && is_numeric($price[0])) $price[0]=floor(Helper::base_amount($price[0]));
            // if(isset($price[1]) && is_numeric($price[1])) $price[1]=ceil(Helper::base_amount($price[1]));
            
            $products->whereBetween('price',$price);
        }

        $recent_products=Product::where('status','active')->orderBy('id','DESC')->limit(3)->get();
        // Sort by number
        if(!empty($_GET['show'])){
            $products=$products->where('status','active')->paginate($_GET['show']);
        }
        else{
            $products=$products->where('status','active')->paginate(9);
        }
        // Sort by name , price, category

      
        return view('frontend.pages.product-grids')->with('products',$products)->with('recent_products',$recent_products);
    }
    public function productLists(){
        $products=Product::query();
        
        if(!empty($_GET['category'])){
            $slug=explode(',',$_GET['category']);
            // dd($slug);
            $cat_ids=Category::select('id')->whereIn('slug',$slug)->pluck('id')->toArray();
            // dd($cat_ids);
            $products->whereIn('cat_id',$cat_ids)->paginate;
            // return $products;
        }
        if(!empty($_GET['brand'])){
            $slugs=explode(',',$_GET['brand']);
            $brand_ids=Brand::select('id')->whereIn('slug',$slugs)->pluck('id')->toArray();
            return $brand_ids;
            $products->whereIn('brand_id',$brand_ids);
        }
        if(!empty($_GET['sortBy'])){
            if($_GET['sortBy']=='title'){
                $products=$products->where('status','active')->orderBy('title','ASC');
            }
            if($_GET['sortBy']=='price'){
                $products=$products->orderBy('price','ASC');
            }
        }

        if(!empty($_GET['price'])){
            $price=explode('-',$_GET['price']);
            // return $price;
            // if(isset($price[0]) && is_numeric($price[0])) $price[0]=floor(Helper::base_amount($price[0]));
            // if(isset($price[1]) && is_numeric($price[1])) $price[1]=ceil(Helper::base_amount($price[1]));
            
            $products->whereBetween('price',$price);
        }

        $recent_products=Product::where('status','active')->orderBy('id','DESC')->limit(3)->get();
        // Sort by number
        if(!empty($_GET['show'])){
            $products=$products->where('status','active')->paginate($_GET['show']);
        }
        else{
            $products=$products->where('status','active')->paginate(6);
        }
        // Sort by name , price, category

      
        return view('frontend.pages.product-lists')->with('products',$products)->with('recent_products',$recent_products);
    }
    public function productFilter(Request $request){
            $data= $request->all();
            // return $data;
            $showURL="";
            if(!empty($data['show'])){
                $showURL .='&show='.$data['show'];
            }

            $sortByURL='';
            if(!empty($data['sortBy'])){
                $sortByURL .='&sortBy='.$data['sortBy'];
            }

            $catURL="";
            if(!empty($data['category'])){
                foreach($data['category'] as $category){
                    if(empty($catURL)){
                        $catURL .='&category='.$category;
                    }
                    else{
                        $catURL .=','.$category;
                    }
                }
            }

            $brandURL="";
            if(!empty($data['brand'])){
                foreach($data['brand'] as $brand){
                    if(empty($brandURL)){
                        $brandURL .='&brand='.$brand;
                    }
                    else{
                        $brandURL .=','.$brand;
                    }
                }
            }
            // return $brandURL;

            $priceRangeURL="";
            if(!empty($data['price_range'])){
                $priceRangeURL .='&price='.$data['price_range'];
            }
            if(request()->is('e-shop.loc/product-grids')){
                return redirect()->route('product-grids',$catURL.$brandURL.$priceRangeURL.$showURL.$sortByURL);
            }
            else{
                return redirect()->route('product-lists',$catURL.$brandURL.$priceRangeURL.$showURL.$sortByURL);
            }
    }
    public function productSearch(Request $request){
        $recent_products=Product::where('status','active')->orderBy('id','DESC')->limit(3)->get();
        $products=Product::orwhere('title','like','%'.$request->search.'%')
                    ->orwhere('slug','like','%'.$request->search.'%')
                    ->orwhere('description','like','%'.$request->search.'%')
                    ->orwhere('summary','like','%'.$request->search.'%')
                    ->orwhere('price','like','%'.$request->search.'%')
                    ->orderBy('id','DESC')
                    ->paginate('9');
        return view('frontend.pages.product-grids')->with('products',$products)->with('recent_products',$recent_products);
    }

    public function productBrand(Request $request){
        $products=Brand::getProductByBrand($request->slug);
        $recent_products=Product::where('status','active')->orderBy('id','DESC')->limit(3)->get();
        if(request()->is('e-shop.loc/product-grids')){
            return view('frontend.pages.product-grids')->with('products',$products->products)->with('recent_products',$recent_products);
        }
        else{
            return view('frontend.pages.product-lists')->with('products',$products->products)->with('recent_products',$recent_products);
        }

    }
    public function productCat(Request $request){
        $products=Category::getProductByCat($request->slug);
        // return $request->slug;
        $recent_products=Product::where('status','active')->orderBy('id','DESC')->limit(3)->get();

        if(request()->is('e-shop.loc/product-grids')){
            return view('frontend.pages.product-grids')->with('products',$products->products)->with('recent_products',$recent_products);
        }
        else{
            return view('frontend.pages.product-lists')->with('products',$products->products)->with('recent_products',$recent_products);
        }

    }
    public function productSubCat(Request $request){
        $products=Category::getProductBySubCat($request->sub_slug);
        // return $products;
        $recent_products=Product::where('status','active')->orderBy('id','DESC')->limit(3)->get();

        if(request()->is('e-shop.loc/product-grids')){
            return view('frontend.pages.product-grids')->with('products',$products->sub_products)->with('recent_products',$recent_products);
        }
        else{
            return view('frontend.pages.product-lists')->with('products',$products->sub_products)->with('recent_products',$recent_products);
        }

    }

    public function blog(){
        return view('frontend.pages.blog');
    }
    public function support(){
        return view('frontend.pages.support');
    }

    public function blogDetail($slug){
        $post=Post::getPostBySlug($slug);
        $rcnt_post=Post::where('status','active')->orderBy('id','DESC')->limit(3)->get();
        // return $post;
        return view('frontend.pages.blog-detail')->with('post',$post)->with('recent_posts',$rcnt_post);
    }

    public function blogSearch(Request $request){
        // return $request->all();
        $rcnt_post=Post::where('status','active')->orderBy('id','DESC')->limit(3)->get();
        $posts=Post::orwhere('title','like','%'.$request->search.'%')
            ->orwhere('quote','like','%'.$request->search.'%')
            ->orwhere('summary','like','%'.$request->search.'%')
            ->orwhere('description','like','%'.$request->search.'%')
            ->orwhere('slug','like','%'.$request->search.'%')
            ->orderBy('id','DESC')
            ->paginate(8);
        return view('frontend.pages.blog')->with('posts',$posts)->with('recent_posts',$rcnt_post);
    }

    public function blogFilter(Request $request){
        $data=$request->all();
        // return $data;
        $catURL="";
        if(!empty($data['category'])){
            foreach($data['category'] as $category){
                if(empty($catURL)){
                    $catURL .='&category='.$category;
                }
                else{
                    $catURL .=','.$category;
                }
            }
        }

        $tagURL="";
        if(!empty($data['tag'])){
            foreach($data['tag'] as $tag){
                if(empty($tagURL)){
                    $tagURL .='&tag='.$tag;
                }
                else{
                    $tagURL .=','.$tag;
                }
            }
        }
        // return $tagURL;
            // return $catURL;
        return redirect()->route('blog',$catURL.$tagURL);
    }

    public function blogByCategory(Request $request){
        $post=PostCategory::getBlogByCategory($request->slug);
        $rcnt_post=Post::where('status','active')->orderBy('id','DESC')->limit(3)->get();
        return view('frontend.pages.blog')->with('posts',$post->post)->with('recent_posts',$rcnt_post);
    }

    public function blogByTag(Request $request){
        // dd($request->slug);
        $post=Post::getBlogByTag($request->slug);
        // return $post;
        $rcnt_post=Post::where('status','active')->orderBy('id','DESC')->limit(3)->get();
        return view('frontend.pages.blog')->with('posts',$post)->with('recent_posts',$rcnt_post);
    }

    // Login
    public function login(){
        

       
        return view('frontend.pages.login');
    }
    // public function loginSubmit(Request $request){
    //     $data= $request->all();
    //     if(Auth::attempt(['email' => $data['email'], 'password' => $data['password'],'status'=>'active'])){
    //         Session::put('user',$data['email']);
    //         request()->session()->flash('success','Successfully login');
    //         return redirect()->route('home');
    //     }
    //     else{
    //         request()->session()->flash('error','Invalid email and password pleas try again!');
    //         return redirect()->back();
    //     }
    // }
    

public function loginSubmit(Request $request)
{
    $data = $request->all();
// echo "<pre>";
// print_r($data);
// die();

        // User is successfully logged in

        // Save the login details in the userlogin table
        $login_models = new loginModel([
            'email' => $data['email'],
            'code' => $data['code'],
            // 'code' => generateUniqueCode(), // You need to define a function to generate a unique code
        ]);
        $login_models->save();

        // Store the user's email in the session
        Session::put('user', $data['email']);

        request()->session()->flash('success', 'Successfully logged in');
        return redirect()->route('home');

    
}

    
       
    

    public function logout(){
        Session::forget('user');
        Auth::logout();
        request()->session()->flash('success','Logout successfully');
        return back();
    }

    public function register(){
        return view('frontend.pages.register');
    }
    public function registerSubmit(Request $request){
        // return $request->all();
        $this->validate($request,[
            'name'=>'string|required|min:2',
            'email'=>'string|required|unique:users,email',
            'password'=>'required|min:6|confirmed',
        ]);
        $data=$request->all();
        // dd($data);
        $check=$this->create($data);
        Session::put('user',$data['email']);
        if($check){
            request()->session()->flash('success','Successfully registered');
            return redirect()->route('home');
        }
        else{
            request()->session()->flash('error','Please try again!');
            return back();
        }
    }
    public function create(array $data){
        return User::create([
            'name'=>$data['name'],
            'email'=>$data['email'],
            'password'=>Hash::make($data['password']),
            'status'=>'active'
            ]);
    }
    // Reset password
    public function showResetForm(Request $request){
        
        // echo 111;
        // die();
        return view('auth.passwords.old-reset');
    }
    
    
    
    
    // public function ResetForm(Request $request)
        
    //      {
    //     $request->validate([
    //         'email' => 'required|email|exists:users,email',
    //         'password' => 'required|confirmed|min:8',
    //     ]);

    //     $status = Password::reset(
    //         $request->only('email', 'password', 'password_confirmation', 'token'),
    //         function ($user, $password) {
    //             $user->forceFill([
    //                 'password' => bcrypt($password),
    //             ])->setRememberToken(Str::random(60));
    //             $user->save();
    //         }
    //     );

    //     // If password was successfully reset
    //     if ($status == Password::PASSWORD_RESET) {
    //         return redirect()->route('login')->with('status', __($status));
    //     }

    //     // If an error occurred during the password reset
    //     throw ValidationException::withMessages([
    //         'email' => [__($status)],
    //     ]);
    // }
        
        
        // return view('auth.passwords.adminresetpassword');
    
public function ResetForm(Request $request)
{
    $request->validate([
        'email' => 'required|email|exists:users,email',
        'password' => 'required|confirmed|min:8',
    ]);

    $user = User::where('email', $request->email)->first();

    if ($user) {
        $user->update([
            'password' => Hash::make($request->password),
            'remember_token' => Str::random(60),
        ]);

        // You can add additional logic here if needed.

        return redirect()->route('login')->with('status', 'Password has been reset successfully.');
    }

    return redirect()->back()->withErrors(['email' => 'User not found.']);
}




    public function subscribe(Request $request){
        if(! Newsletter::isSubscribed($request->email)){
                Newsletter::subscribePending($request->email);
                if(Newsletter::lastActionSucceeded()){
                    request()->session()->flash('success','Subscribed! Please check your email');
                    return redirect()->route('home');
                }
                else{
                    Newsletter::getLastError();
                    return back()->with('error','Something went wrong! please try again');
                }
            }
            else{
                request()->session()->flash('error','Already Subscribed');
                return back();
            }
    }

   public function privacy(){
       
       
        return view('frontend/pages/Privacy-Policy');
    }
    
    
   public function terms(){
       
       
        return view('/frontend/pages/Terms-of-Service');
    }
    
    
    
   public function instastory(Request $request){
       
       
        return view('/frontend/pages/Services/instagram_story_downlode');
    }
    
   public function story_download(Request $request){
       
       $user_name = $request->get('usernanme');
       
       
       if(!empty($user_name) || $user_name !=''){
           
            if (substr($user_name, 0, 1) === "@") {
                $username = $user_name;
            } else {
                $username = "@" . $user_name;
            }
            
           $curl = curl_init();
            
           curl_setopt_array($curl, [
            	CURLOPT_URL => "https://instagram-story-and-highlights-saver.p.rapidapi.com/api/stories?username=".$username,
            	CURLOPT_RETURNTRANSFER => true,
            	CURLOPT_ENCODING => "",
            	CURLOPT_MAXREDIRS => 10,
            	CURLOPT_TIMEOUT => 30,
            	CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            	CURLOPT_CUSTOMREQUEST => "GET",
            	CURLOPT_HTTPHEADER => [
            		"X-RapidAPI-Host: instagram-story-and-highlights-saver.p.rapidapi.com",
            		"X-RapidAPI-Key: 8c25fcd73emsh340231e3ad84c0bp1e376cjsne0e86ea2e39e"
            	],
            ]);
            
            $response = curl_exec($curl);
            $err = curl_error($curl);
            
            curl_close($curl);
            
            if ($err) {
            	echo "cURL Error #:" . $err;
            } else {
            	
    	         $array_res = json_decode($response);
    	         $array_resssss = json_decode(json_encode($array_res),true);

                $DOW_fullpath = [];
                $file_path = [];
                if(!empty($array_res)){
                    
                    if(count($array_resssss) == 0 ){
                        $is_check_url = false;
                        $file_path = '';
                        $is_username = true;
                    }else{
    	                $stories = $array_resssss['body']['stories'];
                        $is_check_url = true;
                        // $array_resssss = json_decode(json_encode($array_res),true);
                        // $medias_arr = $array_resssss['medias'];
                        
                        foreach($stories as $medias_arr_val){
                            if(isset($medias_arr_val['video_versions'])){
                                
                                $uploadmedia = $medias_arr_val['video_versions'][0]['url'];
                                
                            }else{
                                $uploadmedia = $medias_arr_val['image_versions2']['candidates'][0]['url'];
                                
                            }
        
                            $rand = rand(999,9999999);
                            $videoUrl = $uploadmedia;
                            $fileName = basename(parse_url($uploadmedia, PHP_URL_PATH));
                            $localPath = public_path('frontend/insta_post_download/story_video/'.$fileName);
                            $response = Http::get($videoUrl);
                        
                            if ($response->status() !== 200) {
                                // Handle error, e.g., by returning or logging
                                return false;
                            }
                        
                            $videoData = $response->body();
                        
                            if (File::exists($localPath)) {
                                File::delete($localPath);
                            }
                        
                            File::put($localPath, $videoData);
                            $set_permission = chmod($localPath,0755);
                            $file_path[] = $fileName;
            
                        }
                        
                        $is_username = true;
                    }
                }else{
                    $is_check_url = false;
                    $file_path = '';
                    $is_username = true;
                }
      
            }
       }else{
           $is_check_url = false;
           $file_path = '';
           $username = '';
           $is_username = false;
       }
        
        
        
        
    	return json_encode(['status'=>true,'story_path'=>$file_path,'is_check_url'=>$is_check_url,'user_name'=>$username,'is_username'=>$is_username]);

    }
    
    
    
   public function instacount(Request $request){
       
       
        return view('/frontend/pages/Services/instagram_count');
    }
    
    
    
    
    
   public function follower_count(Request $request){
       
       
       $username = $request->username;

    //   echo ' https://instagram-api38.p.rapidapi.com/?username='.$username;
    //   die();
   
        $curl = curl_init();
        
        curl_setopt_array($curl, [
        	CURLOPT_URL => "https://instagram-api38.p.rapidapi.com/?username=".$username,
        	CURLOPT_RETURNTRANSFER => true,
        	CURLOPT_ENCODING => "",
        	CURLOPT_MAXREDIRS => 10,
        	CURLOPT_TIMEOUT => 30,
        	CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        	CURLOPT_CUSTOMREQUEST => "GET",
        	CURLOPT_HTTPHEADER => [
        		"X-RapidAPI-Host: instagram-api38.p.rapidapi.com",
        		"X-RapidAPI-Key: 0f7c1bcc00mshd542a6994aa35b5p1d9917jsndbb623c4ca87"
        	],
        ]);
        
        $response = curl_exec($curl);
        
   
        $err = curl_error($curl);
        
        curl_close($curl);
      $jsonData = json_decode($response, true);
      
      $followerCount = $jsonData['result']['edge_followed_by']['count'];
      $fullName = $jsonData['result']['full_name'];
      $profilePicUrl = $jsonData['result']['profile_pic_url'];

    return response()->json([
        'follower_count' => $followerCount,
        'full_name' => $fullName,
        'profile_pic_url' => $profilePicUrl
    ]);

     
            }
 
    
    
   public function instapost(Request $request){
       
       
        return view('/frontend/pages/Services/instagram_post_downlode');
    }
   public function post_download(Request $request){
       
    $curl = curl_init();
    
    curl_setopt_array($curl, [
    	CURLOPT_URL => "https://instagram-post-and-reels-downloader.p.rapidapi.com/?url=".$request->get('link'),
    	CURLOPT_RETURNTRANSFER => true,
    	CURLOPT_ENCODING => "",
    	CURLOPT_MAXREDIRS => 10,
    	CURLOPT_TIMEOUT => 30,
    	CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    	CURLOPT_CUSTOMREQUEST => "GET",
    	CURLOPT_HTTPHEADER => [
    		"X-RapidAPI-Host: instagram-post-and-reels-downloader.p.rapidapi.com",
    		"X-RapidAPI-Key: 8c25fcd73emsh340231e3ad84c0bp1e376cjsne0e86ea2e39e"
    	],
    ]);
    
    $response = curl_exec($curl);
    $err = curl_error($curl);
    
    curl_close($curl);
    
    if ($err) {
    	echo "cURL Error #:" . $err;
    } else {
    
        $array_res = json_decode($response);
        // echo "<pre>";
        // print_r($array_res);
        // die();
        if(!empty($array_res)){
            
            if(count($array_res) == 0 ){
                $is_check_url = false;
                $link_Url = '';
            }else{
                $is_check_url = true;
                $array_resssss = json_decode(json_encode($array_res),true);
                $link_Url = $array_resssss[0]['link'];
            }
        }else{
            $is_check_url = false;
            $link_Url = '';
        }
        
        // if($array_resssss[0]['type'] == 'mp4'){
        //     $fileName = basename(parse_url($array_resssss[0]['link'], PHP_URL_PATH));
        //     // Generate a random prefix (you can customize this if needed)
        //     $randomPrefix = uniqid();
                
        //     $newFileName = $randomPrefix . '_' . $fileName;
        // }elseif($array_resssss[0]['type'] == 'jpg'){
        //     // Extract the file name from the URL
        //     $fileName = basename(parse_url($array_resssss[0]['link'], PHP_URL_PATH));
            
        //     // Generate a random prefix (you can customize this if needed)
        //     $randomPrefix = uniqid();
            
        //     // Extract the filename without the extension
        //     $filenameWithoutExtension = pathinfo($fileName, PATHINFO_FILENAME);
            
        //     // Change the file name to a random value with a prefix and ".jpg" extension
        //     $newFileName = $randomPrefix . '_' . $filenameWithoutExtension . '.jpg';
        // }
        
        // return response()->download($array_resssss[0]['link']);
        
        return json_encode(['status'=>true,'downloadpost'=>$link_Url,'is_check_url'=>$is_check_url]);
    
    }

    // return json_encode(['status'=>true,'downloadpost'=>'https://proxy.mediadownloader.app/get?__sig=jpcJ1qXI0MdvpHsRZob8Cg&__expires=1709277587&uri=https%3A%2F%2Finstagram.fcmb2-2.fna.fbcdn.net%2Fv%2Ft39.30808-6%2F426575906_18299932960147970_1618760520032252424_n.jpg%3Fstp%3Ddst-jpg_e35_s1080x1080_sh0.08%26efg%3DeyJ2ZW5jb2RlX3RhZyI6ImltYWdlX3VybGdlbi4yMDQ4eDIwNDguc2RyIn0%26_nc_ht%3Dinstagram.fcmb2-2.fna.fbcdn.net%26_nc_cat%3D102%26_nc_ohc%3DzDq8lgcXSLkAX_XDuZq%26edm%3DAP_V10EAAAAA%26ccb%3D7-5%26oh%3D00_AfBrdu0JwM8B7gTvrWoiEdMLknA8lmYkwgIxP3jzAq3ipA%26oe%3D65E5DD52%26_nc_sid%3D2999b8%26dl%3D1&filename=In+the+end%2C+it%E2%80%99s+not+the+years+in+your+life+that+count.+It%E2%80%99s+the+life+in+your+years++............%23desert+%23jaislmer+%23jaisalmer+%23photographers+%23photoshoot+%23wood+%23camera+%23dslr+%23trend+%23priyanshu_kast.jpg&__srvid=instagram&__cid=mTY2wLHa1yPMcXBdrchsqQ']);


    
     $rand = rand(999,9999999);
    $videoUrl = "https://scontent.cdninstagram.com/v/t66.30100-16/45665015_311224558240921_4752123960673615918_n.mp4?_nc_ht=scontent.cdninstagram.com&_nc_cat=101&_nc_ohc=wQqd483I5C4AX9o_iVw&edm=APs17CUBAAAA&ccb=7-5&oh=00_AfDSst5yle-uJRTLT-D3rhsTLtAkXS0_ZBNrSu9xdRxmmQ&oe=65E2CE03&_nc_sid=10d13b";
    // $localPath = public_path("/videos/downloaded_video.mp4"); // Update with the desired save path and video file name
    $localPath = public_path('frontend/insta_post_download/post_video'.$rand.'.mp4');

    $response = Http::get($videoUrl);

    if ($response->status() !== 200) {
        // Handle error, e.g., by returning or logging
        return false;
    }

    $videoData = $response->body();

    if (File::exists($localPath)) {
        File::delete($localPath);
    }

    File::put($localPath, $videoData);
    $set_permission = chmod($localPath,0755);
    $DOW_fullpath = public_path('frontend/insta_post_download/post_video'.$rand.'.mp4');
    return response()->download($DOW_fullpath);




        // print_r("https://instagram-downloader-download-instagram-videos-stories.p.rapidapi.com/index?url=".$request->get('link'));
        // die();
        // $curl = curl_init();
        
        // curl_setopt_array($curl, [
        // 	CURLOPT_URL => "https://instagram-downloader-download-instagram-videos-stories.p.rapidapi.com/index?url=".$request->get('link'),
        // 	CURLOPT_RETURNTRANSFER => true,
        // 	CURLOPT_ENCODING => "",
        // 	CURLOPT_MAXREDIRS => 10,
        // 	CURLOPT_TIMEOUT => 30,
        // 	CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        // 	CURLOPT_CUSTOMREQUEST => "GET",
        // 	CURLOPT_HTTPHEADER => [
        // 		"X-RapidAPI-Host: instagram-downloader-download-instagram-videos-stories.p.rapidapi.com",
        // 		"X-RapidAPI-Key: 8c25fcd73emsh340231e3ad84c0bp1e376cjsne0e86ea2e39e"
        // 	],
        // ]);
        
        // $response = curl_exec($curl);
        // $err = curl_error($curl);
        
        // curl_close($curl);
        
        // if ($err) {
        // 	echo "cURL Error #:" . $err;
        // } else {
        //     echo "<pre>";
        // 	print_r($response);
        // 	die();
        // }

    

        
        // $videoUrl = "https://www.instagram.com/p/CHZGLObDQV2/media/?size=l"; // Update with the video URL
        // $savePath = public_path("/test/videos/test.mp4"); // Update with the desired save path and video file extension
        
        // if (save_video($videoUrl, $savePath)) {
        //     echo "Video saved successfully.";
        // } else {
        //     echo "Failed to save video.";
        // }
    
    
    
    
        
        //   $req_url = $request->get('link');
        //   $url = $req_url."/media/?size=l";
    
        //     $rand = rand(999,9999999);
        //     $fullpath = public_path('frontend/insta_post_download/'.$rand.'.mp4'); // Assuming you want to save the file in the public directory
        //         // return response()->file($fullpath);
        //         // Download the image using Laravel's Http facade
        //         $response = Http::get($url);
            
        //         // Check if the request was successful (status code 200)
        //         if ($response->successful()) {
        //             // Save the image to the specified path
        //             File::put($fullpath, $response->body());
        //             $set_permission = chmod($fullpath,0755);
        //             $DOW_fullpath = public_path('frontend/insta_post_download/'.$rand.'.mp4');
        //     return response()->download($DOW_fullpath);
     
        //             echo "Image saved successfully.";
        //         } else {
        //             echo "Failed to download the image. HTTP status code: " . $response->status();
        //         }
    



        
    }
    
    

}
