<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\Cart;
use App\Models\Order;
// use App\Models\Order;
use App\Models\Product;
use App\Models\ApiService;
use App\Models\VerifyUser;
use App\Models\Shipping;
use App\Models\Provider;
use App\User;
use PDF;
use Notification;
use Helper;
use Illuminate\Support\Str;
use App\Notifications\StatusNotification;
use Session;
use Illuminate\Support\Facades\Mail;
use App\Mail\order_mail;
use Illuminate\Support\Facades\Http;

class OrderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $orders=Order::orderBy('id','DESC')->paginate(10);
        return view('backend.order.index')->with('orders',$orders);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

// public function generateInvoicePDF($order)
// {
//     $file_name = $order->order_number . '-' . $order->first_name . '.pdf';
//     $pdf = PDF::loadView('backend.order.pdf', compact('order'));

//     // Save the PDF to the public directory
//     $path = 'invoices/' . $file_name;
    
//     // Ensure the directory exists before saving
//     $directory = storage_path('app/public/invoices');
//     if (!file_exists($directory)) {
//         mkdir($directory, 0755, true);
//     }

//     // Save the PDF to the specified path
//     $pdf->save(storage_path('app/public/' . $path));

//     return $path;
// }

     
     
     
private function sendOrderMailWithPDF($email, $order){
    // Assuming you have a function to generate and save the PDF, replace 'generateInvoicePDF' with your actual function
    $invoicePath = $this->generateInvoicePDF($order);

    // Ensure the PDF was generated successfully
    if ($invoicePath) {
        // Pass the $order to the Mailable constructor to make it available in the mail view
        $mail = new order_mail($order);

        // Attach the PDF to the email
        $mail->attach($invoicePath, [
            'as' => 'Order_Info.', // Name of the attached file
            'mime' => 'application/pdf', // Mime type of the attached file
        ]);

        // Send the email
        Mail::to($email)->send($mail);
    }
}

public function generateInvoicePDF($order){
    $file_name = $order->order_number . '-' . $order->first_name . '.pdf';
    $pdf = PDF::loadView('backend.order.pdf', compact('order'));

    // Save the PDF to storage or public directory
    $path = 'invoices/' . $file_name;

    // Ensure the directory exists before saving
    $directory = storage_path('app/public/invoices');
    if (!file_exists($directory)) {
        mkdir($directory, 0755, true);
    }

    // Save the PDF to the specified path
    $pdf->save($directory . '/' . $file_name);

    return $directory . '/' . $file_name;
}


     
    public function store(Request $request)
    {
   
        
        $product_id =($request->product_id);
        
        $get_product_data  = Product:: find($product_id);
             
        
        $service_provider_ID = $get_product_data->service_provider;
     
        $apiService_data = Provider::find($service_provider_ID);
   
        $providername= $apiService_data->name;
        //         echo "<pre>";
        // print_r($providername);
        // die();
        
        // $this->validate($request,[
        //     'first_name'=>'string|required',
        //     'last_name'=>'string|required',
        //     'address1'=>'string|required',
        //     'address2'=>'string|nullable',
        //     'coupon'=>'nullable|numeric',
        //     'phone'=>'numeric|required',
        //     'post_code'=>'string|nullable',
        //     'email'=>'string|required'
        // ]);
        // return $request->all();

        // if(empty(Cart::where('user_id',auth()->user()->id)->where('order_id',null)->first())){
        //     request()->session()->flash('error','Cart is Empty !');
        //     return back();
        // }
        // $cart=Cart::get();
        // // return $cart;
        // $cart_index='ORD-'.strtoupper(uniqid());
        // $sub_total=0;
        // foreach($cart as $cart_item){
        //     $sub_total+=$cart_item['amount'];
        //     $data=array(
        //         'cart_id'=>$cart_index,
        //         'user_id'=>$request->user()->id,
        //         'product_id'=>$cart_item['id'],
        //         'quantity'=>$cart_item['quantity'],
        //         'amount'=>$cart_item['amount'],
        //         'status'=>'new',
        //         'price'=>$cart_item['price'],
        //     );

        //     $cart=new Cart();
        //     $cart->fill($data);
        //     $cart->save();
        // }

        // $total_prod=0;
        // if(session('cart')){
        //         foreach(session('cart') as $cart_items){
        //             $total_prod+=$cart_items['quantity'];
        //         }
        // }
        $service_value =  $request->get('service_value');
        $service_name =  $request->get('service_name');
        $email = $request->get('checkout__email');
        $order=new Order();
        $order_data=$request->all();
        

        // $order->order_number = 'ORD-'.strtoupper(Str::random(10));
        
        $order->email = $email;
        $order->first_name = $request->get('checkout__cardholder');
        $order->country = $request->get('checkout__country');
        $order->product_id = $request->get('product_id');
        $order->link = $request->get('link');
        $order->service_value = $service_value;
        $order->service_name = $service_name;
        $order->total_amount = $request->get('price');
        $order->post_code = $request->get('checkout__zip');
        $order->provider_name =$providername;
        
        $order->payment_method = 'cod';
        $order->payment_status = 'Unpaid';
        // $order->fill($order_data);
        
        session::put('email',$request->get('checkout__email'));
        session::put('name',$request->get('checkout__cardholder'));
        session::put('price',$request->get('price'));
        
        $order->save();
        
        // echo"<pre>";
        // print_r($order);
        // die();
        
        
    if ($order == true) {
        $get_verifyuser_data = VerifyUser::all();
        foreach ($get_verifyuser_data as $get_verifyuser_value) {
            $email_val[] = $get_verifyuser_value->email;
        }

        $invoicePath = $this->generateInvoicePDF($order);

        if (in_array($email, $email_val)) {
            $this->sendOrderMailWithPDF($email, $order, $invoicePath);
        } else {
            $VerifyUser = new VerifyUser();
            $VerifyUser->email = $email;
            $VerifyUser->save();

            if ($VerifyUser == true) {
                $this->sendOrderMailWithPDF($email, $order, $invoicePath);
            }
        }
    }

        
        //   die();     
        // if($order == true){
        //     $get_verifyuser_data = VerifyUser::all();
        //     foreach($get_verifyuser_data as $get_verifyuser_value){
        //         $email_val[] = $get_verifyuser_value->email;
                
        //     }
        //         if(in_array($email,$email_val)){
        //             Mail::to($email)->send(new order_mail());
        //         }else{
        //             // echo "failed";
                    
        //             // die();
        //             $VerifyUser = new VerifyUser();
        //             $VerifyUser->email = $email;
        //             $VerifyUser->save();
        //             if($VerifyUser == true){
                        
        //                 Mail::to($email)->send(new order_mail());
        //             }
        //         }
                
                
        // }
        
        
        
        $lastInsertedId = $order->id;
        // $lastInsertedId = 126;
        $get_order_data = Order:: find($lastInsertedId);


        $product_id = $get_order_data->product_id;
        $link_ID = $get_order_data->link;
        $link_IDs = json_decode($link_ID);
        $link_decode = json_decode(json_encode($link_IDs), true);
        // $link_decode = json_decode($link_ID);
        $service_name = $get_order_data->service_name;
        $service_value = $get_order_data->service_value;
        $order_number = $get_order_data->order_number;

        $get_product_data  = Product:: find($product_id);
        $service_provider_ID = $get_product_data->service_provider;
        $apiService_data = Provider::find($service_provider_ID);
        
        $providername= $apiService_data->name;
        
        // echo "<pre>";
        // print_r($providername);
        // die();
        $api_key = $apiService_data->api_key;
        $api_token = $apiService_data->api_token;
        $serviceparameter = $apiService_data->serviceparameter;
        $quantityparameter = $apiService_data->quantityparameter;
        $commentparameter = $apiService_data->commentparameter;
        $actionparameter = $apiService_data->actionparameter;
        
        $all_service_id = $get_product_data->service_id;
        $explode_service_ids = explode(',',$all_service_id);
        $all_plan_values = $get_product_data->plan_value;
        $explode_plan_count = explode(',',$all_plan_values);
        $indexNumber = array_search($service_value, $explode_plan_count);
        $service_id = $explode_service_ids[$indexNumber];


        $api_tocken = '$2y$10$qjlYR9aVV4QFBvCcPYHzieWrPdWoDW/r.vF9DrsDUkYRf1ADHuu46';
        $package = 2;
        $quantity = 10;
        $comments = 'hii';
        $action = 'add';
        
        
        foreach($link_decode as $link_decode_key => $link_decode_val){

            if($service_name == 'Follow'){
                $link = 'https://www.instagram.com/'.$link_decode_val;
                
                 $curl = curl_init();
                curl_setopt_array($curl, array(
                  CURLOPT_URL => $api_key.'?api_token='.$api_token.'&'.$serviceparameter.'='.$service_id.'&link='.$link.'&'.$quantityparameter.'='.$link_decode_key.'&'.$commentparameter.'='.$comments.'&'.$actionparameter.'='.$action,
                  CURLOPT_RETURNTRANSFER => true,
                  CURLOPT_ENCODING => '',
                  CURLOPT_MAXREDIRS => 10,
                  CURLOPT_TIMEOUT => 0,
                  CURLOPT_FOLLOWLOCATION => true,
                  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                  CURLOPT_CUSTOMREQUEST => 'POST',
                ));
                
                $response = curl_exec($curl);
                
                curl_close($curl);
                

                // Decode JSON string to array
                $dataArray = json_decode($response, true);
                
                // Check for JSON decoding errors
                if (json_last_error() !== JSON_ERROR_NONE) {
                    // Handle decoding error
                    echo "Error decoding JSON: " . json_last_error_msg();
                } else {
                    // Check if "order" key exists before accessing it
                    if (isset($dataArray['order'])) {
                        // Access and echo the "order" value
                          $ordid= $dataArray['order'];
                          $get_order_data->update(['order_number' => $ordid]);

                        
                    } else {
                        echo "Key 'order' not found in the decoded data";
                    }
                }

            }else{
                $link = 'https://www.instagram.com/p/'.$link_decode_val;
                
                $curl = curl_init();
                curl_setopt_array($curl, array(
                  CURLOPT_URL => $api_key.'?api_token='.$api_token.'&'.$serviceparameter.'='.$service_id.'&link='.$link.'&'.$quantityparameter.'='.$quantity.'&'.$commentparameter.'='.$comments.'&'.$actionparameter.'='.$action,
                  CURLOPT_RETURNTRANSFER => true,
                  CURLOPT_ENCODING => '',
                  CURLOPT_MAXREDIRS => 10,
                  CURLOPT_TIMEOUT => 0,
                  CURLOPT_FOLLOWLOCATION => true,
                  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                  CURLOPT_CUSTOMREQUEST => 'POST',
                ));
                
                $response = curl_exec($curl);
                
                curl_close($curl);
                
                // echo $response; 
                // die();
                 // Decode JSON string to array
                $dataArray = json_decode($response, true);
                
                // Check for JSON decoding errors
                if (json_last_error() !== JSON_ERROR_NONE) {
                    // Handle decoding error
                    echo "Error decoding JSON: " . json_last_error_msg();
                } else {
                    // Check if "order" key exists before accessing it
                    if (isset($dataArray['order'])) {
                        // Access and echo the "order" value
                          $ordid= $dataArray['order'];
                          $get_order_data->update(['order_number' => $ordid]);

                        
                    } else {
                        echo "Key 'order' not found in the decoded data";
                    }
                }

            }

            
        }
        session::put('service_name',$service_name);
        session::put('order_number',$order_number);






        // die();
        return json_encode(['status'=>true,'service_value'=>$service_value,'service_name'=>$service_name]);
        

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
     
     
      public function getOrderStatus($order,Request $req)
    {
        
    $orderId = Order::find($order);
    $ordid =$orderId->order_number;
    

        // Make the API request
        $response = Http::post('https://reseller.shuttericons.com/api/v2', [
            'api_token' => '$2y$10$qjlYR9aVV4QFBvCcPYHzieWrPdWoDW/r.vF9DrsDUkYRf1ADHuu46',
            'action' => 'status',
            'order' =>$ordid,
        ]);

        // Get the response content
        $apiResponse = $response->body();
        return $apiResponse;
    }
     
     
     
     
     
     
     
     
     
     
     
     
//  public function getOrderDetails(Request $request)
//     {
        
  
//         $orderId = $request->input('order_id'); // Assuming you pass the order ID as a parameter
        
        
        
//         //         $curl = curl_init();
//         //         curl_setopt_array($curl, array(
//         //           CURLOPT_URL => 'https://reseller.shuttericons.com/api/v2?api_token=%242y%2410%24qjlYR9aVV4QFBvCcPYHzieWrPdWoDW%2Fr.vF9DrsDUkYRf1ADHuu46&action=status&order=153596',
//         //           CURLOPT_RETURNTRANSFER => true,
//         //           CURLOPT_ENCODING => '',
//         //           CURLOPT_MAXREDIRS => 10,
//         //           CURLOPT_TIMEOUT => 0,
//         //           CURLOPT_FOLLOWLOCATION => true,
//         //           CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//         //           CURLOPT_CUSTOMREQUEST => 'POST',
//         //         ));
//         //         $response = curl_exec($curl);
//         //         curl_close($curl);
//         //         echo $response;
        
        
        
//         // die();

//         $apiUrl = "https://reseller.shuttericons.com/api/v2?api_token=%242y%2410%24qjlYR9aVV4QFBvCcPYHzieWrPdWoDW%2Fr.vF9DrsDUkYRf1ADHuu46&action=status&order={$orderId}";

//         try {
//             $response = Http::post($apiUrl);

//             // Assuming the API returns JSON
//             $responseData = $response->json();
            
//             // echo "<pre>";
//             // print_r($responseData);
//             // die();
            

//             // Do something with the API response data
//             // For example, you can return the data to a view
//             return view('your.view', ['orderDetails' => $responseData]);
//         } catch (\Exception $e) {
//             // Handle any errors that may occur during the API request
//             return view('your.error-view', ['error' => $e->getMessage()]);
//         }
//     }






// public function getOrderStatus(Request $request, $order)
// {
    
    
//     echo 111;
//     die();
//     $curl = curl_init();

//     curl_setopt_array($curl, array(
//       CURLOPT_URL => "https://reseller.shuttericons.com/api/v2?api_token=%242y%2410%24qjlYR9aVV4QFBvCcPYHzieWrPdWoDW%2Fr.vF9DrsDUkYRf1ADHuu46&action=status&order=" . $order,
//       CURLOPT_RETURNTRANSFER => true,
//       // ... other cURL options ...
//     ));

//     $response = curl_exec($curl);

//     curl_close($curl);

//     // Return the API response as JSON
//     return response()->json(['status' => $response]);
// }





// public function getOrderStatus($order)
//     {
        
        
               
// $curl = curl_init();

// curl_setopt_array($curl, array(
//   CURLOPT_URL => 'https://reseller.shuttericons.com/api/v2?api_token=%242y%2410%24qjlYR9aVV4QFBvCcPYHzieWrPdWoDW%2Fr.vF9DrsDUkYRf1ADHuu46&action=status&order=154146',
//   CURLOPT_RETURNTRANSFER => true,
//   CURLOPT_ENCODING => '',
//   CURLOPT_MAXREDIRS => 10,
//   CURLOPT_TIMEOUT => 0,
//   CURLOPT_FOLLOWLOCATION => true,
//   CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//   CURLOPT_CUSTOMREQUEST => 'POST',
//   CURLOPT_HTTPHEADER => array(
//     'X-Shopify-Access-Token: {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}',
//     'Cookie: XSRF-TOKEN=eyJpdiI6IjV5dEdsaDRKUlRIMG1CRnFZM01wQnc9PSIsInZhbHVlIjoidnVLTThrZzRDcXRFSVNPeGtaTkFscGlcLzhSRks1QktHZ3RaZ2hJekV5WnJHRkhBNzluVklsT1l3ZFwvMEZZbjlcL05Ia3hoSVpuNWJBVHNrQzNSekNlQ3c9PSIsIm1hYyI6IjYyOTIzMTBiNzU0Njg3N2YwYTE0MmQzMzZkNzI4NTM5ZmFiZDdlNzBhNmVhMjY0ZTlhYzUwOGM5OWU4NmRlNDgifQ%3D%3D; laravel_session=eyJpdiI6IktSOGl4aFZCOURJZllPcGZsdEFWVlE9PSIsInZhbHVlIjoiNENxOE9rZHFpY3pUTWpUbVwvUXR5cUFhU2RwdExRa1UwMHNIZXdyQys4NjNDU0k4QlwvVjhXZEhraVYrK3hZaW9DMlNYYU1WenFzU0w0NDhyb2F1ZlA3UT09IiwibWFjIjoiMzQyNTMzN2FlNDhhOTRiYWJiM2JhZWIwMjNlZDNiNjI2ZmRlNzlkYWRkMDViYWNlMjMxZDBlMzcxYjhiODExNCJ9'
//   ),
// ));

// $response = curl_exec($curl);

// curl_close($curl);
// echo $response;
// die();
        
 
        
        
        
        
        
        
//     $order=154146;
//         try {
//             $apiUrl = "https://reseller.shuttericons.com/api/v2?api_token=%242y%2410%24qjlYR9aVV4QFBvCcPYHzieWrPdWoDW%2Fr.vF9DrsDUkYRf1ADHuu46&action=status&order=154146";

//             $response = Http::get($apiUrl);
//             $apiData = $response->json();

//             return view('backend/order/index', ['apiData' => $apiData]);
//         } catch (\Exception $e) {
//             // Handle any errors that may occur during the API request
//             return view('backend/order/index', ['error' => $e->getMessage()]);
//         }
//     }


     
     
    public function show($id)
    {
        $order=Order::find($id);
        // return $order;
        return view('backend.order.show')->with('order',$order);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $order=Order::find($id);
        return view('backend.order.edit')->with('order',$order);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $order=Order::find($id);
        $this->validate($request,[
            'status'=>'required|in:new,process,delivered,cancel'
        ]);
        $data=$request->all();
        // return $request->status;
        if($request->status=='delivered'){
            foreach($order->cart as $cart){
                $product=$cart->product;
                // return $product;
                $product->stock -=$cart->quantity;
                $product->save();
            }
        }
        $status=$order->fill($data)->save();
        if($status){
            request()->session()->flash('success','Successfully updated order');
        }
        else{
            request()->session()->flash('error','Error while updating order');
        }
        return redirect()->route('order.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $order=Order::find($id);
        if($order){
            $status=$order->delete();
            if($status){
                request()->session()->flash('success','Order Successfully deleted');
            }
            else{
                request()->session()->flash('error','Order can not deleted');
            }
            return redirect()->route('order.index');
        }
        else{
            request()->session()->flash('error','Order can not found');
            return redirect()->back();
        }
    }

    public function orderTrack(){
        return view('frontend.pages.order-track');
    }

    public function productTrackOrder(Request $request){
        // return $request->all();
        $order=Order::where('user_id',auth()->user()->id)->where('order_number',$request->order_number)->first();
        if($order){
            if($order->status=="new"){
            request()->session()->flash('success','Your order has been placed. please wait.');
            return redirect()->route('home');

            }
            elseif($order->status=="process"){
                request()->session()->flash('success','Your order is under processing please wait.');
                return redirect()->route('home');
    
            }
            elseif($order->status=="delivered"){
                request()->session()->flash('success','Your order is successfully delivered.');
                return redirect()->route('home');
    
            }
            else{
                request()->session()->flash('error','Your order canceled. please try again');
                return redirect()->route('home');
    
            }
        }
        else{
            request()->session()->flash('error','Invalid order numer please try again');
            return back();
        }
    }

    // PDF generate
    public function pdf(Request $request){
        $order=Order::getAllOrder($request->id);
        // return $order;
        $file_name=$order->order_number.'-'.$order->first_name.'.pdf';
        // return $file_name;
        $pdf=PDF::loadview('backend.order.pdf',compact('order'));
        return $pdf->download($file_name);
    }
    // Income chart
    public function incomeChart(Request $request){
        $year=\Carbon\Carbon::now()->year;
        // dd($year);
        $items=Order::with(['cart_info'])->whereYear('created_at',$year)->where('status','delivered')->get()
            ->groupBy(function($d){
                return \Carbon\Carbon::parse($d->created_at)->format('m');
            });
            // dd($items);
        $result=[];
        foreach($items as $month=>$item_collections){
            foreach($item_collections as $item){
                $amount=$item->cart_info->sum('amount');
                // dd($amount);
                $m=intval($month);
                // return $m;
                isset($result[$m]) ? $result[$m] += $amount :$result[$m]=$amount;
            }
        }
        $data=[];
        for($i=1; $i <=12; $i++){
            $monthName=date('F', mktime(0,0,0,$i,1));
            $data[$monthName] = (!empty($result[$i]))? number_format((float)($result[$i]), 2, '.', '') : 0.0;
        }
        return $data;
    }
    
   
    
}
