<?php

namespace App\Http\Controllers;
use App\Models\Category;
use App\Models\Product;
use App\Models\Plan;
use Illuminate\Http\Request;
use Illuminate\Support\Str;




class PlanController extends Controller{
    public function index(){
        $plan=Plan::orderBy('id','DESC')->paginate();

        // $plan=Category::;
        // echo "<pre>";
        // print_r($plan);
        // die();
        return view('backend.plan.index')->with('plan',$plan);
    }
    public function create(){
        $category=Category::where('is_parent',1)->get();
        // $Product=Product::where('is_parent',1)->get();
        return view('backend.plan.create',compact('category'));
    }

    public function store(Request $request){
        
        $this->validate($request,[
            'Fields_value'=>'string|required',
            'price'=>'integer|required',
            'category_id'=>'string|required',
            'Fields'=>'string|required',
        ]);
        // print_r($request->all());
        // die();
        $data=$request->all();
        // return $data;
        $status=Plan::create($data);
        if($status){
            request()->session()->flash('success','Plan successfully created');
        }
        else{
            request()->session()->flash('error','Error, Please try again');
        }
        return redirect()->route('plan.index');
    }

    public function edit($id){
        $plan=Plan::findOrFail($id);
          $category=Category::where('is_parent',1)->get();
        return view('backend.plan.edit' , compact('category'))->with('plan',$plan);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id){
        $banner=plan::findOrFail($id);
       $this->validate($request,[
            'Fields_value'=>'string|required',
            'price'=>'integer|required',
            'category_id'=>'string|required',
            'Fields'=>'string|required',
        ]);
        $data=$request->all();
        // $slug=Str::slug($request->title);
        // $count=Banner::where('slug',$slug)->count();
        // if($count>0){
        //     $slug=$slug.'-'.date('ymdis').'-'.rand(0,999);
        // }
        // $data['slug']=$slug;
        // return $slug;
        $status=$banner->fill($data)->save();
        if($status){
            request()->session()->flash('success','Plan successfully updated');
        }
        else{
            request()->session()->flash('error','Error occurred while updating banner');
        }
        return redirect()->route('plan.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id){
        $plan=plan::findOrFail($id);
        $status=$plan->delete();
        if($status){
            request()->session()->flash('success','plan successfully deleted');
        }
        else{
            request()->session()->flash('error','Error occurred while deleting banner');
        }
        return redirect()->route('plan.index');
    }

     
         
    
}
