<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Category;
use App\Models\Brand;
use App\Models\Plan;
use App\Models\service_provider;
use App\Models\Provider;

use Illuminate\Support\Str;

class ProductController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $products=Product::getAllProduct();
        // echo "<pre>";
        // print_r($follow);
        // die();
        // return $products;
          $categoryIds = $products->pluck('service_provider')->toArray();
          $categoryNames = Provider::whereIn('id', $categoryIds)->pluck('name', 'id')->toArray();
        //               echo "<pre>";
        // print_r($categoryNames);
        // die();
        return view('backend.product.index')->with(['products'=>$products ,'categoryNames'=>$categoryNames ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        // $brand=Brand::get();
        $categories=Category::where('is_parent',1)->get();
        $providers=Provider::all();
        //         echo "<pre>";
        // print_r($providers);
        // die();
        // return $category;
        return view('backend.product.create')->with(['categories'=>$categories,'providers'=>$providers]);
    }
    public function catfilter($id)
    {
        // $brand=Brand::get();
        // $plan=Plan::where('category_id',$id)->get();
        $Product=Product::where('cat_id',$id)->get();
        // echo "<pre>";
        // print_r($id);
        // die();
        // // return $Plan;
        return json_encode(['Product_data'=>$Product,'status'=>true]);
    }
    public function Fieldfilter($id)
    {
        // $brand=Brand::get();
        // $plan_con = ['category_id'=>$id,'Fields'=>]
        $plan=Plan::where('Fields',$id)->get();
        // echo "<pre>";
        if (count($plan)>0) {
            $plan_data = $plan;
            // print_r($plan);
            // die();
        }else{
            $plan_data = '';
        }
        // // return $Plan;
        return json_encode(['plan_data'=>$plan_data,'status'=>true]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // echo "<pre>";
        // print_r($request->all());
        // die();
        // return $request->all();
        $this->validate($request,[
            'title'=>'required',
            'summary'=>'required',

            'description'=>'nullable',
            'is_featured'=>'required',
            // 'size'=>'nullable',
            'service_provider'=>"required",
            'cat_id'=>'required|exists:categories,id',
            'plan_value'=>'required|array',
            'plan_price'=>'required|array',
            'service_id'=>'required|array',
            // 'plan_value' => 'required_if:plan_price.*,!=,null|array',
            // 'plan_price' => 'required_if:plan_value.*,!=,null|array',
            // 'brand_id'=>'nullable|exists:brands,id',
            // 'child_cat_id'=>'nullable|exists:categories,id',
            // 'is_featured'=>'sometimes|in:1',
            'status'=>'required|in:active,inactive',
            // 'condition'=>'required|in:default,new,hot',
            // 'price'=>'required|numeric',
            // 'discount'=>'nullable|numeric'
        ]);
        
        $data=$request->all();
        // echo "<pre>";
        // print_r($data);
        // die();
        $slug=Str::slug($request->title);
        $count=Product::where('slug',$slug)->count();
        if($count>0){
            $slug=$slug.'-'.date('ymdis').'-'.rand(0,999);
        }
        $data['slug']=$slug;
        $data['child_cat_id']=$data['cat_id'];
        $data['is_featured']=$request->input('is_featured',0);
        $data['service_provider'] = $request->input('service_provider'); 
        $data['plan_value'] = implode(',', $request->input('plan_value', []));
        $data['plan_price'] = implode(',', $request->input('plan_price', []));
        $data['service_id'] = implode(',', $request->input('service_id', []));
        

        //   echo "<pre>";
        // print_r($data);
        // die();
        $size=$request->input('size');
        if($size){
            $data['size']=implode(',',$size);
        }
        else{
            $data['size']='';
        }
        // return $size;
        // return $data;
        $status=Product::create($data);
        if($status){
            request()->session()->flash('success','Product Successfully added');
        }
        else{
            request()->session()->flash('error','Please try again!!');
        }
        return redirect()->route('product.index');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
    
        $brand=Brand::get();
        $product=Product::findOrFail($id);
       
        $product->plan_value = explode(',', $product->plan_value);
        $product->plan_price = explode(',', $product->plan_price);
        //          echo "<pre>";
        // print_r($product);
        // die();
        
        $category=Category::where('is_parent',1)->get();
        $items=Product::where('id',$id)->get();
        
        // $providers=Provider::get(' ');
        $providers=Provider::all();
        // echo "<pre>";
        // print_r($providers);
        // die();
        // return $items;
        return view('backend.product.edit')->with(['product'=>$product ,'providers'=>$providers])
                    ->with('brands',$brand)
                    ->with('categories',$category)->with('items',$items);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        
        

        $product=Product::findOrFail($id);
     
        $serviceProviderId =$product->service_provider;
      
        $serviceProviderName = Provider::where('id', $serviceProviderId)->value('name');
      
               
        $this->validate($request,[
            'title'=>'required',
            'summary'=>'required',
            'description'=>'nullable',
            'is_featured'=>'required',
            // 'service_provider'=>"required",
            'cat_id'=>'required|exists:categories,id',
            'status'=>'required|in:active,inactive',
            
        ]);
//   echo "<pre>";
//         print_r($request->all());
//         die();
        $data=$request->all();
        $slug=Str::slug($request->title);
        $count=Product::where('slug',$slug)->count();
        if($count>0){
            $slug=$slug.'-'.date('ymdis').'-'.rand(0,999);
        }
        $data['slug']=$slug;
        $data['child_cat_id']=$data['cat_id'];
        $data['is_featured']=$request->input('is_featured',0);
        // $data['service_provider'] = $serviceProviderId;         
        $data['service_provider'] = $serviceProviderId;
        $data['service_provider'] = $request->input('service_provider');
        $data['plan_value'] = implode(',', $request->input('plan_value', []));
        $data['plan_price'] = implode(',', $request->input('plan_price', []));
        $data['service_id'] = implode(',', $request->input('service_id', []));

        //                  echo "<pre>";
        // print_r($data);
        // die();
        $size=$request->input('size');
        if($size){
            $data['size']=implode(',',$size);
        }
        else{
            $data['size']='';
        }
        // return $data;
        $status=$product->fill($data)->save();
        if($status){
            request()->session()->flash('success','Product Successfully updated');
        }
        else{
            request()->session()->flash('error','Please try again!!');
        }
        return redirect()->route('product.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $product=Product::findOrFail($id);
        $status=$product->delete();
        
        if($status){
            request()->session()->flash('success','Product successfully deleted');
        }
        else{
            request()->session()->flash('error','Error while deleting product');
        }
        return redirect()->route('product.index');
    }
}
