<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Supportmassage;
use App\Mail\AdminSupportNotification;
use Illuminate\Support\Facades\Mail;

class SupportMessageController extends Controller{

public function store(Request $request){
    $validatedData = $request->validate([
        'username' => 'required|string|max:191',
        'email' => 'required|email|max:191',
        'subject' => 'required|string',
        'message' => 'required|string',
    ]);

    $contact = new Supportmassage;
    $contact->name = $request->input('username');
    $contact->email = $request->input('email');
    $contact->subject = $request->input('subject');
    $contact->message = $request->input('message');

    $contact->save();

    // Send email to admin
     Mail::to('kr7505635@gmail.com')->send(new AdminSupportNotification(
        $contact->name,
        $contact->email,
        $contact->subject,
        $contact->message
    ));

    return redirect()->back()->with('success', 'YOUR query processed successfully! connect soon as possible.');
}

}
