<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\User;
use Illuminate\Support\Facades\Storage;
class UsersController extends Controller{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $users=User::orderBy('id','ASC')->paginate(10);
        return view('backend.users.index')->with('users',$users);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.users.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
        
        
        //   echo "<pre>";
        // print_r($request->all());
        // die();
        
        $this->validate($request,
        [
            'name'=>'string|required|max:30',
            'email'=>'string|required|unique:users',
            'password'=>'string|required',
            'role'=>'required|in:admin,user',
            'status'=>'required|in:active,inactive',
            // 'photo'=>'nullable|string',
             'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);
        
          $data = $request->all();
        
        if ($request->hasFile('photo')) {
            $file = $request->file('photo');
            $fileName = time() . '_' . $file->getClientOriginalExtension();
            // echo "<pre>";
            // print_r($fileName);
            // die();
            $file->move(public_path('user'), $fileName);
        
            // Save the complete file path in the 'photo' field of the $data array
            $data['photo'] = $fileName;
        }
                
        
        // dd($request->all());
        // $data=$request->all();
        $data['password']=Hash::make($request->password);
        // dd($data);
        $status=User::create($data);
        // dd($status);
        if($status){
            request()->session()->flash('success','Successfully added user');
        }
        else{
            request()->session()->flash('error','Error occurred while adding user');
        }
        return redirect()->route('users.index');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
        $user=User::findOrFail($id);
        // echo "<pre>";
        // print_r($user);
        // die();
        return view('backend.users.edit')->with('user',$user);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    // public function update(Request $request, $id)
    // {
    //     $user=User::findOrFail($id);
    //     $this->validate($request,
    //     [
    //         'name'=>'string|required|max:30',
    //         'email'=>'string|required',
    //         'role'=>'required|in:admin,user',
    //         'status'=>'required|in:active,inactive',
    //         // 'photo'=>'nullable|string',
    //     ]);
    //     // dd($request->all());
    //     $data=$request->all();
    //     // dd($data);
   
    //     if ($request->hasFile('photo')) {
    //         $file = $request->file('photo');
    //         $fileName = time() . '.' . $file->getClientOriginalExtension();
    //         // echo "<pre>";
    //         // print_r($fileName);
    //         // die();
    //         $file->move(public_path('user'), $fileName);
        
    //         // Save the complete file path in the 'photo' field of the $data array
    //         $data['photo'] = $fileName;
    //     }
        
        
    //     $status=$user->fill($data)->save();
    //     if($status){
    //         request()->session()->flash('success','Successfully updated');
    //     }
    //     else{
    //         request()->session()->flash('error','Error occured while updating');
    //     }
    //     return redirect()->route('users.index');

    // }
    
    public function update(Request $request, $id){
    $user = User::findOrFail($id);
        
        // echo "<pre>";
        // print_r($user);
        // die();

     $this->validate($request, [
        'name' => 'string|required|max:30',
        'email' => 'string|required',
        'role' => 'required|in:admin,user',
        'status' => 'required|in:active,inactive',
        // 'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
    ]);

    $data = $request->except(['_token', '_method']);

    if ($request->hasFile('photo')) {
        $file = $request->file('photo');
        $fileName = time() . '.' . $file->getClientOriginalExtension();

        // Check if the user directory exists, and create it if not
        if (!is_dir(public_path('user'))) {
            mkdir(public_path('user'), 0755, true);
        }

        // Move the file to the 'user' directory
        $file->move(public_path('user'), $fileName);

        // Save the complete file path in the 'photo' field of the $data array
        $data['photo'] = $fileName;
    }              

    $status = $user->fill($data)->save();

    if ($status) {
        request()->session()->flash('success', 'Successfully updated');
    } else {
        request()->session()->flash('error', 'Error occurred while updating');
    }

    return redirect()->route('users.index');
}

    
    
    

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $delete=User::findorFail($id);
        $status=$delete->delete();
        if($status){
            request()->session()->flash('success','User Successfully deleted');
        }
        else{
            request()->session()->flash('error','There is an error while deleting users');
        }
        return redirect()->route('users.index');
    }
}
