<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\OtpMail;
use App\Mail\WlcomeMail;
use App\Models\VerifyUser;
use App\Models\Order;
use App\Models\Email_config;
use Session;
use App\Models\Wallet;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use Illuminate\Support\Facades\Config;
use App\Console\Commands\CleanUpExpiredOtps;

class VerifyController extends Controller{
    
    
//  public function __construct()
// {
//     $this->middleware('frontend.auth');
// }
    

    public function loginSubmit(Request $request){
        $emailid = $request->input('email');
    
        // Check if a cooldown is active
        $cooldownKey = 'otp_cooldown';
        $cooldownDuration = 45; // 45 seconds cooldown
    
        if ($request->session()->has($cooldownKey)) {
            $cooldownExpiresAt = $request->session()->get($cooldownKey);
    
            // Check if the cooldown has not expired
            if ($cooldownExpiresAt->isFuture()) {
                $remainingTime = now()->diffInSeconds($cooldownExpiresAt);
    
                return back()->withErrors(['error' => "Please wait for {$remainingTime} seconds before requesting a new OTP."]);
            }
        }
    
        $data = $request->validate([
            'email' => 'required|email',
        ]);
    
        $email = $data['email'];
        $otp = rand(100000, 999999);
        Config::set('app.timezone', 'Asia/Kolkata');
    
        // Set expiration time to 15 minutes
        $expirationTime = now()->addSeconds($cooldownDuration);
    
        // Log the expiration time for debugging
        \Log::info('Expiration time: ' . $expirationTime);
        
        // dynemic mail description
        $verifymaildata = Email_config::where('type','verifyMail')->get();
        $array_mailresponse = json_decode(json_encode($verifymaildata),true);
        $emailDesc = $array_mailresponse[0]['email_desc'];

        Mail::to($email)->send(new OtpMail($otp,$emailDesc));
    
        $verifyUser = VerifyUser::updateOrCreate(
            ['email' => $email],
            ['code' => $otp, 'expires_at' => $expirationTime]
        );
    
        // Log the created/updated record for debugging
        \Log::info('VerifyUser record: ' . $verifyUser);
    
        if (!$verifyUser->expires_at) {
            \Log::error('Expires_at not set correctly. VerifyUser ID: ' . $verifyUser->id);
        }
    
        Session::put('user', $email);
    
        // Set the cooldown in the session
        $cooldownExpiresAt = now()->addSeconds($cooldownDuration);
        $request->session()->put($cooldownKey, $cooldownExpiresAt);
    
        $request->session()->flash('success', 'Sent Verification Otp Successfully');
    
        // Display countdown timer on the frontend
    
        return view('frontend/pages/verify_emailcode', compact('emailid', 'cooldownDuration'));
    
   }


    public function verifyemailcode(Request $request){
        
        $request->validate([
            'code' => 'required|numeric',
        ]);
    
        $userCode = $request->input('code');
        $user = VerifyUser::where('code', $userCode)->first();
    
        if ($user) {
            // Check if the code is still valid (not expired)
            if ($user->expires_at && $user->expires_at->isPast()) {
                return back()->with('error', 'Verification code has expired. Please request a new one.');
            }
            $verifymaildata = Email_config::where('type','WelComeMail')->get();
            $array_mailresponse = json_decode(json_encode($verifymaildata),true);
            $welcomeDesc = $array_mailresponse[0]['email_desc'];
            Mail::to($user->email)->send(new WlcomeMail($welcomeDesc));
            $user->update(['code' => true]);
            session()->flash('success', 'Login successful');
            return redirect()->route('login.logininfo');
        } else {
            return back()->with('error', 'Invalid Code. Please try again.');
        }
    }

    public function logininfo(Request $request)
    {
        $emailid = Session::get('user');
        $orders = Order::where('email', $emailid)
                       ->orderBy('id', 'DESC')
                       ->paginate(10);
    
        $user = VerifyUser::where('email', $emailid)->first();
    
        if ($user) {
            $wallet = $user->wallet;
    
            // If the user doesn't have a wallet, create one
            if (!$wallet) {
                $wallet = $this->createWallet($user->id);
            }
    
            // Fetch wallet transactions
            $transactions = $wallet->transactions()->orderBy('created_at', 'desc')->paginate(10);
    
            request()->session()->flash('success', 'Login successfully');
            return view("frontend.pages.logininformation_page", compact('emailid', 'orders', 'wallet', 'transactions'));
        } else {
            // Handle the case where the user with the specified email is not found
            // You might want to redirect to the registration page or take appropriate action
        }
    }

      
      
      
    private function createWallet($userId)
    {
        // Check if the user already has a wallet
        $existingWallet = Wallet::where('verify_user_id', $userId)->first();
    
        if (!$existingWallet) {
            // Create a new wallet for the user
            return Wallet::create([
                'verify_user_id' => $userId,
                'balance' => 0.00,
            ]);
        }
    
        return $existingWallet;
    }
       
    public function logout(Request $request){
        $user = Auth::user();
        $user = $request->input('code');        
        if ($user) {
            $user->update(['code' => null]);
            $user->delete();
        }
        session()->flash('success', 'Logout successful');

       return redirect()->route('home');

    }
        
        
        
        
        
}
