<?php

namespace App\Http\Middleware;

use Closure;

class PrefixCheckMiddleware
{
    public function handle($request, Closure $next)
    {
        // Check if the request has a referer and if it's from your application
        $referer = $request->header('referer');
        $expectedReferer = config('app.url') . '/smm_pannel/user/login';

        if ($referer !== $expectedReferer) {
            abort(403, 'Unauthorized access.');
        }

        return $next($request);
    }
}
