<?php

namespace App\Http\Middleware;

use Closure;

class ProcessCheckMiddleware
{
    public function handle($request, Closure $next)
    {
        // Check if the session variable indicating the process completion is set
        if (!$request->session()->has('process_completed')) {
            abort(403, 'Unauthorized access. Please complete the process.');
        }

        return $next($request);
    }
}
