<?php

namespace App\Http\Middleware;

use Closure;

class TokenCheckMiddleware
{
    public function handle($request, Closure $next)
    {
        // Check if the request has the 'token' parameter
        if (!$request->has('token')) {
            abort(403, 'Unauthorized access.');
        }

        return $next($request);
    }
}
