<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Auth\Authenticatable;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;


class VerifyUser extends Model implements AuthenticatableContract
{
        use Authenticatable;

    use HasFactory;
    protected $fillable = ['email', 'code', 'expires_at', 'code_verified'];

     protected $casts = [
            'expires_at' => 'datetime',
        ];
        
        
          public function wallet()
    {
        return $this->hasOne(Wallet::class, 'verify_user_id', 'id');
    }
      public static function countActiveProductVerifyUser(){
        $data=VerifyUser::count();
        if($data){
            return $data;
        }
        return 0;
     }
}
