<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */

    
    // database/migrations/create_wallets_table.php

public function up()
{
    Schema::create('wallets', function (Blueprint $table) {
        $table->id();
        $table->foreignId('verify_user_id')->constrained('verify_users'); // Assuming you have a 'verify_users' table
        $table->decimal('balance', 10, 2)->default(0.00);
        // Add more fields as needed (e.g., transactions, transaction history, etc.)
        $table->timestamps();
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wallets');
    }
};
// database/migrations/create_wallets_table.php


