@extends('backend.layouts.master')

@section('main-content')

<div class="card shadow mb-4">
    <div class="row">
        <div class="col-md-12">
            <!-- Include your notification blade file if needed -->
            {{-- @include('backend.layouts.notification') --}}
        </div>
    </div>
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary float-left">Product_Order Lists</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table id="example" class="display" style="width:100%">
                <thead>
                    <tr>
                        <th>S.N.</th>
                        <th>Order_id</th>
                        <th>Link</th>
                        <th>Quantity</th>
                        <th>Service_Id</th>
                        <th>Secret_key</th>
                        <th>Coustmer_data</th>
                        <th>Status</th>
                        <th>Date/Time</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($products as $product)
                    <tr class="myRow">
                        <td>{{$product->id}}</td>
                        <td>{{$product->Order_id}}</td>
                        <td>{{$product->Link}}</td>
                        <td>{{$product->quantity}}</td>
                        <td>{{$product->Service_Id}}</td>
                        <td>{{$product->Secret_key}}</td>
                        <td>{{$product->Coustmer_data}}</td>
                        <td>{{$product->Status}}</td>
                        <td>{{$product->created_at}}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@endsection

@push('styles')
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">
@endpush

@push('scripts')
    <script src="https://code.jquery.com/jquery-3.7.0.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    
    <script>
        new DataTable('#example');
    </script>
@endpush
