@extends('backend.layouts.master')
@section('title','E-SHOP || Blog Edit')
@section('main-content')

<div class="card">
    <h5 class="card-header">Edit Blog</h5>
    <div class="card-body">
      <form method="post" action="{{route('/back/service/blog.update',$blog->id)}}" enctype="multipart/form-data">
        @csrf 
        @method('PATCH')
        <div class="form-group">
          <label for="inputTitle" class="col-form-label">Title <span class="text-danger">*</span></label>
        <input id="inputTitle" type="text" name="title" placeholder="Enter title"  value="{{$blog->title}}" class="form-control">
        @error('title')
        <span class="text-danger">{{$message}}</span>
        @enderror
        </div>

        <div class="form-group">
          <label for="inputDesc" class="col-form-label">Description</label>
          <textarea class="form-control" id="description" name="description">{{$blog->description}}</textarea>
          @error('description')
          <span class="text-danger">{{$message}}</span>
          @enderror
        </div>
        
        
        
        <!-- Summer note start -->
     
           <div class="form-group">
          <label for="inputDesc" class="col-form-label">Summer editor</label>
              <html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
        <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Laravel Summernote Editor Example</title>
        <!-- include libraries(jQuery, bootstrap) -->
        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css">
        <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
        
        <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js"></script>
        <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.0/js/bootstrap.min.js"></script>
    </head>
    <body>
        <div class="container">
            <div class="row">
                <div class="col-md-7 offset-3 mt-4">
                    <div class="card-body">
                       
                            <div class="form-group">
                                <textarea class="form-control" name="summernote" id="summernote">{{$blog->summernote}}</textarea>
                            </div>

                        
                    </div>
                </div>
            </div>
        </div>
    </body>
    <!-- summernote css/js -->
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.js"></script>
    <script type="text/javascript">
        $('#summernote').summernote({
            height: 400
        });
    </script>
    </html>
              @error('Summer_editor')
              <span class="text-danger">{{$message}}</span>
              @enderror
            </div>  
        <!-- Summer note end -->

        <!--<div class="form-group">-->
        <!--<label for="inputPhoto" class="col-form-label">Photo <span class="text-danger">*</span></label>-->
        <!--<div class="input-group">-->
        <!--    <span class="input-group-btn">-->
        <!--        <a id="lfm" data-input="thumbnail" data-preview="holder" class="btn btn-primary">-->
        <!--        <i class="fa fa-picture-o"></i> Choose-->
        <!--        </a>-->
        <!--    </span>-->
        <!--  <input id="thumbnail" class="form-control" type="file" name="photo" value="{{$blog->photo}}">-->
        <!--</div>-->
        <!--<div id="holder" style="margin-top:15px;max-height:100px;"></div>-->
        <!--  @error('photo')-->
        <!--  <span class="text-danger">{{$message}}</span>-->
        <!--  @enderror-->
        <!--</div>-->
        
        <div class="form-group">
    <label for="inputPhoto" class="col-form-label">Photo <span class="text-danger">*</span></label>
    <div class="input-group">
        <!--<span class="input-group-btn">-->
        <!--    <a id="lfm" data-input="thumbnail" data-preview="holder" class="btn btn-primary">-->
        <!--        <i class="fa fa-picture-o"></i> Choose-->
        <!--    </a>-->
        <!--</span>-->
        <input id="thumbnail" class="form-control" type="file" name="photo" onchange="updateFileName(this)">
    </div>
    <div id="holder" style="margin-top:15px;max-height:100px;">
        @if ($blog->photo)
            <img src="{{ asset('public/blog/' .$blog->photo) }}" alt="Selected Photo" style="max-height: 100px;">
        @endif
    </div>
    @error('photo')
        <span class="text-danger">{{ $message }}</span>
    @enderror
</div>

<script>
    document.getElementById('thumbnail').addEventListener('change', function (event) {
        updateFileName(this);
    });

    function updateFileName(input) {
        var fileName = input.files[0].name;
        document.getElementById("holder").innerHTML = '<img src="' + URL.createObjectURL(input.files[0]) + '" alt="' + fileName + '" style="max-height: 100px;">';
    }
</script>

        
        
        
        <div class="form-group">
          <label for="status" class="col-form-label">Status <span class="text-danger">*</span></label>
          <select name="status" class="form-control">
            <option value="active" {{(($blog->status=='active') ? 'selected' : '')}}>Active</option>
            <option value="inactive" {{(($blog->status=='inactive') ? 'selected' : '')}}>Inactive</option>
          </select>
          @error('status')
          <span class="text-danger">{{$message}}</span>
          @enderror
        </div>
        <div class="form-group mb-3">
           <button class="btn btn-success" type="submit">Update</button>
        </div>
      </form>
    </div>
</div>

@endsection

@push('styles')
<link rel="stylesheet" href="{{asset('backend/summernote/summernote.min.css')}}">
@endpush
@push('scripts')
<script src="/vendor/laravel-filemanager/js/stand-alone-button.js"></script>
<script src="{{asset('backend/summernote/summernote.min.js')}}"></script>
<script>
    $('#lfm').filemanager('image');

    $(document).ready(function() {
    $('#description').summernote({
      placeholder: "Write short description.....",
        tabsize: 2,
        height: 150
    });
    });
</script>
@endpush