<!-- resources/views/get-details.blade.php -->

@extends('layouts.app')

@section('content')
    <div>
        <h1>API Response Details</h1>

        @if(isset($apiResponse))
            <table class="table">
                <thead>
                    <tr>
                        <th>Key</th>
                        <th>Value</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach(json_decode($apiResponse, true) as $key => $value)
                        <tr>
                            <td>{{ $key }}</td>
                            <td>{{ $value }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @else
            <p>No API response available.</p>
        @endif

        <!-- Add any additional content or styling as needed -->
    </div>
@endsection
