@extends('backend.layouts.master')
@section('title','E-SHOP || Brand Create')
@section('main-content')

<div class="card">
    <h5 class="card-header">Add Plan</h5>
    <div class="card-body">
      <form method="post" action="{{route('/back/service/plan.store')}}">
        {{csrf_field()}}
        <div class="form-group">
          <label for="inputTitle" class="col-form-label">Field Value <span class="text-danger">*</span></label>
        <input id="inputTitle" type="text" name="Fields_value" placeholder="Enter Field Value"  value="{{old('Fields_value')}}" class="form-control">
        @error('Fields_value')
        <span class="text-danger">{{$message}}</span>
        @enderror
        </div>
        <div class="form-group">
          <label for="inputTitle" class="col-form-label">Price <span class="text-danger">*</span></label>
        <input id="inputTitle" type="number" name="price" placeholder="Enter Price"  value="{{old('price')}}" class="form-control">
        @error('price')
        <span class="text-danger">{{$message}}</span>
        @enderror
        </div>
        
        <div class="form-group">
          <label for="category_id">Category <span class="text-danger">*</span></label>
          <select name="category_id" id="category_id" class="form-control" onchange="catIdSelected()">
              <option value="">--Select any category--</option>
              @foreach($category as $key=>$cat_data)
                  <option value='{{$cat_data->id}}'>{{$cat_data->title}}</option>
              @endforeach
          </select>
          @error('category_id')
        <span class="text-danger">{{$message}}</span>
        @enderror
        </div>
        <div class="form-group">
          <label for="Fields">Fields <span class="text-danger">*</span></label>
          <select name="Fields"  class="form-control" >
              <option value="">--Select any Fields--</option>
                  <option value='Like'>Like</option>
                  <option value='Follow'>Follow</option>
                  <option value='Comment'>Comment</option>
                  <option value='View'>View</option>
 
          </select>
          @error('Fields')
        <span class="text-danger">{{$message}}</span>
        @enderror
        </div>


        <div class="form-group">
          <label for="status" class="col-form-label">Status <span class="text-danger">*</span></label>
          <select name="status" class="form-control">
              <option value="active">Active</option>
              <option value="inactive">Inactive</option>
          </select>

        </div>
        <div class="form-group mb-3">
          <button type="reset" class="btn btn-warning">Reset</button>
           <button class="btn btn-success" type="submit">Submit</button>
        </div>
      </form> 
    </div>
</div>

@endsection

@push('styles')
<link rel="stylesheet" href="{{asset('backend/summernote/summernote.min.css')}}">
@endpush
@push('scripts')
<script src="/vendor/laravel-filemanager/js/stand-alone-button.js"></script>
<script src="{{asset('backend/summernote/summernote.min.js')}}"></script>


<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/js/bootstrap-select.min.js"></script>
<script>
    $('#lfm').filemanager('image');

    $(document).ready(function() {
    $('#description').summernote({
      placeholder: "Write short description.....",
        tabsize: 2,
        height: 150
    });
    });
</script>
<script>
    function catIdSelected() {

        var selectedCatId = document.getElementById("category_id").value;
        // Perform actions based on the selected category ID
        // console.log("Selected Category ID: " + selectedCatId);

        $.ajax({
        url:"/admin/catfilter/"+selectedCatId,
        data:{
          _token:"{{csrf_token()}}",
          id:selectedCatId
        },
        type:"POST",
        Type:'json',
        success:function(response){
          
          var jsonData = $.parseJSON(response);
          var selectElement = $("#FieldSelect");

          selectElement.empty();
        // Access the 'status' key
        var Product_data = jsonData.Product_data;
        selectElement.append('<option value="">--Select any Field--</option>');
          $.each(Product_data, function(index, Product) {
            // Access individual Product_data items
            var optionText = Product.title; // Customize as needed
            var optionValue = Product.id;
          
            console.log(optionText);
            selectElement.append('<option  value="' + optionValue + '">' + optionText + '</option>');
          });

          selectElement.selectpicker('refresh');
          

        }
      });
    }
</script>
@endpush