@extends('backend.layouts.master')
@section('title','E-SHOP || Plan Edit')
@section('main-content')

<div class="card">
    <h5 class="card-header">Edit Plan</h5>
    <div class="card-body">
      <form method="post" action="{{route('plan.update',$plan->id)}}">
        @csrf 
        @method('PATCH')
        <div class="form-group">
          <label for="inputTitle" class="col-form-label">Field_value <span class="text-danger">*</span></label>
        <input id="inputTitle" type="text" name="Fields_value" placeholder="Enter title"  value="{{$plan->Fields_value}}" class="form-control">
        @error('title')
        <span class="text-danger">{{$message}}</span>
        @enderror
        </div>        
        <div class="form-group">
          <label for="inputTitle" class="col-form-label">Price <span class="text-danger">*</span></label>
        <input id="inputTitle" type="text" name="price" placeholder="Enter title"  value="{{$plan->price}}" class="form-control">
        @error('title')
        <span class="text-danger">{{$message}}</span>
        @enderror
        </div>        
        <!--  <div class="form-group">-->
        <!--  <label for="category_id">Category <span class="text-danger">*</span></label>-->
        <!--  <select name="category_id" id="category_id" class="form-control" onchange="catIdSelected()">-->
        <!--      <option value="">--Select any category--</option>-->
        <!--      @foreach($category as $key=>$cat_data)-->
        <!--          <option value='{{$cat_data->id}}'>{{$cat_data->title}}</option>-->
        <!--      @endforeach-->
        <!--  </select>-->
        <!--  @error('category_id')-->
        <!--<span class="text-danger">{{$message}}</span>-->
        <!--@enderror-->
        <!--</div>-->
                    <div class="form-group">
                <label for="category_id">Category <span class="text-danger">*</span></label>
                <select name="category_id" id="category_id" class="form-control" onchange="catIdSelected()">
                    <option value="">--Select any category--</option>
                    @foreach($category as $cat_data)
                        <option value='{{$cat_data->id}}' {{ $plan->category_id == $cat_data->id ? 'selected' : '' }}>
                            {{$cat_data->title}}
                        </option>
                    @endforeach
                </select>
                @error('category_id')
                    <span class="text-danger">{{$message}}</span>
                @enderror
            </div>

        <!--<div class="form-group">-->
        <!--  <label for="Fields">Fields <span class="text-danger">*</span></label>-->
        <!--  <select name="Fields"  class="form-control" >-->
        <!--      <option value="">--Select any Fields--</option>-->
        <!--          <option value='Like'>Like</option>-->
        <!--          <option value='Follow'>Follow</option>-->
        <!--          <option value='Comment'>Comment</option>-->
        <!--          <option value='View'>View</option>-->
 
        <!--  </select>-->
        <!--  @error('Fields')-->
        <!--<span class="text-danger">{{$message}}</span>-->
        <!--@enderror-->
        <!--</div>    -->
            <div class="form-group">
            <label for="Fields">Fields <span class="text-danger">*</span></label>
            <select name="Fields" class="form-control">
                <option value="">--Select any Fields--</option>
                <option value='Like' {{ $plan->Fields == 'Like' ? 'selected' : '' }}>Like</option>
                <option value='Follow' {{ $plan->Fields == 'Follow' ? 'selected' : '' }}>Follow</option>
                <option value='Comment' {{ $plan->Fields == 'Comment' ? 'selected' : '' }}>Comment</option>
                <option value='View' {{ $plan->Fields == 'View' ? 'selected' : '' }}>View</option>
            </select>
            @error('Fields')
                <span class="text-danger">{{ $message }}</span>
            @enderror
        </div>


        <div class="form-group">
          <label for="status" class="col-form-label">Status <span class="text-danger">*</span></label>
          <select name="status" class="form-control">
            <option value="active" {{(($plan->status=='active') ? 'selected' : '')}}>Active</option>
            <option value="inactive" {{(($plan->status=='inactive') ? 'selected' : '')}}>Inactive</option>
          </select>
          @error('status')
          <span class="text-danger">{{$message}}</span>
          @enderror
        </div>
        <div class="form-group mb-3">
           <button class="btn btn-success" type="submit">Update</button>
        </div>
      </form>
    </div>
</div>

@endsection

@push('styles')
<link rel="stylesheet" href="{{asset('backend/summernote/summernote.min.css')}}">
@endpush
@push('scripts')
<script src="/vendor/laravel-filemanager/js/stand-alone-button.js"></script>
<script src="{{asset('backend/summernote/summernote.min.js')}}"></script>
<script>
    $('#lfm').filemanager('image');

    $(document).ready(function() {
    $('#description').summernote({
      placeholder: "Write short description.....",
        tabsize: 2,
        height: 150
    });
    });
</script>
@endpush


