@extends('backend.layouts.master')

@section('main-content')

<div class="card shadow mb-4">
    <div class="row">
        <div class="col-md-12">
            <!-- Include your notification blade file if needed -->
            {{-- @include('backend.layouts.notification') --}}
        </div>
    </div>
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary float-left">plan Lists</h6>
         <a href="{{route('plan.create')}}" class="btn btn-primary btn-sm float-right" data-toggle="tooltip" data-placement="bottom" title="Add User"><i class="fas fa-plus"></i> Add Plan</a>
    </div>
    <div class="card-body">
        

     
                 <div class="table-responsive">
        @if(count($plan)>0)
        <!--<table class="table table-bordered" id="banner-dataTable" width="100%" cellspacing="0">-->
               <table id="example" class="display" style="width:100%">   
          <thead>
            <tr>
              <th>S.N.</th>
              <th>Field Value</th>
              <th>Price</th>
              <th>Category</th>
              <th>Field Type</th>
              <th>Status</th>
              <th>Action</th>
            </tr>
          </thead>

          <tbody>
            @php 
                $i = 1;
            @endphp
            @foreach($plan as $plan_val)   
            @php
              $cat_info=DB::table('categories')->select('title')->where('id',$plan_val->category_id)->get();
            @endphp
            <tr>
                <td>{{$i++}}</td>
                <td>{{$plan_val->Fields_value}}</td>
                <td>{{$plan_val->price}}</td>
                <td>{{$cat_info[0]->title}}</td>
                <td>{{$plan_val->Fields}}</td>
                <td>
                    @if($plan_val->status=='active')
                        <span class="badge badge-success">{{$plan_val->status}}</span>
                    @else
                        <span class="badge badge-warning">{{$plan_val->status}}</span>
                    @endif
                </td>
                <td>
                    <a href="{{route('plan.edit',$plan_val->id)}}" class="btn btn-primary btn-sm float-left mr-1" style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" title="edit" data-placement="bottom"><i class="fas fa-edit"></i></a>
                    <form method="POST" action="{{route('plan.destroy',[$plan_val->id])}}">
                        @csrf 
                        @method('delete')
                        <button class="btn btn-danger btn-sm dltBtn" data-id={{$plan_val->id}} style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" data-placement="bottom" title="Delete"><i class="fas fa-trash-alt"></i></button>
                    </form>
                </td>
            </tr>  
            @endforeach
          </tbody>
        </table>
    
        @else
          <h6 class="text-center">No plans found!!! Please create plans</h6>
        @endif
      </div>
    </div>
</div>

@endsection

@push('styles')
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">
@endpush

@push('scripts')
    <script src="https://code.jquery.com/jquery-3.7.0.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    
    <script>
        new DataTable('#example');
    </script>
@endpush










