@extends('backend.layouts.master')
@section('main-content')
<div class="card">
   <h5 class="card-header">Edit Product</h5>
   <div class="card-body">
      <form method="post" action="{{route('/back/service/product.update',$product->id)}}">
         @csrf 
         @method('PATCH')
         <div class="form-group">
            <label for="inputTitle" class="col-form-label">Title <span class="text-danger">*</span></label>
            <input id="inputTitle" type="text" name="title" placeholder="Enter title"  value="{{$product->title}}" class="form-control">
            @error('title')
            <span class="text-danger">{{$message}}</span>
            @enderror
         </div>
         <div class="form-group">
            <label for="summary" class="col-form-label">Summary <span class="text-danger">*</span></label>
            <textarea class="form-control" id="summary" name="summary">{{$product->summary}}</textarea>
            @error('summary')
            <span class="text-danger">{{$message}}</span>
            @enderror
         </div>
         <div class="form-group">
            <label for="description" class="col-form-label">Description</label>
            <textarea class="form-control" id="description" name="description">{{$product->description}}</textarea>
            @error('description')
            <span class="text-danger">{{$message}}</span>
            @enderror
         </div>
         <div class="form-group">
            <label for="is_featured">Is Featured</label><br>
            <input type="checkbox" name='is_featured' id='is_featured' value='{{$product->is_featured}}' {{(($product->is_featured) ? 'checked' : '')}}> Yes                        
         </div>
         {{-- {{$categories}} --}}
         <div class="form-group">
            <label for="cat_id">Category <span class="text-danger">*</span></label>
            <select name="cat_id" id="cat_id" class="form-control">
               <option value="">--Select any category--</option>
               @foreach($categories as $key=>$cat_data)
               <option value='{{$cat_data->id}}' {{(($product->cat_id==$cat_data->id)? 'selected' : '')}}>{{$cat_data->title}}</option>
               @endforeach
            </select>
         </div>
         @php
         $sub_cat_info=DB::table('categories')->select('title')->where('id',$product->child_cat_id)->get();
         // dd($sub_cat_info);
         $brands=DB::table('brands')->select('title')->where('id',$product->brand_id)->get();
         @endphp
         {{-- {{$product->child_cat_id}} --}}
         <div class="form-group">
            <label for="service_provider" class="col-form-label">Service Providers <span class="text-danger">*</span></label>
            <select name="service_provider" id="pro_id" class="form-control">
               <option value="">--Select any Service Providers--</option>
               @foreach($providers as $provider)
               <option value="{{ $provider['id'] }}" {{ $provider['id'] == $product->service_provider ? 'selected' : '' }}>
               {{ $provider['name'] }}
               </option>
               @endforeach
            </select>
            
            <!--@error('service_provider')-->
            <!--   <span class="text-danger">{{ $message }}</span>-->
            <!--@enderror-->
         </div>
         <div class="container" style="max-width:100%;">
            <div class="row" style="margin-left: -1.75rem;">
               <div class="col-md-0"></div>
               <div class="col-md-12">
                  <div class="form-group">
                     <label for="service_provider" class="col-form-label">Add plan <span class="text-danger">*</span></label>
                     <table class="table table-bordered table-hover" id="dynamic_field">
                        @foreach($product->plan_value as $index => $value)
                        <tr id="row{{$index + 1}}">
                           <td>
                              <label for="Value">Value</label>
                              <input type="text" name="plan_value[]" placeholder="Enter plan value" class="form-control name_list" value="{{ $value }}" />
                           </td>
                           <td>
                              <label for="Value">price</label>
                              <input type="text" name="plan_price[]" placeholder="Enter plan price" class="form-control name_email" value="{{ $product->plan_price[$index] }}" />
                           </td>
                           <td>
                                <label for="Value">Service ID</label>
                                <input type="text" name="service_id[]" placeholder="Enter Service ID" class="form-control name_service_id" />
                            </td>
                           <td><button type="button" name="remove" id="{{ $index + 1 }}" class="btn btn-danger btn_remove">X</button></td>
                        </tr>
                        @endforeach
                     </table>
                     <button type="button" name="add" id="add" class="btn btn-primary">Add More</button>
                  </div>
               </div>
               <div class="col-md-1"></div>
            </div>
         </div>
         <div class="form-group">
            <label for="status" class="col-form-label">Status <span class="text-danger">*</span></label>
            <select name="status" class="form-control">
            <option value="active" {{(($product->status=='active')? 'selected' : '')}}>Active</option>
            <option value="inactive" {{(($product->status=='inactive')? 'selected' : '')}}>Inactive</option>
            </select>
            @error('status')
            <span class="text-danger">{{$message}}</span>
            @enderror
         </div>
         <div class="form-group mb-3">
            <button class="btn btn-success" type="submit">Update</button>
         </div>
      </form>
   </div>
</div>
@endsection
@push('styles')
<link rel="stylesheet" href="{{asset('backend/summernote/summernote.min.css')}}">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/css/bootstrap-select.css" />
@endpush
@push('scripts')
<script src="/vendor/laravel-filemanager/js/stand-alone-button.js"></script>
<script src="{{asset('backend/summernote/summernote.min.js')}}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/js/bootstrap-select.min.js"></script>
<script>
   $('#lfm').filemanager('image');
   
   $(document).ready(function() {
   $('#summary').summernote({
     placeholder: "Write short description.....",
       tabsize: 2,
       height: 150
   });
   });
   $(document).ready(function() {
     $('#description').summernote({
       placeholder: "Write detail Description.....",
         tabsize: 2,
         height: 150
     });
   });
</script>
<script>
   var  child_cat_id='{{$product->child_cat_id}}';
         // alert(child_cat_id);
         $('#cat_id').change(function(){
             var cat_id=$(this).val();
             var inputTitle=$("#inputTitle").val();
   
             if(cat_id !=null){
                 // ajax call
                 $.ajax({
                     url:"{{url('/admin/category/')}}"+"/"+inputTitle+"/"+cat_id,
                     type:"POST",
                     data:{
                         _token:"{{csrf_token()}}"
                     },
                     success:function(response){
                         console.log(response.status);
                         console.log(response.Product_fields);
                         var Product_fieldsArray = response.Product_fieldsArray;
                        //  console.log(plan_price);
                         
                        //  let select_table = $("#dynamic_field").html("")
                         let select_table = document.querySelector("#dynamic_field");
                         select_table.innerHTML = '';
                         
                        
                           // Iterate over the data and create rows
                        Product_fieldsArray.forEach(function(data, index) {
                            var newRow = document.createElement("tr");
                    
                            // Create and append the first cell
                            var valueCell = document.createElement("td");
                            valueCell.innerHTML = '<label for="Value">Value</label><input type="text" name="plan_value[]" placeholder="Enter plan value" class="form-control name_list" value="' + data['plan_value'] + '" />';
                            newRow.appendChild(valueCell);
                    
                            // Create and append the second cell
                            var priceCell = document.createElement("td");
                            priceCell.innerHTML = '<label for="Value">Price</label><input type="text" name="plan_price[]" placeholder="Enter plan price" class="form-control name_email" value="' + data['plan_price'] + '" />';
                            newRow.appendChild(priceCell);
                    
                            // Create and append the third cell
                            var serviceIdCell = document.createElement("td");
                            serviceIdCell.innerHTML = '<label for="Value">Service ID</label><input type="text" name="service_id[]" placeholder="Enter Service ID" class="form-control name_service_id" value="' + data['service_id'] + '" />';
                            newRow.appendChild(serviceIdCell);
                    
                            // Create and append the fourth cell (remove button)
                            var removeCell = document.createElement("td");
                            removeCell.innerHTML = '<button type="button" name="remove" id="' + (index + 1) + '" class="btn btn-danger btn_remove">X</button>';
                            newRow.appendChild(removeCell);
                    
                            // Append the new row to the table
                            select_table.appendChild(newRow);
                        });
                     }
                 });
             }
             else{
   
             }
   
         });
         if(child_cat_id!=null){
             $('#cat_id').change();
         }
</script>


<!--provider-->
<script>
    var child_cat_id = '{{$product->child_cat_id}}';

    // Function to fetch data and update fields
    function fetchDataAndUpdateFields() {
        var cat_id = $('#cat_id').val();
        console.log(cat_id);
        var pro_id = $('#pro_id').val();
        var inputTitle = $("#inputTitle").val();
        if (cat_id != null) {
            // ajax call
            $.ajax({
                url: "{{url('/admin/provider/')}}"+"/"+inputTitle+"/"+cat_id+"/"+pro_id,
                type: "POST",
                data: {
                    _token: "{{csrf_token()}}"
                },
                success: function (response) {
                    console.log(response.status);
                    console.log(response.Product_fields);
                    var Product_fieldsArray = response.Product_fieldsArray;

                    let select_table = document.querySelector("#dynamic_field");
                    select_table.innerHTML = '';

                    // Iterate over the data and create rows
                    Product_fieldsArray.forEach(function (data, index) {
                        var newRow = document.createElement("tr");

                        // Create and append the first cell
                        var valueCell = document.createElement("td");
                        valueCell.innerHTML = '<label for="Value">Value</label><input type="text" name="plan_value[]" placeholder="Enter plan value" class="form-control name_list" value="' + data['plan_value'] + '" />';
                        newRow.appendChild(valueCell);

                        // Create and append the second cell
                        var priceCell = document.createElement("td");
                        priceCell.innerHTML = '<label for="Value">Price</label><input type="text" name="plan_price[]" placeholder="Enter plan price" class="form-control name_email" value="' + data['plan_price'] + '" />';
                        newRow.appendChild(priceCell);

                        // Create and append the third cell
                        var serviceIdCell = document.createElement("td");
                        serviceIdCell.innerHTML = '<label for="Value">Service ID</label><input type="text" name="service_id[]" placeholder="Enter Service ID" class="form-control name_service_id" value="' + data['service_id'] + '" />';
                        newRow.appendChild(serviceIdCell);

                        // Create and append the fourth cell (remove button)
                        var removeCell = document.createElement("td");
                        removeCell.innerHTML = '<button type="button" name="remove" id="' + (index + 1) + '" class="btn btn-danger btn_remove">X</button>';
                        newRow.appendChild(removeCell);

                        // Append the new row to the table
                        select_table.appendChild(newRow);
                    });
                }
            });
        }
    }

    // Bind the function to the change event of #cat_id
    $('#pro_id').change(function () {
        fetchDataAndUpdateFields();
    });

    // Trigger the function if child_cat_id is not null
    if (child_cat_id != null) {
        fetchDataAndUpdateFields();
    }
</script>


<!--provider-->












<!--add plan-->
<script>
   $(document).ready(function(){
       var i = 1;
       var addamount = 700;
   
       $("#add").click(function(){
           addamount += 700;
           console.log('amount: ' + addamount);
           i++;
           $('#dynamic_field').append('<tr id="row'+i+'"><td><input type="text" name="plan_value[]" placeholder="Enter plan value" class="form-control name_list"/></td><td><input type="text" name="plan_price[]" placeholder="Enter plan price" class="form-control name_email"/></td><td><input type="text" name="service_id[]" placeholder="Enter Service ID" class="form-control name_service_id" /></td><td><button type="button" name="remove" id="'+i+'" class="btn btn-danger btn_remove">X</button></td></tr>');  
       });
   
       $(document).on('click', '.btn_remove', function(){  
           addamount -= 700;
           console.log('amount: ' + addamount);
           var button_id = $(this).attr("id");     
           $('#row'+button_id+'').remove();  
       });
   
       $("#submit").on('click',function(event){
           var formdata = $("#add_name").serialize();
           console.log(formdata);
           event.preventDefault();
         
           $.ajax({
               url   : "{{route('/back/service/product.store')}}",
               type  : "POST",
               data  : formdata,
               cache : false,
               headers: {
                   'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
               },
               success:function(result){
                   alert(result);
                   $("#add_name")[0].reset();
               }
           });
       });
   });
</script>
@endpush