@extends('backend.layouts.master')
@section('main-content')
 <!-- DataTales Example -->

 <style>
     /* Flip Switch
   ========================================================================== */
    
    .switch {
        display: inline-block;
        margin-bottom: .5rem;
    }
    
    .switch-button {
        background: royalblue;
        width: 4rem;
        height: 2rem;
        padding: 2px;
        position: relative;
        cursor: pointer;
        outline: 0;
        display: block;
        -webkit-user-select: none;
           -moz-user-select: none;
            -ms-user-select: none;
                user-select: none;
        -webkit-transition: all .2s ease-out;
             -o-transition: all .2s ease-out;
                transition: all .2s ease-out;
        -webkit-perspective: 100px;
                perspective: 100px;
    }
    
    .switch-button::before, 
    .switch-button::after {
        line-height: 2rem;
        font-weight: bold;
        color: #FFFFFF;
        text-align: center;
        display: inline-block;
        border-radius: 4px;
        width: 100%;
        position: absolute;
        top: 0;
        left: 0;
        -webkit-backface-visibility: hidden;
                backface-visibility: hidden;
        -webkit-transition: all .4s ease;
             -o-transition: all .4s ease;
                transition: all .4s ease;
    }
    
    .switch-input {
        display: none;
    }
    
    /* When switch is "off" */
    .switch-button::before {
        background: var(--links);
        content: attr(data-toggle-off);
    }
    
    /* When switch is "on" */
    .switch-button::after {
        background: var(--highlight);
        content: attr(data-toggle-on);
        -webkit-transform: rotateY(-180deg);
                transform: rotateY(-180deg);
    }
    
    .switch-button:hover::before {
        -webkit-transform: rotateY(-20deg);
                transform: rotateY(-20deg);
    }
    
    /* "On" state
       ========================== */
    
    .switch-input:checked + .switch-button:hover::after {
        -webkit-transform: rotateY(20deg);
                transform: rotateY(20deg);
    }
    
    .switch-input:checked + .switch-button::before {
        -webkit-transform: rotateY(180deg);
                transform: rotateY(180deg);
    }
    
    .switch-input:checked + .switch-button::after {
        -webkit-transform: rotateY(0);
                transform: rotateY(0);
    }
    
    /* Checkbox in disabled
       ========================== */
    
    .switch-input[type="checkbox"]:disabled + .switch-button {
        opacity: .6;
        cursor: not-allowed;
    }
    
    .switch-input[type="checkbox"]:checked:disabled + .switch-button {
        border-color: #cccccc;
        background: #cccccc;
    }
 </style>
 <div class="card shadow mb-4">
     <div class="row">
         <div class="col-md-12">
            @include('backend.layouts.notification')
         </div>
     </div>
@if(session('error'))
    <div class="alert alert-danger">
        {{ session('error') }}
    </div>
@endif
    <div class="card-header py-3">
      <h6 class="m-0 font-weight-bold text-primary float-left">Provider Lists</h6>
      <a href="{{route('provider.create')}}" class="btn btn-primary btn-sm float-right" data-toggle="tooltip" data-placement="bottom" title="Add User"><i class="fas fa-plus"></i> Add Provider</a>
    </div>
    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-bordered" id="product-dataTable" width="100%" cellspacing="0">
          <thead>
            <tr>
              <th>S.N.</th>
              <th>Name</th>
              <th>Api endpoint</th>
              <th>api_token</th>
              <!--<th>Status</th>-->
              <th>Action</th>
            </tr>
          </thead>
          <tfoot>
            <tr>
              <th>S.N.</th>
              <th>Name</th>
              <th>Api endpoint</th>
              <th>api_token</th>
              <!--<th>Status</th>-->
              <th>Action</th>
            </tr>
          </tfoot>
          <tbody>
              @php 
                $i=1;
              @endphp
                @foreach($providerData as $providerData)
                <tr>
                  <td>{{$i++}}</td>
                  <td>{{$providerData['name']}}</td>
                  <td>{{$providerData['api_key']}}</td>
                  <td>{{$providerData['api_token']}}</td>
                  <!--<td>{{$providerData['status']}}</td>-->
                  <!--<td>-->


                  <!--    <label class="switch" >-->
                  <!--        <input class="switch-input"-->
                  <!--               type="checkbox">-->
                  <!--        <span class="switch-button"-->
                  <!--               data-toggle-on="active" -->
                  <!--               data-toggle-off="Inactive" ></span>-->
                  <!--      </label>-->
                  <!--  @if($providerData->status=='active')-->
                  <!--          <span class="badge badge-success">{{$providerData->status}}</span>-->
                  <!--      @else-->
                  <!--          <span class="badge badge-warning">{{$providerData->status}}</span>-->
                  <!--      @endif-->
                  <!--  </td>-->
                   <td>
                        <a href="{{route('provider.edit',$providerData->id)}}" class="btn btn-primary btn-sm float-left mr-1" style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" title="edit" data-placement="bottom"><i class="fas fa-edit"></i></a>
                    <form method="POST" action="{{route('provider.delete',[$providerData->id])}}">
                      @csrf
                      @method('delete')
                          <button class="btn btn-danger btn-sm dltBtn" data-id={{$providerData->id}} style="height:30px; width:30px;border-radius:50%" data-toggle="tooltip" data-placement="bottom" title="Delete"><i class="fas fa-trash-alt"></i></button>
                        </form>
                    </td>
                </tr>
                @endforeach
          </tbody>
        </table>
      </div>
    </div>
</div>
@endsection
@push('styles')
  <link href="{{asset('backend/vendor/datatables/dataTables.bootstrap4.min.css')}}" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.css" />
  <script>
      
  $(function() {
    $('.toggle-class').change(function() {
        var status = $(this).prop('checked') == true ? 1 : 0; 
        var user_id = $(this).data('id'); 
         console.log(user_id);
         console.log(status);
        $.ajax({
            type: "GET",
            dataType: "json",
            url: '/provider/changeStatus',
            data: {'status': status, 'user_id': user_id},
            success: function(data){
              console.log(data.success)
            }
        });
    })
  })
  </script>
  
  <style>
      div.dataTables_wrapper div.dataTables_paginate{
          display: none;
      }
      .zoom {
        transition: transform .2s; /* Animation */
      }

      .zoom:hover {
        transform: scale(5);
      }
  </style>
@endpush
