






@extends('backend.layouts.master')

@section('main-content')

<div class="card">
    <h5 class="card-header">Add review</h5>
    <div class="card-body">
      <form method="post" action="{{url('/back/service/review')}}">
        {{csrf_field()}}
        <div class="form-group">
           <label for="name">Review By:</label>
           <input id="name" type="text" name="name" placeholder="Enter Review Name"  value="" class="form-control">
          @error('name')
          <span class="text-danger">{{$message}}</span>
          @enderror
        </div>

        <div class="form-group">
         <label for="rate">Ratting</label>
           <input id="rate" type="number" name="rate" placeholder=""  value="" class="form-control">
          @error('rate')
          <span class="text-danger">{{$message}}</span>
          @enderror
        </div>
        <div class="form-group">
        <label for="review">Review</label>
      <textarea name="review" id="review" cols="20" rows="10" class="form-control"></textarea>
          @error('review')
          <span class="text-danger">{{$message}}</span>
          @enderror
        </div>


        
     
        <div class="form-group">
          <label for="status" class="col-form-label">Status <span class="text-danger">*</span></label>
          <select name="status" class="form-control">
              <option value="active">Active</option>
              <option value="inactive">Inactive</option>
          </select>
          @error('status')
          <span class="text-danger">{{$message}}</span>
          @enderror
        </div>
        <div class="form-group mb-3">
          <button type="reset" class="btn btn-warning">Reset</button>
           <button class="btn btn-success" type="submit">Submit</button>
        </div>
      </form>
    </div>
</div>

@endsection

@push('styles')
<link rel="stylesheet" href="{{asset('backend/summernote/summernote.min.css')}}">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/css/bootstrap-select.css" />
@endpush
@push('scripts')
<script src="/vendor/laravel-filemanager/js/stand-alone-button.js"></script>
<script src="{{asset('backend/summernote/summernote.min.js')}}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/js/bootstrap-select.min.js"></script>

<script>
    $('#lfm').filemanager('image');

    $(document).ready(function() {
      $('#summary').summernote({
        placeholder: "Write short description.....",
          tabsize: 2,
          height: 100
      });
    });

    $(document).ready(function() {
      $('#description').summernote({
        placeholder: "Write detail description.....",
          tabsize: 2,
          height: 150
      });
    });

    $(document).ready(function() {
      $('#quote').summernote({
        placeholder: "Write detail Quote.....",
          tabsize: 2,
          height: 100
      });
    });
    // $('select').selectpicker();

</script>
@endpush
