@extends('backend.layouts.master')

@section('main-content')

<div class="card">
    <h5 class="card-header">Edit User</h5>
    <div class="card-body">
      <form method="post" action="{{route('users.update',$user->id)}}" enctype="multipart/form-data">
        @csrf 
        @method('PATCH')
        <div class="form-group">
          <label for="inputTitle" class="col-form-label">Name</label>
        <input id="inputTitle" type="text" name="name" placeholder="Enter name"  value="{{$user->name}}" class="form-control">
        @error('name')
        <span class="text-danger">{{$message}}</span>
        @enderror
        </div>

        <div class="form-group">
            <label for="inputEmail" class="col-form-label">Email</label>
          <input id="inputEmail" type="email" name="email" placeholder="Enter email"  value="{{$user->email}}" class="form-control">
          @error('email')
          <span class="text-danger">{{$message}}</span>
          @enderror
        </div>

        {{-- <div class="form-group">
            <label for="inputPassword" class="col-form-label">Password</label>
          <input id="inputPassword" type="password" name="password" placeholder="Enter password"  value="{{$user->password}}" class="form-control">
          @error('password')
          <span class="text-danger">{{$message}}</span>
          @enderror
        </div> --}}

          <div class="form-group">
            <label for="inputPhoto" class="col-form-label">Photo</label>
            <div class="input-group">
                <!--<span class="input-group-btn">-->
                <!--    <a id="lfm" data-input="thumbnail" data-preview="holder" class="btn btn-primary">-->
                <!--        <i class="fa fa-picture-o"></i> Choose-->
                <!--    </a>-->
                <!--</span>-->
                <input id="thumbnail" class="form-control" type="file" name="photo" value="{{ $user->photo }}" onchange="updateFileName(this)">
            </div>
            <div id="holder" style="margin-top:15px;max-height:100px;">
                @if ($user->photo)
                    <img src="{{ asset('public/user/' . $user->photo) }}" alt="Selected Photo" style="max-height: 100px;">
                @endif
            </div>
        </div>
        
        <script>
            document.getElementById('thumbnail').addEventListener('change', function (event) {
                updateFileName(this);
            });
        
            function updateFileName(input) {
                var fileName = input.value.split('\\').pop().split('/').pop();
                document.getElementById("holder").innerHTML = '<img src="' + URL.createObjectURL(input.files[0]) + '" alt="' + fileName + '" style="max-height: 100px;">';
            }
        </script>

        @php 
        $roles=DB::table('users')->select('role')->where('id',$user->id)->get();
        @endphp
        <!--<div class="form-group">-->
        <!--    <label for="role" class="col-form-label">Role</label>-->
        <!--    <select name="role" class="form-control">-->
        <!--        <option value="">-----Select Role-----</option>-->
        <!--        @foreach($roles as $role)-->
        <!--            <option value="{{$role->role}}" {{(($role->role=='admin') ? 'selected' : '')}}></option>-->
        <!--            <option value="{{$role->role}}" {{(($role->role=='user') ? 'selected' : '')}}></option>-->
                    <!--<option value="{{$role->role}}" {{(($role->role=='superadmin') ? 'selected' : '')}}>superadmin</option>-->
        <!--        @endforeach-->
        <!--    </select>-->
        <!--  @error('role')-->
        <!--  <span class="text-danger">{{$message}}</span>-->
        <!--  @enderror-->
        <!--  </div>-->
           <div class="form-group">
                          <label for="role" class="col-form-label">Role</label>
                          <select name="role" class="form-control">
                              <option value="">-----Select Role-----</option>
                                  <option value="admin" {{(($role->role=='admin')? 'selected' : '')}}>Admin</option>
                                  <option value="user" {{(($role->role=='user')? 'selected' : '')}}>User</option>
                          </select>
                        @error('role')
                        <span class="text-danger">{{$message}}</span>
                        @enderror
                        </div>
          <div class="form-group">
            <label for="status" class="col-form-label">Status</label>
            <select name="status" class="form-control">
                <option value="active" {{(($user->status=='active') ? 'selected' : '')}}>Active</option>
                <option value="inactive" {{(($user->status=='inactive') ? 'selected' : '')}}>Inactive</option>
            </select>
          @error('status')
          <span class="text-danger">{{$message}}</span>
          @enderror
          </div>
        <div class="form-group mb-3">
           <button class="btn btn-success" type="submit">Update</button>
        </div>
      </form>
    </div>
</div>

@endsection

@push('scripts')
<script src="/vendor/laravel-filemanager/js/stand-alone-button.js"></script>
<script>
    $('#lfm').filemanager('image');
</script>
@endpush