<!DOCTYPE html>
<html lang="en">

<head>
    <!-- METADATA SECTION -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=5.0">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-title" content="Blastup">
    <meta name="application-name" content="Blastup">
    <link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">
    <link rel="manifest" href="/site.webmanifest">
    <link rel="mask-icon" href="/safari-pinned-tab.svg" color="#cea3fd">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="theme-color" content="#ffffff">
    <!-- METADATA SECTION END -->
    <!-- FONTS SECTION -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Lato:wght@400;700;900&family=Nunito:wght@800;900&display=swap" rel="stylesheet">
    <!-- FONTS SECTION END -->
    <!-- GOOGLE TAG MANAGER -->
    <script>
        (function(w, d, s, l, i) {
            w[l] = w[l] || [];
            w[l].push({
                'gtm.start': new Date().getTime(),
                event: 'gtm.js'
            });
            var f = d.getElementsByTagName(s)[0],
                j = d.createElement(s),
                dl = l != 'dataLayer' ? '&l=' + l : '';
            j.async = true;
            j.src =
                'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
            f.parentNode.insertBefore(j, f);
        })(window, document, 'script', 'dataLayer', 'GTM-W5Z6C5F');
    </script>
    <!-- GOOGLE TAG MANAGER END -->
    <!-- VISITOR METADATA SECTION -->
    <script>
        window._CUSTOM_USER_DATA = {}
    </script>
    <!-- VISITOR METADATA SECTION END-->
    <!-- HEAD CONTENT SECTION -->
    <title>Lytechx / Checkout</title>
    <meta name="description" content="Complete your purchase easily and securely. All transactions on this page are encrypted and our support team is on standby in case your encounter any problems 🔥">
    <!-- HEAD CONTENT SECTION END-->
</head>

<body>

    <div class="page">
        <nav class="svelte-c9vl9o"><a href="https://blastup.com"><img src="/resources/img/logo.svg" alt="Blastup logo" draggable="false" class="svelte-c9vl9o"></a></nav>
        <div class="progress svelte-p2o84c">
            <div class="progress__item svelte-p2o84c progress__item--selected">
                <div class="progress__item-inner svelte-p2o84c">
                    <div class="progress__circle svelte-p2o84c"></div> <span class="svelte-p2o84c">Selection</span>
                </div>
            </div>
            <div class="progress__item svelte-p2o84c">
                <div class="progress__item-inner svelte-p2o84c">
                    <div class="progress__circle svelte-p2o84c"></div> <span class="svelte-p2o84c">Media</span>
                </div>
            </div>
            <div class="progress__item svelte-p2o84c">
                <div class="progress__item-inner svelte-p2o84c">
                    <div class="progress__circle svelte-p2o84c"></div> <span class="svelte-p2o84c">Payment</span>
                </div>
            </div>
        </div>
        <div class="page__screens">
            <div class="screen">
                <div class="screen__text svelte-3f8ore screen__text--less-padding">
                    <h2 class="screen__title svelte-3f8ore">Account &amp; package</h2>
                    <p class="screen__description svelte-3f8ore">Start by entering your Instagram username.</p>
                </div>
                <div class="features svelte-a7f5mn">
                    <div class="features__item svelte-a7f5mn"><img src="/resources/img/icons/verified--dark.svg" alt="Feature icon" draggable="false" class="svelte-a7f5mn">
                        <p class="svelte-a7f5mn">Internationally acclaimed services &amp; top ratings.</p>
                    </div>
                    <div class="features__item svelte-a7f5mn"><img src="/resources/img/icons/verified--dark.svg" alt="Feature icon" draggable="false" class="svelte-a7f5mn">
                        <p class="svelte-a7f5mn">24/7 support team ready to help.</p>
                    </div>
                    <div class="features__item svelte-a7f5mn"><img src="/resources/img/icons/verified--dark.svg" alt="Feature icon" draggable="false" class="svelte-a7f5mn">
                        <p class="svelte-a7f5mn">10+ years in the marketing business.</p>
                    </div>
                    <div class="features__item svelte-a7f5mn"><img src="/resources/img/icons/verified--dark.svg" alt="Feature icon" draggable="false" class="svelte-a7f5mn">
                        <p class="svelte-a7f5mn">PCI DSS compliant payment system using 256-bit encryption.</p>
                    </div>
                </div>
                <div class="card svelte-4zp6pa">
                    <form>
                        <div class="input-wrapper"><label for="username-input">Instagram username </label> <input id="username-input" name="username-input" placeholder="kyliejenner" required="" type="text"></div>
                        <div class="input-wrapper input-wrapper--select-input input-wrapper--select-valid"><label for="package-select">Product package</label> <select id="package-select" name="package-select" required="">
                                <option disabled="" value="">Select package...</option>
                                <option value="50">50 likes / $1.39 USD</option>
                                <option value="100">100 likes / $2.49 USD</option>
                                <option value="250">250 likes / $4.49 USD</option>
                                <option value="500">500 likes / $7.79 USD</option>
                                <option value="750">750 likes / $9.79 USD</option>
                                <option value="1000">1000 likes / $12.89 USD</option>
                                <option value="1500">1500 likes / $16.99 USD</option>
                                <option value="2000">2000 likes / $19.99 USD</option>
                                <option value="2500">2500 likes / $24.59 USD</option>
                                <option value="5000">5000 likes / $43.99 USD</option>
                                <option value="7500">7500 likes / $63.99 USD</option>
                                <option value="10000">10000 likes / $84.49 USD</option>
                            </select></div> <button class="button svelte-1lyby2h button--with-loader button--highlight" style="">
                            <div class="button__loader-wrapper svelte-1lyby2h">
                                <div class="button__loader-icon svelte-1lyby2h"></div> <span>Loading...</span>
                            </div>
                            <div class="button__content-wrapper svelte-1lyby2h"> <span class="button__text">Continue</span></div>
                        </button>
                    </form>
                </div>
                <div class="payment-methods svelte-15gd2az">
                    <p class="svelte-15gd2az">We accept</p>
                    <div class="payment-methods__icons svelte-15gd2az"><img src="/resources/img/placeholders/apple-pay.svg" draggable="false" alt="Apple Pay icon" class="svelte-15gd2az"><img src="/resources/img/placeholders/visa.svg" draggable="false" alt="Visa icon" class="svelte-15gd2az"><img src="/resources/img/placeholders/mastercard.svg" draggable="false" alt="Mastercard icon" class="svelte-15gd2az"><img src="/resources/img/placeholders/amex.svg" draggable="false" alt="American Express icon" class="svelte-15gd2az"></div>
                </div>
            </div>
        </div>
    </div>
    <!-- GOOGLE TAG MANAGER ACTIVATION SECTION -->
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-W5Z6C5F" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    <!-- GOOGLE TAG MANAGER ACTIVATION SECTION END -->
    <!-- BODY CONTENT SECTION -->
    <div class="page-anchor" style="display: block; >
        <link rel="preload" as="style" href="https://blastup.com/build/assets/AuthManager.03862e63.css" />
        <link rel="preload" as="style" href="https://blastup.com/build/assets/Features.34ea4df2.css" />
        <link rel="preload" as="style" href="https://blastup.com/build/assets/Generic.6b328696.css" />
        <link rel="preload" as="style" href="https://blastup.com/build/assets/Message.7a0882a8.css" />
        <link rel="preload" as="style" href="https://blastup.com/build/assets/Button.32ea2440.css" />
        <link rel="preload" as="style" href="https://blastup.com/build/assets/SavedCardsList.55a0e4ca.css" />
        <link rel="preload" as="style" href="https://blastup.com/build/assets/AvailablePaymentMethods.6b72a1c0.css" />
        <link rel="preload" as="style" href="https://blastup.com/build/assets/LoadableImage.295462a6.css" />
        <link rel="preload" as="style" href="https://blastup.com/build/assets/Divider.0e6981b4.css" />
        <link rel="preload" as="style" href="https://blastup.com/build/assets/AccountBox.cc789654.css" />
        <link rel="preload" as="style" href="https://blastup.com/build/assets/CrossSellCard.87c517a0.css" />
        <link rel="preload" as="style" href="https://blastup.com/build/assets/SummarySelection.7b271534.css" />
        <link rel="preload" as="style" href="https://blastup.com/build/assets/SummaryTable.456016dd.css" />
        <link rel="preload" as="style" href="https://blastup.com/build/assets/DeliverySettingsCard.8a866592.css" />
        <link rel="preload" as="style" href="https://blastup.com/build/assets/CardPayment.12a797dd.css" />
        <link rel="preload" as="style" href="https://blastup.com/build/assets/Checkbox.77309d71.css" />
        <link rel="preload" as="style" href="https://blastup.com/build/assets/Tooltip.be3e7c91.css" />
        <link rel="preload" as="style" href="https://blastup.com/build/assets/DeliveryDelay.ef708dff.css" />
        <link rel="preload" as="style" href="https://blastup.com/build/assets/checkout.40c2dd33.css" />
        <link rel="modulepreload" href="https://blastup.com/build/assets/checkout.4a8483e4.js" />
        <link rel="modulepreload" href="https://blastup.com/build/assets/AuthManager.917c5a60.js" />
        <link rel="modulepreload" href="https://blastup.com/build/assets/Features.ae0e08d4.js" />
        <link rel="modulepreload" href="https://blastup.com/build/assets/CheckoutManager.580f3d30.js" />
        <link rel="modulepreload" href="https://blastup.com/build/assets/Generic.1cabcd7e.js" />
        <link rel="modulepreload" href="https://blastup.com/build/assets/Message.8e087f9d.js" />
        <link rel="modulepreload" href="https://blastup.com/build/assets/Button.7212b5be.js" />
        <link rel="modulepreload" href="https://blastup.com/build/assets/Input.7fed8b8c.js" />
        <link rel="modulepreload" href="https://blastup.com/build/assets/SavedCardsList.7409bfc7.js" />
        <link rel="modulepreload" href="https://blastup.com/build/assets/AvailablePaymentMethods.7235095d.js" />
        <link rel="modulepreload" href="https://blastup.com/build/assets/LoadableImage.1a9eebfa.js" />
        <link rel="modulepreload" href="https://blastup.com/build/assets/Divider.d30120df.js" />
        <link rel="modulepreload" href="https://blastup.com/build/assets/AccountBox.414be1a7.js" />
        <link rel="modulepreload" href="https://blastup.com/build/assets/CrossSellCard.cbb580d6.js" />
        <link rel="modulepreload" href="https://blastup.com/build/assets/SummarySelection.fcea043d.js" />
        <link rel="modulepreload" href="https://blastup.com/build/assets/SummaryTable.69ac23e1.js" />
        <link rel="modulepreload" href="https://blastup.com/build/assets/DeliverySettingsCard.34fab352.js" />
        <link rel="modulepreload" href="https://blastup.com/build/assets/index.2eb4572c.js" />
        <link rel="modulepreload" href="https://blastup.com/build/assets/Checkbox.67640c02.js" />
        <link rel="modulepreload" href="https://blastup.com/build/assets/Tooltip.92114778.js" />
        <link rel="modulepreload" href="https://blastup.com/build/assets/DeliveryDelay.68000359.js" />
        <link rel="stylesheet" href="https://blastup.com/build/assets/AuthManager.03862e63.css" />
        <link rel="stylesheet" href="https://blastup.com/build/assets/Features.34ea4df2.css" />
        <link rel="stylesheet" href="https://blastup.com/build/assets/Generic.6b328696.css" />
        <link rel="stylesheet" href="https://blastup.com/build/assets/Message.7a0882a8.css" />
        <link rel="stylesheet" href="https://blastup.com/build/assets/Button.32ea2440.css" />
        <link rel="stylesheet" href="https://blastup.com/build/assets/SavedCardsList.55a0e4ca.css" />
        <link rel="stylesheet" href="https://blastup.com/build/assets/AvailablePaymentMethods.6b72a1c0.css" />
        <link rel="stylesheet" href="https://blastup.com/build/assets/LoadableImage.295462a6.css" />
        <link rel="stylesheet" href="https://blastup.com/build/assets/Divider.0e6981b4.css" />
        <link rel="stylesheet" href="https://blastup.com/build/assets/AccountBox.cc789654.css" />
        <link rel="stylesheet" href="https://blastup.com/build/assets/CrossSellCard.87c517a0.css" />
        <link rel="stylesheet" href="https://blastup.com/build/assets/SummarySelection.7b271534.css" />
        <link rel="stylesheet" href="https://blastup.com/build/assets/SummaryTable.456016dd.css" />
        <link rel="stylesheet" href="https://blastup.com/build/assets/DeliverySettingsCard.8a866592.css" />
        <link rel="stylesheet" href="https://blastup.com/build/assets/CardPayment.12a797dd.css" />
        <link rel="stylesheet" href="https://blastup.com/build/assets/Checkbox.77309d71.css" />
        <link rel="stylesheet" href="https://blastup.com/build/assets/Tooltip.be3e7c91.css" />
        <link rel="stylesheet" href="https://blastup.com/build/assets/DeliveryDelay.ef708dff.css" />
        <link rel="stylesheet" href="https://blastup.com/build/assets/checkout.40c2dd33.css" />
        <script type="module" src="https://blastup.com/build/assets/checkout.4a8483e4.js"></script>
    </div>
    <footer>
        <div class="footer__content">
            <div class="footer__logo">
                <div class="footer__logo-divider footer__logo-divider--left"></div>
                <a title="Homepage" href="https://blastup.com">
                    <img src="/resources/img/logo--grayscale.svg" alt="Blastup logo" draggable="false" />
                </a>
                <div class="footer__logo-divider footer__logo-divider--right"></div>
            </div>
            <div class="footer__sitemap sitemap">
                <div class="sitemap__row">
                    <ul class="sitemap__category">
                        <li><a title="Home" href="https://blastup.com">Home</a></li>
                        <li><a title="Dashboard" href="https://blastup.com/dashboard">Dashboard</a></li>
                        <li><a title="Blog" href="https://blastup.com/blog">Blog</a></li>
                        <li><a title="Support" href="https://blastup.com/support">Support</a></li>
                        <li><a title="Free Instagram Likes" href="https://blastup.com/free-trial">Free Likes</a></li>
                    </ul>
                    <ul class="sitemap__category">
                        <li><a title="Buy Instagram Followers" href="https://blastup.com/buy-instagram-followers">Buy Instagram Followers</a></li>
                        <li><a title="Buy Instagram Likes" href="https://blastup.com/buy-instagram-likes">Buy Instagram Likes</a></li>
                        <li><a title="Buy Instagram Views" href="https://blastup.com/buy-instagram-views">Buy Instagram Views</a></li>
                        <li><a title="Buy Automatic Instagram Likes" href="https://blastup.com/buy-automatic-instagram-likes">Buy Automatic Instagram Likes</a></li>
                        <li><a title="Buy Automatic Instagram Views" href="https://blastup.com/buy-automatic-instagram-views">Buy Automatic Instagram Views</a></li>
                    </ul>
                    <ul class="sitemap__category">
                        <li><a title="Instagram Followers Count" href="https://blastup.com/stats">Instagram Followers Count</a></li>
                        <li><a title="Download Instagram Videos & Photos" href="https://blastup.com/instagram-downloader">Download Instagram Videos &amp; Photos</a></li>
                        <li><a title="Terms of Service" href="https://blastup.com/terms">Terms of Service</a></li>
                        <li><a title="Privacy Policy" href="https://blastup.com/privacy-policy">Privacy Policy</a></li>
                    </ul>
                </div>
                <div class="footer__address">SocialUp LLC</div>
                <div class="footer__copyright">Copyright © 2024 / <a href="https://blastup.com">Blastup.com</a> / All rights reserved</div>
            </div>
        </div>
    </footer> <!-- BODY CONTENT SECTION END-->
    <!-- GENERIC SCRIPTS SECTION -->
    <script src="https://browser.sentry-cdn.com/7.74.1/bundle.tracing.min.js" integrity="sha384-1Ez4jfPb8+JxwhUMOcsZ2lSNLTABaKqokJNwn2XQCEgmFuwMewLCLyOKGQbLNYsp" crossorigin="anonymous"></script>
    <script>
        try {
            Sentry.init({
                dsn: "https://6ffa1e7ad2114cc9a2bb2618e2bcf2e5@o228640.ingest.sentry.io/1418200",
                integrations: [new Sentry.BrowserTracing()],
                tracesSampleRate: 1.0,
            });
        } catch (e) {
            console.error(e);
        }
    </script>
    <!-- GENERIC SCRIPTS SECTION END -->
    <!-- BOTTOM SCRIPTS SECTION -->
    <script>
        window.__config = {
            __type: "checkout",
            type: "checkout",
            host: "https://blastup.com",
            token: "Zzttm1HqvfNnI5vAkFhBYJOTaHYaNpz0Y5q6dFhS",
            recaptcha_key: "6LfQ7AYpAAAAAG_woLxsqvPWEyP0mg2uuUaC5ZJD",
            currency: {
                name: "usd",
                prefix: "$",
                suffix: " USD"
            },
            checkout_options: {
                public_key: "pk_4c441129-d685-4e0a-b067-c08d73181dc6",
                flags: {
                    fetch_posts: Boolean("true" === "true"),
                    upsell_enabled: Boolean("true" === "true"),
                    check_if_order_fillable: Boolean("false" === "true"),
                    promote_automatic_services: Boolean("false" === "true"),
                },
                features_list: [
                    "Internationally acclaimed services & top ratings.",
                    "24/7 support team ready to help.",
                    "10+ years in the marketing business.",
                    "PCI DSS compliant payment system using 256-bit encryption.",
                ],
                payment_methods_list: [{
                        name: "Apple Pay",
                        url: "/resources/img/placeholders/apple-pay.svg"
                    },
                    {
                        name: "Visa",
                        url: "/resources/img/placeholders/visa.svg"
                    },
                    {
                        name: "Mastercard",
                        url: "/resources/img/placeholders/mastercard.svg"
                    },
                    {
                        name: "American Express",
                        url: "/resources/img/placeholders/amex.svg"
                    },
                ]
            },
            user: {
                authorized: Boolean("true" === "true"),
                email: "kr7505635@gmail.com",
                saved_cards: []
            },
            session: {
                __type: "checkout",
                username: "",
                country: "in",
            },
            product: {
                type: "one_time",
                platform: "instagram",
                name: "likes",
                package: "50"
            },
            product_config: {},
            delivery_settings: []
        }


        window.__config.product_config = {
            "instagram": [{
                    platform: "instagram",
                    name: "likes",
                    type: "one_time",
                    minimum_amount: parseInt(50),
                    icon: "/resources/img/icons/likes.svg",
                    packages: [{
                            "amount": 50,
                            "price": 1.39,
                            "upsell": {
                                "amount": 25,
                                "price": 0.59,
                                "discount": 15
                            },
                            "cross": [{
                                "product": "followers",
                                "amount": 100
                            }, ]
                        },
                        {
                            "amount": 100,
                            "price": 2.49,
                            "upsell": {
                                "amount": 50,
                                "price": 1.09,
                                "discount": 12
                            },
                            "cross": [{
                                "product": "followers",
                                "amount": 150
                            }, ]
                        },
                        {
                            "amount": 250,
                            "price": 4.49,
                            "upsell": {
                                "amount": 100,
                                "price": 1.49,
                                "discount": 17
                            },
                            "cross": [{
                                "product": "followers",
                                "amount": 350
                            }, ]
                        },
                        {
                            "amount": 500,
                            "price": 7.79,
                            "upsell": {
                                "amount": 150,
                                "price": 1.69,
                                "discount": 17
                            },
                            "cross": [{
                                "product": "followers",
                                "amount": 650
                            }, ]
                        },
                        {
                            "amount": 750,
                            "price": 9.79,
                            "upsell": {
                                "amount": 150,
                                "price": 1.59,
                                "discount": 19
                            },
                            "cross": [{
                                "product": "followers",
                                "amount": 900
                            }, ]
                        },
                        {
                            "amount": 1000,
                            "price": 12.89,
                            "upsell": {
                                "amount": 250,
                                "price": 2.59,
                                "discount": 20
                            },
                            "cross": [{
                                "product": "followers",
                                "amount": 1250
                            }, ]
                        },
                        {
                            "amount": 1500,
                            "price": 16.99,
                            "upsell": {
                                "amount": 250,
                                "price": 2.39,
                                "discount": 16
                            },
                            "cross": [{
                                "product": "followers",
                                "amount": 1750
                            }, ]
                        },
                        {
                            "amount": 2000,
                            "price": 19.99,
                            "upsell": {
                                "amount": 250,
                                "price": 2.09,
                                "discount": 16
                            },
                            "cross": [{
                                "product": "followers",
                                "amount": 2250
                            }, ]
                        },
                        {
                            "amount": 2500,
                            "price": 24.59,
                            "upsell": {
                                "amount": 500,
                                "price": 3.99,
                                "discount": 19
                            },
                            "cross": [{
                                "product": "followers",
                                "amount": 3000
                            }, ]
                        },
                        {
                            "amount": 5000,
                            "price": 43.99,
                            "upsell": {
                                "amount": 1000,
                                "price": 6.99,
                                "discount": 21
                            },
                            "cross": [{
                                "product": "followers",
                                "amount": 6000
                            }, ]
                        },
                        {
                            "amount": 7500,
                            "price": 63.99,
                            "upsell": {
                                "amount": 1500,
                                "price": 9.99,
                                "discount": 22
                            },
                            "cross": [{
                                "product": "followers",
                                "amount": 9000
                            }, ]
                        },
                        {
                            "amount": 10000,
                            "price": 84.49,
                            "upsell": {
                                "amount": 2500,
                                "price": 15.49,
                                "discount": 27
                            },
                            "cross": [{
                                "product": "followers",
                                "amount": 12500
                            }, ]
                        },
                    ],
                },
                {
                    platform: "instagram",
                    name: "followers",
                    type: "one_time",
                    minimum_amount: parseInt(100),
                    icon: "/resources/img/icons/followers.svg",
                    packages: [{
                            "amount": 100,
                            "price": 2.99,
                            "upsell": {
                                "amount": 50,
                                "price": 1.29,
                                "discount": 14
                            },
                            "cross": []
                        },
                        {
                            "amount": 250,
                            "price": 4.99,
                            "upsell": {
                                "amount": 100,
                                "price": 1.69,
                                "discount": 15
                            },
                            "cross": []
                        },
                        {
                            "amount": 500,
                            "price": 6.99,
                            "upsell": {
                                "amount": 150,
                                "price": 1.79,
                                "discount": 15
                            },
                            "cross": []
                        },
                        {
                            "amount": 750,
                            "price": 9.99,
                            "upsell": {
                                "amount": 150,
                                "price": 1.79,
                                "discount": 10
                            },
                            "cross": []
                        },
                        {
                            "amount": 1000,
                            "price": 12.99,
                            "upsell": {
                                "amount": 250,
                                "price": 2.89,
                                "discount": 11
                            },
                            "cross": []
                        },
                        {
                            "amount": 1500,
                            "price": 18.99,
                            "upsell": {
                                "amount": 250,
                                "price": 2.79,
                                "discount": 12
                            },
                            "cross": []
                        },
                        {
                            "amount": 2000,
                            "price": 24.49,
                            "upsell": {
                                "amount": 250,
                                "price": 2.69,
                                "discount": 12
                            },
                            "cross": []
                        },
                        {
                            "amount": 2500,
                            "price": 29.99,
                            "upsell": {
                                "amount": 500,
                                "price": 5.29,
                                "discount": 12
                            },
                            "cross": []
                        },
                        {
                            "amount": 5000,
                            "price": 39.99,
                            "upsell": {
                                "amount": 1000,
                                "price": 7.09,
                                "discount": 11
                            },
                            "cross": []
                        },
                        {
                            "amount": 7500,
                            "price": 49.99,
                            "upsell": {
                                "amount": 1500,
                                "price": 8.89,
                                "discount": 11
                            },
                            "cross": []
                        },
                        {
                            "amount": 10000,
                            "price": 59.99,
                            "upsell": {
                                "amount": 2500,
                                "price": 13.19,
                                "discount": 12
                            },
                            "cross": []
                        },
                    ],
                },
                {
                    platform: "instagram",
                    name: "views",
                    type: "one_time",
                    minimum_amount: parseInt(250),
                    icon: "/resources/img/icons/views.svg",
                    packages: [{
                            "amount": 500,
                            "price": 1.99,
                            "upsell": {
                                "amount": 250,
                                "price": 0.79,
                                "discount": 20
                            },
                            "cross": [{
                                    "product": "likes",
                                    "amount": 350
                                },
                                {
                                    "product": "followers",
                                    "amount": 350
                                },
                            ]
                        },
                        {
                            "amount": 1000,
                            "price": 2.99,
                            "upsell": {
                                "amount": 500,
                                "price": 1.29,
                                "discount": 14
                            },
                            "cross": [{
                                    "product": "likes",
                                    "amount": 900
                                },
                                {
                                    "product": "followers",
                                    "amount": 900
                                },
                            ]
                        },
                        {
                            "amount": 2500,
                            "price": 6.99,
                            "upsell": {
                                "amount": 1000,
                                "price": 2.39,
                                "discount": 15
                            },
                            "cross": [{
                                    "product": "likes",
                                    "amount": 1750
                                },
                                {
                                    "product": "followers",
                                    "amount": 1750
                                },
                            ]
                        },
                        {
                            "amount": 5000,
                            "price": 13.99,
                            "upsell": {
                                "amount": 2500,
                                "price": 5.49,
                                "discount": 22
                            },
                            "cross": [{
                                    "product": "likes",
                                    "amount": 3000
                                },
                                {
                                    "product": "followers",
                                    "amount": 3000
                                },
                            ]
                        },
                        {
                            "amount": 10000,
                            "price": 24.99,
                            "upsell": {
                                "amount": 2500,
                                "price": 4.99,
                                "discount": 20
                            },
                            "cross": [{
                                    "product": "likes",
                                    "amount": 5000
                                },
                                {
                                    "product": "followers",
                                    "amount": 5000
                                },
                            ]
                        },
                        {
                            "amount": 15000,
                            "price": 34.49,
                            "upsell": {
                                "amount": 2500,
                                "price": 4.99,
                                "discount": 14
                            },
                            "cross": [{
                                    "product": "likes",
                                    "amount": 6000
                                },
                                {
                                    "product": "followers",
                                    "amount": 6000
                                },
                            ]
                        },
                        {
                            "amount": 20000,
                            "price": 39.99,
                            "upsell": {
                                "amount": 5000,
                                "price": 7.99,
                                "discount": 20
                            },
                            "cross": [{
                                    "product": "likes",
                                    "amount": 7500
                                },
                                {
                                    "product": "followers",
                                    "amount": 7500
                                },
                            ]
                        },
                        {
                            "amount": 30000,
                            "price": 49.99,
                            "upsell": {
                                "amount": 5000,
                                "price": 6.99,
                                "discount": 16
                            },
                            "cross": [{
                                    "product": "likes",
                                    "amount": 9000
                                },
                                {
                                    "product": "followers",
                                    "amount": 9000
                                },
                            ]
                        },
                        {
                            "amount": 50000,
                            "price": 74.99,
                            "upsell": {
                                "amount": 10000,
                                "price": 11.99,
                                "discount": 20
                            },
                            "cross": [{
                                    "product": "likes",
                                    "amount": 10000
                                },
                                {
                                    "product": "followers",
                                    "amount": 9000
                                },
                            ]
                        },
                        {
                            "amount": 100000,
                            "price": 139.99,
                            "upsell": {
                                "amount": 25000,
                                "price": 26.99,
                                "discount": 23
                            },
                            "cross": [{
                                    "product": "likes",
                                    "amount": 12500
                                },
                                {
                                    "product": "followers",
                                    "amount": 10000
                                },
                            ]
                        },
                    ],
                },
            ]
        }


        try {
            window.__config.user.saved_cards = []
        } catch (e) {
            console.error(e);
            Sentry.captureException(e);
        }


        try {
            window.__config.delivery_settings = [{
                    "type": "gender",
                    "products": [],
                },
                {
                    "type": "delay",
                    "products": [
                        "followers",
                        "likes",
                        "views",
                    ],
                },
            ]
        } catch (e) {
            console.error(e);
            Sentry.captureException(e)
        }
        //
    </script>

    <!-- <script src="https://cdn.checkout.com/js/framesv2.min.js" defer></script> -->
    <script src="https://risk.checkout.com/cdn/risk/1/risk.js" async defer></script>
    <script id="recaptcha-script" src="https://www.google.com/recaptcha/enterprise.js?render=6LfQ7AYpAAAAAG_woLxsqvPWEyP0mg2uuUaC5ZJD" async defer></script>
    <!-- BOTTOM SCRIPTS SECTION END -->
</body>

</html>