<!DOCTYPE html>
<html lang="en">

<head>
    <!-- METADATA SECTION -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=5.0">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-title" content="Blastup">
    <meta name="application-name" content="Blastup">
    <link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">
    <link rel="manifest" href="/site.webmanifest">
    <link rel="mask-icon" href="/safari-pinned-tab.svg" color="#cea3fd">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="theme-color" content="#ffffff">
    <!-- METADATA SECTION END -->
    <!-- FONTS SECTION -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Lato:wght@400;700;900&family=Nunito:wght@800;900&display=swap" rel="stylesheet">
    <!-- FONTS SECTION END -->
    <!-- GOOGLE TAG MANAGER -->
    <script>
        (function(w, d, s, l, i) {
            w[l] = w[l] || [];
            w[l].push({
                'gtm.start': new Date().getTime(),
                event: 'gtm.js'
            });
            var f = d.getElementsByTagName(s)[0],
                j = d.createElement(s),
                dl = l != 'dataLayer' ? '&l=' + l : '';
            j.async = true;
            j.src =
                'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
            f.parentNode.insertBefore(j, f);
        })(window, document, 'script', 'dataLayer', 'GTM-W5Z6C5F');
    </script>
    <!-- GOOGLE TAG MANAGER END -->
    <!-- VISITOR METADATA SECTION -->
    <script>
        window._CUSTOM_USER_DATA = {}
    </script>
    <!-- VISITOR METADATA SECTION END-->
    <!-- HEAD CONTENT SECTION -->
    <title>lytechx / Checkout</title>
    <meta name="description" content="Complete your purchase easily and securely. All transactions on this page are encrypted and our support team is on standby in case your encounter any problems 🔥">
    <!-- HEAD CONTENT SECTION END-->
</head>

<body>
    <div class="page">
        <nav class="svelte-c9vl9o"><a href="{{url('/')}}"><img src="{{url('public/frontend/img/logo.svg')}}" alt="Blastup logo" draggable="false" class="svelte-c9vl9o"></a></nav>
        <div class="progress svelte-p2o84c">
            <div class="progress__item svelte-p2o84c progress__item--completed">
                <div class="progress__item-inner svelte-p2o84c">
                    <div class="progress__circle svelte-p2o84c"></div> <span class="svelte-p2o84c">Selection</span>
                </div>
            </div>
            <div class="progress__item svelte-p2o84c progress__item--selected">
                <div class="progress__item-inner svelte-p2o84c">
                    <div class="progress__circle svelte-p2o84c"></div> <span class="svelte-p2o84c">Media</span>
                </div>
            </div>
            <div class="progress__item svelte-p2o84c">
                <div class="progress__item-inner svelte-p2o84c">
                    <div class="progress__circle svelte-p2o84c"></div> <span class="svelte-p2o84c">Payment</span>
                </div>
            </div>
        </div>
        <div class="page__screens">
            <div class="screen">
                <div class="screen__text svelte-3f8ore screen__text--less-padding">
                    <h2 class="screen__title svelte-3f8ore">Media selection</h2>
                    <p class="screen__description svelte-3f8ore">You can split your package between multiple posts and the package amount will be distributed evenly.</p>
                </div>
                <div class="back-action"><button class="button svelte-1lyby2h button--no-shadow button--small button--with-icon button--with-loader button--inset-main" style="">
                        <div class="button__loader-wrapper svelte-1lyby2h">
                            <div class="button__loader-icon svelte-1lyby2h"></div> <span>Loading...</span>
                        </div>
                        <div class="button__content-wrapper svelte-1lyby2h"><img class="button__icon svelte-1lyby2h" src="{{url('public/frontend/img/arrow__left--dark.svg')}}" alt="Button icon" draggable="false"> <span class="button__text">To previous step</span></div>
                    </button></div>
                <div class="card svelte-4zp6pa">
                    <div class="account-box svelte-1lirsk6">
                        <div class="loadable-image account-box__avatar svelte-38on5n">
                            <div class="loadable-image__background svelte-38on5n" style="background-image: url(&quot;https://blastup.com/media/i8gCMZBGRcipmjbo&quot;);"></div>
                            <div class="loadable-image__loader svelte-38on5n"><img alt="Loader icon" src="/resources/img/icons/spinner--white.svg" draggable="false" class="svelte-38on5n"></div>
                        </div>
                        <div class="account-box__text svelte-1lirsk6">
                            <p class="account-box__username svelte-1lirsk6">kumawat.raj3536</p>
                            <p class="account-box__description svelte-1lirsk6">50 likes / $1.39 USD</p>
                        </div>
                    </div>
                    <div class="gallery">
                        <div class="gallery__list svelte-tvc693">
                            <div>
                                <div class="gallery__post post svelte-1yemsu9" role="button">
                                    <div class="loadable-image post__thumbnail svelte-38on5n">
                                        <div class="loadable-image__background svelte-38on5n" style="background-image: url(&quot;https://blastup.com/media/Voq0CtIa2vOkF3iV&quot;);"></div>
                                        <div class="loadable-image__loader svelte-38on5n"><img alt="Loader icon" src="/resources/img/icons/spinner--white.svg" draggable="false" class="svelte-38on5n"></div>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <div class="gallery__post post svelte-1yemsu9" role="button">
                                    <div class="loadable-image post__thumbnail svelte-38on5n">
                                        <div class="loadable-image__background svelte-38on5n" style="background-image: url(&quot;https://blastup.com/media/rQdqhfadaPBuIrra&quot;);"></div>
                                        <div class="loadable-image__loader svelte-38on5n"><img alt="Loader icon" src="/resources/img/icons/spinner--white.svg" draggable="false" class="svelte-38on5n"></div>
                                    </div>
                                </div>
                            </div>
                         
                        </div> <button class="button svelte-1lyby2h button--small button--full-width button--with-loader button--inset-highlight" style="">
                            <div class="button__loader-wrapper svelte-1lyby2h">
                                <div class="button__loader-icon svelte-1lyby2h"></div> <span>Loading...</span>
                            </div>
                            <div class="button__content-wrapper svelte-1lyby2h"> <span class="button__text">Load more</span></div>
                        </button>
                        <div class="divider svelte-1ha3zgo"></div>
                        <div>
                            <div class="selection-sticky svelte-17sp80e selection-sticky--disabled">
                                <div class="selection-sticky__content svelte-17sp80e">
                                    <p class="svelte-17sp80e">Select a post to continue</p> <button class="button svelte-1lyby2h button--small button--with-loader button--highlight button--disabled" style="">
                                        <div class="button__loader-wrapper svelte-1lyby2h">
                                            <div class="button__loader-icon svelte-1lyby2h"></div> <span>Loading...</span>
                                        </div>
                                        <div class="button__content-wrapper svelte-1lyby2h"> <span class="button__text">Next</span></div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- GOOGLE TAG MANAGER ACTIVATION SECTION -->
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-W5Z6C5F" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    <!-- GOOGLE TAG MANAGER ACTIVATION SECTION END -->
    <!-- BODY CONTENT SECTION -->
    @include('frontend.layouts.footer')