<!DOCTYPE html>
<html lang="en">

<head>
    <!-- METADATA SECTION -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=5.0">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-title" content="Blastup">
    <meta name="application-name" content="Blastup">
    <link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">
    <link rel="manifest" href="/site.webmanifest">
    <link rel="mask-icon" href="/safari-pinned-tab.svg" color="#cea3fd">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="theme-color" content="#ffffff">
    <!-- METADATA SECTION END -->
    <!-- FONTS SECTION -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Lato:wght@400;700;900&family=Nunito:wght@800;900&display=swap" rel="stylesheet">
    <!-- FONTS SECTION END -->
    <!-- GOOGLE TAG MANAGER -->
    <script>
        (function(w, d, s, l, i) {
            w[l] = w[l] || [];
            w[l].push({
                'gtm.start': new Date().getTime(),
                event: 'gtm.js'
            });
            var f = d.getElementsByTagName(s)[0],
                j = d.createElement(s),
                dl = l != 'dataLayer' ? '&l=' + l : '';
            j.async = true;
            j.src =
                'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
            f.parentNode.insertBefore(j, f);
        })(window, document, 'script', 'dataLayer', 'GTM-W5Z6C5F');
    </script>
    <!-- GOOGLE TAG MANAGER END -->
    <!-- VISITOR METADATA SECTION -->
    <script>
        window._CUSTOM_USER_DATA = {}
    </script>
    <!-- VISITOR METADATA SECTION END-->
    <!-- HEAD CONTENT SECTION -->
    <title>Blastup / Checkout</title>
    <meta name="description" content="Complete your purchase easily and securely. All transactions on this page are encrypted and our support team is on standby in case your encounter any problems 🔥">
    <!-- HEAD CONTENT SECTION END-->
</head>

<body>
    <div class="page">
        <nav class="svelte-c9vl9o"><a href="https://blastup.com"><img src="/resources/img/logo.svg" alt="Blastup logo" draggable="false" class="svelte-c9vl9o"></a></nav>
        <div class="progress svelte-p2o84c">
            <div class="progress__item svelte-p2o84c progress__item--completed">
                <div class="progress__item-inner svelte-p2o84c">
                    <div class="progress__circle svelte-p2o84c"></div> <span class="svelte-p2o84c">Selection</span>
                </div>
            </div>
            <div class="progress__item svelte-p2o84c progress__item--completed">
                <div class="progress__item-inner svelte-p2o84c">
                    <div class="progress__circle svelte-p2o84c"></div> <span class="svelte-p2o84c">Media</span>
                </div>
            </div>
            <div class="progress__item svelte-p2o84c progress__item--selected">
                <div class="progress__item-inner svelte-p2o84c">
                    <div class="progress__circle svelte-p2o84c"></div> <span class="svelte-p2o84c">Payment</span>
                </div>
            </div>
        </div>
        <div class="page__screens">
            <div class="screen">
                <div class="screen__text svelte-3f8ore screen__text--less-padding">
                    <h2 class="screen__title svelte-3f8ore">Summary &amp; payment</h2>
                    <p class="screen__description svelte-3f8ore">Your transaction details are always end-to-end encrypted.</p>
                </div>
                <div class="back-action"><button class="button svelte-1lyby2h button--no-shadow button--small button--with-icon button--with-loader button--inset-main" style="">
                        <div class="button__loader-wrapper svelte-1lyby2h">
                            <div class="button__loader-icon svelte-1lyby2h"></div> <span>Loading...</span>
                        </div>
                        <div class="button__content-wrapper svelte-1lyby2h"><img class="button__icon svelte-1lyby2h" src="/resources/img/icons/arrow__left--dark.svg" alt="Button icon" draggable="false"> <span class="button__text">To previous step</span></div>
                    </button></div>
                <div class="upsell-card svelte-7a1wq7">
                    <h2 class="upsell-card__title svelte-7a1wq7">🔥 Get more likes at 15% off!</h2>
                    <p class="upsell-card__description svelte-7a1wq7">Add <strong style="font-weight: 700">25 more likes</strong> to
                        your order <strong style="font-weight: 700">for only $0.59 USD</strong>.
                        Unique offer with 15% discount!</p> <button class="button svelte-1lyby2h button--no-shadow button--with-loader button--main" style="">
                        <div class="button__loader-wrapper svelte-1lyby2h">
                            <div class="button__loader-icon svelte-1lyby2h"></div> <span>Loading...</span>
                        </div>
                        <div class="button__content-wrapper svelte-1lyby2h"> <span class="button__text">Add to cart</span></div>
                    </button>
                </div>
                <div class="card svelte-4zp6pa">
                    <div class="selection-summary svelte-8n6l3g">
                        <div class="selection-summary__header selection-account svelte-8n6l3g" role="button">
                            <div class="loadable-image selection-account__avatar svelte-38on5n">
                                <div class="loadable-image__background svelte-38on5n" style="background-image: url(&quot;https://blastup.com/media/evFoHWG8Wc2kivBO&quot;);"></div>
                                <div class="loadable-image__loader svelte-38on5n"><img alt="Loader icon" src="/resources/img/icons/spinner--white.svg" draggable="false" class="svelte-38on5n"></div>
                            </div>
                            <div class="selection-account__description svelte-8n6l3g">
                                <p class="selection-account__username svelte-8n6l3g">kumawat.raj3536</p>
                                <p class="selection-account__package svelte-8n6l3g">Selected 1 post</p>
                            </div>
                            <div class="selection-summary__icon svelte-8n6l3g"><img src="/resources/img/icons/chevron__down--dark.svg" alt="Expand selection icon" draggable="false" class="svelte-8n6l3g"></div>
                        </div>
                    </div>
                    <div class="divider svelte-1ha3zgo"></div>
                    <table class="summary svelte-nahfh4">
                        <tbody>
                            <tr class="row row__item svelte-nahfh4">
                                <td class="svelte-nahfh4">50 likes</td>
                                <td class="svelte-nahfh4">$1.39 USD</td>
                                <td class="svelte-nahfh4"></td>
                            </tr>
                        </tbody>
                        <tfoot>
                            <tr class="svelte-nahfh4">
                                <td class="svelte-nahfh4">Your total</td>
                                <td class="svelte-nahfh4">$1.39 USD</td>
                                <td class="svelte-nahfh4"></td>
                            </tr>
                        </tfoot>
                    </table>
                    <div class="actions svelte-30hqr7"><button class="button svelte-1lyby2h button--with-loader button--inset-main" style="">
                            <div class="button__loader-wrapper svelte-1lyby2h">
                                <div class="button__loader-icon svelte-1lyby2h"></div> <span>Loading...</span>
                            </div>
                            <div class="button__content-wrapper svelte-1lyby2h"> <span class="button__text">Apply coupon</span></div>
                        </button></div>
                </div>
                <div class="settings-card svelte-12kik4b">
                    <div class="settings-card__header svelte-12kik4b" role="button">
                        <div class="settings-card__description svelte-12kik4b">
                            <h2 class="settings-card__title svelte-12kik4b">Delivery settings</h2>
                            <p class="settings-card__available svelte-12kik4b">1 option available</p>
                        </div>
                        <div class="settings-card__icon svelte-12kik4b"><img src="/resources/img/icons/chevron__down--dark.svg" alt="Expand selection icon" draggable="false" class="svelte-12kik4b"></div>
                    </div>
                    <div class="settings-card__body svelte-12kik4b">
                        <div class="option svelte-zu2jaq">
                            <p class="option__title svelte-zu2jaq"><strong>Delivery speed</strong></p>
                            <p class="option__description svelte-zu2jaq">Works <strong>for followers, likes &amp; views</strong>. We will match selected speed to best of our ability.</p>
                            <div class="input-wrapper input-wrapper--select-input input-wrapper--no-margin input-wrapper--select-valid"> <select id="delivery-settings__speed" name="delivery-settings__speed" required="">
                                    <option disabled="" value="">Select speed...</option>
                                    <option value="0">As fast as possible</option>
                                    <option value="30">30 minutes</option>
                                    <option value="50">50 minutes</option>
                                </select></div>
                        </div>
                    </div>
                </div>
                <div class="cross-sell-card svelte-epj0o6">
                    <h2 class="cross-sell-card__title svelte-epj0o6">Get <span class="cross-sell-card__highlight svelte-epj0o6">followers</span> as well 🤩</h2>
                    <p class="cross-sell-card__description svelte-epj0o6">Get a followers package that will <strong>perfectly</strong> supplement your likes order.</p>
                    <div class="input-wrapper input-wrapper--select-input input-wrapper--select-valid"> <select id="followers-cross-sell-select" name="followers-cross-sell-select" required="">
                            <option disabled="" value="">Select package...</option>
                            <option value="100">100 followers / $2.99 USD</option>
                            <option value="150">150 followers / $4.28 USD</option>
                            <option value="250">250 followers / $4.99 USD</option>
                            <option value="350">350 followers / $6.68 USD</option>
                            <option value="500">500 followers / $6.99 USD</option>
                            <option value="650">650 followers / $8.78 USD</option>
                            <option value="750">750 followers / $9.99 USD</option>
                            <option value="900">900 followers / $11.78 USD</option>
                            <option value="1000">1000 followers / $12.99 USD</option>
                            <option value="1250">1250 followers / $15.88 USD</option>
                            <option value="1500">1500 followers / $18.99 USD</option>
                            <option value="1750">1750 followers / $21.78 USD</option>
                            <option value="2000">2000 followers / $24.49 USD</option>
                            <option value="2250">2250 followers / $27.18 USD</option>
                            <option value="2500">2500 followers / $29.99 USD</option>
                            <option value="3000">3000 followers / $35.28 USD</option>
                            <option value="5000">5000 followers / $39.99 USD</option>
                            <option value="6000">6000 followers / $47.08 USD</option>
                            <option value="7500">7500 followers / $49.99 USD</option>
                            <option value="9000">9000 followers / $58.88 USD</option>
                            <option value="10000">10000 followers / $59.99 USD</option>
                            <option value="12500">12500 followers / $73.18 USD</option>
                        </select></div> <button class="button svelte-1lyby2h button--no-shadow button--with-loader button--main" style="">
                        <div class="button__loader-wrapper svelte-1lyby2h">
                            <div class="button__loader-icon svelte-1lyby2h"></div> <span>Loading...</span>
                        </div>
                        <div class="button__content-wrapper svelte-1lyby2h"> <span class="button__text">Add to cart</span></div>
                    </button>
                </div>
                <div class="card svelte-4zp6pa card--secure">
                    <div class="card__header svelte-4zp6pa">
                        <h2 class="card__title svelte-4zp6pa">Secure payment</h2>
                        <p class="card__description">Transaction details are always encrypted in transit and are stored securely in compliance with PCI DSS standard.</p>
                    </div>
                    <div class="new-option svelte-js3x07">
                        <form>
                            <div class="input-wrapper"><label for="checkout__email">Your email for receipt </label> <input id="checkout__email" name="checkout__email" placeholder="example@domain.com" required="" autocomplete="section-new-card billing email" type="email"></div>
                            <div class="input-wrapper input-wrapper--select-input input-wrapper--select-valid"><label for="checkout__country">Your country of residence</label> <select id="checkout__country" name="checkout__country" required="">
                                    <option disabled="" value="">Select country...</option>
                                    <option value="af">Afghanistan</option>
                                    <option value="ax">Aland Islands</option>
                                    <option value="al">Albania</option>
                                    <option value="dz">Algeria</option>
                                    <option value="as">American Samoa</option>
                                    <option value="ad">Andorra</option>
                                    <option value="ao">Angola</option>
                                    <option value="ai">Anguilla</option>
                                    <option value="ag">Antigua</option>
                                    <option value="ar">Argentina</option>
                                    <option value="am">Armenia</option>
                                    <option value="aw">Aruba</option>
                                    <option value="au">Australia</option>
                                    <option value="at">Austria</option>
                                    <option value="az">Azerbaijan</option>
                                    <option value="bs">Bahamas</option>
                                    <option value="bh">Bahrain</option>
                                    <option value="bd">Bangladesh</option>
                                    <option value="bb">Barbados</option>
                                    <option value="by">Belarus</option>
                                    <option value="be">Belgium</option>
                                    <option value="bz">Belize</option>
                                    <option value="bj">Benin</option>
                                    <option value="bm">Bermuda</option>
                                    <option value="bt">Bhutan</option>
                                    <option value="bo">Bolivia</option>
                                    <option value="ba">Bosnia</option>
                                    <option value="bw">Botswana</option>
                                    <option value="bv">Bouvet Island</option>
                                    <option value="br">Brazil</option>
                                    <option value="vg">British Virgin Islands</option>
                                    <option value="bn">Brunei</option>
                                    <option value="bg">Bulgaria</option>
                                    <option value="bf">Burkina Faso</option>
                                    <option value="mm">Burma</option>
                                    <option value="bi">Burundi</option>
                                    <option value="tc">Caicos Islands</option>
                                    <option value="kh">Cambodia</option>
                                    <option value="cm">Cameroon</option>
                                    <option value="ca">Canada</option>
                                    <option value="cv">Cape Verde</option>
                                    <option value="ky">Cayman Islands</option>
                                    <option value="cf">Central African Republic</option>
                                    <option value="td">Chad</option>
                                    <option value="cl">Chile</option>
                                    <option value="cn">China</option>
                                    <option value="cx">Christmas Island</option>
                                    <option value="cc">Cocos Islands</option>
                                    <option value="co">Colombia</option>
                                    <option value="km">Comoros</option>
                                    <option value="cg">Congo Brazzaville</option>
                                    <option value="cd">Congo</option>
                                    <option value="ck">Cook Islands</option>
                                    <option value="cr">Costa Rica</option>
                                    <option value="ci">Cote Divoire</option>
                                    <option value="hr">Croatia</option>
                                    <option value="cu">Cuba</option>
                                    <option value="cy">Cyprus</option>
                                    <option value="cz">Czech Republic</option>
                                    <option value="dk">Denmark</option>
                                    <option value="dj">Djibouti</option>
                                    <option value="dm">Dominica</option>
                                    <option value="do">Dominican Republic</option>
                                    <option value="ec">Ecuador</option>
                                    <option value="eg">Egypt</option>
                                    <option value="sv">El Salvador</option>
                                    <option value="gq">Equatorial Guinea</option>
                                    <option value="er">Eritrea</option>
                                    <option value="ee">Estonia</option>
                                    <option value="et">Ethiopia</option>
                                    <option value="eu">European Union</option>
                                    <option value="fk">Falkland Islands</option>
                                    <option value="fo">Faroe Islands</option>
                                    <option value="fj">Fiji</option>
                                    <option value="fi">Finland</option>
                                    <option value="fr">France</option>
                                    <option value="gf">French Guiana</option>
                                    <option value="pf">French Polynesia</option>
                                    <option value="tf">French Territories</option>
                                    <option value="ga">Gabon</option>
                                    <option value="gm">Gambia</option>
                                    <option value="ge">Georgia</option>
                                    <option value="de">Germany</option>
                                    <option value="gh">Ghana</option>
                                    <option value="gi">Gibraltar</option>
                                    <option value="gr">Greece</option>
                                    <option value="gl">Greenland</option>
                                    <option value="gd">Grenada</option>
                                    <option value="gp">Guadeloupe</option>
                                    <option value="gu">Guam</option>
                                    <option value="gt">Guatemala</option>
                                    <option value="gw">Guinea-Bissau</option>
                                    <option value="gn">Guinea</option>
                                    <option value="gy">Guyana</option>
                                    <option value="ht">Haiti</option>
                                    <option value="hm">Heard Island</option>
                                    <option value="hn">Honduras</option>
                                    <option value="hk">Hong Kong</option>
                                    <option value="hu">Hungary</option>
                                    <option value="is">Iceland</option>
                                    <option value="in">India</option>
                                    <option value="io">Indian Ocean Territory</option>
                                    <option value="id">Indonesia</option>
                                    <option value="ir">Iran</option>
                                    <option value="iq">Iraq</option>
                                    <option value="ie">Ireland</option>
                                    <option value="il">Israel</option>
                                    <option value="it">Italy</option>
                                    <option value="jm">Jamaica</option>
                                    <option value="jp">Japan</option>
                                    <option value="jo">Jordan</option>
                                    <option value="kz">Kazakhstan</option>
                                    <option value="ke">Kenya</option>
                                    <option value="ki">Kiribati</option>
                                    <option value="kw">Kuwait</option>
                                    <option value="kg">Kyrgyzstan</option>
                                    <option value="la">Laos</option>
                                    <option value="lv">Latvia</option>
                                    <option value="lb">Lebanon</option>
                                    <option value="ls">Lesotho</option>
                                    <option value="lr">Liberia</option>
                                    <option value="ly">Libya</option>
                                    <option value="li">Liechtenstein</option>
                                    <option value="lt">Lithuania</option>
                                    <option value="lu">Luxembourg</option>
                                    <option value="mo">Macau</option>
                                    <option value="mk">Macedonia</option>
                                    <option value="mg">Madagascar</option>
                                    <option value="mw">Malawi</option>
                                    <option value="my">Malaysia</option>
                                    <option value="mv">Maldives</option>
                                    <option value="ml">Mali</option>
                                    <option value="mt">Malta</option>
                                    <option value="mh">Marshall Islands</option>
                                    <option value="mq">Martinique</option>
                                    <option value="mr">Mauritania</option>
                                    <option value="mu">Mauritius</option>
                                    <option value="yt">Mayotte</option>
                                    <option value="mx">Mexico</option>
                                    <option value="fm">Micronesia</option>
                                    <option value="md">Moldova</option>
                                    <option value="mc">Monaco</option>
                                    <option value="mn">Mongolia</option>
                                    <option value="me">Montenegro</option>
                                    <option value="ms">Montserrat</option>
                                    <option value="ma">Morocco</option>
                                    <option value="mz">Mozambique</option>
                                    <option value="na">Namibia</option>
                                    <option value="nr">Nauru</option>
                                    <option value="np">Nepal</option>
                                    <option value="an">Netherlands Antilles</option>
                                    <option value="nl">Netherlands</option>
                                    <option value="nc">New Caledonia</option>
                                    <option value="pg">New Guinea</option>
                                    <option value="nz">New Zealand</option>
                                    <option value="ni">Nicaragua</option>
                                    <option value="ne">Niger</option>
                                    <option value="ng">Nigeria</option>
                                    <option value="nu">Niue</option>
                                    <option value="nf">Norfolk Island</option>
                                    <option value="kp">North Korea</option>
                                    <option value="mp">Northern Mariana Islands</option>
                                    <option value="no">Norway</option>
                                    <option value="om">Oman</option>
                                    <option value="pk">Pakistan</option>
                                    <option value="pw">Palau</option>
                                    <option value="ps">Palestine</option>
                                    <option value="pa">Panama</option>
                                    <option value="py">Paraguay</option>
                                    <option value="pe">Peru</option>
                                    <option value="ph">Philippines</option>
                                    <option value="pn">Pitcairn Islands</option>
                                    <option value="pl">Poland</option>
                                    <option value="pt">Portugal</option>
                                    <option value="pr">Puerto Rico</option>
                                    <option value="qa">Qatar</option>
                                    <option value="re">Reunion</option>
                                    <option value="ro">Romania</option>
                                    <option value="ru">Russia</option>
                                    <option value="rw">Rwanda</option>
                                    <option value="sh">Saint Helena</option>
                                    <option value="kn">Saint Kitts and Nevis</option>
                                    <option value="lc">Saint Lucia</option>
                                    <option value="pm">Saint Pierre</option>
                                    <option value="vc">Saint Vincent</option>
                                    <option value="ws">Samoa</option>
                                    <option value="sm">San Marino</option>
                                    <option value="gs">Sandwich Islands</option>
                                    <option value="st">Sao Tome</option>
                                    <option value="sa">Saudi Arabia</option>
                                    <option value="sn">Senegal</option>
                                    <option value="cs">Serbia</option>
                                    <option value="rs">Serbia</option>
                                    <option value="sc">Seychelles</option>
                                    <option value="sl">Sierra Leone</option>
                                    <option value="sg">Singapore</option>
                                    <option value="sk">Slovakia</option>
                                    <option value="si">Slovenia</option>
                                    <option value="sb">Solomon Islands</option>
                                    <option value="so">Somalia</option>
                                    <option value="za">South Africa</option>
                                    <option value="kr">South Korea</option>
                                    <option value="es">Spain</option>
                                    <option value="lk">Sri Lanka</option>
                                    <option value="sd">Sudan</option>
                                    <option value="sr">Suriname</option>
                                    <option value="sj">Svalbard</option>
                                    <option value="sz">Swaziland</option>
                                    <option value="se">Sweden</option>
                                    <option value="ch">Switzerland</option>
                                    <option value="sy">Syria</option>
                                    <option value="tw">Taiwan</option>
                                    <option value="tj">Tajikistan</option>
                                    <option value="tz">Tanzania</option>
                                    <option value="th">Thailand</option>
                                    <option value="tl">Timorleste</option>
                                    <option value="tg">Togo</option>
                                    <option value="tk">Tokelau</option>
                                    <option value="to">Tonga</option>
                                    <option value="tt">Trinidad</option>
                                    <option value="tn">Tunisia</option>
                                    <option value="tr">Turkey</option>
                                    <option value="tm">Turkmenistan</option>
                                    <option value="tv">Tuvalu</option>
                                    <option value="ug">Uganda</option>
                                    <option value="ua">Ukraine</option>
                                    <option value="ae">United Arab Emirates</option>
                                    <option value="gb">United Kingdom</option>
                                    <option value="us">United States</option>
                                    <option value="uy">Uruguay</option>
                                    <option value="um">Us Minor Islands</option>
                                    <option value="vi">Us Virgin Islands</option>
                                    <option value="uz">Uzbekistan</option>
                                    <option value="vu">Vanuatu</option>
                                    <option value="va">Vatican City</option>
                                    <option value="ve">Venezuela</option>
                                    <option value="vn">Vietnam</option>
                                    <option value="wf">Wallis and Futuna</option>
                                    <option value="eh">Western Sahara</option>
                                    <option value="ye">Yemen</option>
                                    <option value="zm">Zambia</option>
                                    <option value="zw">Zimbabwe</option>
                                </select></div>
                            <div class="input-wrapper"><label for="checkout__zip">Postal/ZIP code </label> <input id="checkout__zip" name="checkout__zip" placeholder="90028" required="" autocomplete="section-new-card billing postal-code" type="text"></div>
                            <div class="input-wrapper"><label for="checkout__cardholder">Cardholder name </label> <input id="checkout__cardholder" name="checkout__cardholder" placeholder="John Doe" required="" autocomplete="section-new-card billing cc-name" type="text"></div>
                            <div class="cko svelte-1hb2bv6">
                                <div class="cko__card-number input-wrapper svelte-1hb2bv6"><label for="checkout-fake-input-cardNumber" class="svelte-1hb2bv6">Card number <img src="/resources/img/icons/lock--green.svg" draggable="false" alt="Lock icon" class="svelte-1hb2bv6"></label>
                                    <div class="card-number-frame frame--activated"><input data-fieldidentifier="checkout-fake-input-cardNumber" aria-hidden="true" autocomplete="fake" readonly="true" style="position:absolute;top:-1px;left:0;width:100%;height:1px;border:0;margin:0;padding:0;pointer-events:none;opacity:0;background:transparent;"><iframe id="cardNumber" src="https://js.checkout.com/framesv2/?v=2.40.3&amp;publicKey=pk_4c441129-d685-4e0a-b067-c08d73181dc6&amp;iOS=false&amp;schemeChoiceVariant=NONE&amp;isMultiFrame=true&amp;safari=false&amp;acceptedPaymentMethods=Visa%252CMaestro%252CMastercard%252CAmerican%2520Express&amp;cardNumberPlaceholder=%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%2520%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%2520%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%2520%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2&amp;expiryMonthPlaceholder=MM&amp;expiryYearPlaceholder=YY&amp;cvvPlaceholder=%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2&amp;element=card-number" style="width:100%;height:100%;background:transparent;overflow:hidden;border:0 none transparent;margin:0;padding:0;-webkit-tap-highlight-color:transparent;display:block;position:static;" title="checkout-frames-cardNumber" name="checkout-frames-cardNumber" scrolling="no" tabindex="0"></iframe></div>
                                </div>
                                <div class="input-group">
                                    <div class="cko__expiry input-wrapper svelte-1hb2bv6"><label for="checkout-fake-input-expiryDate" class="svelte-1hb2bv6">Expiry date <img src="/resources/img/icons/lock--green.svg" draggable="false" alt="Lock icon" class="svelte-1hb2bv6"></label>
                                        <div class="expiry-date-frame frame--activated"><input data-fieldidentifier="checkout-fake-input-expiryDate" aria-hidden="true" autocomplete="fake" readonly="true" style="position:absolute;top:-1px;left:0;width:100%;height:1px;border:0;margin:0;padding:0;pointer-events:none;opacity:0;background:transparent;"><iframe id="expiryDate" src="https://js.checkout.com/framesv2/?v=2.40.3&amp;publicKey=pk_4c441129-d685-4e0a-b067-c08d73181dc6&amp;iOS=false&amp;schemeChoiceVariant=NONE&amp;isMultiFrame=true&amp;safari=false&amp;acceptedPaymentMethods=Visa%252CMaestro%252CMastercard%252CAmerican%2520Express&amp;cardNumberPlaceholder=%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%2520%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%2520%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%2520%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2&amp;expiryMonthPlaceholder=MM&amp;expiryYearPlaceholder=YY&amp;cvvPlaceholder=%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2&amp;element=expiry-date" style="width:100%;height:100%;background:transparent;overflow:hidden;border:0 none transparent;margin:0;padding:0;-webkit-tap-highlight-color:transparent;display:block;position:static;" title="checkout-frames-expiryDate" name="checkout-frames-expiryDate" scrolling="no" tabindex="0"></iframe></div>
                                    </div>
                                    <div class="cko__cvc input-wrapper svelte-1hb2bv6"><label for="checkout-fake-input-cvv" class="svelte-1hb2bv6">CVV/CVC <img src="/resources/img/icons/lock--green.svg" draggable="false" alt="Lock icon" class="svelte-1hb2bv6"></label>
                                        <div class="cvv-frame frame--activated"><input data-fieldidentifier="checkout-fake-input-cvv" aria-hidden="true" autocomplete="fake" readonly="true" style="position:absolute;top:-1px;left:0;width:100%;height:1px;border:0;margin:0;padding:0;pointer-events:none;opacity:0;background:transparent;"><iframe id="cvv" src="https://js.checkout.com/framesv2/?v=2.40.3&amp;publicKey=pk_4c441129-d685-4e0a-b067-c08d73181dc6&amp;iOS=false&amp;schemeChoiceVariant=NONE&amp;isMultiFrame=true&amp;safari=false&amp;acceptedPaymentMethods=Visa%252CMaestro%252CMastercard%252CAmerican%2520Express&amp;cardNumberPlaceholder=%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%2520%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%2520%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%2520%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2&amp;expiryMonthPlaceholder=MM&amp;expiryYearPlaceholder=YY&amp;cvvPlaceholder=%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2&amp;element=cvv" style="width:100%;height:100%;background:transparent;overflow:hidden;border:0 none transparent;margin:0;padding:0;-webkit-tap-highlight-color:transparent;display:block;position:static;" title="checkout-frames-cvv" name="checkout-frames-cvv" scrolling="no" tabindex="0"></iframe></div>
                                    </div>
                                </div>
                            </div>
                            <div class="divider svelte-1ha3zgo"></div>
                            <div style="margin-bottom: 10px;">
                                <div class="checkbox svelte-1bibwq">
                                    <div class="checkbox__box svelte-1bibwq"></div>
                                    <p class="checkbox__description svelte-1bibwq">Remember this card</p>
                                    <div class="tooltip svelte-1a4tcr8">
                                        <div class="tooltip__trigger svelte-1a4tcr8">?</div>
                                    </div>
                                </div>
                            </div> <button class="button svelte-1lyby2h button--full-width button--with-loader button--highlight" style="">
                                <div class="button__loader-wrapper svelte-1lyby2h">
                                    <div class="button__loader-icon svelte-1lyby2h"></div> <span>Loading...</span>
                                </div>
                                <div class="button__content-wrapper svelte-1lyby2h"> <span class="button__text">Pay $1.39 USD</span></div>
                            </button>
                        </form>
                    </div>
                </div>
                <div class="payment-methods svelte-15gd2az">
                    <p class="svelte-15gd2az">We accept</p>
                    <div class="payment-methods__icons svelte-15gd2az"><img src="/resources/img/placeholders/apple-pay.svg" draggable="false" alt="Apple Pay icon" class="svelte-15gd2az"><img src="/resources/img/placeholders/visa.svg" draggable="false" alt="Visa icon" class="svelte-15gd2az"><img src="/resources/img/placeholders/mastercard.svg" draggable="false" alt="Mastercard icon" class="svelte-15gd2az"><img src="/resources/img/placeholders/amex.svg" draggable="false" alt="American Express icon" class="svelte-15gd2az"></div>
                </div>
            </div>
        </div>
    </div>
    <!-- GOOGLE TAG MANAGER ACTIVATION SECTION -->
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-W5Z6C5F" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    <!-- GOOGLE TAG MANAGER ACTIVATION SECTION END -->
    <!-- BODY CONTENT SECTION -->

    @include('frontend.layouts.footer')