<!DOCTYPE html>
<html lang="en">

<head>
    <!-- METADATA SECTION -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=5.0">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-title" content="Blastup">
    <meta name="application-name" content="Blastup">
    <link rel="apple-touch-icon" sizes="180x180" href="{{url('public/frontend/img/apple-touch-icon.png')}}">
    <link rel="icon" type="image/png" sizes="32x32" href="{{url('public/frontend/img/favicon-32x32.png')}}">
    <link rel="icon" type="image/png" sizes="16x16" href="{{url('public/frontend/img/favicon-16x16.png')}}">
    <link rel="manifest" href="/site.webmanifest">
    <link rel="mask-icon" href="/safari-pinned-tab.svg" color="#cea3fd">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="theme-color" content="#ffffff">
    <!-- METADATA SECTION END -->
    <!-- FONTS SECTION -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Lato:wght@400;700;900&family=Nunito:wght@800;900&display=swap" rel="stylesheet">
    <!-- FONTS SECTION END -->
    <!-- GOOGLE TAG MANAGER -->
    <script>
        (function(w, d, s, l, i) {
            w[l] = w[l] || [];
            w[l].push({
                'gtm.start': new Date().getTime(),
                event: 'gtm.js'
            });
            var f = d.getElementsByTagName(s)[0],
                j = d.createElement(s),
                dl = l != 'dataLayer' ? '&l=' + l : '';
            j.async = true;
            j.src =
                'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
            f.parentNode.insertBefore(j, f);
        })(window, document, 'script', 'dataLayer', 'GTM-W5Z6C5F');
    </script>
    <!-- GOOGLE TAG MANAGER END -->
    <!-- VISITOR METADATA SECTION -->
    <script>
        window._CUSTOM_USER_DATA = {}
    </script>
    <!-- VISITOR METADATA SECTION END-->
    <!-- HEAD CONTENT SECTION -->
    <title>Blastup / Checkout</title>
    <meta name="description" content="Complete your purchase easily and securely. All transactions on this page are encrypted and our support team is on standby in case your encounter any problems ðŸ”¥">
    <!-- HEAD CONTENT SECTION END-->
    
<style>
    .loading {
      height: 0;
      width: 0;
      padding: 15px;
      border: 6px solid #ccc;
      border-right-color: #888;
      border-radius: 22px;
      -webkit-animation: rotate 1s infinite linear;
      /* left, top and position just for the demo! */
      position: absolute;
      left: 5%;
      top: 18%;
    }
    
    .newloading {
        height: 0px;
        width: 0;
        padding: 6px;
        border: 3px solid #ccc;
        border-right-color: #888;
        border-radius: 22px;
        -webkit-animation: rotate 1s infinite linear;
        position: absolute;
        left: 40%;
        top: 31%;
    }

    @-webkit-keyframes rotate {
    /* 100% keyframe for  clockwise. 
        use 0% instead for anticlockwise */
        100% {
        -webkit-transform: rotate(360deg);
        }
    }
</style>
</head>

<body>

    <div class="page">
        <nav class="svelte-c9vl9o"><a href="{{url('/')}}"><img src="{{url('public/frontend/img/logo.svg')}}" alt="Blastup logo" draggable="false" class="svelte-c9vl9o"></a></nav>
        <div class="progress svelte-p2o84c">
            <div class="progress__item svelte-p2o84c progress__item--selected">
                <div class="progress__item-inner svelte-p2o84c">
                    <div class="progress__circle svelte-p2o84c" id="Selection_circle"></div> <span class="svelte-p2o84c">Selection</span>
                </div>
            </div>
            <div class="progress__item svelte-p2o84c">
                <div class="progress__item-inner svelte-p2o84c">
                    <div class="progress__circle svelte-p2o84c" id="Media_circle"></div> <span class="svelte-p2o84c">Media</span>
                </div>
            </div>
            <div class="progress__item svelte-p2o84c">
                <div class="progress__item-inner svelte-p2o84c">
                    <div class="progress__circle svelte-p2o84c" id="Payment_circle"></div> <span class="svelte-p2o84c">Payment</span>
                </div>
            </div>
        </div>
        <div class="page__screens">
            
            <div class="screen" id="selection_section">
                <div class="screen__text svelte-3f8ore screen__text--less-padding">
                    <h2 class="screen__title svelte-3f8ore">Account &amp; package</h2>
                    <p class="screen__description svelte-3f8ore">Start by entering your Instagram username.</p>
                </div>
                <div class="features svelte-a7f5mn">
                    <div class="features__item svelte-a7f5mn"><img src="{{url('public/frontend/img/verified--dark.svg')}}" alt="Feature icon" draggable="false" class="svelte-a7f5mn">
                        <p class="svelte-a7f5mn">Internationally acclaimed services &amp; top ratings.</p>
                    </div>
                    <div class="features__item svelte-a7f5mn"><img src="{{url('public/frontend/img/verified--dark.svg')}}" alt="Feature icon" draggable="false" class="svelte-a7f5mn">
                        <p class="svelte-a7f5mn">24/7 support team ready to help.</p>
                    </div>
                    <div class="features__item svelte-a7f5mn"><img src="{{url('public/frontend/img/verified--dark.svg')}}" alt="Feature icon" draggable="false" class="svelte-a7f5mn">
                        <p class="svelte-a7f5mn">10+ years in the marketing business.</p>
                    </div>
                    <div class="features__item svelte-a7f5mn"><img src="{{url('public/frontend/img/verified--dark.svg')}}" alt="Feature icon" draggable="false" class="svelte-a7f5mn">
                        <p class="svelte-a7f5mn">PCI DSS compliant payment system using 256-bit encryption.</p>
                    </div>
                </div>
                <div class="card svelte-4zp6pa">
                    <form id="selectionform" method="post">
                        @csrf
                        <div class="input-wrapper"><label for="username-input">Instagram username </label> <input id="username-input" name="username-input" placeholder="kyliejenner" required="" type="text"></div>
                        <div class="input-wrapper input-wrapper--select-input input-wrapper--select-valid"><label for="package-select">Product package</label> <select id="package-select" name="package-select" required="">
                                <option disabled="" value="">Select package...</option>
                          
                                
                                    @if(count($plan_values) == count($plan_prices))
                                     @foreach($plan_values as $key => $value)
                                         <option value="{{$value}},{{$plan_prices[$key]}}" {{ ($plan_val == $value) ? 'selected' : '' }} >{{$value}} {{$plan}} / ${{$plan_prices[$key]}} USD</option>
                                     @endforeach
                                @endif
                                
                                
                                
                            </select>
                        </div>
                        <input type="hidden" name="price" value="{{$price_val}}" >
                        <input type="hidden" name="plan" value="{{$plan}}" >
                        <input type="hidden" name="field" value="{{$plan}}" >
                        <input type="hidden" name="next_max_id" value="" id="next_max_id">
                        <input type="hidden" name="pk_id" value="" id="pk_id">
                        <button class="button svelte-1lyby2h button--with-loader button--highlight" style="" id="non_loaing_btn">
                            <div class="button__loader-wrapper svelte-1lyby2h">
                                <div class="button__loader-icon svelte-1lyby2h"></div> <span>Loading...</span>
                            </div>
                            <div class="button__content-wrapper svelte-1lyby2h"> <span class="button__text">Continue</span></div>
                           
                        </button>
                        <button class="button svelte-1lyby2h button--with-loader button--highlight" style="background: #a3a1a9;" id="loading_btn">
                           
                            <div class="button__content-wrapper svelte-1lyby2h" style="padding-left: 21px;">Loading...</div>
                            <span class="button__text loading"></span>
                        </button>
                    </form>
                </div>
                <div class="payment-methods svelte-15gd2az">
                    <p class="svelte-15gd2az">We accept</p>
                    <div class="payment-methods__icons svelte-15gd2az">
                        <img src="{{url('public/frontend/img/apple-pay.svg')}}" draggable="false" alt="Apple Pay icon" class="svelte-15gd2az">
                        <img src="{{url('public/frontend/img/visa.svg')}}" draggable="false" alt="Visa icon" class="svelte-15gd2az">
                        <img src="{{url('public/frontend/img/mastercard.svg')}}" draggable="false" alt="Mastercard icon" class="svelte-15gd2az">
                        <img src="{{url('public/frontend/img/amex.svg')}}" draggable="false" alt="American Express icon" class="svelte-15gd2az">
                    </div>
                </div>
            </div>
            
            <div class="screen" id="media_section" style="display:none">
                <div class="screen__text svelte-3f8ore screen__text--less-padding">
                    <h2 class="screen__title svelte-3f8ore">Media selection</h2>
                    <p class="screen__description svelte-3f8ore">You can split your package between multiple posts and the package amount will be distributed evenly.</p>
                </div>
                <div class="back-action">
                    <button class="button svelte-1lyby2h button--no-shadow button--small button--with-icon button--with-loader button--inset-main" id="media_prev" style="">
                        <div class="button__loader-wrapper svelte-1lyby2h">
                            <div class="button__loader-icon svelte-1lyby2h"></div> <span>Loading...</span>
                        </div>
                        <div class="button__content-wrapper svelte-1lyby2h">
                            <img class="button__icon svelte-1lyby2h"  src="{{url('public/frontend/img/arrow__left--dark.svg')}}" alt="Button icon" draggable="false">
                            <span class="button__text">To previous step</span>
                        </div>
                    </button>
                </div>
                <div class="card svelte-4zp6pa">
                    <div class="account-box svelte-1lirsk6">
                        <div class="loadable-image account-box__avatar svelte-38on5n" >
                            <div class="loadable-image__background svelte-38on5n" id="profile_pic"></div>
                            <div class="loadable-image__loader svelte-38on5n"><img alt="Loader icon" src="{{url('public/frontend/img/giphy.gif')}}" draggable="false" class="svelte-38on5n"></div>
                        </div>
                        <div class="account-box__text svelte-1lirsk6">
                            <p class="account-box__username svelte-1lirsk6">kumawat.raj3536</p>
                            <p class="account-box__description svelte-1lirsk6">50 likes / $1.39 USD</p>
                        </div>
                    </div>
                    <div class="gallery">
                        <!--<img  src="https://scontent-ord5-1.cdninstagram.com/v/t51.2885-15/407191326_6956021897794424_8749004755501750662_n.webp?stp=dst-jpg_e35&amp;_nc_ht=scontent-ord5-1.cdninstagram.com&amp;_nc_cat=108&amp;_nc_ohc=wRxRqSlPu10AX88I1Nf&amp;edm=ACWDqb8BAAAA&amp;ccb=7-5&amp;ig_c=MzI1MTE4NjAxNjQ1OTMwOTk4Ng%3D%3D.2-ccb7-5&amp;oh=00_AfAYvoZefDd38jo98b_70dXnBdGWZFZyOuvazsSZtrf_9g&amp;oe=65BF7338&amp;_nc_sid=ee9879" crossorigin="anonymous" >-->
                        <div class="gallery__list svelte-tvc693" id="append_post">
                 
                         
                        </div>
                        <button class="button svelte-1lyby2h button--small button--full-width button--with-loader button--inset-highlight" style="" onclick="load_more_btn_click()" id="load_more_btn">
                            <div class="button__loader-wrapper svelte-1lyby2h">
                                <div class="button__loader-icon svelte-1lyby2h"></div> <span>Loading...</span>
                            </div>
                            <div class="button__content-wrapper svelte-1lyby2h"> <span class="button__text">Load more</span></div>
                        </button>
                        <br>
                        <button class="button svelte-1lyby2h button--small button--full-width button--with-loader button--inset-highlight" style="" id="newload_more_btn">
                            <div class="button__loader-wrapper svelte-1lyby2h">
                                <div class="button__loader-icon svelte-1lyby2h"></div> <span>Loading...</span>
                            </div>
                            <div class="button__content-wrapper svelte-1lyby2h"></div>
                            <div class="button__content-wrapper svelte-1lyby2h"> <span class="button__text">Loading...</span></div>
                            <span class="button__text newloading"></span>
                        </button>
                        <div class="divider svelte-1ha3zgo newstyle" ></div>
                        <div>
                            <div class="selection-sticky svelte-17sp80e ">
                                <div class="selection-sticky__content svelte-17sp80e">
                                    <p class="svelte-17sp80e select_count">Select a post to continue</p>
                                    <button id="nextButton" class="button svelte-1lyby2h button--small button--with-loader button--highlight button--disabled" style="">
                                        <div class="button__loader-wrapper svelte-1lyby2h">
                                            <div class="button__loader-icon svelte-1lyby2h"></div> <span>Loading...</span>
                                        </div>
                                        <div class="button__content-wrapper svelte-1lyby2h">
                                             <span class="button__text">Next</span>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="screen" id="payment_section" style="display:none">
               <div class="screen__text svelte-3f8ore screen__text--less-padding">
                  <h2 class="screen__title svelte-3f8ore">Summary &amp; payment</h2>
                  <p class="screen__description svelte-3f8ore">Your transaction details are always end-to-end encrypted.</p>
               </div>
               <div class="back-action">
                  <button class="button svelte-1lyby2h button--no-shadow button--small button--with-icon button--with-loader button--inset-main" id="payment_prev" style="">
                        <div class="button__loader-wrapper svelte-1lyby2h">
                            <div class="button__loader-icon svelte-1lyby2h"></div>
                            <span>Loading...</span>
                        </div>
                        <div class="button__content-wrapper svelte-1lyby2h">
                            <img class="button__icon svelte-1lyby2h"  src="{{url('public/frontend/img/arrow__left--dark.svg')}}" alt="Button icon" draggable="false">
                            <span class="button__text">To previous step</span>
                        </div>
                  </button>
               </div>
               <div class="upsell-card svelte-7a1wq7">
                  <h2 class="upsell-card__title svelte-7a1wq7">🔥 Get more likes at 15% off!</h2>
                  <p class="upsell-card__description svelte-7a1wq7">Add <strong style="font-weight: 700">25 more likes</strong> to
                     your order <strong style="font-weight: 700">for only $0.59 USD</strong>.
                     Unique offer with 15% discount!
                  </p>
                  <button class="button svelte-1lyby2h button--no-shadow button--with-loader button--main" style="">
                     <div class="button__loader-wrapper svelte-1lyby2h">
                        <div class="button__loader-icon svelte-1lyby2h"></div>
                        <span>Loading...</span>
                     </div>
                     <div class="button__content-wrapper svelte-1lyby2h"> <span class="button__text">Add to cart</span></div>
                  </button>
               </div>
               <div class="card svelte-4zp6pa">
                  <div class="selection-summary svelte-8n6l3g" id="pre_view_postsSSS">
                     <div class="selection-summary__header selection-account svelte-8n6l3g" role="button">
                        <div class="loadable-image selection-account__avatar svelte-38on5n">
                           <div class="loadable-image__background svelte-38on5n" id="profile_img" ></div>
                           <div class="loadable-image__loader svelte-38on5n">
                               <img alt="Loader icon" src="{{url('public/frontend/img/giphy.gif')}}" draggable="false" class="svelte-38on5n">
                            </div>
                        </div>
                        
                        <div class="selection-account__description svelte-8n6l3g">
                           <p class="selection-account__username svelte-8n6l3g username">akshaykumar</p>
                           <p class="selection-account__package svelte-8n6l3g postcount">Selected 1 post</p>
                        </div>
                        <div class="selection-summary__icon svelte-8n6l3g selection_icon" >
                            <img src="{{url('public/frontend/img/chevron__down--dark.svg')}}" alt="Expand selection icon" draggable="false" class="svelte-8n6l3g">
                        </div>
                     </div>
                        <div class="selection-summary__body selection-posts svelte-8n6l3g" id="add_preview_post" >
                         
                        </div>
                     
                  </div>
                  <div class="divider svelte-1ha3zgo"></div>
                  <table class="summary svelte-nahfh4">
                     <tbody>
                        <!--<tr class="row row__item svelte-nahfh4">-->
                        <!--   <td class="svelte-nahfh4">50 likes</td>-->
                        <!--   <td class="svelte-nahfh4">$1.39 USD</td>-->
                        <!--   <td class="svelte-nahfh4"></td>-->
                        <!--</tr>-->
                     </tbody>
                     <tfoot>
                        <!--<tr class="svelte-nahfh4">-->
                        <!--   <td class="svelte-nahfh4">Your total</td>-->
                        <!--   <td class="svelte-nahfh4">$1.39 USD</td>-->
                        <!--   <td class="svelte-nahfh4"></td>-->
                        <!--</tr>-->
                     </tfoot>
                  </table>
                  <div class="actions svelte-30hqr7">
                     <button class="button svelte-1lyby2h button--with-loader button--inset-main" style="">
                        <div class="button__loader-wrapper svelte-1lyby2h">
                           <div class="button__loader-icon svelte-1lyby2h"></div>
                           <span>Loading...</span>
                        </div>
                        <div class="button__content-wrapper svelte-1lyby2h"> <span class="button__text">Apply coupon</span></div>
                     </button>
                  </div>
               </div>
               <div class="settings-card svelte-12kik4b" id="prew_deli_setting">
                  <div class="settings-card__header svelte-12kik4b" role="button" id="hideshowbar">
                     <div class="settings-card__description svelte-12kik4b">
                        <h2 class="settings-card__title svelte-12kik4b">Delivery settings</h2>
                        <p class="settings-card__available svelte-12kik4b">1 option available</p>
                     </div>
                     <div class="settings-card__icon svelte-12kik4b"><img src="{{url('public/frontend/img/chevron__down--dark.svg')}}" alt="Expand selection icon" draggable="false" class="svelte-12kik4b"></div>
                  </div>
                  <!--<div class="settings-card__body svelte-12kik4b">-->
                  <!--   <div class="option svelte-zu2jaq">-->
                  <!--      <p class="option__title svelte-zu2jaq"><strong>Delivery speed</strong></p>-->
                  <!--      <p class="option__description svelte-zu2jaq">Works <strong>for followers, likes &amp; views</strong>. We will match selected speed to best of our ability.</p>-->
                  <!--      <div class="input-wrapper input-wrapper--select-input input-wrapper--no-margin input-wrapper--select-valid">-->
                  <!--         <select id="delivery-settings__speed" name="delivery-settings__speed" required="">-->
                  <!--            <option disabled="" value="">Select speed...</option>-->
                  <!--            <option value="0">As fast as possible</option>-->
                  <!--            <option value="30">30 minutes</option>-->
                  <!--            <option value="50">50 minutes</option>-->
                  <!--         </select>-->
                  <!--      </div>-->
                  <!--   </div>-->
                  <!--</div>-->
               </div>
               <div class="cross-sell-card svelte-epj0o6 boostfollowers">
                  <h2 class="cross-sell-card__title svelte-epj0o6">Boost your <span class="cross-sell-card__highlight svelte-epj0o6">followers</span>  🤩</h2>
                  <p class="cross-sell-card__description svelte-epj0o6">Get a followers package that will <strong>perfectly</strong> supplement your likes order.</p>
                  <div class="input-wrapper input-wrapper--select-input input-wrapper--select-valid">
                     <select id="followers-cross-sell-select" name="followers-cross-sell-select" required="">
                        <option disabled="" value="">Select package...</option>
                        <option value="100">100 followers / $2.99 USD</option>
                        <option value="150">150 followers / $4.28 USD</option>
                        <option value="250">250 followers / $4.99 USD</option>
                        <option value="350">350 followers / $6.68 USD</option>
                        <option value="500">500 followers / $6.99 USD</option>
                        <option value="650">650 followers / $8.78 USD</option>
                        <option value="750">750 followers / $9.99 USD</option>
                        <option value="900">900 followers / $11.78 USD</option>
                        <option value="1000">1000 followers / $12.99 USD</option>
                        <option value="1250">1250 followers / $15.88 USD</option>
                        <option value="1500">1500 followers / $18.99 USD</option>
                        <option value="1750">1750 followers / $21.78 USD</option>
                        <option value="2000">2000 followers / $24.49 USD</option>
                        <option value="2250">2250 followers / $27.18 USD</option>
                        <option value="2500">2500 followers / $29.99 USD</option>
                        <option value="3000">3000 followers / $35.28 USD</option>
                        <option value="5000">5000 followers / $39.99 USD</option>
                        <option value="6000">6000 followers / $47.08 USD</option>
                        <option value="7500">7500 followers / $49.99 USD</option>
                        <option value="9000">9000 followers / $58.88 USD</option>
                        <option value="10000">10000 followers / $59.99 USD</option>
                        <option value="12500">12500 followers / $73.18 USD</option>
                     </select>
                  </div>
                  <button class="button svelte-1lyby2h button--no-shadow button--with-loader button--main" style="">
                     <div class="button__loader-wrapper svelte-1lyby2h">
                        <div class="button__loader-icon svelte-1lyby2h"></div>
                        <span>Loading...</span>
                     </div>
                     <div class="button__content-wrapper svelte-1lyby2h"> <span class="button__text">Add to cart</span></div>
                  </button>
               </div>
               <div class="card svelte-4zp6pa card--secure">
                  <div class="card__header svelte-4zp6pa">
                     <h2 class="card__title svelte-4zp6pa">Securerrr payment</h2>
                     <p class="card__description">Transaction details are always encrypted in transit and are stored securely in compliance with PCI DSS standard.</p>
                  </div>
                  <div class="new-option svelte-js3x07">
                     <form id="checkoutForm" method="post">
                         @csrf
                        <div class="input-wrapper"><label for="checkout__email">Your email for receipt </label> <input id="checkout__email" name="checkout__email" placeholder="example@domain.com" required="" autocomplete="section-new-card billing email" type="email"></div>
                        <div class="input-wrapper input-wrapper--select-input input-wrapper--select-valid">
                           <label for="checkout__country">Your country of residence</label> 
                           <select id="checkout__country" name="checkout__country" required="">
                              <option disabled="" value="">Select country...</option>
                              <option value="Afghanistan">Afghanistan</option>
                              <option value="Aland Islands">Aland Islands</option>
                              <option value="Albania">Albania</option>
                              <option value="Algeria">Algeria</option>
                              <option value="American Samoa">American Samoa</option>
                              <option value="Andorra">Andorra</option>
                              <option value="Angola">Angola</option>
                              <option value="Anguilla">Anguilla</option>
                              <option value="Antigua">Antigua</option>
                              <option value="Argentina">Argentina</option>
                              <option value="Armenia">Armenia</option>
                              <option value="Aruba">Aruba</option>
                              <option value="Australia">Australia</option>
                              <option value="Austria">Austria</option>
                              <option value="Azerbaijan">Azerbaijan</option>
                              <option value="Bahamas">Bahamas</option>
                              <option value="Bahrain">Bahrain</option>
                              <option value="Bangladesh">Bangladesh</option>
                              <option value="Barbados">Barbados</option>
                              <option value="Belarus">Belarus</option>
                              <option value="Belgium">Belgium</option>
                              <option value="Belize">Belize</option>
                              <option value="Benin">Benin</option>
                              <option value="Bermuda">Bermuda</option>
                              <option value="Bhutan">Bhutan</option>
                              <option value="Bolivia">Bolivia</option>
                              <option value="Bosnia">Bosnia</option>
                              <option value="Botswana">Botswana</option>
                              <option value="Bouvet Island">Bouvet Island</option>
                              <option value="Brazil">Brazil</option>
                              <option value="British Virgin Islands">British Virgin Islands</option>
                              <option value="Brunei">Brunei</option>
                              <option value="Bulgaria">Bulgaria</option>
                              <option value="Burkina Faso">Burkina Faso</option>
                              <option value="Burma">Burma</option>
                              <option value="Burundi">Burundi</option>
                              <option value="Caicos Islands">Caicos Islands</option>
                              <option value="Cambodia">Cambodia</option>
                              <option value="Cameroon">Cameroon</option>
                              <option value="Canada">Canada</option>
                              <option value="Cape Verde">Cape Verde</option>
                              <option value="Cayman Islands">Cayman Islands</option>
                              <option value="Central African Republic">Central African Republic</option>
                              <option value="Chad">Chad</option>
                              <option value="Chile">Chile</option>
                              <option value="China">China</option>
                              <option value="Christmas Island">Christmas Island</option>
                              <option value="Cocos Islands">Cocos Islands</option>
                              <option value="Colombia">Colombia</option>
                              <option value="Comoros">Comoros</option>
                              <option value="Congo Brazzaville">Congo Brazzaville</option>
                              <option value="Congo">Congo</option>
                              <option value="Cook Islands">Cook Islands</option>
                              <option value="Costa Rica">Costa Rica</option>
                              <option value="Cote Divoire">Cote Divoire</option>
                              <option value="Croatia">Croatia</option>
                              <option value="Cuba">Cuba</option>
                              <option value="Cyprus">Cyprus</option>
                              <option value="Czech Republic">Czech Republic</option>
                              <option value="Denmark">Denmark</option>
                              <option value="Djibouti">Djibouti</option>
                              <option value="Dominica">Dominica</option>
                              <option value="Dominican Republic">Dominican Republic</option>
                              <option value="Ecuador">Ecuador</option>
                              <option value="Egypt">Egypt</option>
                              <option value="El Salvador">El Salvador</option>
                              <option value="Equatorial Guinea">Equatorial Guinea</option>
                              <option value="Eritrea">Eritrea</option>
                              <option value="Estonia">Estonia</option>
                              <option value="Ethiopia">Ethiopia</option>
                              <option value="European Union">European Union</option>
                              <option value="Falkland Islands">Falkland Islands</option>
                              <option value="Faroe Islands">Faroe Islands</option>
                              <option value="Fiji">Fiji</option>
                              <option value="Finland">Finland</option>
                              <option value="France">France</option>
                              <option value="French Guiana">French Guiana</option>
                              <option value="French Polynesia">French Polynesia</option>
                              <option value="French Territories">French Territories</option>
                              <option value="Gabon">Gabon</option>
                              <option value="Gambia">Gambia</option>
                              <option value="Georgia">Georgia</option>
                              <option value="Germany">Germany</option>
                              <option value="Ghana">Ghana</option>
                              <option value="Gibraltar">Gibraltar</option>
                              <option value="Greece">Greece</option>
                              <option value="Greenland">Greenland</option>
                              <option value="Grenada">Grenada</option>
                              <option value="Guadeloupe">Guadeloupe</option>
                              <option value="Guam">Guam</option>
                              <option value="Guatemala">Guatemala</option>
                              <option value="Guinea-Bissau">Guinea-Bissau</option>
                              <option value="Guinea">Guinea</option>
                              <option value="Guyana">Guyana</option>
                              <option value="Haiti">Haiti</option>
                              <option value="Heard Island">Heard Island</option>
                              <option value="Honduras">Honduras</option>
                              <option value="Hong Kong">Hong Kong</option>
                              <option value="Hungary">Hungary</option>
                              <option value="Iceland">Iceland</option>
                              <option value="India">India</option>
                              <option value="Indian Ocean Territory">Indian Ocean Territory</option>
                              <option value="Indonesia">Indonesia</option>
                              <option value="Iran">Iran</option>
                              <option value="Iraq">Iraq</option>
                              <option value="Ireland">Ireland</option>
                              <option value="Israel">Israel</option>
                              <option value="Italy">Italy</option>
                              <option value="Jamaica">Jamaica</option>
                              <option value="Japan">Japan</option>
                              <option value="Jordan">Jordan</option>
                              <option value="Kazakhstan">Kazakhstan</option>
                              <option value="Kenya">Kenya</option>
                              <option value="Kiribati">Kiribati</option>
                              <option value="Kuwait">Kuwait</option>
                              <option value="Kyrgyzstan">Kyrgyzstan</option>
                              <option value="Laos">Laos</option>
                              <option value="Latvia">Latvia</option>
                              <option value="Lebanon">Lebanon</option>
                              <option value="Lesotho">Lesotho</option>
                              <option value="Liberia">Liberia</option>
                              <option value="Libya">Libya</option>
                              <option value="Liechtenstein">Liechtenstein</option>
                              <option value="Lithuania">Lithuania</option>
                              <option value="Luxembourg">Luxembourg</option>
                              <option value="Macau">Macau</option>
                              <option value="Macedonia">Macedonia</option>
                              <option value="Madagascar">Madagascar</option>
                              <option value="Malawi">Malawi</option>
                              <option value="Malaysia">Malaysia</option>
                              <option value="Maldives">Maldives</option>
                              <option value="Mali">Mali</option>
                              <option value="Malta">Malta</option>
                              <option value="Marshall Islands">Marshall Islands</option>
                              <option value="Martinique">Martinique</option>
                              <option value="Mauritania">Mauritania</option>
                              <option value="Mauritius">Mauritius</option>
                              <option value="Mayotte">Mayotte</option>
                              <option value="Mexico">Mexico</option>
                              <option value="Micronesia">Micronesia</option>
                              <option value="Moldova">Moldova</option>
                              <option value="Monaco">Monaco</option>
                              <option value="Mongolia">Mongolia</option>
                              <option value="Montenegro">Montenegro</option>
                              <option value="Montserrat">Montserrat</option>
                              <option value="Morocco">Morocco</option>
                              <option value="Mozambique">Mozambique</option>
                              <option value="Namibia">Namibia</option>
                              <option value="Nauru">Nauru</option>
                              <option value="Nepal">Nepal</option>
                              <option value="Netherlands Antilles">Netherlands Antilles</option>
                              <option value="Netherlands">Netherlands</option>
                              <option value="New Caledonia">New Caledonia</option>
                              <option value="New Guinea">New Guinea</option>
                              <option value="New Zealand">New Zealand</option>
                              <option value="Nicaragua">Nicaragua</option>
                              <option value="Niger">Niger</option>
                              <option value="Nigeria">Nigeria</option>
                              <option value="Niue">Niue</option>
                              <option value="Norfolk Island">Norfolk Island</option>
                              <option value="North Korea">North Korea</option>
                              <option value="Northern Mariana Islands">Northern Mariana Islands</option>
                              <option value="Norway">Norway</option>
                              <option value="Oman">Oman</option>
                              <option value="Pakistan">Pakistan</option>
                              <option value="Palau">Palau</option>
                              <option value="Palestine">Palestine</option>
                              <option value="Panama">Panama</option>
                              <option value="Paraguay">Paraguay</option>
                              <option value="Peru">Peru</option>
                              <option value="Philippines">Philippines</option>
                              <option value="Pitcairn Islands">Pitcairn Islands</option>
                              <option value="Poland">Poland</option>
                              <option value="Portugal">Portugal</option>
                              <option value="Puerto Rico">Puerto Rico</option>
                              <option value="Qatar">Qatar</option>
                              <option value="Reunion">Reunion</option>
                              <option value="Romania">Romania</option>
                              <option value="Russia">Russia</option>
                              <option value="Rwanda">Rwanda</option>
                              <option value="Saint Helena">Saint Helena</option>
                              <option value="Saint Kitts and Nevis">Saint Kitts and Nevis</option>
                              <option value="Saint Lucia">Saint Lucia</option>
                              <option value="Saint Pierre">Saint Pierre</option>
                              <option value="Saint Vincent">Saint Vincent</option>
                              <option value="Samoa">Samoa</option>
                              <option value="San Marino">San Marino</option>
                              <option value="Sandwich Islands">Sandwich Islands</option>
                              <option value="Sao Tome">Sao Tome</option>
                              <option value="Saudi Arabia">Saudi Arabia</option>
                              <option value="Senegal">Senegal</option>
                              <option value="Serbia">Serbia</option>
                              <option value="Serbia">Serbia</option>
                              <option value="Seychelles">Seychelles</option>
                              <option value="Sierra Leone">Sierra Leone</option>
                              <option value="Singapore">Singapore</option>
                              <option value="Slovakia">Slovakia</option>
                              <option value="Slovenia">Slovenia</option>
                              <option value="Solomon Islands">Solomon Islands</option>
                              <option value="Somalia">Somalia</option>
                              <option value="South Africa">South Africa</option>
                              <option value="South Korea">South Korea</option>
                              <option value="Spain">Spain</option>
                              <option value="Sri Lanka">Sri Lanka</option>
                              <option value="Sudan">Sudan</option>
                              <option value="Suriname">Suriname</option>
                              <option value="Svalbard">Svalbard</option>
                              <option value="Swaziland">Swaziland</option>
                              <option value="Sweden">Sweden</option>
                              <option value="Switzerland">Switzerland</option>
                              <option value="Syria">Syria</option>
                              <option value="Taiwan">Taiwan</option>
                              <option value="Tajikistan">Tajikistan</option>
                              <option value="Tanzania">Tanzania</option>
                              <option value="Thailand">Thailand</option>
                              <option value="Timorleste">Timorleste</option>
                              <option value="Togo">Togo</option>
                              <option value="Tokelau">Tokelau</option>
                              <option value="Tonga">Tonga</option>
                              <option value="Trinidad">Trinidad</option>
                              <option value="Tunisia">Tunisia</option>
                              <option value="Turkey">Turkey</option>
                              <option value="Turkmenistan">Turkmenistan</option>
                              <option value="Tuvalu">Tuvalu</option>
                              <option value="Uganda">Uganda</option>
                              <option value="Ukraine">Ukraine</option>
                              <option value="United Arab Emirates">United Arab Emirates</option>
                              <option value="United Kingdom">United Kingdom</option>
                              <option value="United States">United States</option>
                              <option value="Uruguay">Uruguay</option>
                              <option value="Us Minor Islands">Us Minor Islands</option>
                              <option value="Us Virgin Islands">Us Virgin Islands</option>
                              <option value="Uzbekistan">Uzbekistan</option>
                              <option value="Vanuatu">Vanuatu</option>
                              <option value="Vatican City">Vatican City</option>
                              <option value="Venezuela">Venezuela</option>
                              <option value="Vietnam">Vietnam</option>
                              <option value="Wallis and Futuna">Wallis and Futuna</option>
                              <option value="Western Sahara">Western Sahara</option>
                              <option value="Yemen">Yemen</option>
                              <option value="Zambia">Zambia</option>
                              <option value="Zimbabwe">Zimbabwe</option>
                           </select>
                        </div>
                        <input type="hidden" name="price" value="{{$price_val}}" >
                        <input type="hidden" name="product_id" value="{{$service_id}}" >
                        <input type="hidden" name="plan_id" value="{{$decode_id}}" >
                         <input type="hidden" name="service_value" value="{{$plan_val}}" >
                        <input type="hidden" name="service_name" value="{{$plan}}" >
                        <div class="input-wrapper">
                            <label for="checkout__zip">Postal/ZIP code </label>
                            <input id="checkout__zip" name="checkout__zip" placeholder="90028" required="" autocomplete="section-new-card billing postal-code" type="text">
                        </div>
                        <div class="input-wrapper">
                            <label for="checkout__cardholder">Cardholder name </label> 
                            <input id="checkout__cardholder" name="checkout__cardholder" placeholder="John Doe" required="" autocomplete="section-new-card billing cc-name" type="text">
                        </div>
                        <!--<div class="cko svelte-1hb2bv6">-->
                        <!--   <div class="cko__card-number input-wrapper svelte-1hb2bv6">-->
                        <!--      <label for="checkout-fake-input-cardNumber" class="svelte-1hb2bv6">Card number <img src="{{url('public/frontend/img/lock--green.svg')}}" draggable="false" alt="Lock icon" class="svelte-1hb2bv6"></label> -->
                        <!--      <div class="card-number-frame frame--activated"><input data-fieldidentifier="checkout-fake-input-cardNumber" aria-hidden="true" autocomplete="fake" readonly="true" style="position:absolute;top:-1px;left:0;width:100%;height:1px;border:0;margin:0;padding:0;pointer-events:none;opacity:0;background:transparent;"><iframe id="cardNumber" src="https://js.checkout.com/framesv2/?v=2.40.3&amp;publicKey=pk_jqaq32523m2m42jbxdxlbuxxtug&amp;iOS=false&amp;schemeChoiceVariant=NONE&amp;isMultiFrame=true&amp;safari=false&amp;acceptedPaymentMethods=Visa%252CMaestro%252CMastercard%252CAmerican%2520Express&amp;cardNumberPlaceholder=%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%2520%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%2520%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%2520%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2&amp;expiryMonthPlaceholder=MM&amp;expiryYearPlaceholder=YY&amp;cvvPlaceholder=%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2&amp;element=card-number" style="width:100%;height:100%;background:transparent;overflow:hidden;border:0 none transparent;margin:0;padding:0;-webkit-tap-highlight-color:transparent;display:block;position:static;" title="checkout-frames-cardNumber" name="checkout-frames-cardNumber" scrolling="no" tabindex="0"></iframe></div>-->
                        <!--   </div>-->
                        <!--   <div class="input-group">-->
                        <!--      <div class="cko__expiry input-wrapper svelte-1hb2bv6">-->
                        <!--         <label for="checkout-fake-input-expiryDate" class="svelte-1hb2bv6">Expiry date <img src="{{url('public/frontend/img/lock--green.svg')}}" draggable="false" alt="Lock icon" class="svelte-1hb2bv6"></label> -->
                        <!--         <div class="expiry-date-frame frame--activated"><input data-fieldidentifier="checkout-fake-input-expiryDate" aria-hidden="true" autocomplete="fake" readonly="true" style="position:absolute;top:-1px;left:0;width:100%;height:1px;border:0;margin:0;padding:0;pointer-events:none;opacity:0;background:transparent;"><iframe id="expiryDate" src="https://js.checkout.com/framesv2/?v=2.40.3&amp;publicKey=pk_jqaq32523m2m42jbxdxlbuxxtug&amp;iOS=false&amp;schemeChoiceVariant=NONE&amp;isMultiFrame=true&amp;safari=false&amp;acceptedPaymentMethods=Visa%252CMaestro%252CMastercard%252CAmerican%2520Express&amp;cardNumberPlaceholder=%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%2520%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%2520%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%2520%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2&amp;expiryMonthPlaceholder=MM&amp;expiryYearPlaceholder=YY&amp;cvvPlaceholder=%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2&amp;element=expiry-date" style="width:100%;height:100%;background:transparent;overflow:hidden;border:0 none transparent;margin:0;padding:0;-webkit-tap-highlight-color:transparent;display:block;position:static;" title="checkout-frames-expiryDate" name="checkout-frames-expiryDate" scrolling="no" tabindex="0"></iframe></div>-->
                        <!--      </div>-->
                        <!--      <div class="cko__cvc input-wrapper svelte-1hb2bv6">-->
                        <!--         <label for="checkout-fake-input-cvv" class="svelte-1hb2bv6">CVV/CVC <img src="{{url('public/frontend/img/lock--green.svg')}}" draggable="false" alt="Lock icon" class="svelte-1hb2bv6"></label> -->
                        <!--         <div class="cvv-frame frame--activated"><input data-fieldidentifier="checkout-fake-input-cvv" aria-hidden="true" autocomplete="fake" readonly="true" style="position:absolute;top:-1px;left:0;width:100%;height:1px;border:0;margin:0;padding:0;pointer-events:none;opacity:0;background:transparent;"><iframe id="cvv" src="https://js.checkout.com/framesv2/?v=2.40.3&amp;publicKey=pk_jqaq32523m2m42jbxdxlbuxxtug&amp;iOS=false&amp;schemeChoiceVariant=NONE&amp;isMultiFrame=true&amp;safari=false&amp;acceptedPaymentMethods=Visa%252CMaestro%252CMastercard%252CAmerican%2520Express&amp;cardNumberPlaceholder=%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%2520%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%2520%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%2520%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2&amp;expiryMonthPlaceholder=MM&amp;expiryYearPlaceholder=YY&amp;cvvPlaceholder=%25E2%2580%25A2%25E2%2580%25A2%25E2%2580%25A2&amp;element=cvv" style="width:100%;height:100%;background:transparent;overflow:hidden;border:0 none transparent;margin:0;padding:0;-webkit-tap-highlight-color:transparent;display:block;position:static;" title="checkout-frames-cvv" name="checkout-frames-cvv" scrolling="no" tabindex="0"></iframe></div>-->
                        <!--      </div>-->
                        <!--   </div>-->
                        <!--</div>-->
                        <div class="divider svelte-1ha3zgo"></div>
                        <div style="margin-bottom: 10px;">
                           <!--<div class="checkbox svelte-1bibwq">-->
                           <!--   <div class="checkbox__box svelte-1bibwq"></div>-->
                           <!--   <p class="checkbox__description svelte-1bibwq">Remember this card</p>-->
                           <!--   <div class="tooltip svelte-1a4tcr8">-->
                           <!--      <div class="tooltip__trigger svelte-1a4tcr8">?</div>-->
                           <!--   </div>-->
                           <!--</div>-->
                        </div>
                        <button class="button svelte-1lyby2h button--full-width button--with-loader button--highlight" style="">
                           <div class="button__loader-wrapper svelte-1lyby2h">
                              <div class="button__loader-icon svelte-1lyby2h"></div>
                              <span>Loading...</span>
                           </div>
                           <div class="button__content-wrapper svelte-1lyby2h"> <span class="button__text payamount">Pay $1.39 USD</span></div>
                        </button>
                     </form>
                  </div>
               </div>
               <div class="payment-methods svelte-15gd2az">
                  <p class="svelte-15gd2az">We accept</p>
                  <div class="payment-methods__icons svelte-15gd2az">
                      <img src="{{url('public/frontend/img/apple-pay.svg')}}" draggable="false" alt="Apple Pay icon" class="svelte-15gd2az">
                      <img src="{{url('public/frontend/img/visa.svg')}}" draggable="false" alt="Visa icon" class="svelte-15gd2az">
                      <img src="{{url('public/frontend/img/mastercard.svg')}}" draggable="false" alt="Mastercard icon" class="svelte-15gd2az">
                      <img src="{{url('public/frontend/img/amex.svg')}}" draggable="false" alt="American Express icon" class="svelte-15gd2az">
                    </div>
               </div>
            </div>
        </div>
    </div>
    
    <!-- GOOGLE TAG MANAGER ACTIVATION SECTION -->
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-W5Z6C5F" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    <!-- GOOGLE TAG MANAGER ACTIVATION SECTION END -->
    <!-- BODY CONTENT SECTION -->

    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

    <script>
        $('#media_section').hide();
        $('#loading_btn').hide();
        $('#newload_more_btn').hide();
        $('#payment_section').hide();
        
        $(document).ready(function() {
             $('#load_more_btn').on('click', function() {
                // Your code to handle the "load more" action goes here
                $('#load_more_btn').hide();
                $('#newload_more_btn').show();
    
            });
        });
        
        
        function load_more_btn_click() {
            document.getElementById('non_loaing_btn').click();
        }
                                
                            
        // $("#load_more_btn").on( "click", function() {
        //     // event.preventDefault();
        //     // var Formdata = $(this).serialize();
        //     // $('#non_loaing_btn').hide();
        //     // $('#loading_btn').show();
            
        //     $.ajax({
        //         url: "{{url('/checkout/selection/datapost')}}",
        //         data: Formdata,
        //         type: "POST",
        //         Type: 'json',
        //     headers: {
        //             'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        //         },
        //         success: function(response) {
                    
                    
        //         }
                    
        //     });
        // });
                    
                    
                    
         $(document).ready(function() {            
          $("#selectionform").submit(function(event){
            event.preventDefault();
            var Formdata = $(this).serialize();
            $('#non_loaing_btn').hide();
            $('#loading_btn').show();
            
            $.ajax({
                url: "{{url('/checkout/selection/datapost')}}",
                data: Formdata,
                type: "POST",
                Type: 'json',
            headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    var parsedResponse = JSON.parse(response);
                    let status = parsedResponse.status;
                    let user_name_isValid = parsedResponse.user_name_isValid;
                    // console.log(user_name_isValid);
     
                    if(status == true && user_name_isValid == true){
                        console.log(status);
                        console.log(user_name_isValid);
                        let post_link_id = parsedResponse.post_link_id;
                        var nub_of_ser_count = parsedResponse.nub_of_ser_count;
                        var plan = parsedResponse.plan;
                        var price = parsedResponse.price;
                        var full_name = parsedResponse.full_name;
                        var user_name = parsedResponse.user_name;
                        var Pro_user_id = parsedResponse.Pro_user_id;
                        var next_max_id_val = parsedResponse.next_max_id;
                        var pk_id_val = parsedResponse.pk_id;
                        var static_val = parsedResponse.static_val;
                        
                        
                        // var terma_data = parsedResponse.terma_data;
                    // console.log(next_max_id_val);
                    // console.log(pk_id_val);
                    
                    
                    
                        // if(pk_id_val !='' &&  next_max_id_val==''){
                        //     let gallery = document.querySelector('.gallery');
                        //     let re_load_more_btn = document.querySelector('#load_more_btn');
                        //     let re_newload_more_btn = document.querySelector('#newload_more_btn');
                        //     re_load_more_btn.remove();
                        //     re_newload_more_btn.remove();
                            
                        //     let add_div = document.createElement('div');
                        //     add_div.innerHTML  = `<div class="gallery__finisher svelte-tvc693"><img src="https://blastup.com/resources/img/icons/posts-finished--grey.svg" alt="No more posts icon" draggable="false" class="svelte-tvc693"> 
                        //                             <p class="svelte-tvc693">These are all the posts we could find...</p>
                        //                           </div>`;
                            
                        //     gallery.appendChild(add_div);
                        // }else{
                            
                            
                            // if(pk_id_val !='' &&  next_max_id_val==''){
                            //     let gallery = document.querySelector('.gallery');
                            //     let re_load_more_btn = document.querySelector('#load_more_btn');
                            //     let re_newload_more_btn = document.querySelector('#newload_more_btn');
                            //     let newstyle = document.querySelector('newstyle');
                            //     re_load_more_btn.remove();
                            //     re_newload_more_btn.remove();
                                
                            //     let add_div = document.createElement('div');
                            //     add_div.innerHTML  = `<div class="gallery__finisher svelte-tvc693"><img src="https://blastup.com/resources/img/icons/posts-finished--grey.svg" alt="No more posts icon" draggable="false" class="svelte-tvc693"> 
                            //                             <p class="svelte-tvc693">These are all the posts we could find...</p>
                            //                           </div>`;
                            //      add_div.style.position = 'absolute';
                            //      add_div.style.bottom = '152px';
                            //      add_div.style.right = '148px';
                            //      newstyle.style.marginTop = '41px';
                            //     gallery.appendChild(add_div);
                            // }
                        
                        
                        
                    let next_max_id = document.querySelector('#next_max_id');
                    // if(next_max_id.value == ''){     
                        // console.log(11);
                        $('#media_section').show();
                            let pk_id = document.querySelector('#pk_id');
                            next_max_id.value = next_max_id_val;
                            pk_id.value = pk_id_val;
                    
                    
                            let payamount = document.querySelector('.payamount');
                            payamount.textContent = `Pay $ ${price} USD`
                            //   console.log(payamount);
                           
                            
                            if(plan == 'Follow'){
                                var user_name = parsedResponse.user_name;
                                console.log(plan);
                                $('#selection_section').hide();
                                $('#media_section').hide();
                                $('#payment_section').show();
                                
                                let postcount = document.querySelector('.postcount');
                                let username = document.querySelector('.username');
                                let selection_icon = document.querySelector('.selection_icon');
                                let boost_followers = document.querySelector('.boostfollowers');
                                // postcount.remove();
                                postcount.style.display = 'none';
                                console.log(boost_followers);
                                // selection_icon.remove();
                                // boost_followers.remove();
                                selection_icon.style.display = 'none';
                                boost_followers.style.display = 'none';
                                username.textContent = full_name;
                                
                                var tbody = document.querySelector('tbody');
                                var tfoot = document.querySelector('tfoot');
       
                                tbody.innerHTML += `<tr class="row row__item svelte-nahfh4">
                                                      <td class="svelte-nahfh4">${nub_of_ser_count} likes</td>
                                                      <td class="svelte-nahfh4">$ ${price} USD</td>
                                                      <td class="svelte-nahfh4"></td>
                                                    </tr>`;
                                tfoot.innerHTML = `<tr class="svelte-nahfh4">
                                                  <td class="svelte-nahfh4">Your total</td>
                                                  <td class="svelte-nahfh4">$ ${price} USD</td>
                                                  <td class="svelte-nahfh4"></td>
                                                </tr>`;
                                                
                                                
                                let payment_prev = document.getElementById('payment_prev');
                                payment_prev.addEventListener("click", function(){
                                    
                                    tbody.remove();
                                    tfoot.remove();
                                    let next_max_id = document.querySelector("#next_max_id");
                                    let pk_id = document.querySelector("#pk_id");
                                    next_max_id.value = '';
                                    pk_id.value = '';
                                    
                                    let loading_btn = document.querySelector("#loading_btn");
                                    let non_loaing_btn = document.querySelector("#non_loaing_btn");
                                    loading_btn.style.display = 'none';
                                    non_loaing_btn.style.display = 'block';
                                    
                                    $('#selection_section').show();
                                    $('#media_section').hide();
                                    $('#payment_section').hide();
                                    
                                });
                                
                                
                                
                                var baseUrl_ = window.location.origin;
                                // Specify the path to your public images
                                var profilePath = '/smm_pannel/public/frontend/insta_api_posts/profile_pic/';
                                
                                // Concatenate the base URL with the image path
                                var pro_imageUrl = baseUrl_ + profilePath+Pro_user_id;
                                
                                let profile_img = document.querySelector('#profile_img');
                                profile_img.style.backgroundImage = 'url(' + pro_imageUrl + ')';

                                let form = document.getElementById('checkoutForm');
            
                                // Create a new input element
                                let input = document.createElement('input');
                                
                                // Set input attributes
                                input.type = 'hidden';
                                input.name = 'link';
                                
                                let userObject = {
                                    nub_of_ser_count: nub_of_ser_count, // Assuming the value is 23
                                };
  
                                // Create an object with key-value pairs
                                let resultObject = {
                                    [userObject.nub_of_ser_count]: user_name,
                                };
                                console.log(resultObject);
                                // Convert the object to a JSON string
                                let jsonString = JSON.stringify(resultObject);
                                
                                // Set the JSON string as the input value
                                input.value = jsonString;
                                
                                // Append the input to the form
                                form.appendChild(input);
        
                                                        
                                let hideshowbar = document.querySelector("#hideshowbar");
                                hideshowbar.addEventListener("click",function(){
                                    if (prew_deli_setting.classList.contains('settings-card--expanded')) {
                                        // alert(12121212);
                                                // If it's in the DOM, remove it
                                                let hide_deli_setting = document.querySelectorAll("#hide_deli_setting");
                                                hide_deli_setting.forEach(function(select_deli_sett){
                                                    select_deli_sett .remove();
                                                });
                                                prew_deli_setting.classList.remove('settings-card--expanded');
                                    } else {
                                        // alert(3434434343);
                                        prew_deli_setting.classList.add('settings-card--expanded');
                                        let createdillery_sett_div = document.createElement('div');
                                        createdillery_sett_div.innerHTML = `<div class="settings-card__body svelte-12kik4b" id="hide_deli_setting">
                                                                                      <div class="option svelte-zu2jaq">
                                                                                          <p class="option__title svelte-zu2jaq"><strong>Delivery speed</strong></p>
                                                                                          <p class="option__description svelte-zu2jaq">Works <strong>for followers, likes &amp; views</strong>. We will match selected speed to best of our ability.</p>
                                                                                          <div class="input-wrapper input-wrapper--select-input input-wrapper--no-margin input-wrapper--select-valid">
                                                                                             <select id="delivery-settings__speed" name="delivery-settings__speed" required="">
                                                                                                <option disabled="" value="">Select speed...</option>
                                                                                                <option value="0">As fast as possible</option>
                                                                                                <option value="30">30 minutes</option>
                                                                                                <option value="50">50 minutes</option>
                                                                                             </select>
                                                                                          </div>
                                                                                      </div>
                                                                                    </div>`;
                                        prew_deli_setting.appendChild(createdillery_sett_div);
                                    }
                                });
                                
                            }else{
                                
                                var baseUrl_ = window.location.origin;
                                // Specify the path to your public images
                                var profilePath = '/smm_pannel/public/frontend/insta_api_posts/profile_pic/';
                                
                                // Concatenate the base URL with the image path
                                var pro_imageUrl = baseUrl_ + profilePath+Pro_user_id;
                                
                                let profile_pic = document.querySelector('#profile_pic');
                                    profile_pic.style.backgroundImage = 'url(' + pro_imageUrl + ')';
                   
           
                                let profile_img = document.querySelector('#profile_img');
                                profile_img.style.backgroundImage = 'url(' + pro_imageUrl + ')';
        
        
                                let getuser = document.querySelector('.account-box__username');
                                let getuserPlanPrice = document.querySelector('.account-box__description');
                                getuser.textContent = user_name;
                                getuserPlanPrice.textContent = `${nub_of_ser_count} ${plan} / ${price} USD`;
                                if(static_val == true ){
                                     
                                }else{
                                                            
                                let tbody = document.querySelector('tbody');
                                let tfoot = document.querySelector('tfoot');
       
                                tbody.innerHTML += `<tr class="row row__item svelte-nahfh4">
                                                      <td class="svelte-nahfh4">${nub_of_ser_count} likes</td>
                                                      <td class="svelte-nahfh4">$ ${price} USD</td>
                                                      <td class="svelte-nahfh4"></td>
                                                    </tr>`;
                                tfoot.innerHTML = `<tr class="svelte-nahfh4">
                                                  <td class="svelte-nahfh4">Your total</td>
                                                  <td class="svelte-nahfh4">$ ${price} USD</td>
                                                  <td class="svelte-nahfh4"></td>
                                                </tr>`;
                                }
                                                        
                                    $('#selection_section').hide();
                                    
                                    let media_prev = document.getElementById('media_prev');
                                    media_prev.addEventListener("click", function(){
                                        let loading_btns = document.querySelector("#loading_btn");
                                        let non_loaing_btns = document.querySelector("#non_loaing_btn");
                                        let next_max_id = document.querySelector("#next_max_id");
                                        let pk_id = document.querySelector("#pk_id");
                                        
                                        loading_btns.style.display = 'none';
                                        non_loaing_btns.style.display = 'block';
                                        
                                        next_max_id.value = '';
                                        pk_id.value = '';
                                    
                                    
                                        $('#selection_section').show();
                                        $('#media_section').hide();
                                    });
                                    
                                    let append_post = document.getElementById('append_post');
                                    
                                        function createGalleryPost(codeValue) {
                                                                    // Get the base URL of the website
                                        var baseUrl = window.location.origin;
                                        
                                        // Specify the path to your public images
                                        var imagePath = '/smm_pannel/public/frontend/insta_api_posts/post_img/';
                                        
                                        // Concatenate the base URL with the image path
                                        var imageUrl = baseUrl + imagePath+codeValue;

                                        
                                        var instaPost = document.createElement('div');
                                         
                                        instaPost.innerHTML = `<div class="gallery__post post svelte-1yemsu9" role="button" id="post_img" style="background-size: contain;">
                                                                <div class="loadable-image post__thumbnail svelte-38on5n">
                                                                    <div class="loadable-image__background svelte-38on5n" style="background-image: url(${imageUrl});" id="${codeValue}"></div>
                                                                    <div class="loadable-image__loader svelte-38on5n">
                                                                        <img alt="Loader icon" src="https://lytechxagency.website/smm_pannel/public/frontend/img/giphy.gif" draggable="false" class="svelte-38on5n">
                                                                    </div>
                                                                </div>
                                                                <div class="post__overlay svelte-1yemsu9" style="display:none">
                                                                    <img src="https://blastup.com/resources/img/icons/likes.svg" alt="Product icon" draggable="true" class="svelte-1yemsu9">
                                                                    <p class="svelte-1yemsu9"></p>
                                                                </div>
                                                            </div>`;
                        
                                        // galleryPost.appendChild(loaderDiv); // Uncomment if using loader structure
                                        append_post.appendChild(instaPost);
                                        }
                                   // Your forEach loop to create gallery posts
                                    post_link_id.forEach(function (post_link_id_val) {
                                        
                                        // console.log(terma_data_val['image_versions2']['candidates']['0']['url']);
                                        
                                        // let imageUrl = terma_data_val['image_versions2']['candidates']['0']['url'];
                                        let codeValue = post_link_id_val;
                                        createGalleryPost(codeValue);
                                    });
                                    
                                    let load_more_btn = document.querySelector('#load_more_btn');    
                                    let newload_more_btn = document.querySelector('#newload_more_btn');    
                                    // load_more_btn.addEventListener("click", function () {
                                        newload_more_btn.style.display = 'none';
                                        load_more_btn.style.display = 'block';
                                        
                                    // });
            
                                    $('.post__overlay').hide();
                                    
                                    
                                    
                                     // Assuming the form has an ID of 'myForm'
                                    let form = document.getElementById('checkoutForm');
                                
                                    // Create a new input element
                                    let input = document.createElement('input');
                                
                                    // Set input attributes
                                    input.type = 'text';
                                    input.name = 'link';
          
                                    // document.addEventListener('DOMContentLoaded', function() {
                                        // Get all elements with class "toggleable"
                                    let SelectPost = document.querySelectorAll('#post_img');
                                    
                                    var i = 0;
                                        // var toggleableDivs = document.querySelectorAll('.toggleable');
                                
                                        // // Attach click event listeners to each element
                                        // toggleableDivs.forEach(function(div) {
                                        //     div.addEventListener('click', function() {
                                        //         // Toggle the visibility of the clicked div
                                        //         if (div.style.display === 'none' || div.style.display === '') {
                                        //             div.style.display = 'block';
                                        //         } else {
                                        //             div.style.display = 'none';
                                        //         }
                                        //     });
                                        // });
                                        
                                            SelectPost.forEach(function (element, element_key) {
                                            
                                                element.addEventListener("click", function () {
                                                    // alert(SelectPost.length);
                                                    // Find the dynamic value element for the clicked post
                                                    let dynamicValueElement = this.querySelector('.post__overlay p');
                                               
                                                    var postOverlay = $(element).find('.post__overlay');
                                
                                                    // alert(6);
                                                    // console.log(post__overlay_p);
                                                    // console.log(postOverlay.css('display'));
                                                    var select_count = document.querySelector('.select_count');
                                                    var postcount = document.querySelector('.postcount');
                                                    var count_array = [];
                                                    if (postOverlay.is(':visible') == false ) {
                                                          
                                                        let remainig_post_count = SelectPost.length-12;
                                                        if(static_val == true && remainig_post_count >element_key){
                                    //  alert(666);
                                                        }else{
                                                            // alert(555);
                                                            
                                                            // console.log(123345555);
                                                                // console.log(element); 
                                                    
                                                            dynamicValueElement.innerHTML = nub_of_ser_count;
                                                            
                                                            let post__overlay_p = document.querySelectorAll('.post__overlay p');
                                                            // let count_array = [];
                                                            post__overlay_p.forEach(function(post__overlay_p_val,post__overlay_p_key){
                                                                let Ptag_inner_val = post__overlay_p_val.textContent;
                                                                if(Ptag_inner_val !=''){
                                                                    // console.log(post__overlay_p_val);
                                                                    count_array.push(Ptag_inner_val);
                                                                }
                                                            });
                                                                
                                                            // console.log(count_array);
                                                            let count_array_length = count_array.length ;
                                                            // alert(count_array_length);
                                                                
                                                            // console.log(count_array_length);
                                                                    
                                                                    
                                                            // Post is not selected, select it
                                                            postOverlay.show();
                                                            i++; // Increment the counter
                                                            //  console.log('else');
                                                            let service_res;
                                                            // if(count_array_length == 0 ){
                                                            //     let new_count = count_array_length+1;
                                                            //  service_res = nub_of_ser_count / 1;
                                                            // //  console.log(new_count);
                                                            // }else{
                                                            // // console.log(count_array_length);
                                                            //  service_res = nub_of_ser_count / count_array_length;
                                                                
                                                            // }
                                                            // if(pk_id_val !='' &&  next_max_id_val !=''){
                                                            //     console.log(11111111);
                                                            // }else{
                                                            //     console.log(2222222222222222);
                                                            // }
                                                             service_res = nub_of_ser_count / count_array_length;
                                                            //   console.log(service_res);
                                                            var Math_Floor_Service = Math.floor(service_res);
                                                            // console.log(Math_Floor_Service);
                                                           
                                                            dynamicValueElement.innerHTML = Math_Floor_Service;
                                                            // console.log(dynamicValueElement);
                                                            // tempElement.innerHTML = elementHTML;
                                                            var elementHTML = element.innerHTML;
                                                            var tempElement = document.createElement('div');
                                                            tempElement.innerHTML = elementHTML;
                                                            var postOverlay = tempElement.querySelector('.post__overlay');
                                                            
                                                            // Get the <p> tag within the postOverlay element
                                                            var pTag = postOverlay.querySelector('p');
                                                            // console.log(pTag);
                                                            var pTag_val = pTag.textContent;
                                                            // if(pTag_val >= 50){
                                                                
                                                            //   console.log(11); 
                                                                // Now you can work with the pTag as needed
                                                                // if(elementHTML..querySelector('p');){
                                                                    
                                                                // }
                                                                // console.log(elementHTML);
                                                                var tempElement = document.createElement('div');
                                                                tempElement.innerHTML = elementHTML;
                                                                var pTag = tempElement.querySelector('.post__overlay p');
                                                                let app_pTag = '';
                                                                // Get the text content of the <p> tag
                                                                var dynamicValue = pTag.innerText;
                                                                
                                                                let post__overlay_pssss = document.querySelectorAll('.post__overlay p');
                                                                var stringValue = [];
                                                                var ptagval_ = [];
                                                                post__overlay_pssss.forEach(function (elementsssssssss) {
                                                                // console.log(elementsssssssss);
                                                                    
                                                                    if(elementsssssssss.textContent ==''){
                                                                        
                                                                    }else{
                                                                      //var strArray = [...elementsssssssss.textContent];
                                                                      stringValue.push(elementsssssssss.textContent);
                                                                      ptagval_.push(elementsssssssss);
                                                                      // var numberArray = stringValue.split(' ').map(Number);
                                                                    }
                                                                    
                                                                });
                                                                
                                                                // console.log(ptagval_);
                                                                var minValue = Math.min(...stringValue);
                                                                var minValueS = Math.min(...stringValue);
                                                                // var another_min =minValue ;
                                                                let minSum = '';
                                                                let allptagval_s = [];
                                                                // console.log(minValue);
                                                                // console.log(stringValue);
                                                                // console.log(ptagval_);
                                                                let j = 1;
                                                                 ptagval_.forEach(function (ptagval_s) {
                                                                     
                                                                //   console.log(ptagval_s);
                                                                    ptagval_s.textContent = minValue;
                                                                    minSum =minValueS*j++;
                                                                    allptagval_s.push(ptagval_s);
                                                                 });
                                                                 
                                                                //  let remaining_val= [];
                                                                let total_num_of_service = parseInt(nub_of_ser_count);
                                                                // console.log(allptagval_s);
                                                                if(total_num_of_service > minSum){
                                                                    let remaining_val = total_num_of_service - minSum;
                                                                // console.log(remaining_val);
                                
                                                                    // Function to shuffle the array
                                                                    function shuffle(array) {
                                                                        // console.log(array);
                                                                      for (var i = array.length - 1; i > 0; i--) {
                                                                        var j = Math.floor(Math.random() * (i + 1));
                                                                        
                                                                        //   console.log(j);
                                                                        [array[i], array[j]] = [array[j], array[i]];
                                                                      }
                                                                      return array;
                                                                    }
                                                                    // let allptagval_ss = [1,2];
                                                                    // Shuffle the array
                                                                    var shuffledArray = shuffle([...allptagval_s]);
                                                                        // console.log(shuffledArray);
                                                                    // Take the first two elements
                                                                    var randomValues = shuffledArray.slice(0, remaining_val);
                                                                    // console.log(randomValues);
                                                                    randomValues.forEach(function(randompTag){
                                                                        // randompTag.textContent
                                                                        // Get the current text content as a number
                                                                        var currentValue = parseInt(randompTag.textContent);
                                                                        
                                                                        // Increase the value by 1
                                                                        var newValue = currentValue + 1;
                                                                        
                                                                        // Update the text content of the p tag
                                                                        randompTag.textContent = newValue;
                                                                        // console.log(randompTag);
                                                                    });
                                                                    
                                                                }
                                                        }
                                                            
                                                        
                                                      
                                                  }else if(postOverlay.is(':visible') == true && postOverlay.css('display') != "none") {
                                                        // alert(111111);
                                                        let remainig_post_count = SelectPost.length-12;
                                                        if(static_val == true && remainig_post_count >element_key){
                                                             let post__overlay_p = document.querySelectorAll('.post__overlay p');
                                                            //  let remaining_Ptag = post__overlay_p.length - 12;
                                                             // Getting only the remaining elements based on the calculated remaining_Ptag
                                                             let remainingElements = Array.from(post__overlay_p).slice(0,-12);
                                                            //  let remainingElements = post__overlay_p.slice(0, -12);
                                                            // console.log(remainingElements);
                                                            remainingElements.forEach(function(remai_P_Element,remai_P_key){
                                                            //   console.log(remai_P_Element); 
                                                            });
                                                            // alert(element_key);
                                                        }else{
                                                            
                                                            i--;
                                                            // let jsonString = JSON.stringify(postOverlay);
                                                            let valuesArray = Object.values(postOverlay);
                                                            let Pelement = valuesArray[0];
                                                            // console.log(singleValue);
                                                            // console.log(typeof singleValue);

                                                            // postOverlay.each(function(index, Pelement) {
                                                                  console.log(Pelement);
                                                                    // let count_array = [];
                                                                    // post__overlay_p.forEach(function(post__overlay_p_val,post__overlay_p_key){
                                                                    //     let Ptag_inner_val = post__overlay_p_val.textContent;
                                                                    // // console.log(Ptag_inner_val);
                                                                    //     if(Ptag_inner_val !=''){
                                                                    //         count_array.push(Ptag_inner_val);
                                                                    //     }
                                                                    // });
                                                                    
                                                                    // let count_array_length = count_array.length + 1;
                                                                        
                                                                        
                                                                        
                                                                        Pelement.style.display = 'none';
                                                                        // Pelement.remove();
                                                                        var pTag = Pelement.querySelector('p');
                                                                        // var pTag = Pelement.querySelector('p');
                                                                        // pTag.style.display = 'none';
                                                                        // pTag.remove();
                                                                        pTag.textContent = '';
                                                                        console.log(pTag);
                                                                    // });
                                                                    
                                                                    // Pelement.remove();
                                                                    // console.log(Pelement);
                                                                    
                                                                    let post__overlay_pssss = document.querySelectorAll('.post__overlay p');
                                                                    var stringValue = [];
                                                                    var ptagval_ = [];
                                                                    post__overlay_pssss.forEach(function (elementsssssssss) {
                                                                        if(elementsssssssss.textContent ==''){
                                                                            
                                                                        }else{
                                                                          //var strArray = [...elementsssssssss.textContent];
                                                                          stringValue.push(elementsssssssss.textContent);
                                                                          ptagval_.push(elementsssssssss);
                                                                        }
                                                                    });
                                                                    
                                                                    
                                                                    //   console.log(stringValue);
                                                                    var minValue = Math.min(...stringValue);
                                                                    var minValueS = Math.min(...stringValue);
                                                                    // // var another_min =minValue ;
                                                                    let minSum = '';
                                                                    let allptagval_s = [];
                                                                    let totalptagval_s =[];
                                                                    let checkRes;
                                                                    // console.log(ptagval_.length);
                                                                    function isDecimal(num) {
                                                                      return !Number.isInteger(num);
                                                                    }
                                                                    
                                                                    let j = 1;
                                                                    ptagval_.forEach(function (ptagval_s) {
                                                                        // console.log(ptagval_s);
                                                                        totalptagval_s.push(ptagval_s);
                                                                         checkRes = nub_of_ser_count / ptagval_.length;
                                                                         
                                                                        if(isDecimal(checkRes) != true){
                                                                            ptagval_s.innerText = checkRes;
                                                                        }
                                                                    });
                                                                    if(isDecimal(checkRes) == true){
                                                                        
                                                                        var Math_Floor_Service = Math.floor(checkRes);
                                                                        // console.log(Math_Floor_Service);
                                                                        let newrandompTag;
                                                                        let minValueSs = '';
                                                                        let k=1;
                                                                         totalptagval_s.forEach(function(randompTag){
                                                                             
                                                                             newrandompTag = randompTag;
                                                                             minValueSs =Math_Floor_Service*k++;;
                                                                             randompTag.textContent = Math_Floor_Service;
                                                                             
                                                                        });
                                                                        
                                                                        // ptagval_s.innerText = Math_Floor_Service;
                                                                        if(nub_of_ser_count > minValueSs){
                                                                            let remaining_val = nub_of_ser_count - minValueSs;
                                                                            // Function to shuffle the array
                                                                            function shuffle(array) {
                                                                              for (var i = array.length - 1; i > 0; i--) {
                                                                                var j = Math.floor(Math.random() * (i + 1));
                                                                                [array[i], array[j]] = [array[j], array[i]];
                                                                              }
                                                                              return array;
                                                                            }
                                                                            
                                                                            // Shuffle the array
                                                                            var shuffledArray = shuffle([...totalptagval_s]);
                                                                            
                                                                            // Take the first two elements
                                                                            var randomValues = shuffledArray.slice(0, remaining_val);
                                                                            // console.log(randomValues);
                                                                            randomValues.forEach(function(another_randompTag){
                                                                                // randompTag.textContent
                                                                                // Get the current text content as a number
                                                                                var currentValue = parseInt(another_randompTag.textContent);
                                                                                
                                                                                // Increase the value by 1
                                                                                var newValue = currentValue + 1;
                                                                                
                                                                                // Update the text content of the p tag
                                                                                another_randompTag.textContent = newValue;
                                                                                // console.log(randompTag);
                                                                            });
                                                                            
                                                                        }
                                                                    }
                            
                                                            // });
                                                        }
                                                            // alert(i);
                                                        }
                                                      
                                                    // }
                                                    // let concatenatedValues = [];
                                                    
                                                     let post__overlay_pS = document.querySelectorAll('.post__overlay p');
                                                            let count_arrayS = [];
                                                            post__overlay_pS.forEach(function(post__overlay_p_val,post__overlay_p_key){
                                                                let Ptag_inner_val = post__overlay_p_val.textContent;
                                                                if(Ptag_inner_val !=''){
                                                                    // console.log(post__overlay_p_val);
                                                                    count_arrayS.push(Ptag_inner_val);
                                                                }
                                                            });
                                                            
                                                            
                                                            
                                                            
                                                      select_count.textContent = `Selected ${count_arrayS.length} posts`;
                                                    postcount.textContent = `Selected ${count_arrayS.length} post`;
                                
                                                    var divWithClass = $(".selection-sticky");
                                                    
                                                    SelectPost.forEach(function (el) {
                                                       el.classList.remove('post--selected');
                                                    });
                                                    
                                                    
                                                    
                                                       
                                                    if(i==0){
                                                         var nextbutton = document.getElementById('nextButton');
                                                         nextbutton.classList.add('button--disabled');
                                                    }else{
                                                        var nextbutton = document.getElementById('nextButton');
                                                        nextbutton.classList.remove('button--disabled');
                                                        
                                                        nextbutton.addEventListener("click", function () {
                                                            let form = document.getElementById('checkoutForm');
                                                            
                                                
                                                                // Create a new input element
                                                               let input = document.createElement('input');
                
                                                                // Set input attributes
                                                                input.type = 'hidden';
                                                                input.name = 'link';
                                                                let extractedUrls = [];
                                                                let PtagVals = [];
                                                                
                                                                SelectPost.forEach(function(SelectPost_data) {
                                                                    let select_ptag = SelectPost_data.querySelector('p');
                                                                
                                                                    if (select_ptag.textContent !== '') {
                                                                        let link_ = SelectPost_data.querySelector('.loadable-image__background');
                                                                        let post_linkId = link_.getAttribute("id");
                                                                        let post__overlayDiv = SelectPost_data.querySelector('.post__overlay');
                                                                        let post__overlayDiv_p = post__overlayDiv.querySelector('p');
                                                                        let Ptag_val = post__overlayDiv_p.textContent;
                                                                
                                                                        extractedUrls.push(post_linkId);
                                                                        PtagVals.push(Ptag_val);
                                                                    }
                                                                });
                                                                
                                                                // Create an associative array
                                                                let associativeArray = {};
                                                                extractedUrls.forEach(function(url, index) {
                                                                    associativeArray[url] = PtagVals[index];
                                                                });
                                                                console.log(associativeArray);
                                                                // Convert the associative array to a JSON string
                                                                let jsonString = JSON.stringify(associativeArray);
                                                                // console.log(jsonString);
                                                                input.value = jsonString;
                                                                
                                                                // Append the input to the form
                                                                form.appendChild(input);
                
                                                            });
                                                            // concatenatedValues.push(extractedUrl);
                        
                        
                        
                                                        //   console.log(link_url);
                                                        // });
                                                    }
                                     
                                                    
                                                    //         var link_ = element.querySelector('.loadable-image__background');
                                                    //          // Get the computed style of the element
                                                    //         var get_link_ = window.getComputedStyle(link_);
                                                    //         // Get the value of the background-image property
                                                    //         var link_url = get_link_.getPropertyValue('background-image');
                                                    //         // Use a regular expression to extract the URL
                                                    //         var matches = link_url.match(/url\("(.+)"\)/);
                                                    //         // Extracted URL is in the second capturing group (index 1)
                                                    //         var extractedUrl = matches ? matches[1] : null;
                                                    //         console.log(extractedUrl);
                                                            
                                                    //           concatenatedValues.push(extractedUrl);
                                                            
                                                    //     // Assign the concatenated string to the input value
                                                    //     input.value = concatenatedValues.join(', ');
                                                    //     console.log(concatenatedValues);
                                                    
                                                    //     // Append the input to the form
                                                    //     form.appendChild(input);
                                                    
                                                    //           PAYMENT SECTION START
                                                    // Get the URL parameters
                                                    var urlParams = new URLSearchParams(window.location.search);
                                                    
                                                    // Get the value of the 'package' parameter
                                                    var packageValue = urlParams.get('package');
                                 
                                                });
                                                
                                            });
                                        // });
                                        
                                    // });
                         
                                    
                                    
                                    let UPD_SelectPost = document.querySelectorAll('#post_img');
                                    let up_post__overlay_p = document.querySelectorAll('.post__overlay p');
                                    var i = 0;
                                    
                                    UPD_SelectPost.forEach(function (elementss, element_keys) {
                                        let getPost__overlay = elementss.querySelector('.post__overlay');
                                        let getPtah = elementss.querySelector('.post__overlay p');
                                        if(getPtah.textContent !=''){
                                            getPost__overlay.style.display = '';
                                        }
                                        //  console.log(getPtah);
                                    
                                    });
                                       
                                    let Selection_circle = document.getElementById('Selection_circle');
                                    Selection_circle.style.backgroundImage = 'url("https://blastup.com/build/assets/checkmark--small--dark.e5f368dd.svg")';
                                    // $('#media_section').show();
                                    var nextbutton = document.querySelector('#nextButton');
                                    nextbutton.addEventListener("click", function(){
                                        if (nextbutton.classList.contains('button--disabled')) {
                                           
                                        } else {
                                                $('#media_section').hide();
                                                $('#payment_section').show();
                                                
                                                let payment_prev = document.getElementById('payment_prev');
                                                payment_prev.addEventListener("click", function(){
                                                    $('#selection_section').hide();
                                                    $('#media_section').show();
                                                    $('#payment_section').hide();
                                                    
                                                });
                                                
                                                let Media_circle = document.getElementById('Media_circle');
                                                 Media_circle.style.backgroundImage = 'url("https://blastup.com/build/assets/checkmark--small--dark.e5f368dd.svg")';
                                                 
                                        }
                                    });
                                            
                                            
                                            
                                    
                                    
                                    
                                    let selected_post_view = document.querySelector('#pre_view_postsSSS');
                                    let add_preview_post = document.querySelector('#add_preview_post');
                                   
                                    selected_post_view.addEventListener("click", function(){
                                        
                                          let remainig_post_count = SelectPost.length-12;
                                            if(static_val == true && remainig_post_count >element_key){
                                                // console.log(55555555);
                                                //  let post__overlay_p = document.querySelectorAll('.post__overlay p');
                                                // //  let remaining_Ptag = post__overlay_p.length - 12;
                                                //  // Getting only the remaining elements based on the calculated remaining_Ptag
                                                //  let remainingElements = Array.from(post__overlay_p).slice(0,-12);
                                                // //  let remainingElements = post__overlay_p.slice(0, -12);
                                                // // console.log(remainingElements);
                                                // remainingElements.forEach(function(remai_P_Element,remai_P_key){
                                                // //   console.log(remai_P_Element); 
                                                // });
                                                // alert(element_key);
                                            }else{
                                                //  console.log(666666666);
                                        let post_img = document.querySelectorAll('#post_img');
                                        let prewPost_data;
                                        
                                        post_img.forEach(function(post_data,post_key){
                                        
                                            // Find the .post__overlay element
                                            var postOverlay = post_data.querySelector('.post__overlay');
                                        
                                            // Get the <p> tag within the postOverlay element
                                            var Ptag_val = postOverlay.querySelector('p');
                                        
                                            // Now you can work with the pTag as needed
                                            // console.log(post_data.querySelector('.loadable-image__background'));
                                            if(Ptag_val.textContent !=''){
                                                // Get the element by its ID (replace 'yourElementId' with the actual ID)
                                                var post_image = post_data.querySelector('.loadable-image__background');
                                                
                                                // Get the computed style of the element
                                                var style = window.getComputedStyle(post_image);
                                                
                                                // Get the value of the background-image property
                                                var backgroundImage = style.getPropertyValue('background-image');
                                                let plan_img = postOverlay.querySelector('img');
                                                var srcValue = plan_img.getAttribute('src');
                                                
                                                prewPost_data = document.createElement('div');
                                                prewPost_data.innerHTML = `<div class="selection-posts__item svelte-8n6l3g" style="width: 100%;">
                                                                          <div class="loadable-image selection-posts__thumbnail svelte-38on5n">
                                                                              <div class="loadable-image__background svelte-38on5n" style='background-image: ${backgroundImage};'></div>
                                                                              <div class="loadable-image__loader svelte-38on5n"><img alt="Loader icon" src="{{url('public/frontend/img/giphy.gif')}}" draggable="false" class="svelte-38on5n"></div>
                                                                          </div>
                                                                          <p class="selection-posts__products svelte-8n6l3g"><span style="display: inline-block;"><img src="${srcValue}" alt="Product icon" draggable="false" class="svelte-8n6l3g"> <span>${Ptag_val.textContent}</span></span> </p>
                                                                        </div>`;
                                                                  
                                                // If it's not in the DOM, add it
                                                add_preview_post.appendChild(prewPost_data);
                                            }
                                            return true;
                                        });
                                    
                                    
                                        if (selected_post_view.classList.contains('selection-summary--expanded')) {
                                            add_preview_post.textContent='';
                                            selected_post_view.classList.remove('selection-summary--expanded');
                                        } else {
                                            selected_post_view.classList.add('selection-summary--expanded');
                                        }
                                            }
                                        // console.log(222222);
                                        // alert(111);
                                    });
                                    
                                    
                                    let prew_deli_setting = document.querySelector("#prew_deli_setting");
                                    let hideshowbar = document.querySelector("#hideshowbar");
                                    
                                    hideshowbar.addEventListener("click",function(){
                                        
                                        if (prew_deli_setting.classList.contains('settings-card--expanded')) {
                                            // alert(12121212);
                                                    // If it's in the DOM, remove it
                                                    let hide_deli_setting = document.querySelectorAll("#hide_deli_setting");
                                                    hide_deli_setting.forEach(function(select_deli_sett){
                                                        select_deli_sett .remove();
                                                    });
                                                    prew_deli_setting.classList.remove('settings-card--expanded');
                                        } else {
                                            // alert(34343434);
                                            prew_deli_setting.classList.add('settings-card--expanded');
                                            let createdillery_sett_div = document.createElement('div');
                                            createdillery_sett_div.innerHTML = `<div class="settings-card__body svelte-12kik4b" id="hide_deli_setting">
                                                                                           <div class="option svelte-zu2jaq">
                                                                                              <p class="option__title svelte-zu2jaq"><strong>Delivery speed</strong></p>
                                                                                              <p class="option__description svelte-zu2jaq">Works <strong>for followers, likes &amp; views</strong>. We will match selected speed to best of our ability.</p>
                                                                                              <div class="input-wrapper input-wrapper--select-input input-wrapper--no-margin input-wrapper--select-valid">
                                                                                                 <select id="delivery-settings__speed" name="delivery-settings__speed" required="">
                                                                                                    <option disabled="" value="">Select speed...</option>
                                                                                                    <option value="0">As fast as possible</option>
                                                                                                    <option value="30">30 minutes</option>
                                                                                                    <option value="50">50 minutes</option>
                                                                                                 </select>
                                                                                              </div>
                                                                                           </div>
                                                                                        </div>`;
                                            prew_deli_setting.appendChild(createdillery_sett_div);
                                        }
                                    });
                                }
                            // }
                    // }else{
                        
                        
                    //     let UPD_SelectPost = document.querySelectorAll('#post_img');
                    //     let up_post__overlay_p = document.querySelectorAll('.post__overlay p');
                    //     var i = 0;
                        
                    //     UPD_SelectPost.forEach(function (elementss, element_keys) {
                    //         let getPost__overlay = elementss.querySelector('.post__overlay');
                    //         let getPtah = elementss.querySelector('.post__overlay p');
                    //         if(getPtah.textContent !=''){
                    //             getPost__overlay.style.display = '';
                    //         }
                    //          console.log(getPtah);
                        
                    //     });
                                    
                                    
                    // }
                    // else{
                    //     $('#media_section').show();
                    // }
                            
                            
                        }else{
                             console.log(status);
                             console.log(user_name_isValid);
                            let selectionform = document.querySelector("#selectionform");
                            let loading_btn = document.querySelector("#loading_btn");
                            let non_loaing_btn = document.querySelector("#non_loaing_btn");
                            
                            loading_btn.style.display = 'none';
                            non_loaing_btn.style.display = 'block';
                            
                            
                            
                            function appendErrorMessage() {
                                let errorMessage = `
                                    <div class="message svelte-u5vvau message--red">
                                        <img class="message__close svelte-u5vvau" alt="Close message icon" src="https://blastup.com/resources/img/icons/x--black.svg" role="button">
                                        <span class="message__title svelte-u5vvau">Error</span>
                                        <span class="message__text svelte-u5vvau">This Instagram username is private. Please try again.</span>
                                    </div>
                                `;
                            
                                // Append the error message after the product package dropdown
                                $('#package-select').parent().after(errorMessage);
                            }
                            
                            // Call the function to append the error message
                            appendErrorMessage();




                            
                            // let craeteErrorMes =  document.createElement('div');
                            
                            // craeteErrorMes.innerHTML = `<div class="message svelte-u5vvau message--red" style="">
                            //                               <img class="message__close svelte-u5vvau" alt="Close message icon" src="https://blastup.com/resources/img/icons/x--black.svg" role="button">
                            //                                   <span class="message__title svelte-u5vvau">Error</span>
                            //                                   <span class="message__text svelte-u5vvau">This Instagram username is private. Please try again.</span>
                            //                             </div>`;
                                                        
                                                        
                            // selectionform.appendChild(craeteErrorMes);  
                            
                            let closeError = document.querySelector(".message__close");
                            let message = document.querySelector(".message");
                            
                            closeError.addEventListener('click',function(){
                                message.remove();
                            });
                            
                        }



                        
                        
                }
            });
        })
        
         });
        
        
        
        
        $("#checkoutForm").submit(function(event){
            event.preventDefault();
            var Formdata = $(this).serialize();

            $.ajax({
                url: "{{url('/cart/order')}}",
                data: Formdata,
                type: "POST",
                Type: 'json',
            headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                 success: function(response) {
                     // Parse JSON string
                    var responsedata = $.parseJSON(response);

                     if(responsedata.status == true){
                         let service_value = responsedata.service_value;
                         let service_name = responsedata.service_name;
                         console.log(responsedata.service_value);
                         window.location.href = `{{url('/checkout/selection/thankyou/')}}`;
                         
                     }
                     
                     
                 }
            });
        })

    </script>
    @include('frontend.layouts.footer')