<?php
    use Illuminate\Support\Facades\Route;
    use Illuminate\Support\Facades\Artisan;
    use App\Http\Controllers\AdminController;
    use App\Http\Controllers\FrontendController;
    use App\Http\Controllers\Blogcontroller;
    use App\Http\Controllers\Auth\LoginController;
    use App\Http\Controllers\MessageController;
    use App\Http\Controllers\CartController;
    use App\Http\Controllers\WishlistController;
    use App\Http\Controllers\OrderController;
    use App\Http\Controllers\ProductReviewController;
    use App\Http\Controllers\PostCommentController;
    use App\Http\Controllers\ProductOrdercontroller;
    use App\Http\Controllers\CouponController;
    use App\Http\Controllers\PayPalController;
    use App\Http\Controllers\NotificationController;
    use App\Http\Controllers\HomeController;
    use App\Http\Controllers\PlanController;
    use App\Http\Controllers\ProductController;
    use App\Http\Controllers\ProviderController;
    use App\Http\Controllers\CategoryController;
    use App\Http\Controllers\VerifyController;
    use App\Http\Controllers\WalletController;
    use App\Http\Controllers\ForgetPasswordController;
    use \UniSharp\LaravelFilemanager\Lfm;

    /*
    |--------------------------------------------------------------------------
    | Web Routes
    |--------------------------------------------------------------------------
    |
    | Here is where you can register web routes for your application. These
    | routes are loaded by the RouteServiceProvider within a group which
    | contains the "web" middleware group. Now create something great!
    |
    */

    // CACHE CLEAR ROUTE
    Route::get('cache-clear', function () {
        Artisan::call('optimize:clear');
        request()->session()->flash('success', 'Successfully cache cleared.');
        return redirect()->back();
    })->name('cache.clear');


    // STORAGE LINKED ROUTE
    Route::get('storage-link',[AdminController::class,'storageLink'])->name('storage.link');


    Auth::routes(['register' => false]);
    Route::get('user/login', [FrontendController::class, 'login'])->name('login.form');
    Route::post('user/login', [FrontendController::class, 'loginSubmit'])->name('login.submit');
    Route::post('user/login', [VerifyController::class, 'loginSubmit'])->name('login.submit');
    Route::post('user/verify', [VerifyController::class, 'verifyemailcode'])->name('login.verify');
    Route::get('user/logininfo', [VerifyController::class, 'logininfo'])->name('login.logininfo');
    Route::post('user/logout', [VerifyController::class, 'logout'])->name('login.logout');
    // Route::get('user/logout', [FrontendController::class, 'logout'])->name('user.logout');

    Route::get('user/register', [FrontendController::class, 'register'])->name('register.form');
    Route::post('user/register', [FrontendController::class, 'registerSubmit'])->name('register.submit');
    // Reset password
    Route::post('password-reset', [FrontendController::class, 'showResetForm'])->name('password.reset');
    Route::patch('pass-reset', [FrontendController::class, 'ResetForm'])->name('password.resett');
     // Socialite
    // Route::get('login/{provider}/', [LoginController::class, 'redirect'])->name('login.redirect');
    // Route::get('login/{provider}/callback/', [LoginController::class, 'Callback'])->name('login.callback');

    // Routes
    // Route::get('login/{provider}/', [LoginController::class, 'redirect'])->name('login.redirect');
    // Route::get('login/{provider}/callback/', [LoginController::class, 'Callback'])->name('login.callback');

    
    
    // Route::get('/auth/google/callback', [LoginController::class, 'Callback'])->name('login.callback');

    Route::get('/', [FrontendController::class, 'home'])->name('home');
    
    
    // login with google

    Route::get('/login/google', 'FrontendController@redirectToGoogle')->name('login.google');
    Route::get('/auth/google/callback', 'FrontendController@handleGoogleCallback');


    // wallate
    Route::get('/wallet', [WalletController::class, 'show'])->name('wallet.show');

    // Route::middleware(['auth'])->group(function () {
    //     Route::get('/wallet', [WalletController::class, 'show'])->name('wallet.show');
    //     Route::post('/wallet/deposit', [WalletController::class, 'deposit'])->name('wallet.deposit');
    //     Route::post('/wallet/withdraw', [WalletController::class, 'withdraw'])->name('wallet.withdraw');
    //     // Add more routes for transactions, transaction history, etc.
    // });


    // Frontend Routes
    Route::get('/home', [FrontendController::class, 'index']);
    Route::get('/about-us', [FrontendController::class, 'aboutUs'])->name('about-us');
    Route::get('/contact', [FrontendController::class, 'contact'])->name('contact');
    Route::post('/contact/message', [MessageController::class, 'store'])->name('contact.store');
    Route::get('product-detail/{slug}', [FrontendController::class, 'productDetail'])->name('product-detail');
    Route::post('/product/search', [FrontendController::class, 'productSearch'])->name('product.search');
    Route::get('/product-cat/{slug}', [FrontendController::class, 'productCat'])->name('product-cat');
    Route::get('/product-sub-cat/{slug}/{sub_slug}', [FrontendController::class, 'productSubCat'])->name('product-sub-cat');
    Route::get('/product-brand/{slug}', [FrontendController::class, 'productBrand'])->name('product-brand');
    Route::get('/blogdetail/{id}', [Blogcontroller::class, 'blogDetail'])->name('blog.detail.about');
    Route::post('/contact/store', 'SupportMessageController@store')->name('contact.store');
    
    
    // frontend footer pages
    // service 
    Route::get('/instastory-us', [FrontendController::class, 'instastory'])->name('instastory-us');
    Route::get('/instacount-us', [FrontendController::class, 'instacount'])->name('instacount-us');
    Route::get('/instapost-us', [FrontendController::class, 'instapost'])->name('instapost-us');
    Route::post('/post/download', [FrontendController::class, 'post_download'])->name('post.download');
    Route::post('/story/download', [FrontendController::class, 'story_download'])->name('story.download');
    Route::post('/follower/count', [FrontendController::class, 'follower_count'])->name('follower.count');

    
    // terms and privacy 
    Route::get('/privacy-policy', [FrontendController::class, 'privacy'])->name('privacy-co');
    Route::get('/traems-conditions', [FrontendController::class, 'terms'])->name('traems-co');
    
    // Cart section
    Route::get('/add-to-cart/{slug}', [CartController::class, 'addToCart'])->name('add-to-cart')->middleware('user');
    Route::post('/add-to-cart', [CartController::class, 'singleAddToCart'])->name('single-add-to-cart')->middleware('user');
    Route::get('cart-delete/{id}', [CartController::class, 'cartDelete'])->name('cart-delete');
    Route::post('cart-update', [CartController::class, 'cartUpdate'])->name('cart.update');

    Route::get('/cart', function () {
        return view('frontend.pages.cart');
    })->name('cart');
    // Route::get('/checkout', [CartController::class, 'checkout'])->name('checkout')->middleware('user');

    // smm service routes
    Route::get('{service}/{id}', [FrontendController::class, 'like'])->name('likes');
    
    // checkout routes 
    Route::get('/checkout/selection/{plan}/{service_id}', [FrontendController::class, 'checkout_selection'])->name('checkout-selection');
    Route::post('/checkout/selection/datapost', [FrontendController::class, 'selection_post'])->name('checkout-selection_post');
    Route::get('/checkout/media/{plan}/{ID}/{newid}', [FrontendController::class, 'checkout_media'])->name('checkout-media');
    Route::get('/checkout/payment', [FrontendController::class, 'checkout_payment'])->name('checkout-payment');
    
    Route::get('/blog', [FrontendController::class, 'blog'])->name('blog');
    
    Route::get('/support', [FrontendController::class, 'support'])->name('support');
    
    Route::get('/checkout/selection/thankyou', [FrontendController::class, 'thankyou'])->name('thankyou');
    
    // reset password admin
    // Route::get('password-reset', [ForgetPasswordController::class, 'ResetForm'])->name('password.adminreset');


   // Wishlist
    Route::get('/wishlist', function () {
        return view('frontend.pages.wishlist');
    })->name('wishlist');
    Route::get('/wishlist/{slug}', [WishlistController::class, 'wishlist'])->name('add-to-wishlist')->middleware('user');
    Route::get('wishlist-delete/{id}', [WishlistController::class, 'wishlistDelete'])->name('wishlist-delete');
    Route::post('cart/order', [OrderController::class, 'store'])->name('cart.order');
    Route::get('order/pdf/{id}', [OrderController::class, 'pdf'])->name('order.pdf');
    Route::get('/income', [OrderController::class, 'incomeChart'])->name('product.order.income');
    // Route::get('/user/chart',[AdminController::class, 'userPieChart'])->name('user.piechart');
    Route::get('/product-grids', [FrontendController::class, 'productGrids'])->name('product-grids');
    Route::get('/product-lists', [FrontendController::class, 'productLists'])->name('product-lists');
    Route::match(['get', 'post'], '/filter', [FrontendController::class, 'productFilter'])->name('shop.filter');
    // Order Track
    Route::get('/product/track', [OrderController::class, 'orderTrack'])->name('order.track');
    Route::post('product/track/order', [OrderController::class, 'productTrackOrder'])->name('product.track.order');
    // Blog
    // Route::get('/blog', [FrontendController::class, 'blog'])->name('blog');
    // Route::get('/blogdetail/{id}', [FrontendController::class, 'blogDetail'])->name('blog.detail.about');
    Route::get('/blog/search', [FrontendController::class, 'blogSearch'])->name('blog.search');
    Route::post('/blog/filter', [FrontendController::class, 'blogFilter'])->name('blog.filter');
    Route::get('blog-cat/{slug}', [FrontendController::class, 'blogByCategory'])->name('blog.category');
    Route::get('blog-tag/{slug}', [FrontendController::class, 'blogByTag'])->name('blog.tag');

    // NewsLetter
    Route::post('/subscribe', [FrontendController::class, 'subscribe'])->name('subscribe');
    
   

    // Product Review
    Route::resource('/back/service/review', 'ProductReviewController');
    Route::get('/back/service/review.create', [ProductReviewController::class, 'create'])->name('/back/service/review');
    Route::post('/back/service/review', [ProductReviewController::class, 'store'])->name('/back/service/review.store');
    // Route::post('/back/service/product/{slug}/review', [ProductReviewController::class, 'store'])->name('/back/service/review.store');

    // Post Comment
    Route::post('post/{slug}/comment', [PostCommentController::class, 'store'])->name('post-comment.store');
    Route::resource('/comment', 'PostCommentController');
    // Coupon
    Route::post('/coupon-store', [CouponController::class, 'couponStore'])->name('coupon-store');
    // Payment
    Route::get('payment', [PayPalController::class, 'payment'])->name('payment');
    Route::get('cancel', [PayPalController::class, 'cancel'])->name('payment.cancel');
    Route::get('payment/success', [PayPalController::class, 'success'])->name('payment.success');





   // Backend section start

    Route::group(['prefix' => '/admin', 'middleware' => ['auth', 'admin']], function () {
        Route::get('/', [AdminController::class, 'index'])->name('admin');
        Route::get('/back/service/file-manager', function () {
            return view('backend.layouts.file-manager');
        })->name('/back/service/file-manager');
        // user route
        Route::resource('/back/service/users', 'UsersController');
        // Banner
        Route::resource('/back/service/banner', 'BannerController');
        Route::get('/back/service/banner.create', [BannerController::class, 'create'])->name('/back/service/banner');
        
        // Blog
        Route::resource('/back/service/blog', 'Blogcontroller');
        Route::get('/back/service/blog.create', [Blogcontroller::class, 'create'])->name('/back/service/blog');
        Route::post('/back/service/blog', [Blogcontroller::class, 'store'])->name('/back/service/blog.store');
        Route::post('/back/service/blog/{id}', [Blogcontroller::class, 'update'])->name('/back/service/blog.update');




 
        // providers
         Route::get('/provider/index', [ProviderController::class, 'index'])->name('provider.index');
         Route::get('/provider/create', [ProviderController::class, 'create'])->name('provider.create');
         Route::post('/provider/store', [ProviderController::class, 'store'])->name('provider.store');
         Route::get('/provider/edit/{ID}', [ProviderController::class, 'edit'])->name('provider.edit');
         Route::delete('/provider/delete/{ID}', [ProviderController::class, 'delete'])->name('provider.delete');
         Route::post('/provider/provider_update', [ProviderController::class, 'provider_update'])->name('provider_update.update');
         Route::post('/provider/changeStatus', [ProviderController::class, 'changeStatus'])->name('provider.changeStatus');
         
         
        // Brand
        Route::resource('brand', 'BrandController');
        // Plan
        Route::resource('/back/service/plan', 'PlanController');
        Route::get('/back/service/plan.create', [PlanController::class, 'create'])->name('/back/service/plan');
        Route::post('/back/service/plan', [PlanController::class, 'store'])->name('/back/service/plan.store');
        
        
        Route::POST('/catfilter/{ID}', [ProductController::class, 'catfilter'])->name('admin-catfilter');
        Route::POST('/Fieldfilter/{ID}', [ProductController::class, 'Fieldfilter'])->name('admin-Fieldfilter');
        Route::POST('/header/{service}', [FrontendController::class, 'header'])->name('admin-header');
        // Profile
        Route::get('/back/service/profile', [AdminController::class, 'profile'])->name('/back/service/admin-profile');
        Route::post('/back/service/profile/{id}', [AdminController::class, 'profileUpdate'])->name('/back/service/profile-update');
        // Category
        Route::resource('/back/service/category', 'CategoryController');
        Route::get('/back/service/category.create', [CategoryController::class, 'create'])->name('/back/service/category');
        Route::post('/back/service/category', [CategoryController::class, 'store'])->name('/service/category.store');
        
        // Product
        Route::resource('/back/service/product', 'ProductController');
        Route::get('/back/service/product.create', [ProductController::class, 'create'])->name('/back/service/product');
        Route::post('/back/service/product', [ProductController::class, 'store'])->name('/back/service/product.store');
        // Route::post('/back/service/api', [ProductController::class, 'getOrderDetails'])->name('/back/service/product.api');
        // Route::get('/back/service/product.api/{orderId}', [ProductController::class, 'getOrderDetails']);
        Route::get('/back/servic/get_order_status/{order}', [OrderController::class, 'getOrderStatus']);
        // Route::get('/back/servic/get-details', [ProductController::class, 'getDetails']);

        // Route::get('/back/service/product.api/{orderId}', [ProductController::class, 'getOrderDetails']);


        Route::post('/back/service/product/{id}', [ProductController::class, 'update'])->name('/back/service/product.update');
        // Ajax for sub category
        Route::post('/category/{title}/{id}', 'CategoryController@getChildByParent');
        // Route::post('/provider/{title}/{id}', 'CategoryController@getserviceprivider');
        Route::post('/provider/{title}/{cat_id}/{pro_id}', 'CategoryController@getserviceprivider');

        // POST category
        Route::resource('/post-category', 'PostCategoryController');
        // Post tag
        Route::resource('/post-tag', 'PostTagController');
        // Post
        Route::resource('/post', 'PostController');
        // Message
        Route::resource('/back/service/message', 'MessageController');
        Route::get('/back/service/message/five', [MessageController::class, 'messageFive'])->name('/back/service/messages.five');

        // Order
        Route::resource('/back/service/order', 'OrderController');
        // Shipping
        Route::resource('/shipping', 'ShippingController');
        // Coupon
        Route::resource('/back/service/coupon', 'CouponController');
        
        
        //ProductOrder
        Route::get('/back/service/productorder', [ProductOrdercontroller::class, 'list'])->name('/back/service/productorder.list');
        // Settings
        Route::get('/back/service/settings', [AdminController::class, 'profile'])->name('/back/service/settings');
        Route::post('setting/update', [AdminController::class, 'settingsUpdate'])->name('settings.update');
        
        // Service-setting
        Route::get('/back/service/setting', [AdminController::class, 'Service'])->name('/back/service/setting');
        Route::post('service/update', [AdminController::class, 'serviceUpdate'])->name('service.update');
        
        // userslist
       Route::get('/back/service/userlist/', [AdminController::class, 'userlist'])->name('/back/service/userlist');
       
       
       
      Route::get('/back/service/last-7-days-users', [AdminController::class, 'getLastSevenDaysUsers'])->name('last-7-days-users');



// Route::get('/last-7-days-users', 'UserController@getLastSevenDaysUsers')->name('last-7-days-users');

       
      // add balance 
       Route::post('/back/service/add-balance/', [AdminController::class, 'addBalance'])->name('/back/service/add-balance');
       Route::post('/back/service/debit-balance/', [AdminController::class, 'debitBalance'])->name('/back/service/debit-balance');


        
        // Emailsetting
        Route::get('/back/service/emailsetting', [AdminController::class, 'emailsetting'])->name('/back/service/emailsetting');
        Route::post('service/emailupdate', [AdminController::class, 'emailupdate'])->name('service.emailupdate');
        Route::post('service/getmailtype', [AdminController::class, 'getmailtype'])->name('service.getmailtype');

        // Notification
        Route::get('/notification/{id}', [NotificationController::class, 'show'])->name('admin.notification');
        Route::get('/notifications', [NotificationController::class, 'index'])->name('all.notification');
        Route::delete('/notification/{id}', [NotificationController::class, 'delete'])->name('notification.delete');
        // Password Change
        Route::get('/back/service/change-password', [AdminController::class, 'changePassword'])->name('/back/service/change.password.form');
        Route::post('/back/service/change-password', [AdminController::class, 'changPasswordStore'])->name('/back/service/change.password');
    });


    // User section start
    // Route::group(['prefix' => '/user', 'middleware' => ['user']], function () {
     Route::group(['prefix' => '/user', 'middleware' => ['auth', 'user']], function () {
        Route::get('/', [HomeController::class, 'index'])->name('user');
        // Route::get('/', [HomeController::class, 'header'])->name('header');
        // Profile
        Route::get('/back/service/profile', [HomeController::class, 'profile'])->name('user-profile');
        Route::post('/back/service/profile/{id}', [HomeController::class, 'profileUpdate'])->name('user-profile-update');
        //  Order
        Route::get('/back/service/order', "HomeController@orderIndex")->name('user.order.index');
        Route::get('/back/service/order/show/{id}', "HomeController@orderShow")->name('user.order.show');
        Route::delete('/back/service/order/delete/{id}', [HomeController::class, 'userOrderDelete'])->name('user.order.delete');
        // Product Review
        Route::get('/back/service/user-review', [HomeController::class, 'productReviewIndex'])->name('user.productreview.index');
        Route::delete('/back/service/user-review/delete/{id}', [HomeController::class, 'productReviewDelete'])->name('user.productreview.delete');
        Route::get('/back/service/user-review/edit/{id}', [HomeController::class, 'productReviewEdit'])->name('user.productreview.edit');
        Route::patch('/back/service/user-review/update/{id}', [HomeController::class, 'productReviewUpdate'])->name('user.productreview.update');
 
        // Post comment
        Route::get('/back/service/user-post/comment', [HomeController::class, 'userComment'])->name('user.post-comment.index');
        Route::delete('/back/service/user-post/comment/delete/{id}', [HomeController::class, 'userCommentDelete'])->name('user.post-comment.delete');
        Route::get('/back/service/user-post/comment/edit/{id}', [HomeController::class, 'userCommentEdit'])->name('user.post-comment.edit');
        Route::patch('/back/service/user-post/comment/udpate/{id}', [HomeController::class, 'userCommentUpdate'])->name('user.post-comment.update');

        // Password Change
        Route::get('/back/service/change-password', [HomeController::class, 'changePassword'])->name('user.change.password.form');
        Route::post('/back/service/change-password', [HomeController::class, 'changPasswordStore'])->name('change.password');

    });

        Route::group(['prefix' => 'laravel-filemanager', 'middleware' => ['web', 'auth']], function () {
        Lfm::routes();
         });


    
    